/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.NumberEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class AddEvaluator
extends NumberEvaluator {
    protected static final long serialVersionUID = 1L;

    public AddEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.subEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least 1 value but found %d", expression, this.subEvaluators.size()));
        }
    }

    @Override
    public Number evaluate(Tuple tuple) throws IOException {
        List<BigDecimal> results = this.evaluateAll(tuple);
        if (results.stream().anyMatch(item -> null == item)) {
            return null;
        }
        BigDecimal result = null;
        if (results.size() > 0) {
            result = results.get(0);
            for (int idx = 1; idx < results.size(); ++idx) {
                result = result.add(results.get(idx));
            }
        }
        return this.normalizeType(result);
    }
}

