/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.apache.solr.client.solrj.cloud.autoscaling.DistribStateManager;
import org.apache.solr.client.solrj.cloud.autoscaling.VersionedData;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SpecProvider;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.util.ByteUtils;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.ValidatingJsonMap;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.server.ByteBufferInputStream;
import org.noggit.CharArr;
import org.noggit.JSONParser;
import org.noggit.JSONWriter;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Pattern ARRAY_ELEMENT_INDEX = Pattern.compile("(\\S*?)\\[([-]?\\d+)\\]");

    public static Map getDeepCopy(Map map, int maxDepth) {
        return Utils.getDeepCopy(map, maxDepth, true, false);
    }

    public static Map getDeepCopy(Map map, int maxDepth, boolean mutable) {
        return Utils.getDeepCopy(map, maxDepth, mutable, false);
    }

    public static Map getDeepCopy(Map map, int maxDepth, boolean mutable, boolean sorted) {
        if (map == null) {
            return null;
        }
        if (maxDepth < 1) {
            return map;
        }
        AbstractMap copy = sorted ? new TreeMap() : new LinkedHashMap();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            copy.put(e.getKey(), Utils.makeDeepCopy(e.getValue(), maxDepth, mutable, sorted));
        }
        return mutable ? copy : Collections.unmodifiableMap(copy);
    }

    private static Object makeDeepCopy(Object v, int maxDepth, boolean mutable, boolean sorted) {
        if (v instanceof MapWriter && maxDepth > 1) {
            v = ((MapWriter)v).toMap(new LinkedHashMap<String, Object>());
        } else if (v instanceof IteratorWriter && maxDepth > 1) {
            v = ((IteratorWriter)v).toList(new ArrayList());
            if (sorted) {
                Collections.sort((List)v);
            }
        }
        if (v instanceof Map) {
            v = Utils.getDeepCopy((Map)v, maxDepth - 1, mutable, sorted);
        } else if (v instanceof Collection) {
            v = Utils.getDeepCopy((Collection)v, maxDepth - 1, mutable, sorted);
        }
        return v;
    }

    public static InputStream toJavabin(Object o) throws IOException {
        try (JavaBinCodec jbc = new JavaBinCodec();){
            BinaryRequestWriter.BAOS baos = new BinaryRequestWriter.BAOS();
            jbc.marshal(o, baos);
            ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream(ByteBuffer.wrap(baos.getbuf(), 0, baos.size()));
            return byteBufferInputStream;
        }
    }

    public static Collection getDeepCopy(Collection c, int maxDepth, boolean mutable) {
        return Utils.getDeepCopy(c, maxDepth, mutable, false);
    }

    public static Collection getDeepCopy(Collection c, int maxDepth, boolean mutable, boolean sorted) {
        if (c == null || maxDepth < 1) {
            return c;
        }
        AbstractCollection result = c instanceof Set ? (sorted ? new TreeSet() : new HashSet()) : new ArrayList();
        for (Object o : c) {
            result.add(Utils.makeDeepCopy(o, maxDepth, mutable, sorted));
        }
        if (sorted && result instanceof List) {
            Collections.sort((List)((Object)result));
        }
        return mutable ? result : (result instanceof Set ? Collections.unmodifiableSet((Set)((Object)result)) : Collections.unmodifiableList((List)((Object)result)));
    }

    public static byte[] toJSON(Object o) {
        if (o == null) {
            return new byte[0];
        }
        CharArr out = new CharArr();
        if (!(o instanceof List) && !(o instanceof Map)) {
            if (o instanceof MapWriter) {
                o = ((MapWriter)o).toMap(new LinkedHashMap<String, Object>());
            } else if (o instanceof IteratorWriter) {
                o = ((IteratorWriter)o).toList(new ArrayList());
            }
        }
        new JSONWriter(out, 2).write(o);
        return Utils.toUTF8(out);
    }

    public static String toJSONString(Object o) {
        return new String(Utils.toJSON(o), StandardCharsets.UTF_8);
    }

    public static byte[] toUTF8(CharArr out) {
        byte[] arr = new byte[out.size() * 3];
        int nBytes = ByteUtils.UTF16toUTF8((CharSequence)out, 0, out.size(), arr, 0);
        return Arrays.copyOf(arr, nBytes);
    }

    public static Object fromJSON(byte[] utf8) {
        CharArr chars = new CharArr();
        ByteUtils.UTF8toUTF16(utf8, 0, utf8.length, chars);
        JSONParser parser = new JSONParser(chars.getArray(), chars.getStart(), chars.length());
        parser.setFlags(parser.getFlags() | 0x40 | 0x80);
        try {
            return ObjectBuilder.getVal((JSONParser)parser);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> makeMap(Object ... keyVals) {
        return Utils.makeMap(false, keyVals);
    }

    public static Map<String, Object> makeMap(boolean skipNulls, Object ... keyVals) {
        if ((keyVals.length & 1) != 0) {
            throw new IllegalArgumentException("arguments should be key,value");
        }
        LinkedHashMap<String, Object> propMap = new LinkedHashMap<String, Object>(keyVals.length >> 1);
        for (int i = 0; i < keyVals.length; i += 2) {
            Object keyVal = keyVals[i + 1];
            if (skipNulls && keyVal == null) continue;
            propMap.put(keyVals[i].toString(), keyVal);
        }
        return propMap;
    }

    public static Object fromJSON(InputStream is) {
        try {
            return new ObjectBuilder(Utils.getJSONParser(new InputStreamReader(is, StandardCharsets.UTF_8))).getObject();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parse error", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object fromJSONResource(String resourceName) {
        URL resource = Utils.class.getClassLoader().getResource(resourceName);
        if (null == resource) {
            throw new IllegalArgumentException("invalid resource name: " + resourceName);
        }
        try (InputStream stream = resource.openStream();){
            Object object = Utils.fromJSON(stream);
            return object;
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Resource error: " + e.getMessage(), (Throwable)e);
        }
    }

    public static JSONParser getJSONParser(Reader reader) {
        JSONParser parser = new JSONParser(reader);
        parser.setFlags(parser.getFlags() | 0x40 | 0x80);
        return parser;
    }

    public static Object fromJSONString(String json) {
        try {
            return new ObjectBuilder(Utils.getJSONParser(new StringReader(json))).getObject();
        }
        catch (IOException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Parse error", (Throwable)e);
        }
    }

    public static Object getObjectByPath(Object root, boolean onlyPrimitive, String hierarchy) {
        List<String> parts = StrUtils.splitSmart(hierarchy, '/');
        if (parts.get(0).isEmpty()) {
            parts.remove(0);
        }
        return Utils.getObjectByPath(root, onlyPrimitive, parts);
    }

    public static boolean setObjectByPath(Object root, String hierarchy, Object value) {
        List<String> parts = StrUtils.splitSmart(hierarchy, '/');
        if (parts.get(0).isEmpty()) {
            parts.remove(0);
        }
        return Utils.setObjectByPath(root, parts, value);
    }

    public static boolean setObjectByPath(Object root, List<String> hierarchy, Object value) {
        if (root == null) {
            return false;
        }
        if (!Utils.isMapLike(root)) {
            throw new RuntimeException("must be a Map or NamedList");
        }
        Object obj = root;
        for (int i = 0; i < hierarchy.size(); ++i) {
            Object o;
            Matcher matcher;
            int idx = -2;
            String s = hierarchy.get(i);
            if (s.endsWith("]") && (matcher = ARRAY_ELEMENT_INDEX.matcher(s)).find()) {
                s = matcher.group(1);
                idx = Integer.parseInt(matcher.group(2));
            }
            if (i < hierarchy.size() - 1) {
                o = Utils.getVal(obj, s);
                if (o == null) {
                    return false;
                }
                if (idx > -1) {
                    List l = (List)o;
                    Object object = o = idx < l.size() ? (Object)l.get(idx) : null;
                }
                if (!Utils.isMapLike(o)) {
                    return false;
                }
            } else {
                if (idx == -2) {
                    if (obj instanceof NamedList) {
                        NamedList namedList = (NamedList)obj;
                        int location = namedList.indexOf(s, 0);
                        if (location == -1) {
                            namedList.add(s, value);
                        } else {
                            namedList.setVal(location, value);
                        }
                    } else if (obj instanceof Map) {
                        ((Map)obj).put(s, value);
                    }
                    return true;
                }
                Object v = Utils.getVal(obj, s);
                if (v instanceof List) {
                    List list = (List)v;
                    if (idx == -1) {
                        list.add(value);
                    } else if (idx < list.size()) {
                        list.set(idx, value);
                    } else {
                        return false;
                    }
                    return true;
                }
                return false;
            }
            obj = o;
        }
        return false;
    }

    public static Object getObjectByPath(Object root, boolean onlyPrimitive, List<String> hierarchy) {
        if (root == null) {
            return null;
        }
        if (!Utils.isMapLike(root)) {
            return null;
        }
        Object obj = root;
        for (int i = 0; i < hierarchy.size(); ++i) {
            List l;
            Object o;
            Matcher matcher;
            int idx = -1;
            String s = hierarchy.get(i);
            if (s.endsWith("]") && (matcher = ARRAY_ELEMENT_INDEX.matcher(s)).find()) {
                s = matcher.group(1);
                idx = Integer.parseInt(matcher.group(2));
            }
            if (i < hierarchy.size() - 1) {
                o = Utils.getVal(obj, s);
                if (o == null) {
                    return null;
                }
                if (idx > -1) {
                    l = (List)o;
                    Object object = o = idx < l.size() ? (Object)l.get(idx) : null;
                }
                if (!Utils.isMapLike(o)) {
                    return null;
                }
            } else {
                Object val = Utils.getVal(obj, s);
                if (val == null) {
                    return null;
                }
                if (idx > -1) {
                    l = (List)val;
                    Object object = val = idx < l.size() ? (Object)l.get(idx) : null;
                }
                if (onlyPrimitive && Utils.isMapLike(val)) {
                    return null;
                }
                return val;
            }
            obj = o;
        }
        return false;
    }

    private static boolean isMapLike(Object o) {
        return o instanceof Map || o instanceof NamedList || o instanceof MapWriter;
    }

    private static Object getVal(Object obj, final String key) {
        if (obj instanceof MapWriter) {
            final Object[] result = new Object[1];
            try {
                ((MapWriter)obj).writeMap(new MapWriter.EntryWriter(){

                    @Override
                    public MapWriter.EntryWriter put(String k, Object v) throws IOException {
                        if (key.equals(k)) {
                            result[0] = v;
                        }
                        return this;
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return result[0];
        }
        if (obj instanceof NamedList) {
            return ((NamedList)obj).get(key);
        }
        if (obj instanceof Map) {
            return ((Map)obj).get(key);
        }
        throw new RuntimeException("must be a NamedList or Map");
    }

    public static void consumeFully(HttpEntity entity) {
        if (entity != null) {
            try {
                Utils.readFully(entity.getContent());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (IOException iOException) {
            }
            finally {
                EntityUtils.consumeQuietly((HttpEntity)entity);
            }
        }
    }

    private static void readFully(InputStream is) throws IOException {
        is.skip(is.available());
        while (is.read() != -1) {
        }
    }

    public static Map<String, Object> getJson(DistribStateManager distribStateManager, String path) throws InterruptedException, IOException, KeeperException {
        VersionedData data = null;
        try {
            data = distribStateManager.getData(path);
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyMap();
        }
        if (data == null || data.getData() == null || data.getData().length == 0) {
            return Collections.emptyMap();
        }
        return (Map)Utils.fromJSON(data.getData());
    }

    public static Map<String, Object> getJson(SolrZkClient zkClient, String path, boolean retryOnConnLoss) throws KeeperException, InterruptedException {
        try {
            byte[] bytes = zkClient.getData(path, null, null, retryOnConnLoss);
            if (bytes != null && bytes.length > 0) {
                return (Map)Utils.fromJSON(bytes);
            }
        }
        catch (KeeperException.NoNodeException e) {
            return Collections.emptyMap();
        }
        return Collections.emptyMap();
    }

    public static SpecProvider getSpec(String name) {
        return () -> ValidatingJsonMap.parse("apispec/" + name + ".json", "apispec/");
    }

    public static String parseMetricsReplicaName(String collectionName, String coreName) {
        if (collectionName == null || !coreName.startsWith(collectionName)) {
            return null;
        }
        if (coreName.length() > collectionName.length()) {
            String str = coreName.substring(collectionName.length() + 1);
            int pos = str.lastIndexOf("_replica");
            if (pos == -1) {
                return str;
            }
            return str.substring(pos + 1);
        }
        return null;
    }

    public static String getBaseUrlForNodeName(String nodeName, String urlScheme) {
        int _offset = nodeName.indexOf("_");
        if (_offset < 0) {
            throw new IllegalArgumentException("nodeName does not contain expected '_' separator: " + nodeName);
        }
        String hostAndPort = nodeName.substring(0, _offset);
        try {
            String path = URLDecoder.decode(nodeName.substring(1 + _offset), "UTF-8");
            return urlScheme + "://" + hostAndPort + (path.isEmpty() ? "" : "/" + path);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM Does not seem to support UTF-8", e);
        }
    }

    public static long time(TimeSource timeSource, TimeUnit unit) {
        return unit.convert(timeSource.getTime(), TimeUnit.NANOSECONDS);
    }

    public static long timeElapsed(TimeSource timeSource, long start, TimeUnit unit) {
        return unit.convert(timeSource.getTime() - TimeUnit.NANOSECONDS.convert(start, unit), TimeUnit.NANOSECONDS);
    }
}

