/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.cloud.autoscaling.Policy;
import org.apache.solr.client.solrj.cloud.autoscaling.Row;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Preference
implements MapWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    final Policy.SortParam name;
    Integer precision;
    final Policy.Sort sort;
    Preference next;
    final int idx;
    private final Map original;

    public Preference(Map<String, Object> m) {
        this(m, 0);
    }

    public Preference(Map<String, Object> m, int idx) {
        this.idx = idx;
        this.original = Utils.getDeepCopy(m, 3);
        this.sort = Policy.Sort.get(m);
        this.name = Policy.SortParam.get(m.get(this.sort.name()).toString());
        Object p = m.getOrDefault("precision", 0);
        this.precision = p instanceof Number ? ((Number)p).intValue() : Integer.parseInt(p.toString());
        if (this.precision < 0) {
            throw new RuntimeException("precision must be a positive value ");
        }
        if (this.precision < this.name.min || this.precision > this.name.max) {
            throw new RuntimeException(StrUtils.formatString("invalid precision value {0} , must lie between {1} and {2}", this.precision, this.name.min, this.name.max));
        }
    }

    int compare(Row r1, Row r2, boolean useApprox) {
        if (!r1.isLive && !r2.isLive) {
            return 0;
        }
        if (!r1.isLive) {
            return -1;
        }
        if (!r2.isLive) {
            return 1;
        }
        Object o1 = useApprox ? r1.cells[this.idx].approxVal : r1.cells[this.idx].val;
        Object o2 = useApprox ? r2.cells[this.idx].approxVal : r2.cells[this.idx].val;
        int result = 0;
        if (o1 instanceof Long && o2 instanceof Long) {
            result = ((Long)o1).compareTo((Long)o2);
        } else if (o1 instanceof Double && o2 instanceof Double) {
            result = this.compareWithTolerance((Double)o1, (Double)o2, useApprox ? 1 : 1);
        } else if (!o1.getClass().getName().equals(o2.getClass().getName())) {
            throw new RuntimeException("Unable to compare " + o1 + " of type: " + o1.getClass().getName() + " from " + r1.cells[this.idx].toString() + " and " + o2 + " of type: " + o2.getClass().getName() + " from " + r2.cells[this.idx].toString());
        }
        return result == 0 ? (this.next == null ? 0 : this.next.compare(r1, r2, useApprox)) : this.sort.sortval * result;
    }

    private int compareWithTolerance(Double o1, Double o2, int percentage) {
        if (percentage == 0) {
            return o1.compareTo(o2);
        }
        if (o1.equals(o2)) {
            return 0;
        }
        double delta = Math.abs(o1 - o2);
        if (100.0 * delta / o1 < (double)percentage) {
            return 0;
        }
        return o1.compareTo(o2);
    }

    void setApproxVal(List<Row> tmpMatrix) {
        Object prevVal = null;
        for (Row row : tmpMatrix) {
            double currD;
            if (!row.isLive) continue;
            if (prevVal == null) {
                prevVal = row.cells[this.idx].approxVal = row.cells[this.idx].val;
                continue;
            }
            double prevD = ((Number)prevVal).doubleValue();
            if (Math.abs(prevD - (currD = ((Number)row.cells[this.idx].val).doubleValue())) >= (double)this.precision.intValue()) {
                prevVal = row.cells[this.idx].approxVal = row.cells[this.idx].val;
                continue;
            }
            prevVal = row.cells[this.idx].approxVal = prevVal;
        }
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        Iterator iterator = this.original.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry o;
            Map.Entry e = o = iterator.next();
            ew.put(String.valueOf(e.getKey()), e.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Preference that = (Preference)o;
        if (this.idx != that.idx) {
            return false;
        }
        if (this.getName() != that.getName()) {
            return false;
        }
        if (this.precision != null ? !this.precision.equals(that.precision) : that.precision != null) {
            return false;
        }
        if (this.sort != that.sort) {
            return false;
        }
        if (this.next != null ? !this.next.equals(that.next) : that.next != null) {
            return false;
        }
        return this.original.equals(that.original);
    }

    public Policy.SortParam getName() {
        return this.name;
    }

    public String toString() {
        return Utils.toJSONString(this);
    }
}

