/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.util.Utils;

public class ReplicaInfo
implements MapWriter {
    private final String name;
    private String core;
    private String collection;
    private String shard;
    private Replica.Type type;
    private String node;
    public final boolean isLeader;
    private final Map<String, Object> variables = new HashMap<String, Object>();

    public ReplicaInfo(String coll, String shard, Replica r, Map<String, Object> vals) {
        this.name = r.getName();
        this.core = r.getCoreName();
        this.collection = coll;
        this.shard = shard;
        this.type = r.getType();
        this.isLeader = r.getBool("leader", false);
        if (vals != null) {
            this.variables.putAll(vals);
        }
        this.node = r.getNodeName();
    }

    public ReplicaInfo(String name, String core, String coll, String shard, Replica.Type type, String node, Map<String, Object> vals) {
        if (vals == null) {
            vals = Collections.emptyMap();
        }
        this.name = name;
        if (vals != null) {
            this.variables.putAll(vals);
        }
        this.isLeader = "true".equals(String.valueOf(vals.getOrDefault("leader", "false")));
        this.collection = coll;
        this.shard = shard;
        this.type = type;
        this.core = core;
        this.node = node;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put(this.name, ew1 -> {
            for (Map.Entry<String, Object> e : this.variables.entrySet()) {
                ew1.put(e.getKey(), e.getValue());
            }
            if (this.core != null && !this.variables.containsKey("core")) {
                ew1.put("core", this.core);
            }
            if (this.shard != null && !this.variables.containsKey("shard")) {
                ew1.put("shard", this.shard);
            }
            if (this.collection != null && !this.variables.containsKey("collection")) {
                ew1.put("collection", this.collection);
            }
            if (this.node != null && !this.variables.containsKey("node_name")) {
                ew1.put("node_name", this.node);
            }
            if (this.type != null) {
                ew1.put("type", this.type.toString());
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public String getCore() {
        return this.core;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getShard() {
        return this.shard;
    }

    public Replica.Type getType() {
        Replica.Type o;
        Object object = o = this.type == null ? this.variables.get("type") : this.type;
        if (o == null) {
            return Replica.Type.NRT;
        }
        if (o instanceof Replica.Type) {
            return o;
        }
        Replica.Type type = Replica.Type.get(String.valueOf((Object)o).toUpperCase(Locale.ROOT));
        return type;
    }

    public Replica.State getState() {
        if (this.variables.get("state") != null) {
            return Replica.State.getState((String)this.variables.get("state"));
        }
        this.variables.put("state", Replica.State.ACTIVE.toString());
        return Replica.State.ACTIVE;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Object getVariable(String name) {
        return this.variables.get(name);
    }

    public String toString() {
        return Utils.toJSONString(this);
    }

    public String getNode() {
        return this.node;
    }
}

