/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.solr.common.IteratorWriter;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.NavigableObject;
import org.apache.solr.common.util.Utils;

public interface MapWriter
extends MapSerializable,
NavigableObject {
    default public String jsonStr() {
        return Utils.toJSONString(this);
    }

    @Override
    default public Map toMap(final Map<String, Object> map) {
        try {
            this.writeMap(new EntryWriter(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public EntryWriter put(CharSequence k, Object v) {
                    if (v instanceof MapWriter) {
                        v = ((MapWriter)((Object)v)).toMap(new LinkedHashMap<String, Object>());
                    }
                    if (v instanceof IteratorWriter) {
                        v = ((IteratorWriter)((Object)v)).toList(new ArrayList());
                    }
                    if (v instanceof Iterable) {
                        ArrayList<void> lst = new ArrayList<void>();
                        for (Object t : (Iterable)((Object)v)) {
                            void var5_5;
                            void var5_8;
                            if (t instanceof MapWriter) {
                                Map map2 = ((MapWriter)t).toMap(new LinkedHashMap<String, Object>());
                            }
                            if (var5_8 instanceof IteratorWriter) {
                                List list = ((IteratorWriter)var5_8).toList(new ArrayList());
                            }
                            lst.add(var5_5);
                        }
                        v = lst;
                    }
                    if (v instanceof Map) {
                        LinkedHashMap map3 = new LinkedHashMap();
                        for (Map.Entry entry : ((Map)((Object)v)).entrySet()) {
                            Object vv = entry.getValue();
                            if (vv instanceof MapWriter) {
                                vv = ((MapWriter)vv).toMap(new LinkedHashMap<String, Object>());
                            }
                            if (vv instanceof IteratorWriter) {
                                vv = ((IteratorWriter)vv).toList(new ArrayList());
                            }
                            map3.put(entry.getKey(), vv);
                        }
                        v = map3;
                    }
                    map.put(k == null ? null : k.toString(), v);
                    return this;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public void writeMap(EntryWriter var1) throws IOException;

    public static interface EntryWriter {
        public EntryWriter put(CharSequence var1, Object var2) throws IOException;

        default public EntryWriter putNoEx(CharSequence k, Object v) {
            try {
                this.put(k, v);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        default public EntryWriter put(CharSequence k, Object v, BiPredicate<CharSequence, Object> p) throws IOException {
            if (p.test(k, v)) {
                this.put(k, v);
            }
            return this;
        }

        default public EntryWriter putIfNotNull(CharSequence k, Object v) throws IOException {
            if (v != null) {
                this.put(k, v);
            }
            return this;
        }

        default public EntryWriter putStringIfNotNull(CharSequence k, Object v) throws IOException {
            if (v != null) {
                this.put(k, String.valueOf(v));
            }
            return this;
        }

        default public EntryWriter put(CharSequence k, int v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }

        default public EntryWriter put(CharSequence k, long v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }

        default public EntryWriter put(CharSequence k, float v) throws IOException {
            this.put(k, Float.valueOf(v));
            return this;
        }

        default public EntryWriter put(CharSequence k, double v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }

        default public EntryWriter put(CharSequence k, boolean v) throws IOException {
            this.put(k, (Object)v);
            return this;
        }
    }
}

