/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.solr.common.MapWriter;

public class Tuple
implements Cloneable,
MapWriter {
    public boolean EOF;
    public boolean EXCEPTION;
    public Map fields = new HashMap();
    public List<String> fieldNames;
    public Map<String, String> fieldLabels;

    public Tuple() {
    }

    public Tuple(Map fields) {
        if (fields.containsKey("EOF")) {
            this.EOF = true;
        }
        if (fields.containsKey("EXCEPTION")) {
            this.EXCEPTION = true;
        }
        this.fields.putAll(fields);
    }

    public Object get(Object key) {
        return this.fields.get(key);
    }

    public void put(Object key, Object value) {
        this.fields.put(key, value);
    }

    public void remove(Object key) {
        this.fields.remove(key);
    }

    public String getString(Object key) {
        return String.valueOf(this.fields.get(key));
    }

    public String getException() {
        return (String)this.fields.get("EXCEPTION");
    }

    public Long getLong(Object key) {
        Object o = this.fields.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Long.parseLong(o.toString());
    }

    public Boolean getBool(Object key) {
        Object o = this.fields.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return Boolean.parseBoolean(o.toString());
    }

    public List<Boolean> getBools(Object key) {
        return (List)this.fields.get(key);
    }

    public Date getDate(Object key) {
        Object o = this.fields.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        return new Date(Instant.parse(o.toString()).toEpochMilli());
    }

    public List<Date> getDates(Object key) {
        List vals = (List)this.fields.get(key);
        if (vals == null) {
            return null;
        }
        ArrayList<Date> ret = new ArrayList<Date>();
        for (String dateStr : (List)this.fields.get(key)) {
            ret.add(new Date(Instant.parse(dateStr).toEpochMilli()));
        }
        return ret;
    }

    public Double getDouble(Object key) {
        Object o = this.fields.get(key);
        if (o == null) {
            return null;
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        return Double.parseDouble(o.toString());
    }

    public List<String> getStrings(Object key) {
        return (List)this.fields.get(key);
    }

    public List<Long> getLongs(Object key) {
        return (List)this.fields.get(key);
    }

    public List<Double> getDoubles(Object key) {
        return (List)this.fields.get(key);
    }

    public Map getMap() {
        return this.fields;
    }

    public List<Map> getMaps(Object key) {
        return (List)this.fields.get(key);
    }

    public void setMaps(Object key, List<Map> maps) {
        this.fields.put(key, maps);
    }

    public Map<String, Map> getMetrics() {
        return (Map)this.fields.get("_METRICS_");
    }

    public void setMetrics(Map<String, Map> metrics) {
        this.fields.put("_METRICS_", metrics);
    }

    public Tuple clone() {
        HashMap m = new HashMap();
        m.putAll(this.fields);
        Tuple clone = new Tuple(m);
        return clone;
    }

    public void merge(Tuple other) {
        this.fields.putAll(other.getMap());
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        if (this.fieldNames == null) {
            this.fields.forEach((k, v) -> {
                try {
                    ew.put((CharSequence)((String)k), v);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        } else {
            for (String fieldName : this.fieldNames) {
                String label = this.fieldLabels.get(fieldName);
                ew.put((CharSequence)label, this.fields.get(label));
            }
        }
    }
}

