/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.http.entity.ContentType;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.V2RequestSupport;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.AuthenticationStoreHolder;
import org.apache.solr.client.solrj.impl.BaseHttpSolrClient;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientBuilderFactory;
import org.apache.solr.client.solrj.impl.HttpListenerFactory;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.client.solrj.util.AsyncListener;
import org.apache.solr.client.solrj.util.Cancellable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.StringUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.SolrNamedThreadFactory;
import org.apache.solr.common.util.Utils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.ProtocolHandlers;
import org.eclipse.jetty.client.api.AuthenticationStore;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpClientTransportOverHTTP;
import org.eclipse.jetty.client.util.ByteBufferContentProvider;
import org.eclipse.jetty.client.util.FormContentProvider;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.client.util.InputStreamResponseListener;
import org.eclipse.jetty.client.util.MultiPartContentProvider;
import org.eclipse.jetty.client.util.OutputStreamContentProvider;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.http.HttpClientTransportOverHTTP2;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.BlockingArrayQueue;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class Http2SolrClient
extends SolrClient {
    public static final String REQ_PRINCIPAL_KEY = "solr-req-principal";
    private static volatile SSLConfig defaultSSLConfig;
    private static final Logger log;
    private static final String AGENT;
    private static final Charset FALLBACK_CHARSET;
    private static final String DEFAULT_PATH = "/select";
    private static final List<String> errPath;
    private HttpClient httpClient;
    private volatile Set<String> urlParamNames = Set.of();
    private long idleTimeoutMillis;
    private long requestTimeoutMillis;
    protected ResponseParser parser = new BinaryResponseParser();
    protected RequestWriter requestWriter = new BinaryRequestWriter();
    private List<HttpListenerFactory> listenerFactory = new ArrayList<HttpListenerFactory>();
    private AsyncTracker asyncTracker = new AsyncTracker();
    private String serverBaseUrl;
    private boolean closeClient;
    private ExecutorService executor;
    private boolean shutdownExecutor;
    private final String basicAuthAuthorizationStr;
    private AuthenticationStoreHolder authenticationStore;
    private static final Exception CANCELLED_EXCEPTION;
    private static final Cancellable FAILED_MAKING_REQUEST_CANCELLABLE;

    protected Http2SolrClient(String serverBaseUrl, Builder builder) {
        if (serverBaseUrl != null) {
            if (!serverBaseUrl.equals("/") && serverBaseUrl.endsWith("/")) {
                serverBaseUrl = serverBaseUrl.substring(0, serverBaseUrl.length() - 1);
            }
            if (serverBaseUrl.startsWith("//")) {
                serverBaseUrl = serverBaseUrl.substring(1, serverBaseUrl.length());
            }
            this.serverBaseUrl = serverBaseUrl;
        }
        this.idleTimeoutMillis = builder.idleTimeoutMillis != null && builder.idleTimeoutMillis > 0L ? builder.idleTimeoutMillis : 600000L;
        if (builder.http2SolrClient == null) {
            this.httpClient = this.createHttpClient(builder);
            this.closeClient = true;
        } else {
            this.httpClient = builder.http2SolrClient.httpClient;
        }
        this.basicAuthAuthorizationStr = builder.basicAuthUser != null && builder.basicAuthPassword != null ? this.basicAuthCredentialsToAuthorizationString(builder.basicAuthUser, builder.basicAuthPassword) : null;
        if (builder.requestWriter != null) {
            this.requestWriter = builder.requestWriter;
        }
        if (builder.responseParser != null) {
            this.parser = builder.responseParser;
        }
        this.requestTimeoutMillis = builder.requestTimeoutMillis == null ? -1L : builder.requestTimeoutMillis;
        this.httpClient.setFollowRedirects(builder.followRedirects);
        this.urlParamNames = builder.urlParamNames;
        assert (ObjectReleaseTracker.track(this));
    }

    public void addListenerFactory(HttpListenerFactory factory) {
        this.listenerFactory.add(factory);
    }

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    ProtocolHandlers getProtocolHandlers() {
        return this.httpClient.getProtocolHandlers();
    }

    private HttpClient createHttpClient(Builder builder) {
        HttpClient httpClient;
        this.executor = builder.executor;
        if (this.executor == null) {
            BlockingArrayQueue queue = new BlockingArrayQueue(256, 256);
            this.executor = new ExecutorUtil.MDCAwareThreadPoolExecutor(32, 256, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)queue, new SolrNamedThreadFactory("h2sc"));
            this.shutdownExecutor = true;
        } else {
            this.shutdownExecutor = false;
        }
        SslContextFactory.Client sslContextFactory = builder.sslConfig == null ? Http2SolrClient.getDefaultSslContextFactory() : builder.sslConfig.createClientContextFactory();
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setReuseAddress(true);
        clientConnector.setSslContextFactory(sslContextFactory);
        clientConnector.setSelectors(2);
        if (builder.useHttp1_1) {
            if (log.isDebugEnabled()) {
                log.debug("Create Http2SolrClient with HTTP/1.1 transport");
            }
            HttpClientTransportOverHTTP transport = new HttpClientTransportOverHTTP(clientConnector);
            httpClient = new HttpClient((HttpClientTransport)transport);
            if (builder.maxConnectionsPerHost != null) {
                httpClient.setMaxConnectionsPerDestination(builder.maxConnectionsPerHost.intValue());
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Create Http2SolrClient with HTTP/2 transport");
            }
            HTTP2Client http2client = new HTTP2Client(clientConnector);
            HttpClientTransportOverHTTP2 transport = new HttpClientTransportOverHTTP2(http2client);
            httpClient = new HttpClient((HttpClientTransport)transport);
            httpClient.setMaxConnectionsPerDestination(4);
        }
        httpClient.setExecutor((Executor)this.executor);
        httpClient.setStrictEventOrdering(false);
        httpClient.setConnectBlocking(true);
        httpClient.setFollowRedirects(false);
        httpClient.setMaxRequestsQueuedPerDestination(this.asyncTracker.getMaxRequestsQueuedPerDestination());
        httpClient.setUserAgentField(new HttpField(HttpHeader.USER_AGENT, AGENT));
        httpClient.setIdleTimeout(this.idleTimeoutMillis);
        this.authenticationStore = new AuthenticationStoreHolder();
        httpClient.setAuthenticationStore((AuthenticationStore)this.authenticationStore);
        if (builder.connectionTimeoutMillis != null) {
            httpClient.setConnectTimeout(builder.connectionTimeoutMillis.longValue());
        }
        try {
            httpClient.start();
        }
        catch (Exception e) {
            this.close();
            throw new RuntimeException(e);
        }
        return httpClient;
    }

    @Override
    public void close() {
        this.asyncTracker.waitForComplete();
        try {
            if (this.closeClient) {
                this.httpClient.stop();
                this.httpClient.destroy();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Exception on closing client", e);
        }
        finally {
            if (this.shutdownExecutor) {
                ExecutorUtil.shutdownAndAwaitTermination(this.executor);
            }
        }
        assert (ObjectReleaseTracker.release(this));
    }

    public void setAuthenticationStore(AuthenticationStore authenticationStore) {
        this.authenticationStore.updateAuthenticationStore(authenticationStore);
    }

    public boolean isV2ApiRequest(SolrRequest<?> request) {
        return request instanceof V2Request || request.getPath().contains("/____v2");
    }

    public long getIdleTimeout() {
        return this.idleTimeoutMillis;
    }

    public OutStream initOutStream(String baseUrl, UpdateRequest updateRequest, String collection) throws IOException {
        String contentType = this.requestWriter.getUpdateContentType();
        ModifiableSolrParams origParams = new ModifiableSolrParams(updateRequest.getParams());
        ModifiableSolrParams requestParams = new ModifiableSolrParams(origParams);
        requestParams.set("wt", this.parser.getWriterType());
        requestParams.set("version", this.parser.getVersion());
        Object basePath = baseUrl;
        if (collection != null) {
            basePath = (String)basePath + "/" + collection;
        }
        if (!((String)basePath).endsWith("/")) {
            basePath = (String)basePath + "/";
        }
        OutputStreamContentProvider provider = new OutputStreamContentProvider();
        Request postRequest = this.httpClient.newRequest((String)basePath + "update" + requestParams.toQueryString()).method(HttpMethod.POST).header(HttpHeader.CONTENT_TYPE, contentType).content((ContentProvider)provider);
        this.decorateRequest(postRequest, updateRequest);
        InputStreamResponseListener responseListener = new InputStreamResponseListener();
        postRequest.send((Response.CompleteListener)responseListener);
        boolean isXml = "application/xml; charset=UTF-8".equals(this.requestWriter.getUpdateContentType());
        OutStream outStream = new OutStream(collection, origParams, provider, responseListener, isXml);
        if (isXml) {
            outStream.write("<stream>".getBytes(FALLBACK_CHARSET));
        }
        return outStream;
    }

    public void send(OutStream outStream, SolrRequest<?> req, String collection) throws IOException {
        SolrParams params;
        assert (outStream.belongToThisStream(req, collection));
        this.requestWriter.write(req, outStream.outProvider.getOutputStream());
        if (outStream.isXml && (params = req.getParams()) != null) {
            String fmt = null;
            if (params.getBool("optimize", false)) {
                fmt = "<optimize waitSearcher=\"%s\" />";
            } else if (params.getBool("commit", false)) {
                fmt = "<commit waitSearcher=\"%s\" />";
            }
            if (fmt != null) {
                byte[] content = String.format(Locale.ROOT, fmt, "" + params.getBool("waitSearcher", false)).getBytes(FALLBACK_CHARSET);
                outStream.write(content);
            }
        }
        outStream.flush();
    }

    public Cancellable asyncRequest(final SolrRequest<?> solrRequest, String collection, final AsyncListener<NamedList<Object>> asyncListener) {
        Request req;
        try {
            req = this.makeRequest(solrRequest, collection);
        }
        catch (IOException | SolrServerException e) {
            asyncListener.onFailure(e);
            return FAILED_MAKING_REQUEST_CANCELLABLE;
        }
        final ResponseParser parser = solrRequest.getResponseParser() == null ? this.parser : solrRequest.getResponseParser();
        final MDCCopyHelper mdcCopyHelper = new MDCCopyHelper();
        req.onRequestQueued(this.asyncTracker.queuedListener).onComplete(this.asyncTracker.completeListener).send((Response.CompleteListener)new InputStreamResponseListener(){

            public void onHeaders(Response response) {
                super.onHeaders(response);
                1 listener = this;
                Http2SolrClient.this.executor.execute(() -> {
                    InputStream is = listener.getInputStream();
                    assert (ObjectReleaseTracker.track(is));
                    try {
                        NamedList<Object> body = Http2SolrClient.this.processErrorsAndResponse(solrRequest, parser, response, is);
                        mdcCopyHelper.onBegin(null);
                        log.debug("response processing success");
                        asyncListener.onSuccess(body);
                    }
                    catch (BaseHttpSolrClient.RemoteSolrException e) {
                        if (SolrException.getRootCause(e) != CANCELLED_EXCEPTION) {
                            mdcCopyHelper.onBegin(null);
                            log.debug("response processing failed");
                            asyncListener.onFailure(e);
                        }
                    }
                    catch (SolrServerException e) {
                        mdcCopyHelper.onBegin(null);
                        log.debug("response processing failed");
                        asyncListener.onFailure(e);
                    }
                    finally {
                        log.debug("response processing completed");
                        mdcCopyHelper.onComplete(null);
                    }
                });
            }

            public void onFailure(Response response, Throwable failure) {
                super.onFailure(response, failure);
                if (failure != CANCELLED_EXCEPTION) {
                    asyncListener.onFailure(new SolrServerException(failure.getMessage(), failure));
                }
            }
        });
        return () -> req.abort((Throwable)CANCELLED_EXCEPTION);
    }

    @Override
    public NamedList<Object> request(SolrRequest<?> solrRequest, String collection) throws SolrServerException, IOException {
        Request req = this.makeRequest(solrRequest, collection);
        ResponseParser parser = solrRequest.getResponseParser() == null ? this.parser : solrRequest.getResponseParser();
        Throwable abortCause = null;
        try {
            InputStreamResponseListener listener = new InputStreamResponseListener();
            req.send((Response.CompleteListener)listener);
            Response response = listener.get(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
            InputStream is = listener.getInputStream();
            assert (ObjectReleaseTracker.track(is));
            NamedList<Object> namedList = this.processErrorsAndResponse(solrRequest, parser, response, is);
            return namedList;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            abortCause = e;
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            throw new SolrServerException("Timeout occurred while waiting response from server at: " + req.getURI(), e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            abortCause = cause;
            if (cause instanceof ConnectException) {
                throw new SolrServerException("Server refused connection at: " + req.getURI(), cause);
            }
            if (cause instanceof SolrServerException) {
                throw (SolrServerException)cause;
            }
            if (cause instanceof IOException) {
                throw new SolrServerException("IOException occurred when talking to server at: " + this.getBaseURL(), cause);
            }
            throw new SolrServerException(cause.getMessage(), cause);
        }
        catch (RuntimeException | SolrServerException sse) {
            abortCause = sse;
            throw sse;
        }
        finally {
            if (abortCause != null) {
                req.abort(abortCause);
            }
        }
    }

    private NamedList<Object> processErrorsAndResponse(SolrRequest<?> solrRequest, ResponseParser parser, Response response, InputStream is) throws SolrServerException {
        String contentType = response.getHeaders().get(HttpHeader.CONTENT_TYPE);
        String mimeType = null;
        String encoding = null;
        if (contentType != null) {
            mimeType = MimeTypes.getContentTypeWithoutCharset((String)contentType);
            encoding = MimeTypes.getCharsetFromContentType((String)contentType);
        }
        return this.processErrorsAndResponse(response, parser, is, mimeType, encoding, this.isV2ApiRequest(solrRequest));
    }

    private void setBasicAuthHeader(SolrRequest<?> solrRequest, Request req) {
        if (solrRequest.getBasicAuthUser() != null && solrRequest.getBasicAuthPassword() != null) {
            String encoded = this.basicAuthCredentialsToAuthorizationString(solrRequest.getBasicAuthUser(), solrRequest.getBasicAuthPassword());
            req.header("Authorization", encoded);
        } else if (this.basicAuthAuthorizationStr != null) {
            req.header("Authorization", this.basicAuthAuthorizationStr);
        }
    }

    private String basicAuthCredentialsToAuthorizationString(String user, String pass) {
        String userPass = user + ":" + pass;
        return "Basic " + Base64.getEncoder().encodeToString(userPass.getBytes(FALLBACK_CHARSET));
    }

    private Request makeRequest(SolrRequest<?> solrRequest, String collection) throws SolrServerException, IOException {
        Request req = this.createRequest(solrRequest, collection);
        this.decorateRequest(req, solrRequest);
        return req;
    }

    private void decorateRequest(Request req, SolrRequest<?> solrRequest) {
        req.header(HttpHeader.ACCEPT_ENCODING, null);
        if (this.requestTimeoutMillis > 0L) {
            req.timeout(this.requestTimeoutMillis, TimeUnit.MILLISECONDS);
        } else {
            req.timeout(this.idleTimeoutMillis, TimeUnit.MILLISECONDS);
        }
        if (solrRequest.getUserPrincipal() != null) {
            req.attribute(REQ_PRINCIPAL_KEY, (Object)solrRequest.getUserPrincipal());
        }
        this.setBasicAuthHeader(solrRequest, req);
        for (HttpListenerFactory factory : this.listenerFactory) {
            HttpListenerFactory.RequestResponseListener listener = factory.get();
            listener.onQueued(req);
            req.onRequestBegin((Request.BeginListener)listener);
            req.onComplete((Response.CompleteListener)listener);
        }
        Map<String, String> headers = solrRequest.getHeaders();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                req.header(entry.getKey(), entry.getValue());
            }
        }
    }

    private String changeV2RequestEndpoint(String basePath) throws MalformedURLException {
        URL oldURL = new URL(basePath);
        String newPath = oldURL.getPath().replaceFirst("/solr", "/api");
        return new URL(oldURL.getProtocol(), oldURL.getHost(), oldURL.getPort(), newPath).toString();
    }

    private Request createRequest(SolrRequest<?> solrRequest, String collection) throws IOException, SolrServerException {
        Object basePath;
        ResponseParser parser;
        if (solrRequest.getBasePath() == null && this.serverBaseUrl == null) {
            throw new IllegalArgumentException("Destination node is not provided!");
        }
        if (solrRequest instanceof V2RequestSupport) {
            solrRequest = ((V2RequestSupport)((Object)solrRequest)).getV2Request();
        }
        SolrParams params = solrRequest.getParams();
        RequestWriter.ContentWriter contentWriter = this.requestWriter.getContentWriter(solrRequest);
        Collection<ContentStream> streams = contentWriter == null ? this.requestWriter.getContentStreams(solrRequest) : null;
        String path = this.requestWriter.getPath(solrRequest);
        if (path == null || !path.startsWith("/")) {
            path = DEFAULT_PATH;
        }
        if ((parser = solrRequest.getResponseParser()) == null) {
            parser = this.parser;
        }
        ModifiableSolrParams wparams = new ModifiableSolrParams(params);
        if (parser != null) {
            wparams.set("wt", parser.getWriterType());
            wparams.set("version", parser.getVersion());
        }
        Object object = basePath = solrRequest.getBasePath() == null ? this.serverBaseUrl : solrRequest.getBasePath();
        if (collection != null) {
            basePath = (String)basePath + "/" + collection;
        }
        if (solrRequest instanceof V2Request) {
            basePath = System.getProperty("solr.v2RealPath") == null ? this.changeV2RequestEndpoint((String)basePath) : this.serverBaseUrl + "/____v2";
        }
        if (SolrRequest.METHOD.GET == solrRequest.getMethod()) {
            if (streams != null || contentWriter != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "GET can't send streams!");
            }
            return this.httpClient.newRequest((String)basePath + path + wparams.toQueryString()).method(HttpMethod.GET);
        }
        if (SolrRequest.METHOD.DELETE == solrRequest.getMethod()) {
            return this.httpClient.newRequest((String)basePath + path + wparams.toQueryString()).method(HttpMethod.DELETE);
        }
        if (SolrRequest.METHOD.POST == solrRequest.getMethod() || SolrRequest.METHOD.PUT == solrRequest.getMethod()) {
            HttpMethod method;
            String url = (String)basePath + path;
            boolean hasNullStreamName = false;
            if (streams != null) {
                hasNullStreamName = streams.stream().anyMatch(cs -> cs.getName() == null);
            }
            boolean isMultipart = streams != null && streams.size() > 1 && !hasNullStreamName;
            HttpMethod httpMethod = method = SolrRequest.METHOD.POST == solrRequest.getMethod() ? HttpMethod.POST : HttpMethod.PUT;
            if (contentWriter != null) {
                Request req = this.httpClient.newRequest(url + wparams.toQueryString()).method(method);
                BinaryRequestWriter.BAOS baos = new BinaryRequestWriter.BAOS();
                contentWriter.write(baos);
                return req.content((ContentProvider)new ByteBufferContentProvider(contentWriter.getContentType(), new ByteBuffer[]{ByteBuffer.wrap(baos.getbuf(), 0, baos.size())}));
            }
            if (streams == null || isMultipart) {
                ModifiableSolrParams queryParams = this.calculateQueryParams(this.urlParamNames, wparams);
                queryParams.add(this.calculateQueryParams(solrRequest.getQueryParams(), wparams));
                Request req = this.httpClient.newRequest(url + queryParams.toQueryString()).method(method);
                return this.fillContentStream(req, streams, wparams, isMultipart);
            }
            ContentStream contentStream = streams.iterator().next();
            return this.httpClient.newRequest(url + wparams.toQueryString()).method(method).content((ContentProvider)new InputStreamContentProvider(contentStream.getStream()), contentStream.getContentType());
        }
        throw new SolrServerException("Unsupported method: " + solrRequest.getMethod());
    }

    private Request fillContentStream(Request req, Collection<ContentStream> streams, ModifiableSolrParams wparams, boolean isMultipart) throws IOException {
        if (isMultipart) {
            MultiPartContentProvider content = new MultiPartContentProvider();
            Iterator<String> iter = wparams.getParameterNamesIterator();
            while (iter.hasNext()) {
                String key = iter.next();
                String[] vals = wparams.getParams(key);
                if (vals == null) continue;
                for (String val : vals) {
                    content.addFieldPart(key, (ContentProvider)new StringContentProvider(val), null);
                }
            }
            if (streams != null) {
                for (ContentStream contentStream : streams) {
                    String name;
                    String contentType = contentStream.getContentType();
                    if (contentType == null) {
                        contentType = "multipart/form-data";
                    }
                    if ((name = contentStream.getName()) == null) {
                        name = "";
                    }
                    HttpFields.Mutable fields = HttpFields.build((int)1);
                    fields.add(HttpHeader.CONTENT_TYPE, contentType);
                    content.addFilePart(name, contentStream.getName(), (ContentProvider)new InputStreamContentProvider(contentStream.getStream()), (HttpFields)fields);
                }
            }
            req.content((ContentProvider)content);
        } else {
            Fields fields = new Fields();
            Iterator<String> iter = wparams.getParameterNamesIterator();
            while (iter.hasNext()) {
                String key = iter.next();
                String[] vals = wparams.getParams(key);
                if (vals == null) continue;
                for (String val : vals) {
                    fields.add(key, val);
                }
            }
            req.content((ContentProvider)new FormContentProvider(fields, FALLBACK_CHARSET));
        }
        return req;
    }

    private boolean wantStream(ResponseParser processor) {
        return processor == null || processor instanceof InputStreamResponseParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedList<Object> processErrorsAndResponse(Response response, ResponseParser processor, InputStream is, String mimeType, String encoding, boolean isV2Api) throws SolrServerException {
        Object error;
        NamedList<Object> rsp;
        Collection processorMimeTypes;
        boolean shouldClose = true;
        int httpStatus = response.getStatus();
        switch (httpStatus) {
            case 200: 
            case 400: 
            case 409: {
                break;
            }
            case 301: 
            case 302: {
                if (this.httpClient.isFollowRedirects()) break;
                throw new SolrServerException("Server at " + this.getBaseURL() + " sent back a redirect (" + httpStatus + ").");
            }
            default: {
                if (processor != null && mimeType != null) break;
                throw new BaseHttpSolrClient.RemoteSolrException(this.serverBaseUrl, httpStatus, "non ok status: " + httpStatus + ", message:" + response.getReason(), null);
            }
        }
        if (this.wantStream(processor)) {
            NamedList<Object> rsp2 = new NamedList<Object>();
            rsp2.add("stream", is);
            shouldClose = false;
            NamedList<Object> namedList = rsp2;
            return namedList;
        }
        Collection<String> processorSupportedContentTypes = processor.getContentTypes();
        if (processorSupportedContentTypes != null && !processorSupportedContentTypes.isEmpty() && !(processorMimeTypes = (Collection)processorSupportedContentTypes.stream().map(ct -> ContentType.parse((String)ct).getMimeType().trim().toLowerCase(Locale.ROOT)).collect(Collectors.toSet())).contains(mimeType)) {
            String allSupportedTypes = String.join((CharSequence)", ", processorMimeTypes);
            String prefix = "Expected mime type in [" + allSupportedTypes + "] but got " + mimeType + ". ";
            String exceptionEncoding = encoding != null ? encoding : FALLBACK_CHARSET.name();
            try {
                ByteArrayOutputStream body = new ByteArrayOutputStream();
                is.transferTo(body);
                throw new BaseHttpSolrClient.RemoteSolrException(this.serverBaseUrl, httpStatus, prefix + body.toString(exceptionEncoding), null);
            }
            catch (IOException e) {
                throw new BaseHttpSolrClient.RemoteSolrException(this.serverBaseUrl, httpStatus, "Could not parse response with encoding " + exceptionEncoding, e);
            }
        }
        try {
            rsp = processor.processResponse(is, encoding);
        }
        catch (Exception e) {
            throw new BaseHttpSolrClient.RemoteSolrException(this.serverBaseUrl, httpStatus, e.getMessage(), e);
        }
        Object object = error = rsp == null ? null : rsp.get("error");
        if (error != null && String.valueOf(Utils.getObjectByPath(error, true, errPath)).endsWith("ExceptionWithErrObject")) {
            throw BaseHttpSolrClient.RemoteExecutionException.create(this.serverBaseUrl, rsp);
        }
        if (httpStatus != 200 && !isV2Api) {
            NamedList<String> metadata = null;
            String reason = null;
            try {
                if (error != null) {
                    Object metadataObj;
                    reason = (String)Utils.getObjectByPath(error, false, Collections.singletonList("msg"));
                    if (reason == null) {
                        reason = (String)Utils.getObjectByPath(error, false, Collections.singletonList("trace"));
                    }
                    if ((metadataObj = Utils.getObjectByPath(error, false, Collections.singletonList("metadata"))) instanceof NamedList) {
                        metadata = (NamedList<String>)metadataObj;
                    } else if (metadataObj instanceof List) {
                        List list = (List)metadataObj;
                        metadata = new NamedList(list.size() / 2);
                        for (int i = 0; i < list.size(); i += 2) {
                            metadata.add((String)list.get(i), (String)list.get(i + 1));
                        }
                    } else if (metadataObj instanceof Map) {
                        metadata = new NamedList<String>((Map)metadataObj);
                    }
                }
            }
            catch (Exception metadataObj) {
                // empty catch block
            }
            if (reason == null) {
                StringBuilder msg = new StringBuilder();
                msg.append(response.getReason()).append("\n\n").append("request: ").append(response.getRequest().getMethod());
                reason = URLDecoder.decode(msg.toString(), FALLBACK_CHARSET);
            }
            BaseHttpSolrClient.RemoteSolrException rss = new BaseHttpSolrClient.RemoteSolrException(this.serverBaseUrl, httpStatus, reason, null);
            if (metadata != null) {
                rss.setMetadata(metadata);
            }
            throw rss;
        }
        NamedList<Object> namedList = rsp;
        return namedList;
        finally {
            if (shouldClose) {
                try {
                    is.close();
                    assert (ObjectReleaseTracker.release(is));
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Deprecated
    public void setRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    protected RequestWriter getRequestWriter() {
        return this.requestWriter;
    }

    @Deprecated
    public void setFollowRedirects(boolean follow) {
        this.httpClient.setFollowRedirects(follow);
    }

    public String getBaseURL() {
        return this.serverBaseUrl;
    }

    @Deprecated
    public Set<String> getQueryParams() {
        return this.getUrlParamNames();
    }

    public Set<String> getUrlParamNames() {
        return this.urlParamNames;
    }

    @Deprecated
    public void setUrlParamNames(Set<String> urlParamNames) {
        this.urlParamNames = urlParamNames;
    }

    private ModifiableSolrParams calculateQueryParams(Set<String> queryParamNames, ModifiableSolrParams wparams) {
        ModifiableSolrParams queryModParams = new ModifiableSolrParams();
        if (queryParamNames != null) {
            for (String param : queryParamNames) {
                String[] value = wparams.getParams(param);
                if (value == null) continue;
                for (String v : value) {
                    queryModParams.add(param, v);
                }
                wparams.remove(param);
            }
        }
        return queryModParams;
    }

    public ResponseParser getParser() {
        return this.parser;
    }

    @Deprecated
    public void setParser(ResponseParser parser) {
        this.parser = parser;
    }

    public static void setDefaultSSLConfig(SSLConfig sslConfig) {
        defaultSSLConfig = sslConfig;
    }

    public static void resetSslContextFactory() {
        defaultSSLConfig = null;
    }

    static SslContextFactory.Client getDefaultSslContextFactory() {
        String checkPeerNameStr = System.getProperty("solr.ssl.checkPeerName");
        boolean sslCheckPeerName = !"false".equalsIgnoreCase(checkPeerNameStr);
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client(!sslCheckPeerName);
        if (null != System.getProperty("javax.net.ssl.keyStore")) {
            sslContextFactory.setKeyStorePath(System.getProperty("javax.net.ssl.keyStore"));
        }
        if (null != System.getProperty("javax.net.ssl.keyStorePassword")) {
            sslContextFactory.setKeyStorePassword(System.getProperty("javax.net.ssl.keyStorePassword"));
        }
        if (null != System.getProperty("javax.net.ssl.keyStoreType")) {
            sslContextFactory.setKeyStoreType(System.getProperty("javax.net.ssl.keyStoreType"));
        }
        if (null != System.getProperty("javax.net.ssl.trustStore")) {
            sslContextFactory.setTrustStorePath(System.getProperty("javax.net.ssl.trustStore"));
        }
        if (null != System.getProperty("javax.net.ssl.trustStorePassword")) {
            sslContextFactory.setTrustStorePassword(System.getProperty("javax.net.ssl.trustStorePassword"));
        }
        if (null != System.getProperty("javax.net.ssl.trustStoreType")) {
            sslContextFactory.setTrustStoreType(System.getProperty("javax.net.ssl.trustStoreType"));
        }
        if (Boolean.parseBoolean(System.getProperty("solr.jetty.ssl.verifyClientHostName", "true"))) {
            sslContextFactory.setEndpointIdentificationAlgorithm("HTTPS");
        } else {
            sslContextFactory.setEndpointIdentificationAlgorithm(null);
        }
        return sslContextFactory;
    }

    static {
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        AGENT = "Solr[" + Http2SolrClient.class.getName() + "] 2.0";
        FALLBACK_CHARSET = StandardCharsets.UTF_8;
        errPath = Arrays.asList("metadata", "error-class");
        CANCELLED_EXCEPTION = new Exception();
        FAILED_MAKING_REQUEST_CANCELLABLE = () -> {};
    }

    private static class MDCCopyHelper
    extends HttpListenerFactory.RequestResponseListener {
        private final Map<String, String> submitterContext = MDC.getCopyOfContextMap();
        private Map<String, String> threadContext;

        private MDCCopyHelper() {
        }

        @Override
        public void onBegin(Request request) {
            this.threadContext = MDC.getCopyOfContextMap();
            MDCCopyHelper.updateContextMap(this.submitterContext);
        }

        @Override
        public void onComplete(Result result) {
            MDCCopyHelper.updateContextMap(this.threadContext);
        }

        private static void updateContextMap(Map<String, String> context) {
            if (context != null && !context.isEmpty()) {
                MDC.setContextMap(context);
            } else {
                MDC.clear();
            }
        }
    }

    public static class Builder {
        private Http2SolrClient http2SolrClient;
        private SSLConfig sslConfig = defaultSSLConfig;
        private Long idleTimeoutMillis;
        private Long connectionTimeoutMillis;
        private Long requestTimeoutMillis;
        private Integer maxConnectionsPerHost;
        private String basicAuthUser;
        private String basicAuthPassword;
        private boolean useHttp1_1 = Boolean.getBoolean("solr.http1");
        private boolean followRedirects = false;
        protected String baseSolrUrl;
        private ExecutorService executor;
        protected RequestWriter requestWriter;
        protected ResponseParser responseParser;
        private Set<String> urlParamNames = Set.of();

        public Builder() {
        }

        public Builder(String baseSolrUrl) {
            this.baseSolrUrl = baseSolrUrl;
        }

        public Http2SolrClient build() {
            Http2SolrClient client = new Http2SolrClient(this.baseSolrUrl, this);
            try {
                this.httpClientBuilderSetup(client);
            }
            catch (RuntimeException e) {
                try {
                    client.close();
                }
                catch (Exception exceptionOnClose) {
                    e.addSuppressed(exceptionOnClose);
                }
                throw e;
            }
            return client;
        }

        private void httpClientBuilderSetup(Http2SolrClient client) {
            String factoryClassName = System.getProperty("solr.httpclient.builder.factory");
            if (factoryClassName != null) {
                HttpClientBuilderFactory factory;
                log.debug("Using Http Builder Factory: {}", (Object)factoryClassName);
                try {
                    factory = (HttpClientBuilderFactory)Class.forName(factoryClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Unable to instantiate " + Http2SolrClient.class.getName(), e);
                }
                factory.setup(client);
            }
        }

        public Builder withHttpClient(Http2SolrClient httpClient) {
            this.http2SolrClient = httpClient;
            return this;
        }

        public Builder withRequestWriter(RequestWriter requestWriter) {
            this.requestWriter = requestWriter;
            return this;
        }

        public Builder withResponseParser(ResponseParser responseParser) {
            this.responseParser = responseParser;
            return this;
        }

        public Builder withFollowRedirects(boolean followRedirects) {
            this.followRedirects = followRedirects;
            return this;
        }

        public Builder withExecutor(ExecutorService executor) {
            this.executor = executor;
            return this;
        }

        public Builder withSSLConfig(SSLConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public Builder withBasicAuthCredentials(String user, String pass) {
            if (!(user == null && pass == null || user != null && pass != null)) {
                throw new IllegalStateException("Invalid Authentication credentials. Either both username and password or none must be provided");
            }
            this.basicAuthUser = user;
            this.basicAuthPassword = pass;
            return this;
        }

        public Builder withTheseParamNamesInTheUrl(Set<String> urlParamNames) {
            this.urlParamNames = urlParamNames;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder maxConnectionsPerHost(int max) {
            this.withMaxConnectionsPerHost(max);
            return this;
        }

        public Builder withMaxConnectionsPerHost(int max) {
            this.maxConnectionsPerHost = max;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder idleTimeout(int idleConnectionTimeout) {
            this.withIdleTimeout(idleConnectionTimeout, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder withIdleTimeout(long idleConnectionTimeout, TimeUnit unit) {
            this.idleTimeoutMillis = TimeUnit.MILLISECONDS.convert(idleConnectionTimeout, unit);
            return this;
        }

        public Builder useHttp1_1(boolean useHttp1_1) {
            this.useHttp1_1 = useHttp1_1;
            return this;
        }

        @Deprecated(since="9.2")
        public Builder connectionTimeout(int connectionTimeout) {
            this.withConnectionTimeout(connectionTimeout, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder withConnectionTimeout(long connectionTimeout, TimeUnit unit) {
            this.connectionTimeoutMillis = TimeUnit.MILLISECONDS.convert(connectionTimeout, unit);
            return this;
        }

        @Deprecated(since="9.2")
        public Builder requestTimeout(int requestTimeout) {
            this.withRequestTimeout(requestTimeout, TimeUnit.MILLISECONDS);
            return this;
        }

        public Builder withRequestTimeout(long requestTimeout, TimeUnit unit) {
            this.requestTimeoutMillis = TimeUnit.MILLISECONDS.convert(requestTimeout, unit);
            return this;
        }
    }

    private static class AsyncTracker {
        private static final int MAX_OUTSTANDING_REQUESTS = 1000;
        private final Phaser phaser = new Phaser(1);
        private final Semaphore available = new Semaphore(1000, false);
        private final Request.QueuedListener queuedListener = request -> {
            this.phaser.register();
            try {
                this.available.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        };
        private final Response.CompleteListener completeListener = result -> {
            this.phaser.arriveAndDeregister();
            this.available.release();
        };

        AsyncTracker() {
        }

        int getMaxRequestsQueuedPerDestination() {
            return 3000;
        }

        public void waitForComplete() {
            this.phaser.arriveAndAwaitAdvance();
            this.phaser.arriveAndDeregister();
        }
    }

    public static class OutStream
    implements Closeable {
        private final String origCollection;
        private final ModifiableSolrParams origParams;
        private final OutputStreamContentProvider outProvider;
        private final InputStreamResponseListener responseListener;
        private final boolean isXml;

        public OutStream(String origCollection, ModifiableSolrParams origParams, OutputStreamContentProvider outProvider, InputStreamResponseListener responseListener, boolean isXml) {
            this.origCollection = origCollection;
            this.origParams = origParams;
            this.outProvider = outProvider;
            this.responseListener = responseListener;
            this.isXml = isXml;
        }

        boolean belongToThisStream(SolrRequest<?> solrRequest, String collection) {
            ModifiableSolrParams solrParams = new ModifiableSolrParams(solrRequest.getParams());
            return this.origParams.toNamedList().equals(solrParams.toNamedList()) && StringUtils.equals(this.origCollection, collection);
        }

        public void write(byte[] b) throws IOException {
            this.outProvider.getOutputStream().write(b);
        }

        public void flush() throws IOException {
            this.outProvider.getOutputStream().flush();
        }

        @Override
        public void close() throws IOException {
            if (this.isXml) {
                this.write("</stream>".getBytes(FALLBACK_CHARSET));
            }
            this.outProvider.getOutputStream().close();
        }

        public InputStreamResponseListener getResponseListener() {
            return this.responseListener;
        }
    }
}

