/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.PerReplicaStates;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Replica
extends ZkNodeProps
implements MapWriter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public final String name;
    public final String node;
    public final String core;
    public final Type type;
    public final String shard;
    public final String collection;
    private DocCollection.PrsSupplier prsSupplier;
    private State state;
    private static final Map<String, State> STATES = new HashMap<String, State>();

    void setPrsSupplier(DocCollection.PrsSupplier prsSupplier) {
        this.prsSupplier = prsSupplier;
    }

    public Replica(String name, Map<String, Object> map, String collection, String shard) {
        super(new HashMap<String, Object>());
        this.propMap.putAll(map);
        this.collection = collection;
        this.shard = shard;
        this.name = name;
        this.node = (String)this.propMap.get("node_name");
        this.core = (String)this.propMap.get("core");
        this.type = Type.get((String)this.propMap.get("type"));
        this.state = State.getState(String.valueOf(this.propMap.getOrDefault("state", State.ACTIVE.toString())));
        this.validate();
    }

    public Replica(String name, String node, String collection, String shard, String core, State state, Type type, Map<String, Object> props) {
        super(new HashMap<String, Object>());
        this.name = name;
        this.node = node;
        this.state = state;
        this.type = type;
        this.collection = collection;
        this.shard = shard;
        this.core = core;
        if (props != null) {
            this.propMap.putAll(props);
        }
        this.validate();
    }

    public Replica(Map<String, Object> nestedMap) {
        super(new String[0]);
        this.name = nestedMap.keySet().iterator().next();
        Map details = (Map)nestedMap.get(this.name);
        Objects.requireNonNull(details);
        details = Utils.getDeepCopy(details, 4);
        this.collection = String.valueOf(details.get("collection"));
        this.shard = String.valueOf(details.get("shard"));
        this.core = String.valueOf(details.get("core"));
        this.node = String.valueOf(details.get("node_name"));
        this.propMap.putAll(details);
        this.type = Type.valueOf(String.valueOf(this.propMap.getOrDefault("type", "NRT")));
        if (this.state == null) {
            this.state = State.getState(String.valueOf(this.propMap.getOrDefault("state", "active")));
        }
        this.validate();
    }

    private final void validate() {
        Objects.requireNonNull(this.name, "'name' must not be null");
        Objects.requireNonNull(this.core, "'core' must not be null");
        Objects.requireNonNull(this.collection, "'collection' must not be null");
        Objects.requireNonNull(this.shard, "'shard' must not be null");
        Objects.requireNonNull(this.type, "'type' must not be null");
        Objects.requireNonNull(this.state, "'state' must not be null");
        Objects.requireNonNull(this.node, "'node' must not be null");
        String baseUrl = (String)this.propMap.get("base_url");
        Objects.requireNonNull(baseUrl, "'base_url' must not be null");
        this.propMap.put("node_name", this.node);
        this.propMap.put("core", this.core);
        this.propMap.put("type", this.type.toString());
        this.propMap.put("state", this.state.toString());
    }

    public String getCollection() {
        return this.collection;
    }

    public String getShard() {
        return this.shard;
    }

    @Override
    public Map<String, Object> getProperties() {
        return super.getProperties();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Replica)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Replica other = (Replica)o;
        return this.name.equals(other.name);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getCoreUrl() {
        return ZkCoreNodeProps.getCoreUrl(this.getBaseUrl(), this.core);
    }

    public String getBaseUrl() {
        return this.getStr("base_url");
    }

    public String getCoreName() {
        return this.core;
    }

    public String getNodeName() {
        return this.node;
    }

    public State getState() {
        if (this.prsSupplier != null) {
            PerReplicaStates.State s = this.prsSupplier.get().get(this.name);
            if (s != null) {
                return s.state;
            }
            return State.DOWN;
        }
        return this.state;
    }

    public void setState(State state) {
        this.state = state;
        this.propMap.put("state", this.state.toString());
    }

    public boolean isActive(Set<String> liveNodes) {
        return this.node != null && liveNodes.contains(this.node) && this.getState() == State.ACTIVE;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isLeader() {
        if (this.prsSupplier != null) {
            PerReplicaStates.State st = this.prsSupplier.get().get(this.name);
            return st == null ? false : st.isLeader;
        }
        return this.getBool("leader", false);
    }

    public Object get(String key, Object defValue) {
        Object o = this.get(key);
        if (o != null) {
            return o;
        }
        return defValue;
    }

    public String getProperty(String propertyName) {
        Object propertyKey = !propertyName.startsWith("property.") ? "property." + propertyName : propertyName;
        String propertyValue = this.getStr((String)propertyKey);
        return propertyValue;
    }

    public Replica copyWith(PerReplicaStates.State state) {
        log.debug("A replica is updated with new state : {}", (Object)state);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>(this.propMap);
        if (state == null) {
            props.put("state", State.DOWN.toString());
            props.remove("leader");
        } else {
            props.put("state", state.state.toString());
            if (state.isLeader.booleanValue()) {
                props.put("leader", "true");
            }
        }
        Replica r = new Replica(this.name, props, this.collection, this.shard);
        return r;
    }

    public PerReplicaStates.State getReplicaState() {
        if (this.prsSupplier != null) {
            return this.prsSupplier.get().get(this.name);
        }
        return null;
    }

    public Object clone() {
        return new Replica(this.name, this.node, this.collection, this.shard, this.core, this.getState(), this.type, this.propMap);
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)this.name, this._allPropsWriter());
    }

    public static State getState(String shortName) {
        return STATES.get(shortName);
    }

    private MapWriter _allPropsWriter() {
        return w -> {
            w.putIfNotNull((CharSequence)"core", this.core).putIfNotNull((CharSequence)"node_name", this.node).putIfNotNull((CharSequence)"type", this.type.toString()).putIfNotNull((CharSequence)"state", this.getState().toString()).putIfNotNull((CharSequence)"leader", () -> this.isLeader() ? "true" : null).putIfNotNull((CharSequence)"force_set_state", this.propMap.get("force_set_state")).putIfNotNull((CharSequence)"base_url", this.propMap.get("base_url"));
            for (Map.Entry e : this.propMap.entrySet()) {
                if (ReplicaStateProps.WELL_KNOWN_PROPS.contains(e.getKey())) continue;
                w.putIfNotNull((CharSequence)e.getKey(), e.getValue());
            }
        };
    }

    @Override
    public void write(JSONWriter jsonWriter) {
        jsonWriter.write(this._allPropsWriter());
    }

    @Override
    public String toString() {
        return this.name + ":" + Utils.toJSONString(this.propMap);
    }

    static {
        STATES.put(State.ACTIVE.shortName, State.ACTIVE);
        STATES.put(State.DOWN.shortName, State.DOWN);
        STATES.put(State.RECOVERING.shortName, State.RECOVERING);
        STATES.put(State.RECOVERY_FAILED.shortName, State.RECOVERY_FAILED);
    }

    public static interface ReplicaStateProps {
        public static final String COLLECTION = "collection";
        public static final String SHARD_ID = "shard";
        public static final String LEADER = "leader";
        public static final String STATE = "state";
        public static final String CORE_NAME = "core";
        public static final String CORE_NODE_NAME = "core_node_name";
        public static final String TYPE = "type";
        public static final String NODE_NAME = "node_name";
        public static final String BASE_URL = "base_url";
        public static final String PROPERTY_PREFIX = "property.";
        public static final String FORCE_SET_STATE = "force_set_state";
        public static final Set<String> WELL_KNOWN_PROPS = Set.of("leader", "state", "core", "core_node_name", "type", "node_name", "base_url", "force_set_state");
    }

    public static enum Type {
        NRT(true),
        TLOG(true),
        PULL(false);

        public final boolean leaderEligible;

        private Type(boolean b) {
            this.leaderEligible = b;
        }

        public static Type get(String name) {
            return name == null ? NRT : Type.valueOf(name.toUpperCase(Locale.ROOT));
        }

        public static boolean isLeaderType(Type type) {
            return type == null || type == NRT || type == TLOG;
        }
    }

    public static enum State {
        ACTIVE("A"),
        DOWN("D"),
        RECOVERING("R"),
        RECOVERY_FAILED("F");

        public final String shortName;
        public final String longName;

        private State(String c) {
            this.shortName = c;
            this.longName = super.toString().toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.longName;
        }

        public static State getState(String stateStr) {
            return stateStr == null ? null : State.valueOf(stateStr.toUpperCase(Locale.ROOT));
        }
    }
}

