/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.RoutedAliasTypes;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.client.solrj.util.SolrIdentifierValidator;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;

public abstract class CollectionAdminRequest<T extends CollectionAdminResponse>
extends SolrRequest<T>
implements MapWriter {
    public static final java.util.List<String> MODIFIABLE_COLLECTION_PROPERTIES = Arrays.asList("replicationFactor", "collection.configName", "perReplicaState", "readOnly");
    protected final CollectionParams.CollectionAction action;
    @Deprecated
    public static String PROPERTY_PREFIX = "property.";

    public CollectionAdminRequest(CollectionParams.CollectionAction action) {
        this("/admin/collections", action);
    }

    public CollectionAdminRequest(String path, CollectionParams.CollectionAction action) {
        super(SolrRequest.METHOD.GET, path);
        this.action = CollectionAdminRequest.checkNotNull("action", action);
    }

    @Override
    public SolrParams getParams() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", this.action.toString());
        return params;
    }

    protected void addProperties(ModifiableSolrParams params, Properties props) {
        for (String propertyName : props.stringPropertyNames()) {
            params.set(PROPERTY_PREFIX + propertyName, props.getProperty(propertyName));
        }
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)"class", this.getClass().getName());
        ew.put((CharSequence)"method", this.getMethod().toString());
        SolrParams params = this.getParams();
        if (params != null) {
            Iterator<String> it = params.getParameterNamesIterator();
            while (it.hasNext()) {
                String[] values;
                String name = it.next();
                for (String value : values = params.getParams(name)) {
                    ew.put((CharSequence)("params." + name), value);
                }
            }
        }
    }

    public String toString() {
        return this.jsonStr();
    }

    @Override
    public String getRequestType() {
        return SolrRequest.SolrRequestType.ADMIN.toString();
    }

    protected <T extends CollectionAdminRequest<? extends CollectionAdminResponse>> T propagateBasicAuthCreds(T req) {
        String user = this.getBasicAuthUser();
        String pass = this.getBasicAuthPassword();
        if (user != null && pass != null && req.getBasicAuthUser() == null) {
            req.setBasicAuthCredentials(user, pass);
        }
        return req;
    }

    public static Create createCollection(String collection, String config, Integer numShards, Integer numNrtReplicas, Integer numTlogReplicas, Integer numPullReplicas) {
        return new Create(collection, config, numShards, numNrtReplicas, numTlogReplicas, numPullReplicas);
    }

    public static Create createCollection(String collection, String config, int numShards, int numReplicas) {
        return new Create(collection, config, numShards, numReplicas, null, null);
    }

    public static Create createCollection(String collection, int numShards, int numReplicas) {
        return new Create(collection, null, numShards, numReplicas, 0, 0);
    }

    public static Create createCollectionWithImplicitRouter(String collection, String config, String shards, int numReplicas) {
        return new Create(collection, config, shards, numReplicas);
    }

    public static Create createCollectionWithImplicitRouter(String collection, String config, String shards, int numNrtReplicas, int numTlogReplicas, int numPullReplicas) {
        return new Create(collection, config, "implicit", null, CollectionAdminRequest.checkNotNull("shards", shards), numNrtReplicas, numTlogReplicas, numPullReplicas);
    }

    public static Modify modifyCollection(String collection, Map<String, Object> properties) {
        return new Modify(collection, properties);
    }

    public static Reload reloadCollection(String collection) {
        return new Reload(collection);
    }

    public static Rename renameCollection(String collection, String target) {
        return new Rename(collection, target);
    }

    public static DeleteNode deleteNode(String node) {
        return new DeleteNode(node);
    }

    public static MoveReplica moveReplica(String collection, String replica, String targetNode) {
        return new MoveReplica(collection, replica, targetNode);
    }

    public static RebalanceLeaders rebalanceLeaders(String collection) {
        return new RebalanceLeaders(collection);
    }

    public static ReindexCollection reindexCollection(String collection) {
        return new ReindexCollection(collection);
    }

    public static ColStatus collectionStatus(String collection) {
        CollectionAdminRequest.checkNotNull("collection", collection);
        return new ColStatus(collection);
    }

    public static ColStatus collectionStatuses() {
        return new ColStatus();
    }

    public static Delete deleteCollection(String collection) {
        return new Delete(collection);
    }

    public static Backup backupCollection(String collection, String backupName) {
        return new Backup(collection, backupName);
    }

    public static Restore restoreCollection(String collection, String backupName) {
        return new Restore(collection, backupName);
    }

    public static InstallShard installDataToShard(String collection, String shard, String location, String backupRepository) {
        return new InstallShard(collection, shard, location, backupRepository);
    }

    public static InstallShard installDataToShard(String collection, String shard, String location) {
        return new InstallShard(collection, shard, location, null);
    }

    static <T> T checkNotNull(String param, T value) {
        if (value == null) {
            throw new NullPointerException("Please specify a non-null value for parameter " + param);
        }
        return value;
    }

    public static CreateShard createShard(String collection, String shard) {
        return new CreateShard(collection, shard);
    }

    public static MockCollTask mockCollTask(String collection) {
        return new MockCollTask(collection);
    }

    public static SplitShard splitShard(String collection) {
        return new SplitShard(collection);
    }

    public static DeleteShard deleteShard(String collection, String shard) {
        return new DeleteShard(collection, shard);
    }

    public static ForceLeader forceLeaderElection(String collection, String shard) {
        return new ForceLeader(collection, shard);
    }

    public static RequestStatus requestStatus(String requestId) {
        return new RequestStatus(requestId);
    }

    public static void waitForAsyncRequest(String requestId, SolrClient client, long timeout) throws SolrServerException, InterruptedException, IOException {
        CollectionAdminRequest.requestStatus(requestId).waitFor(client, timeout);
    }

    public static DeleteStatus deleteAsyncId(String requestId) {
        return new DeleteStatus(CollectionAdminRequest.checkNotNull("requestId", requestId), null);
    }

    public static DeleteStatus deleteAllAsyncIds() {
        return new DeleteStatus(null, true);
    }

    public static SetAliasProperty setAliasProperty(String aliasName) {
        return new SetAliasProperty(aliasName);
    }

    public static CreateAlias createAlias(String aliasName, String aliasedCollections) {
        return new CreateAlias(aliasName, aliasedCollections);
    }

    public static CreateTimeRoutedAlias createTimeRoutedAlias(String aliasName, String start, String interval, String routerField, Create createCollTemplate) {
        return new CreateTimeRoutedAlias(aliasName, routerField, start, interval, createCollTemplate);
    }

    public static CreateCategoryRoutedAlias createCategoryRoutedAlias(String aliasName, String routerField, int maxCardinality, Create createCollTemplate) {
        return new CreateCategoryRoutedAlias(aliasName, routerField, maxCardinality, createCollTemplate);
    }

    public static DimensionalRoutedAlias createDimensionalRoutedAlias(String aliasName, Create createCollTemplate, RoutedAliasAdminRequest ... dims) {
        return new DimensionalRoutedAlias(aliasName, createCollTemplate, dims);
    }

    public static DeleteAlias deleteAlias(String aliasName) {
        return new DeleteAlias(aliasName);
    }

    public static AddReplica addReplicaToShard(String collection, String shard) {
        return CollectionAdminRequest.addReplicaToShard(collection, shard, Replica.Type.NRT);
    }

    public static AddReplica addReplicaToShard(String collection, String shard, Replica.Type replicaType) {
        return new AddReplica(collection, CollectionAdminRequest.checkNotNull("shard", shard), null, replicaType);
    }

    public static AddReplica addReplicaByRouteKey(String collection, String routeKey) {
        return new AddReplica(collection, null, CollectionAdminRequest.checkNotNull("routeKey", routeKey), null);
    }

    public static DeleteReplica deleteReplica(String collection, String shard, String replica) {
        return new DeleteReplica(collection, CollectionAdminRequest.checkNotNull("shard", shard), CollectionAdminRequest.checkNotNull("replica", replica));
    }

    public static DeleteReplica deleteReplica(String collection, String shard, int count) {
        return new DeleteReplica(collection, CollectionAdminRequest.checkNotNull("shard", shard), count);
    }

    public static DeleteReplica deleteReplicasFromShard(String collection, String shard, int count) {
        return new DeleteReplica(collection, CollectionAdminRequest.checkNotNull("shard", shard), count);
    }

    public static DeleteReplica deleteReplicasFromAllShards(String collection, int count) {
        return new DeleteReplica(collection, count);
    }

    public static ClusterProp setClusterProperty(String propertyName, String propertyValue) {
        return new ClusterProp(propertyName, propertyValue);
    }

    public static CollectionProp setCollectionProperty(String collection, String propertyName, String propertyValue) {
        return new CollectionProp(collection, propertyName, propertyValue);
    }

    public static Migrate migrateData(String collection, String targetCollection, String splitKey) {
        return new Migrate(collection, targetCollection, splitKey);
    }

    public static AddRole addRole(String node, String role) {
        return new AddRole(node, role);
    }

    public static RemoveRole removeRole(String node, String role) {
        return new RemoveRole(node, role);
    }

    public static OverseerStatus getOverseerStatus() {
        return new OverseerStatus();
    }

    public static ClusterStatus getClusterStatus() {
        return new ClusterStatus();
    }

    public static java.util.List<String> listCollections(SolrClient client) throws IOException, SolrServerException {
        CollectionAdminResponse resp = (CollectionAdminResponse)new List().process(client);
        return (java.util.List)resp.getResponse().get("collections");
    }

    public static DeleteBackup deleteBackupById(String backupName, int backupId) {
        return new DeleteBackup(backupName).setBackupId(backupId);
    }

    public static DeleteBackup deleteBackupByRecency(String backupName, int numRecentBackupPointsToRetain) {
        return new DeleteBackup(backupName).setMaxNumBackupPoints(numRecentBackupPointsToRetain);
    }

    public static DeleteBackup deleteBackupPurgeUnusedFiles(String backupName) {
        return new DeleteBackup(backupName).setPurgeUnused();
    }

    public static ListBackup listBackup(String backupName) {
        return new ListBackup(backupName);
    }

    public static AddReplicaProp addReplicaProperty(String collection, String shard, String replica, String propertyName, String propertyValue) {
        return new AddReplicaProp(collection, shard, replica, propertyName, propertyValue);
    }

    public static DeleteReplicaProp deleteReplicaProperty(String collection, String shard, String replica, String propertyName) {
        return new DeleteReplicaProp(collection, shard, replica, propertyName);
    }

    public static BalanceShardUnique balanceReplicaProperty(String collection, String propertyName) {
        return new BalanceShardUnique(collection, propertyName);
    }

    public static class Modify
    extends AsyncCollectionSpecificAdminRequest {
        protected Map<String, Object> attributes;

        private Modify(String collection, Map<String, Object> attributes) {
            super(CollectionParams.CollectionAction.MODIFYCOLLECTION, collection);
            this.attributes = attributes;
        }

        public void setAttributes(Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        public Modify setAttribute(String key, Object value) {
            if (key == null) {
                throw new IllegalArgumentException("Attribute key cannot be null for the modify collection API");
            }
            if (!MODIFIABLE_COLLECTION_PROPERTIES.contains(key)) {
                throw new IllegalArgumentException("Unknown attribute key: " + key + ". Must be one of: " + MODIFIABLE_COLLECTION_PROPERTIES);
            }
            if (value == null) {
                throw new IllegalArgumentException("Value cannot be null for key: " + key);
            }
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(key, value);
            return this;
        }

        public Modify unsetAttribute(String key) {
            if (key == null) {
                throw new IllegalArgumentException("Attribute key cannot be null for the modify collection API");
            }
            if (!MODIFIABLE_COLLECTION_PROPERTIES.contains(key)) {
                throw new IllegalArgumentException("Unknown attribute key: " + key + ". Must be one of: " + MODIFIABLE_COLLECTION_PROPERTIES);
            }
            if (this.attributes == null) {
                this.attributes = new HashMap<String, Object>();
            }
            this.attributes.put(key, "");
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("collection", this.collection);
            for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                params.set(entry.getKey(), String.valueOf(entry.getValue()));
            }
            return params;
        }
    }

    public static class BalanceShardUnique
    extends AsyncCollectionAdminRequest {
        protected String collection;
        protected String propertyName;
        protected Boolean onlyActiveNodes;
        protected Boolean shardUnique;

        private BalanceShardUnique(String collection, String propertyName) {
            super(CollectionParams.CollectionAction.BALANCESHARDUNIQUE);
            this.collection = BalanceShardUnique.checkNotNull("collection", collection);
            this.propertyName = BalanceShardUnique.checkNotNull("propertyName", propertyName);
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public Boolean getOnlyActiveNodes() {
            return this.onlyActiveNodes;
        }

        public BalanceShardUnique setOnlyActiveNodes(Boolean onlyActiveNodes) {
            this.onlyActiveNodes = onlyActiveNodes;
            return this;
        }

        public Boolean getShardUnique() {
            return this.shardUnique;
        }

        public BalanceShardUnique setShardUnique(Boolean shardUnique) {
            this.shardUnique = shardUnique;
            return this;
        }

        @Override
        public String getCollection() {
            return this.collection;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("collection", this.collection);
            params.set("property", this.propertyName);
            if (this.onlyActiveNodes != null) {
                params.set("onlyactivenodes", this.onlyActiveNodes);
            }
            if (this.shardUnique != null) {
                params.set("shardUnique", this.shardUnique);
            }
            return params;
        }
    }

    public static class DeleteReplicaProp
    extends AsyncShardSpecificAdminRequest {
        private final String replica;
        private final String propertyName;

        private DeleteReplicaProp(String collection, String shard, String replica, String propertyName) {
            super(CollectionParams.CollectionAction.DELETEREPLICAPROP, collection, shard);
            this.replica = DeleteReplicaProp.checkNotNull("replica", replica);
            this.propertyName = DeleteReplicaProp.checkNotNull("propertyName", propertyName);
        }

        public String getReplica() {
            return this.replica;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("replica", this.replica);
            params.set("property", this.propertyName);
            return params;
        }
    }

    public static class AddReplicaProp
    extends AsyncShardSpecificAdminRequest {
        private String replica;
        private String propertyName;
        private String propertyValue;
        private Boolean shardUnique;

        private AddReplicaProp(String collection, String shard, String replica, String propertyName, String propertyValue) {
            super(CollectionParams.CollectionAction.ADDREPLICAPROP, collection, shard);
            this.replica = AddReplicaProp.checkNotNull("replica", replica);
            this.propertyName = AddReplicaProp.checkNotNull("propertyName", propertyName);
            this.propertyValue = AddReplicaProp.checkNotNull("propertyValue", propertyValue);
        }

        public String getReplica() {
            return this.replica;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public Boolean getShardUnique() {
            return this.shardUnique;
        }

        public AddReplicaProp setShardUnique(Boolean shardUnique) {
            this.shardUnique = shardUnique;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("replica", this.replica);
            params.set("property", this.propertyName);
            params.set("property.value", this.propertyValue);
            if (this.shardUnique != null) {
                params.set("shardUnique", this.shardUnique);
            }
            return params;
        }
    }

    public static class ListBackup
    extends CollectionAdminRequest<CollectionAdminResponse> {
        private final String backupName;
        private String location;
        private String repositoryName;

        private ListBackup(String backupName) {
            super(CollectionParams.CollectionAction.LISTBACKUP);
            this.backupName = backupName;
        }

        public ListBackup setBackupRepository(String backupRepository) {
            this.repositoryName = backupRepository;
            return this;
        }

        public ListBackup setBackupLocation(String backupLocation) {
            this.location = backupLocation;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("name", this.backupName);
            params.setNonNull("location", this.location);
            params.setNonNull("repository", this.repositoryName);
            return params;
        }

        @Override
        protected CollectionAdminResponse createResponse(SolrClient client) {
            return new CollectionAdminResponse();
        }
    }

    public static class DeleteBackup
    extends CollectionAdminRequest<CollectionAdminResponse> {
        private final String name;
        private String repository;
        private String location;
        private Integer backupId;
        private Integer maxNumBackupPoints;
        private Boolean purgeUnused;

        private DeleteBackup(String backupName) {
            super(CollectionParams.CollectionAction.DELETEBACKUP);
            this.name = backupName;
        }

        public DeleteBackup setRepositoryName(String backupRepository) {
            this.repository = backupRepository;
            return this;
        }

        public DeleteBackup setLocation(String backupLocation) {
            this.location = backupLocation;
            return this;
        }

        protected DeleteBackup setBackupId(int backupId) {
            this.backupId = backupId;
            return this;
        }

        protected DeleteBackup setMaxNumBackupPoints(int backupPointsToRetain) {
            this.maxNumBackupPoints = backupPointsToRetain;
            return this;
        }

        protected DeleteBackup setPurgeUnused() {
            this.purgeUnused = true;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("name", this.name);
            params.setNonNull("location", this.location);
            params.setNonNull("repository", this.repository);
            params.setNonNull("backupId", this.backupId);
            params.setNonNull("maxNumBackupPoints", this.maxNumBackupPoints);
            params.setNonNull("purgeUnused", this.purgeUnused);
            return params;
        }

        @Override
        protected CollectionAdminResponse createResponse(SolrClient client) {
            return new CollectionAdminResponse();
        }
    }

    public static class List
    extends CollectionAdminRequest<CollectionAdminResponse> {
        public List() {
            super(CollectionParams.CollectionAction.LIST);
        }

        @Override
        protected CollectionAdminResponse createResponse(SolrClient client) {
            return new CollectionAdminResponse();
        }
    }

    public static class ListAliases
    extends CollectionAdminRequest<CollectionAdminResponse> {
        public ListAliases() {
            super(CollectionParams.CollectionAction.LISTALIASES);
        }

        @Override
        protected CollectionAdminResponse createResponse(SolrClient client) {
            return new CollectionAdminResponse();
        }
    }

    public static class ClusterStatus
    extends CollectionAdminRequest<CollectionAdminResponse> {
        protected String shardName = null;
        protected String collection = null;
        protected String routeKey = null;

        public ClusterStatus() {
            super(CollectionParams.CollectionAction.CLUSTERSTATUS);
        }

        public ClusterStatus setCollectionName(String collectionName) {
            this.collection = collectionName;
            return this;
        }

        public String getCollectionName() {
            return this.collection;
        }

        public ClusterStatus setShardName(String shard) {
            this.shardName = shard;
            return this;
        }

        public String getShardName() {
            return this.shardName;
        }

        public String getRouteKey() {
            return this.routeKey;
        }

        public ClusterStatus setRouteKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            if (this.collection != null) {
                params.set("collection", this.collection);
            }
            if (this.shardName != null) {
                params.set("shard", this.shardName);
            }
            if (this.routeKey != null) {
                params.set("_route_", this.routeKey);
            }
            return params;
        }

        @Override
        protected CollectionAdminResponse createResponse(SolrClient client) {
            return new CollectionAdminResponse();
        }
    }

    public static class RequestApiDistributedProcessingResponse
    extends CollectionAdminResponse {
        public boolean getIsCollectionApiDistributed() {
            return (Boolean)this.getResponse().get("isDistributedApi");
        }
    }

    public static class RequestApiDistributedProcessing
    extends CollectionAdminRequest<RequestApiDistributedProcessingResponse> {
        public RequestApiDistributedProcessing() {
            super(CollectionParams.CollectionAction.DISTRIBUTEDAPIPROCESSING);
        }

        @Override
        protected RequestApiDistributedProcessingResponse createResponse(SolrClient client) {
            return new RequestApiDistributedProcessingResponse();
        }
    }

    public static class OverseerStatus
    extends AsyncCollectionAdminRequest {
        public OverseerStatus() {
            super(CollectionParams.CollectionAction.OVERSEERSTATUS);
        }
    }

    public static class RemoveRole
    extends CollectionAdminRoleRequest {
        private RemoveRole(String node, String role) {
            super(CollectionParams.CollectionAction.REMOVEROLE, node, role);
        }
    }

    public static class AddRole
    extends CollectionAdminRoleRequest {
        private AddRole(String node, String role) {
            super(CollectionParams.CollectionAction.ADDROLE, node, role);
        }
    }

    public static class Migrate
    extends AsyncCollectionAdminRequest {
        private String collection;
        private String targetCollection;
        private String splitKey;
        private Integer forwardTimeout;
        private Properties properties;

        private Migrate(String collection, String targetCollection, String splitKey) {
            super(CollectionParams.CollectionAction.MIGRATE);
            this.collection = Migrate.checkNotNull("collection", collection);
            this.targetCollection = Migrate.checkNotNull("targetCollection", targetCollection);
            this.splitKey = Migrate.checkNotNull("split.key", splitKey);
        }

        public String getCollectionName() {
            return this.collection;
        }

        public String getTargetCollection() {
            return this.targetCollection;
        }

        public String getSplitKey() {
            return this.splitKey;
        }

        public Migrate setForwardTimeout(int forwardTimeout) {
            this.forwardTimeout = forwardTimeout;
            return this;
        }

        public Integer getForwardTimeout() {
            return this.forwardTimeout;
        }

        public Migrate setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Properties getProperties() {
            return this.properties;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("collection", this.collection);
            params.set("target.collection", this.targetCollection);
            params.set("split.key", this.splitKey);
            if (this.forwardTimeout != null) {
                params.set("forward.timeout", this.forwardTimeout);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            return params;
        }
    }

    public static class CollectionProp
    extends AsyncCollectionSpecificAdminRequest {
        private String propertyName;
        private String propertyValue;

        private CollectionProp(String collection, String propertyName, String propertyValue) {
            super(CollectionParams.CollectionAction.COLLECTIONPROP, collection);
            this.propertyName = CollectionProp.checkNotNull("propertyName", propertyName);
            this.propertyValue = propertyValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.add("propertyName", this.propertyName);
            params.add("propertyValue", this.propertyValue);
            return params;
        }

        @Override
        protected CollectionAdminResponse createResponse(SolrClient client) {
            return new CollectionAdminResponse();
        }
    }

    public static class ClusterProp
    extends CollectionAdminRequest<CollectionAdminResponse> {
        private String propertyName;
        private String propertyValue;

        private ClusterProp(String propertyName, String propertyValue) {
            super(CollectionParams.CollectionAction.CLUSTERPROP);
            this.propertyName = ClusterProp.checkNotNull("propertyName", propertyName);
            this.propertyValue = propertyValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.add("name", this.propertyName);
            params.add("val", this.propertyValue);
            return params;
        }

        @Override
        protected CollectionAdminResponse createResponse(SolrClient client) {
            return new CollectionAdminResponse();
        }
    }

    public static class DeleteReplica
    extends AsyncCollectionSpecificAdminRequest {
        protected String shard;
        protected String replica;
        protected Boolean onlyIfDown;
        private Boolean deleteDataDir;
        private Boolean deleteInstanceDir;
        private Boolean deleteIndexDir;
        private Integer count;

        private DeleteReplica(String collection, String shard, String replica) {
            super(CollectionParams.CollectionAction.DELETEREPLICA, collection);
            this.shard = shard;
            this.replica = replica;
        }

        private DeleteReplica(String collection, String shard, int count) {
            super(CollectionParams.CollectionAction.DELETEREPLICA, collection);
            this.shard = shard;
            this.count = count;
        }

        private DeleteReplica(String collection, int count) {
            super(CollectionParams.CollectionAction.DELETEREPLICA, collection);
            this.count = count;
        }

        public String getReplica() {
            return this.replica;
        }

        public DeleteReplica setOnlyIfDown(boolean onlyIfDown) {
            this.onlyIfDown = onlyIfDown;
            return this;
        }

        public Boolean getOnlyIfDown() {
            return this.onlyIfDown;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.remove("name");
            params.set("collection", this.collection);
            if (this.replica != null) {
                params.set("replica", this.replica);
            }
            if (this.shard != null) {
                params.set("shard", this.shard);
            }
            if (this.onlyIfDown != null) {
                params.set("onlyIfDown", this.onlyIfDown);
            }
            if (this.deleteDataDir != null) {
                params.set("deleteDataDir", this.deleteDataDir);
            }
            if (this.deleteInstanceDir != null) {
                params.set("deleteInstanceDir", this.deleteInstanceDir);
            }
            if (this.deleteIndexDir != null) {
                params.set("deleteIndex", this.deleteIndexDir);
            }
            if (this.count != null) {
                params.set("count", this.count);
            }
            return params;
        }

        public Boolean getDeleteDataDir() {
            return this.deleteDataDir;
        }

        public DeleteReplica setDeleteDataDir(Boolean deleteDataDir) {
            this.deleteDataDir = deleteDataDir;
            return this;
        }

        public Boolean getDeleteInstanceDir() {
            return this.deleteInstanceDir;
        }

        public DeleteReplica setDeleteInstanceDir(Boolean deleteInstanceDir) {
            this.deleteInstanceDir = deleteInstanceDir;
            return this;
        }

        public Boolean getDeleteIndexDir() {
            return this.deleteIndexDir;
        }

        public DeleteReplica setDeleteIndexDir(Boolean deleteIndexDir) {
            this.deleteIndexDir = deleteIndexDir;
            return this;
        }
    }

    public static class AddReplica
    extends AsyncCollectionAdminRequest {
        private static final String REPLICA_TYPE_PARAM = "type";
        protected String collection;
        protected String shard;
        protected String node;
        protected String coreName;
        protected String routeKey;
        protected String instanceDir;
        protected String dataDir;
        protected String ulogDir;
        protected Properties properties;
        protected Replica.Type type;
        protected Integer nrtReplicas;
        protected Integer tlogReplicas;
        protected Integer pullReplicas;
        protected Boolean skipNodeAssignment;
        protected String createNodeSet;

        private AddReplica(String collection, String shard, String routeKey, Replica.Type type) {
            super(CollectionParams.CollectionAction.ADDREPLICA);
            this.collection = AddReplica.checkNotNull("collection", collection);
            this.shard = shard;
            this.routeKey = routeKey;
            this.type = type;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public AddReplica setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public AddReplica withProperty(String key, String value) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.setProperty(key, value);
            return this;
        }

        public String getNode() {
            return this.node;
        }

        public AddReplica setNode(String node) {
            this.node = node;
            return this;
        }

        public AddReplica setSkipNodeAssignment(Boolean skipNodeAssignment) {
            this.skipNodeAssignment = skipNodeAssignment;
            return this;
        }

        public String getRouteKey() {
            return this.routeKey;
        }

        public String getInstanceDir() {
            return this.instanceDir;
        }

        public String getUlogDir() {
            return this.ulogDir;
        }

        public AddReplica setInstanceDir(String instanceDir) {
            this.instanceDir = instanceDir;
            return this;
        }

        public String getDataDir() {
            return this.dataDir;
        }

        public AddReplica setDataDir(String dataDir) {
            this.dataDir = dataDir;
            return this;
        }

        public AddReplica setType(Replica.Type type) {
            this.type = type;
            return this;
        }

        public AddReplica setCoreName(String coreName) {
            this.coreName = coreName;
            return this;
        }

        public AddReplica setUlogDir(String ulogDir) {
            this.ulogDir = ulogDir;
            return this;
        }

        public String getShard() {
            return this.shard;
        }

        public Integer getNrtReplicas() {
            return this.nrtReplicas;
        }

        public AddReplica setNrtReplicas(Integer nrtReplicas) {
            this.nrtReplicas = nrtReplicas;
            return this;
        }

        public Integer getTlogReplicas() {
            return this.tlogReplicas;
        }

        public AddReplica setTlogReplicas(Integer tlogReplicas) {
            this.tlogReplicas = tlogReplicas;
            return this;
        }

        public Integer getPullReplicas() {
            return this.pullReplicas;
        }

        public AddReplica setPullReplicas(Integer pullReplicas) {
            this.pullReplicas = pullReplicas;
            return this;
        }

        public String getCreateNodeSet() {
            return this.createNodeSet;
        }

        public AddReplica setCreateNodeSet(String createNodeSet) {
            this.createNodeSet = createNodeSet;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.add("collection", this.collection);
            assert (null == this.routeKey ^ null == this.shard);
            if (null != this.shard) {
                params.add("shard", this.shard);
            }
            if (null != this.routeKey) {
                params.add("_route_", this.routeKey);
            }
            if (this.node != null) {
                params.add("node", this.node);
            }
            if (this.skipNodeAssignment != null) {
                params.add("skipNodeAssignment", String.valueOf(this.skipNodeAssignment));
            }
            if (this.instanceDir != null) {
                params.add("instanceDir", this.instanceDir);
            }
            if (this.dataDir != null) {
                params.add("dataDir", this.dataDir);
            }
            if (this.ulogDir != null) {
                params.add("ulogDir", this.ulogDir);
            }
            if (this.coreName != null) {
                params.add("name", this.coreName);
            }
            if (this.type != null) {
                params.add(REPLICA_TYPE_PARAM, this.type.name());
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            if (this.nrtReplicas != null) {
                params.add("nrtReplicas", String.valueOf(this.nrtReplicas));
            }
            if (this.tlogReplicas != null) {
                params.add("tlogReplicas", String.valueOf(this.tlogReplicas));
            }
            if (this.pullReplicas != null) {
                params.add("pullReplicas", String.valueOf(this.pullReplicas));
            }
            if (this.createNodeSet != null) {
                params.add("createNodeSet", this.createNodeSet);
            }
            return params;
        }
    }

    public static class DeleteAlias
    extends AsyncCollectionAdminRequest {
        protected String aliasName;

        private DeleteAlias(String aliasName) {
            super(CollectionParams.CollectionAction.DELETEALIAS);
            this.aliasName = DeleteAlias.checkNotNull("aliasName", aliasName);
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("name", this.aliasName);
            return params;
        }
    }

    public static class DimensionalRoutedAlias
    extends AsyncCollectionAdminRequest
    implements RoutedAliasAdminRequest {
        private String aliasName;
        private final Create createCollTemplate;
        private final RoutedAliasAdminRequest[] dims;

        public DimensionalRoutedAlias(String aliasName, Create createCollTemplate, RoutedAliasAdminRequest ... dims) {
            super(CollectionParams.CollectionAction.CREATEALIAS);
            this.aliasName = aliasName;
            this.createCollTemplate = createCollTemplate;
            this.dims = dims;
        }

        public static void addDimensionIndexIfRequired(Set<String> params, int i, String param) {
            params.add(DimensionalRoutedAlias.withDimensionIndexIfRequired(param, i));
        }

        private static String withDimensionIndexIfRequired(String param, int index) {
            if (param.startsWith("router.")) {
                return "router." + index + "." + param.split("\\.")[1];
            }
            return param;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            ArrayList<String> types = new ArrayList<String>();
            ArrayList<String> fields = new ArrayList<String>();
            for (int i = 0; i < this.dims.length; ++i) {
                RoutedAliasAdminRequest dim = this.dims[i];
                types.add(dim.getType().name());
                fields.add(dim.getRouterField());
                for (String param : dim.getParamNames()) {
                    String value = dim.getParams().get(param);
                    if (value != null) {
                        params.add(DimensionalRoutedAlias.withDimensionIndexIfRequired(param, i), value);
                        continue;
                    }
                    if (!dim.getRequiredParamNames().contains(param)) continue;
                    throw new IllegalArgumentException("Dimension of type " + dim.getType() + " requires a value for " + param);
                }
            }
            params.add("name", this.aliasName);
            params.add("router.name", "Dimensional[" + String.join((CharSequence)",", types) + "]");
            params.add("router.field", String.join((CharSequence)",", fields));
            ModifiableSolrParams createCollParams = this.mergeCollParams(this.createCollTemplate);
            return SolrParams.wrapDefaults(params, createCollParams);
        }

        @Override
        public RoutedAliasTypes getType() {
            throw new UnsupportedOperationException("Dimensions of dimensions are not allowed, the multiverse might collapse!");
        }

        @Override
        public String getRouterField() {
            throw new UnsupportedOperationException("Dimensions of dimensions are not allowed, the multiverse might collapse!");
        }

        @Override
        public java.util.List<String> getParamNames() {
            throw new UnsupportedOperationException("Dimensions of dimensions are not allowed, the multiverse might collapse!");
        }

        @Override
        public java.util.List<String> getRequiredParamNames() {
            throw new UnsupportedOperationException("Dimensions of dimensions are not allowed, the multiverse might collapse!");
        }
    }

    public static interface RoutedAliasAdminRequest {
        public static final String ROUTER_TYPE_NAME = "router.name";
        public static final String ROUTER_FIELD = "router.field";

        public RoutedAliasTypes getType();

        public String getRouterField();

        public java.util.List<String> getParamNames();

        public java.util.List<String> getRequiredParamNames();

        public SolrParams getParams();

        default public ModifiableSolrParams mergeCollParams(Create createCollTemplate) {
            ModifiableSolrParams createCollParams = new ModifiableSolrParams();
            if (createCollTemplate == null) {
                return createCollParams;
            }
            SolrParams collParams = createCollTemplate.getParams();
            Iterator<String> pIter = collParams.getParameterNamesIterator();
            while (pIter.hasNext()) {
                String key = pIter.next();
                if (key.equals("action") || key.equals("name")) continue;
                createCollParams.set("create-collection." + key, collParams.getParams(key));
            }
            return createCollParams;
        }
    }

    public static class CreateCategoryRoutedAlias
    extends AsyncCollectionAdminRequest
    implements RoutedAliasAdminRequest {
        public static final String ROUTER_MAX_CARDINALITY = "router.maxCardinality";
        public static final String ROUTER_MUST_MATCH = "router.mustMatch";
        private final String aliasName;
        private final String routerField;
        private Integer maxCardinality;
        private String mustMatch;
        private final Create createCollTemplate;

        public CreateCategoryRoutedAlias(String aliasName, String routerField, int maxCardinality, Create createCollTemplate) {
            super(CollectionParams.CollectionAction.CREATEALIAS);
            this.aliasName = aliasName;
            this.routerField = routerField;
            this.maxCardinality = maxCardinality;
            this.createCollTemplate = createCollTemplate;
        }

        public CreateCategoryRoutedAlias setMustMatch(String regex) {
            this.mustMatch = regex;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.add("name", this.aliasName);
            params.add("router.name", RoutedAliasTypes.CATEGORY.name());
            params.add("router.field", this.routerField);
            params.add(ROUTER_MAX_CARDINALITY, this.maxCardinality.toString());
            if (this.mustMatch != null) {
                params.add(ROUTER_MUST_MATCH, this.mustMatch);
            }
            ModifiableSolrParams createCollParams = this.mergeCollParams(this.createCollTemplate);
            return SolrParams.wrapDefaults(params, createCollParams);
        }

        @Override
        public RoutedAliasTypes getType() {
            return RoutedAliasTypes.CATEGORY;
        }

        @Override
        public String getRouterField() {
            return this.routerField;
        }

        @Override
        public java.util.List<String> getParamNames() {
            return java.util.List.of("router.name", "router.field", ROUTER_MAX_CARDINALITY, ROUTER_MUST_MATCH);
        }

        @Override
        public java.util.List<String> getRequiredParamNames() {
            return java.util.List.of("router.name", "router.field", ROUTER_MAX_CARDINALITY);
        }
    }

    public static class CreateTimeRoutedAlias
    extends AsyncCollectionAdminRequest
    implements RoutedAliasAdminRequest {
        public static final String ROUTER_START = "router.start";
        public static final String ROUTER_INTERVAL = "router.interval";
        public static final String ROUTER_MAX_FUTURE = "router.maxFutureMs";
        public static final String ROUTER_PREEMPTIVE_CREATE_WINDOW = "router.preemptiveCreateMath";
        public static final String ROUTER_AUTO_DELETE_AGE = "router.autoDeleteAge";
        private final String aliasName;
        private final String routerField;
        private final String start;
        private final String interval;
        private TimeZone tz;
        private Long maxFutureMs;
        private String preemptiveCreateMath;
        private String autoDeleteAge;
        private final Create createCollTemplate;

        public CreateTimeRoutedAlias(String aliasName, String routerField, String start, String interval, Create createCollTemplate) {
            super(CollectionParams.CollectionAction.CREATEALIAS);
            this.aliasName = aliasName;
            this.start = start;
            this.interval = interval;
            this.routerField = routerField;
            this.createCollTemplate = createCollTemplate;
        }

        public CreateTimeRoutedAlias setTimeZone(TimeZone tz) {
            this.tz = tz;
            return this;
        }

        @Deprecated
        public CreateTimeRoutedAlias setMaxFutureMs(Integer maxFutureMs) {
            this.maxFutureMs = (long)maxFutureMs;
            return this;
        }

        public CreateTimeRoutedAlias setMaxFutureMs(Long maxFutureMs) {
            this.maxFutureMs = maxFutureMs;
            return this;
        }

        public CreateTimeRoutedAlias setPreemptiveCreateWindow(String preemptiveCreateMath) {
            this.preemptiveCreateMath = preemptiveCreateMath;
            return this;
        }

        public CreateTimeRoutedAlias setAutoDeleteAge(String autoDeleteAge) {
            this.autoDeleteAge = autoDeleteAge;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.add("name", this.aliasName);
            params.add("router.name", "time");
            params.add("router.field", this.routerField);
            params.add(ROUTER_START, this.start);
            params.add(ROUTER_INTERVAL, this.interval);
            if (this.tz != null) {
                params.add("TZ", this.tz.getID());
            }
            if (this.maxFutureMs != null) {
                params.add(ROUTER_MAX_FUTURE, "" + this.maxFutureMs);
            }
            if (this.preemptiveCreateMath != null) {
                params.add(ROUTER_PREEMPTIVE_CREATE_WINDOW, this.preemptiveCreateMath);
            }
            if (this.autoDeleteAge != null) {
                params.add(ROUTER_AUTO_DELETE_AGE, this.autoDeleteAge);
            }
            ModifiableSolrParams createCollParams = this.mergeCollParams(this.createCollTemplate);
            return SolrParams.wrapDefaults(params, createCollParams);
        }

        @Override
        public RoutedAliasTypes getType() {
            return RoutedAliasTypes.TIME;
        }

        @Override
        public String getRouterField() {
            return this.routerField;
        }

        @Override
        public java.util.List<String> getParamNames() {
            return java.util.List.of("router.name", "router.field", ROUTER_START, ROUTER_INTERVAL, ROUTER_MAX_FUTURE, ROUTER_PREEMPTIVE_CREATE_WINDOW, ROUTER_AUTO_DELETE_AGE, "TZ");
        }

        @Override
        public java.util.List<String> getRequiredParamNames() {
            return java.util.List.of("router.name", "router.field", ROUTER_START, ROUTER_INTERVAL);
        }
    }

    public static class CreateAlias
    extends AsyncCollectionAdminRequest {
        protected String aliasName;
        protected String aliasedCollections;

        private CreateAlias(String aliasName, String aliasedCollections) {
            super(CollectionParams.CollectionAction.CREATEALIAS);
            this.aliasName = SolrIdentifierValidator.validateAliasName(aliasName);
            this.aliasedCollections = CreateAlias.checkNotNull("aliasedCollections", aliasedCollections);
        }

        public String getAliasName() {
            return this.aliasName;
        }

        public String getAliasedCollections() {
            return this.aliasedCollections;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("name", this.aliasName);
            params.set("collections", this.aliasedCollections);
            return params;
        }
    }

    public static class SetAliasProperty
    extends AsyncCollectionAdminRequest {
        private final String aliasName;
        private Map<String, String> properties = new HashMap<String, String>();

        public SetAliasProperty(String aliasName) {
            super(CollectionParams.CollectionAction.ALIASPROP);
            this.aliasName = SolrIdentifierValidator.validateAliasName(aliasName);
        }

        public SetAliasProperty addProperty(String key, String value) {
            if (value == null) {
                this.properties.put(key, "");
            } else {
                this.properties.put(key, value);
            }
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("name", this.aliasName);
            this.properties.forEach((key, value) -> params.set("property." + key, (String)value));
            return params;
        }
    }

    public static class DeleteStatus
    extends CollectionAdminRequest<CollectionAdminResponse> {
        protected String requestId = null;
        protected Boolean flush = null;

        private DeleteStatus(String requestId, Boolean flush) {
            super(CollectionParams.CollectionAction.DELETESTATUS);
            if (requestId == null && flush == null) {
                throw new IllegalArgumentException("Either requestid or flush parameter must be specified.");
            }
            if (requestId != null && flush != null) {
                throw new IllegalArgumentException("Both requestid and flush parameters can not be specified together.");
            }
            this.requestId = requestId;
            this.flush = flush;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public Boolean getFlush() {
            return this.flush;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            if (this.requestId != null) {
                params.set("requestid", this.requestId);
            }
            if (this.flush != null) {
                params.set("flush", this.flush);
            }
            return params;
        }

        @Override
        protected CollectionAdminResponse createResponse(SolrClient client) {
            return new CollectionAdminResponse();
        }
    }

    public static class RequestStatus
    extends CollectionAdminRequest<RequestStatusResponse> {
        protected String requestId = null;

        private RequestStatus(String requestId) {
            super(CollectionParams.CollectionAction.REQUESTSTATUS);
            this.requestId = RequestStatus.checkNotNull("requestId", requestId);
        }

        public String getRequestId() {
            return this.requestId;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("requestid", this.requestId);
            return params;
        }

        @Override
        protected RequestStatusResponse createResponse(SolrClient client) {
            return new RequestStatusResponse();
        }

        public RequestStatusState waitFor(SolrClient client, long timeoutSeconds) throws IOException, SolrServerException, InterruptedException {
            long finishTime = System.nanoTime() + TimeUnit.SECONDS.toNanos(timeoutSeconds);
            RequestStatusState state = RequestStatusState.NOT_FOUND;
            while (System.nanoTime() < finishTime) {
                state = ((RequestStatusResponse)this.process(client)).getRequestStatus();
                if (state == RequestStatusState.COMPLETED || state == RequestStatusState.FAILED) {
                    this.propagateBasicAuthCreds(RequestStatus.deleteAsyncId(this.requestId)).process(client);
                    return state;
                }
                TimeUnit.SECONDS.sleep(1L);
            }
            return state;
        }
    }

    public static class RequestStatusResponse
    extends CollectionAdminResponse {
        public RequestStatusState getRequestStatus() {
            NamedList innerResponse = (NamedList)this.getResponse().get("status");
            return RequestStatusState.fromKey((String)innerResponse.get("state"));
        }
    }

    public static class ForceLeader
    extends ShardSpecificAdminRequest {
        private ForceLeader(String collection, String shard) {
            super(CollectionParams.CollectionAction.FORCELEADER, collection, shard);
        }
    }

    public static class DeleteShard
    extends AsyncShardSpecificAdminRequest {
        private Boolean deleteInstanceDir;
        private Boolean deleteDataDir;

        private DeleteShard(String collection, String shard) {
            super(CollectionParams.CollectionAction.DELETESHARD, collection, shard);
        }

        public Boolean getDeleteInstanceDir() {
            return this.deleteInstanceDir;
        }

        public DeleteShard setDeleteInstanceDir(Boolean deleteInstanceDir) {
            this.deleteInstanceDir = deleteInstanceDir;
            return this;
        }

        public Boolean getDeleteDataDir() {
            return this.deleteDataDir;
        }

        public DeleteShard setDeleteDataDir(Boolean deleteDataDir) {
            this.deleteDataDir = deleteDataDir;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            if (this.deleteInstanceDir != null) {
                params.set("deleteInstanceDir", this.deleteInstanceDir);
            }
            if (this.deleteDataDir != null) {
                params.set("deleteDataDir", this.deleteDataDir);
            }
            return params;
        }
    }

    public static class SplitShard
    extends AsyncCollectionAdminRequest {
        protected String collection;
        protected String ranges;
        protected String splitKey;
        protected String shard;
        protected String splitMethod;
        protected Boolean splitByPrefix;
        protected Integer numSubShards;
        protected Float splitFuzz;
        private Properties properties;
        protected String createNodeSet;

        private SplitShard(String collection) {
            super(CollectionParams.CollectionAction.SPLITSHARD);
            this.collection = SplitShard.checkNotNull("collection", collection);
        }

        public SplitShard setRanges(String ranges) {
            this.ranges = ranges;
            return this;
        }

        public SplitShard setCreateNodeSet(String nodeset) {
            this.createNodeSet = nodeset;
            return this;
        }

        public String getRanges() {
            return this.ranges;
        }

        public Integer getNumSubShards() {
            return this.numSubShards;
        }

        public SplitShard setNumSubShards(Integer numSubShards) {
            this.numSubShards = numSubShards;
            return this;
        }

        public SplitShard setSplitMethod(String splitMethod) {
            this.splitMethod = splitMethod;
            return this;
        }

        public String getSplitMethod() {
            return this.splitMethod;
        }

        public SplitShard setSplitFuzz(float splitFuzz) {
            this.splitFuzz = Float.valueOf(splitFuzz);
            return this;
        }

        public Float getSplitFuzz() {
            return this.splitFuzz;
        }

        public SplitShard setSplitKey(String splitKey) {
            this.splitKey = splitKey;
            return this;
        }

        public String getSplitKey() {
            return this.splitKey;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public SplitShard setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public SplitShard setShardName(String shard) {
            this.shard = shard;
            return this;
        }

        public Boolean getSplitByPrefix() {
            return this.splitByPrefix;
        }

        public SplitShard setSplitByPrefix(Boolean splitByPrefix) {
            this.splitByPrefix = splitByPrefix;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection", this.collection);
            if (this.shard == null && this.splitKey == null) {
                throw new IllegalArgumentException("You must set shardname OR splitkey for this request.");
            }
            params.set("shard", this.shard);
            params.set("split.key", this.splitKey);
            params.set("ranges", this.ranges);
            params.set("splitMethod", this.splitMethod);
            if (this.numSubShards != null) {
                params.set("numSubShards", this.numSubShards);
            }
            if (this.splitFuzz != null) {
                params.set("splitFuzz", String.valueOf(this.splitFuzz));
            }
            if (this.splitByPrefix != null) {
                params.set("splitByPrefix", this.splitByPrefix);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            if (this.createNodeSet != null) {
                params.set("createNodeSet", this.createNodeSet);
            }
            return params;
        }
    }

    public static class MockCollTask
    extends AsyncCollectionAdminRequest {
        protected final String collection;
        protected String sleep;

        private MockCollTask(String collection) {
            super(CollectionParams.CollectionAction.MOCK_COLL_TASK);
            this.collection = MockCollTask.checkNotNull("collection", collection);
        }

        public MockCollTask setSleep(String sleep) {
            this.sleep = sleep;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.add("collection", this.collection);
            params.setNonNull("sleep", this.sleep);
            return params;
        }
    }

    public static class CreateShard
    extends AsyncShardSpecificAdminRequest {
        protected String nodeSet;
        protected Properties properties;

        public CreateShard setNodeSet(String nodeSet) {
            this.nodeSet = nodeSet;
            return this;
        }

        public String getNodeSet() {
            return this.nodeSet;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public CreateShard setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        private CreateShard(String collection, String shard) {
            super(CollectionParams.CollectionAction.CREATESHARD, collection, SolrIdentifierValidator.validateShardName(shard));
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            if (this.nodeSet != null) {
                params.set("createNodeSet", this.nodeSet);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            return params;
        }
    }

    public static class ListSnapshots
    extends AsyncCollectionSpecificAdminRequest {
        public ListSnapshots(String collection) {
            super(CollectionParams.CollectionAction.LISTSNAPSHOTS, ListSnapshots.checkNotNull("collection", collection));
        }

        @Override
        public String getCollectionName() {
            return this.collection;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection", this.collection);
            return params;
        }
    }

    public static class DeleteSnapshot
    extends AsyncCollectionSpecificAdminRequest {
        protected final String commitName;

        public DeleteSnapshot(String collection, String commitName) {
            super(CollectionParams.CollectionAction.DELETESNAPSHOT, DeleteSnapshot.checkNotNull("collection", collection));
            this.commitName = DeleteSnapshot.checkNotNull("commitName", commitName);
        }

        @Override
        public String getCollectionName() {
            return this.collection;
        }

        public String getCommitName() {
            return this.commitName;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection", this.collection);
            params.set("commitName", this.commitName);
            return params;
        }
    }

    public static class CreateSnapshot
    extends AsyncCollectionSpecificAdminRequest {
        protected final String commitName;

        public CreateSnapshot(String collection, String commitName) {
            super(CollectionParams.CollectionAction.CREATESNAPSHOT, CreateSnapshot.checkNotNull("collection", collection));
            this.commitName = CreateSnapshot.checkNotNull("commitName", commitName);
        }

        @Override
        public String getCollectionName() {
            return this.collection;
        }

        public String getCommitName() {
            return this.commitName;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection", this.collection);
            params.set("commitName", this.commitName);
            return params;
        }
    }

    public static class InstallShard
    extends AsyncShardSpecificAdminRequest {
        protected String repositoryName;
        protected String location;

        public InstallShard(String collection, String shard, String location, String backupRepository) {
            super(CollectionParams.CollectionAction.INSTALLSHARDDATA, collection, shard);
            this.repositoryName = backupRepository;
            this.location = location;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.setNonNull("repository", this.repositoryName);
            params.setNonNull("location", this.location);
            return params;
        }
    }

    public static class Restore
    extends AsyncCollectionSpecificAdminRequest {
        protected final String backupName;
        protected Optional<String> repositoryName = Optional.empty();
        protected String location;
        protected String configName;
        protected Integer replicationFactor;
        protected Integer nrtReplicas;
        protected Integer tlogReplicas;
        protected Integer pullReplicas;
        protected Optional<String> createNodeSet = Optional.empty();
        protected Optional<Boolean> createNodeSetShuffle = Optional.empty();
        protected Properties properties;
        protected Integer backupId;

        public Restore(String collection, String backupName) {
            super(CollectionParams.CollectionAction.RESTORE, collection);
            this.backupName = backupName;
        }

        public String getLocation() {
            return this.location;
        }

        public Restore setLocation(String location) {
            this.location = location;
            return this;
        }

        public Optional<String> getRepositoryName() {
            return this.repositoryName;
        }

        public Restore setRepositoryName(String repositoryName) {
            this.repositoryName = Optional.ofNullable(repositoryName);
            return this;
        }

        public void setCreateNodeSet(String createNodeSet) {
            this.createNodeSet = Optional.of(createNodeSet);
        }

        public Optional<String> getCreateNodeSet() {
            return this.createNodeSet;
        }

        public Optional<Boolean> getCreateNodeSetShuffle() {
            return this.createNodeSetShuffle;
        }

        public void setCreateNodeSetShuffle(boolean createNodeSetShuffle) {
            this.createNodeSetShuffle = Optional.of(createNodeSetShuffle);
        }

        public Restore setConfigName(String config) {
            this.configName = config;
            return this;
        }

        public String getConfigName() {
            return this.configName;
        }

        public Integer getReplicationFactor() {
            return this.replicationFactor;
        }

        public Restore setReplicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public Integer getNrtReplicas() {
            return this.nrtReplicas;
        }

        public Restore setNrtReplicas(Integer nrtReplicas) {
            this.nrtReplicas = nrtReplicas;
            return this;
        }

        public Integer getTlogReplicas() {
            return this.tlogReplicas;
        }

        public Restore setTlogReplicas(Integer tlogReplicas) {
            this.tlogReplicas = tlogReplicas;
            return this;
        }

        public Integer getPullReplicas() {
            return this.pullReplicas;
        }

        public Restore setPullReplicas(Integer pullReplicas) {
            this.pullReplicas = pullReplicas;
            return this;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public Restore setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Restore setBackupId(int backupId) {
            this.backupId = backupId;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection", this.collection);
            params.set("name", this.backupName);
            params.set("location", this.location);
            params.set("collection.configName", this.configName);
            if (this.replicationFactor != null && this.nrtReplicas != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Cannot set both replicationFactor and nrtReplicas as they mean the same thing");
            }
            if (this.replicationFactor != null) {
                params.set("replicationFactor", this.replicationFactor);
            }
            if (this.nrtReplicas != null) {
                params.set("nrtReplicas", this.nrtReplicas);
            }
            if (this.pullReplicas != null) {
                params.set("pullReplicas", this.pullReplicas);
            }
            if (this.tlogReplicas != null) {
                params.set("tlogReplicas", this.tlogReplicas);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            if (this.repositoryName.isPresent()) {
                params.set("repository", this.repositoryName.get());
            }
            if (this.createNodeSet.isPresent()) {
                params.set("createNodeSet", this.createNodeSet.get());
            }
            if (this.createNodeSetShuffle.isPresent()) {
                params.set("createNodeSet.shuffle", this.createNodeSetShuffle.get());
            }
            if (this.backupId != null) {
                params.set("backupId", this.backupId);
            }
            return params;
        }
    }

    public static class Backup
    extends AsyncCollectionSpecificAdminRequest {
        protected final String name;
        protected Optional<String> repositoryName = Optional.empty();
        protected String location;
        protected Optional<String> commitName = Optional.empty();
        protected Optional<String> indexBackupStrategy = Optional.empty();
        protected boolean incremental = true;
        protected Optional<Integer> maxNumBackupPoints = Optional.empty();
        protected boolean backupConfigset = true;

        public Backup(String collection, String name) {
            super(CollectionParams.CollectionAction.BACKUP, collection);
            this.name = name;
            this.repositoryName = Optional.empty();
        }

        public String getLocation() {
            return this.location;
        }

        public Backup setLocation(String location) {
            this.location = location;
            return this;
        }

        public Optional<String> getRepositoryName() {
            return this.repositoryName;
        }

        public Backup setRepositoryName(String repositoryName) {
            this.repositoryName = Optional.ofNullable(repositoryName);
            return this;
        }

        public Optional<String> getCommitName() {
            return this.commitName;
        }

        public Backup setCommitName(String commitName) {
            this.commitName = Optional.ofNullable(commitName);
            return this;
        }

        public Optional<String> getIndexBackupStrategy() {
            return this.indexBackupStrategy;
        }

        public Backup setIndexBackupStrategy(String indexBackupStrategy) {
            this.indexBackupStrategy = Optional.ofNullable(indexBackupStrategy);
            return this;
        }

        @Deprecated
        public Backup setIncremental(boolean incremental) {
            this.incremental = incremental;
            return this;
        }

        public Backup setMaxNumberBackupPoints(int maxNumBackupPoints) {
            this.maxNumBackupPoints = Optional.of(maxNumBackupPoints);
            return this;
        }

        public Backup setBackupConfigset(boolean backupConfigset) {
            this.backupConfigset = backupConfigset;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection", this.collection);
            params.set("name", this.name);
            params.set("location", this.location);
            if (this.repositoryName.isPresent()) {
                params.set("repository", this.repositoryName.get());
            }
            if (this.commitName.isPresent()) {
                params.set("commitName", this.commitName.get());
            }
            if (this.indexBackupStrategy.isPresent()) {
                params.set("indexBackup", this.indexBackupStrategy.get());
            }
            if (this.maxNumBackupPoints.isPresent()) {
                params.set("maxNumBackupPoints", this.maxNumBackupPoints.get());
            }
            params.set("incremental", this.incremental);
            params.set("backupConfigset", this.backupConfigset);
            return params;
        }
    }

    public static class Delete
    extends AsyncCollectionSpecificAdminRequest {
        private Delete(String collection) {
            super(CollectionParams.CollectionAction.DELETE, collection);
        }
    }

    public static class ColStatus
    extends AsyncCollectionAdminRequest {
        protected String collection = null;
        protected Boolean withSegments = null;
        protected Boolean withFieldInfo = null;
        protected Boolean withCoreInfo = null;
        protected Boolean withSizeInfo = null;
        protected Boolean withRawSizeInfo = null;
        protected Boolean withRawSizeSummary = null;
        protected Boolean withRawSizeDetails = null;
        protected Float rawSizeSamplingPercent = null;

        private ColStatus(String collection) {
            super(CollectionParams.CollectionAction.COLSTATUS);
            this.collection = collection;
        }

        private ColStatus() {
            super(CollectionParams.CollectionAction.COLSTATUS);
        }

        public ColStatus setWithSegments(boolean withSegments) {
            this.withSegments = withSegments;
            return this;
        }

        public ColStatus setWithFieldInfo(boolean withFieldInfo) {
            this.withFieldInfo = withFieldInfo;
            return this;
        }

        public ColStatus setWithCoreInfo(boolean withCoreInfo) {
            this.withCoreInfo = withCoreInfo;
            return this;
        }

        public ColStatus setWithSizeInfo(boolean withSizeInfo) {
            this.withSizeInfo = withSizeInfo;
            return this;
        }

        public ColStatus setWithRawSizeInfo(boolean withRawSizeInfo) {
            this.withRawSizeInfo = withRawSizeInfo;
            return this;
        }

        public ColStatus setWithRawSizeSummary(boolean withRawSizeSummary) {
            this.withRawSizeSummary = withRawSizeSummary;
            return this;
        }

        public ColStatus setWithRawSizeDetails(boolean withRawSizeDetails) {
            this.withRawSizeDetails = withRawSizeDetails;
            return this;
        }

        public ColStatus setRawSizeSamplingPercent(float rawSizeSamplingPercent) {
            this.rawSizeSamplingPercent = Float.valueOf(rawSizeSamplingPercent);
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.setNonNull("collection", this.collection);
            params.setNonNull("segments", this.withSegments);
            params.setNonNull("fieldInfo", this.withFieldInfo);
            params.setNonNull("coreInfo", this.withCoreInfo);
            params.setNonNull("sizeInfo", this.withSizeInfo);
            params.setNonNull("rawSizeInfo", this.withRawSizeInfo);
            params.setNonNull("rawSizeSummary", this.withRawSizeSummary);
            params.setNonNull("rawSizeDetails", this.withRawSizeDetails);
            params.setNonNull("rawSizeSamplingPercent", this.rawSizeSamplingPercent);
            return params;
        }
    }

    public static class ReindexCollection
    extends AsyncCollectionSpecificAdminRequest {
        private static final String CONFIGNAME_PARAM = "configName";
        String target;
        String query;
        String fields;
        String configName;
        Boolean removeSource;
        String cmd;
        Integer batchSize;
        Map<String, Object> collectionParams = new HashMap<String, Object>();

        private ReindexCollection(String collection) {
            super(CollectionParams.CollectionAction.REINDEXCOLLECTION, collection);
        }

        public ReindexCollection setTarget(String target) {
            this.target = target;
            return this;
        }

        public ReindexCollection setCommand(String command) {
            this.cmd = command;
            return this;
        }

        public ReindexCollection setQuery(String query) {
            this.query = query;
            return this;
        }

        public ReindexCollection setFields(String fields) {
            this.fields = fields;
            return this;
        }

        public ReindexCollection setRemoveSource(boolean removeSource) {
            this.removeSource = removeSource;
            return this;
        }

        public ReindexCollection setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public ReindexCollection setConfigName(String configName) {
            this.configName = configName;
            return this;
        }

        public ReindexCollection setCollectionParam(String key, Object value) {
            this.collectionParams.put(key, value);
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.setNonNull("target", this.target);
            params.setNonNull("cmd", this.cmd);
            params.setNonNull(CONFIGNAME_PARAM, this.configName);
            params.setNonNull("q", this.query);
            params.setNonNull("fl", this.fields);
            params.setNonNull("removeSource", this.removeSource);
            params.setNonNull("rows", this.batchSize);
            this.collectionParams.forEach((k, v) -> params.setNonNull((String)k, v));
            return params;
        }
    }

    public static class RebalanceLeaders
    extends AsyncCollectionAdminRequest {
        protected Integer maxAtOnce;
        protected Integer maxWaitSeconds;
        protected String collection;

        public RebalanceLeaders setMaxAtOnce(Integer maxAtOnce) {
            this.maxAtOnce = maxAtOnce;
            return this;
        }

        public RebalanceLeaders setMaxWaitSeconds(Integer maxWaitSeconds) {
            this.maxWaitSeconds = maxWaitSeconds;
            return this;
        }

        public Integer getMaxAtOnce() {
            return this.maxAtOnce;
        }

        public Integer getMaxWaitSeconds() {
            return this.maxWaitSeconds;
        }

        public RebalanceLeaders(String collection) {
            super(CollectionParams.CollectionAction.REBALANCELEADERS);
            this.collection = RebalanceLeaders.checkNotNull("collection", collection);
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection", this.collection);
            if (this.maxWaitSeconds != null) {
                params.set("maxWaitSeconds", this.maxWaitSeconds);
            }
            if (this.maxAtOnce != null) {
                params.set("maxAtOnce", this.maxAtOnce);
            }
            return params;
        }
    }

    public static class MoveReplica
    extends AsyncCollectionAdminRequest {
        protected String collection;
        protected String replica;
        protected String targetNode;
        protected String shard;
        protected String sourceNode;
        protected boolean randomlyMoveReplica;
        protected boolean inPlaceMove = true;
        protected int timeout = -1;

        public MoveReplica(String collection, String replica, String targetNode) {
            super(CollectionParams.CollectionAction.MOVEREPLICA);
            this.collection = MoveReplica.checkNotNull("collection", collection);
            this.replica = MoveReplica.checkNotNull("replica", replica);
            this.targetNode = MoveReplica.checkNotNull("targetNode", targetNode);
            this.randomlyMoveReplica = false;
        }

        public MoveReplica(String collection, String shard, String sourceNode, String targetNode) {
            super(CollectionParams.CollectionAction.MOVEREPLICA);
            this.collection = MoveReplica.checkNotNull("collection", collection);
            this.shard = MoveReplica.checkNotNull("shard", shard);
            this.sourceNode = MoveReplica.checkNotNull("sourceNode", sourceNode);
            this.targetNode = MoveReplica.checkNotNull("targetNode", targetNode);
            this.randomlyMoveReplica = true;
        }

        public void setInPlaceMove(boolean inPlaceMove) {
            this.inPlaceMove = inPlaceMove;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("collection", this.collection);
            params.set("targetNode", this.targetNode);
            params.set("inPlaceMove", this.inPlaceMove);
            if (this.timeout != -1) {
                params.set("timeout", this.timeout);
            }
            if (this.randomlyMoveReplica) {
                params.set("shard", this.shard);
                params.set("sourceNode", this.sourceNode);
            } else {
                params.set("replica", this.replica);
            }
            return params;
        }
    }

    public static class ReplaceNode
    extends AsyncCollectionAdminRequest {
        String sourceNode;
        String targetNode;
        Boolean parallel;

        public ReplaceNode(String source, String target) {
            super(CollectionParams.CollectionAction.REPLACENODE);
            this.sourceNode = ReplaceNode.checkNotNull("sourceNode", source);
            this.targetNode = target;
        }

        public ReplaceNode setParallel(Boolean flag) {
            this.parallel = flag;
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("sourceNode", this.sourceNode);
            if (StrUtils.isNotNullOrEmpty(this.targetNode)) {
                params.set("targetNode", this.targetNode);
            }
            if (this.parallel != null) {
                params.set("parallel", this.parallel.toString());
            }
            return params;
        }
    }

    public static class DeleteNode
    extends AsyncCollectionAdminRequest {
        String node;

        public DeleteNode(String node) {
            super(CollectionParams.CollectionAction.DELETENODE);
            this.node = DeleteNode.checkNotNull("node", node);
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("node", this.node);
            return params;
        }
    }

    public static class Rename
    extends AsyncCollectionSpecificAdminRequest {
        String target;

        public Rename(String collection, String target) {
            super(CollectionParams.CollectionAction.RENAME, collection);
            this.target = target;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            params.set("target", this.target);
            return params;
        }
    }

    public static class Reload
    extends AsyncCollectionSpecificAdminRequest {
        private Reload(String collection) {
            super(CollectionParams.CollectionAction.RELOAD, collection);
        }
    }

    public static class Create
    extends AsyncCollectionSpecificAdminRequest {
        protected String configName = null;
        protected String createNodeSet = null;
        protected String routerName;
        protected String policy;
        protected String shards;
        protected String routerField;
        protected Integer numShards;
        protected Integer nrtReplicas;
        protected Integer pullReplicas;
        protected Integer tlogReplicas;
        protected Boolean perReplicaState;
        protected Properties properties;
        protected String alias;
        protected String[] rule;
        protected String[] snitch;

        protected Create(String collection, String config, Integer numShards, Integer numNrtReplicas, Integer numTlogReplicas, Integer numPullReplicas) {
            this(collection, config, null, numShards, null, numNrtReplicas, numTlogReplicas, numPullReplicas);
        }

        protected Create(String collection, String config, String shards, int numNrtReplicas) {
            this(collection, config, "implicit", null, Create.checkNotNull("shards", shards), numNrtReplicas, null, null);
        }

        private Create(String collection, String config, String routerName, Integer numShards, String shards, Integer numNrtReplicas, Integer numTlogReplicas, Integer numPullReplicas) {
            super(CollectionParams.CollectionAction.CREATE, SolrIdentifierValidator.validateCollectionName(collection));
            if (null != shards && null != numShards) {
                throw new IllegalArgumentException("Can not specify both a numShards and a list of shards");
            }
            this.configName = config;
            this.routerName = routerName;
            this.numShards = numShards;
            this.setShards(shards);
            this.nrtReplicas = numNrtReplicas;
            this.tlogReplicas = numTlogReplicas;
            this.pullReplicas = numPullReplicas;
        }

        public Create setCreateNodeSet(String nodeSet) {
            this.createNodeSet = nodeSet;
            return this;
        }

        public Create setRouterName(String routerName) {
            this.routerName = routerName;
            return this;
        }

        public Create setRouterField(String routerField) {
            this.routerField = routerField;
            return this;
        }

        public Create setNrtReplicas(Integer nrtReplicas) {
            this.nrtReplicas = nrtReplicas;
            return this;
        }

        public Create setTlogReplicas(Integer tlogReplicas) {
            this.tlogReplicas = tlogReplicas;
            return this;
        }

        public Create setPullReplicas(Integer pullReplicas) {
            this.pullReplicas = pullReplicas;
            return this;
        }

        public Create setReplicationFactor(Integer repl) {
            this.nrtReplicas = repl;
            return this;
        }

        public Create setRule(String ... s) {
            this.rule = s;
            return this;
        }

        public Create setSnitch(String ... s) {
            this.snitch = s;
            return this;
        }

        public Create setPerReplicaState(Boolean b) {
            this.perReplicaState = b;
            return this;
        }

        public Create setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public String getConfigName() {
            return this.configName;
        }

        public String getCreateNodeSet() {
            return this.createNodeSet;
        }

        public String getRouterName() {
            return this.routerName;
        }

        public String getShards() {
            return this.shards;
        }

        public Integer getNumShards() {
            return this.numShards;
        }

        public Integer getReplicationFactor() {
            return this.getNumNrtReplicas();
        }

        public Integer getNumNrtReplicas() {
            return this.nrtReplicas;
        }

        public Integer getNumTlogReplicas() {
            return this.tlogReplicas;
        }

        public Integer getNumPullReplicas() {
            return this.pullReplicas;
        }

        public Boolean getPerReplicaState() {
            return this.perReplicaState;
        }

        public Create setShards(String shards) {
            if (null != shards) {
                for (String shard : shards.split(",")) {
                    SolrIdentifierValidator.validateShardName(shard);
                }
            }
            this.shards = shards;
            return this;
        }

        public Properties getProperties() {
            return this.properties;
        }

        public Create setProperties(Properties properties) {
            this.properties = properties;
            return this;
        }

        public Create setProperties(Map<String, String> properties) {
            this.properties = new Properties();
            this.properties.putAll(properties);
            return this;
        }

        public Create withProperty(String key, String value) {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.setProperty(key, value);
            return this;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = (ModifiableSolrParams)super.getParams();
            if (this.configName != null) {
                params.set("collection.configName", this.configName);
            }
            if (this.createNodeSet != null) {
                params.set("createNodeSet", this.createNodeSet);
            }
            if (this.numShards != null) {
                params.set("numShards", this.numShards);
            }
            if (this.routerName != null) {
                params.set("router.name", this.routerName);
            }
            if (this.shards != null) {
                params.set("shards", this.shards);
            }
            if (this.routerField != null) {
                params.set("router.field", this.routerField);
            }
            if (this.nrtReplicas != null) {
                params.set("nrtReplicas", this.nrtReplicas);
            }
            if (this.properties != null) {
                this.addProperties(params, this.properties);
            }
            if (this.pullReplicas != null) {
                params.set("pullReplicas", this.pullReplicas);
            }
            if (this.tlogReplicas != null) {
                params.set("tlogReplicas", this.tlogReplicas);
            }
            if (Boolean.TRUE.equals(this.perReplicaState)) {
                params.set("perReplicaState", this.perReplicaState);
            }
            params.setNonNull("alias", this.alias);
            return params;
        }

        public Create setPolicy(String policy) {
            this.policy = policy;
            return this;
        }
    }

    protected static abstract class CollectionAdminRoleRequest
    extends AsyncCollectionAdminRequest {
        protected String node;
        protected String role;

        public CollectionAdminRoleRequest(CollectionParams.CollectionAction action, String node, String role) {
            super(action);
            this.role = CollectionAdminRoleRequest.checkNotNull("role", role);
            this.node = CollectionAdminRoleRequest.checkNotNull("node", node);
        }

        public String getNode() {
            return this.node;
        }

        public String getRole() {
            return this.role;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("role", this.role);
            params.set("node", this.node);
            return params;
        }
    }

    protected static abstract class ShardSpecificAdminRequest
    extends CollectionAdminRequest<CollectionAdminResponse> {
        protected String collection;
        protected String shard;

        public ShardSpecificAdminRequest(CollectionParams.CollectionAction action, String collection, String shard) {
            super(action);
            this.collection = ShardSpecificAdminRequest.checkNotNull("collection", collection);
            this.shard = ShardSpecificAdminRequest.checkNotNull("shard", shard);
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("collection", this.collection);
            params.set("shard", this.shard);
            return params;
        }

        @Override
        protected CollectionAdminResponse createResponse(SolrClient client) {
            return new CollectionAdminResponse();
        }
    }

    protected static abstract class AsyncShardSpecificAdminRequest
    extends AsyncCollectionAdminRequest {
        protected String collection;
        protected String shard;

        public AsyncShardSpecificAdminRequest(CollectionParams.CollectionAction action, String collection, String shard) {
            super(action);
            this.collection = AsyncShardSpecificAdminRequest.checkNotNull("collection", collection);
            this.shard = AsyncShardSpecificAdminRequest.checkNotNull("shard", shard);
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("collection", this.collection);
            params.set("shard", this.shard);
            return params;
        }
    }

    protected static abstract class AsyncCollectionSpecificAdminRequest
    extends AsyncCollectionAdminRequest {
        protected String collection;
        protected Boolean followAliases;

        public AsyncCollectionSpecificAdminRequest(CollectionParams.CollectionAction action, String collection) {
            super(action);
            this.collection = AsyncCollectionSpecificAdminRequest.checkNotNull("collection", collection);
        }

        public String getCollectionName() {
            return this.collection;
        }

        public void setFollowAliases(Boolean followAliases) {
            this.followAliases = followAliases;
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            params.set("name", this.collection);
            params.setNonNull("followAliases", this.followAliases);
            return params;
        }
    }

    public static abstract class AsyncCollectionAdminRequest
    extends CollectionAdminRequest<CollectionAdminResponse> {
        protected String asyncId = null;
        protected boolean waitForFinalState = false;

        public AsyncCollectionAdminRequest(CollectionParams.CollectionAction action) {
            super(action);
        }

        @Override
        protected CollectionAdminResponse createResponse(SolrClient client) {
            return new CollectionAdminResponse();
        }

        private static String generateAsyncId() {
            return UUID.randomUUID().toString();
        }

        public String getAsyncId() {
            return this.asyncId;
        }

        public void setWaitForFinalState(boolean waitForFinalState) {
            this.waitForFinalState = waitForFinalState;
        }

        public void setAsyncId(String asyncId) {
            this.asyncId = asyncId;
        }

        public String processAsync(SolrClient client) throws IOException, SolrServerException {
            return this.processAsync(AsyncCollectionAdminRequest.generateAsyncId(), client);
        }

        public String processAsync(String asyncId, SolrClient client) throws IOException, SolrServerException {
            this.asyncId = asyncId;
            NamedList<Object> resp = client.request(this);
            if (resp.get("error") != null) {
                throw new SolrServerException((String)resp.get("error"));
            }
            return (String)resp.get("requestid");
        }

        public RequestStatusState processAndWait(SolrClient client, long timeoutSeconds) throws SolrServerException, InterruptedException, IOException {
            return this.processAndWait(AsyncCollectionAdminRequest.generateAsyncId(), client, timeoutSeconds);
        }

        public RequestStatusState processAndWait(String asyncId, SolrClient client, long timeoutSeconds) throws IOException, SolrServerException, InterruptedException {
            this.processAsync(asyncId, client);
            return this.propagateBasicAuthCreds(AsyncCollectionAdminRequest.requestStatus(asyncId)).waitFor(client, timeoutSeconds);
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams(super.getParams());
            if (this.asyncId != null) {
                params.set("async", this.asyncId);
            }
            if (this.waitForFinalState) {
                params.set("waitForFinalState", this.waitForFinalState);
            }
            return params;
        }
    }
}

