/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.Set;
import org.apache.solr.client.api.model.BalanceReplicasRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

public class ClusterApi {

  public static class BalanceReplicasResponse extends JacksonParsingResponse<SolrJerseyResponse> {
    public BalanceReplicasResponse() {
      super(SolrJerseyResponse.class);
    }
  }

  public static class BalanceReplicas extends SolrRequest<BalanceReplicasResponse> {
    private final BalanceReplicasRequestBody requestBody;

    /** Create a BalanceReplicas request object. */
    public BalanceReplicas() {
      super(SolrRequest.METHOD.valueOf("POST"), "/cluster/replicas/balance");

      this.requestBody = new BalanceReplicasRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param nodes The set of nodes across which replicas will be balanced. Defaults to all live
     *     data nodes.
     */
    public void setNodes(Set<String> nodes) {
      this.requestBody.nodes = nodes;
    }
    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param waitForFinalState If true, the request will complete only when all affected replicas
     *     become active. If false, the API will return the status of the single action, which may
     *     be before the new replica is online and active.
     */
    public void setWaitForFinalState(Boolean waitForFinalState) {
      this.requestBody.waitForFinalState = waitForFinalState;
    }
    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param async Request ID to track this action which will be processed asynchronously.
     */
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected BalanceReplicasResponse createResponse(SolrClient client) {
      return new BalanceReplicasResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
