/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.ListCollectionsResponse;
import org.apache.solr.client.api.model.ReloadCollectionRequestBody;
import org.apache.solr.client.api.model.RenameCollectionRequestBody;
import org.apache.solr.client.api.model.SubResponseAccumulatingJerseyResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

public class CollectionsApi {

  public static class DeleteCollectionResponse
      extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
    public DeleteCollectionResponse() {
      super(SubResponseAccumulatingJerseyResponse.class);
    }
  }

  public static class DeleteCollection extends SolrRequest<DeleteCollectionResponse> {
    private final String collectionName;
    private Boolean followAliases;
    private String async;

    /**
     * Create a DeleteCollection request object.
     *
     * @param collectionName Path param - The name of the collection to be deleted.
     */
    public DeleteCollection(String collectionName) {
      super(
          SolrRequest.METHOD.valueOf("DELETE"),
          "/collections/{collectionName}".replace("{" + "collectionName" + "}", collectionName));

      this.collectionName = collectionName;
    }

    public void setFollowAliases(Boolean followAliases) {
      this.followAliases = followAliases;
    }

    /**
     * @param async An ID to track the request asynchronously
     */
    public void setAsync(String async) {
      this.async = async;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (followAliases != null) {
        params.add("followAliases", followAliases.toString());
      }
      if (async != null) {
        params.add("async", async);
      }
      return params;
    }

    @Override
    protected DeleteCollectionResponse createResponse(SolrClient client) {
      return new DeleteCollectionResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ListCollectionsResponse
      extends JacksonParsingResponse<ListCollectionsResponse> {
    public ListCollectionsResponse() {
      super(ListCollectionsResponse.class);
    }
  }

  public static class ListCollections extends SolrRequest<ListCollectionsResponse> {

    /** Create a ListCollections request object. */
    public ListCollections() {
      super(SolrRequest.METHOD.valueOf("GET"), "/collections");
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected ListCollectionsResponse createResponse(SolrClient client) {
      return new ListCollectionsResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ReloadCollectionResponse
      extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
    public ReloadCollectionResponse() {
      super(SubResponseAccumulatingJerseyResponse.class);
    }
  }

  public static class ReloadCollection extends SolrRequest<ReloadCollectionResponse> {
    private final ReloadCollectionRequestBody requestBody;
    private final String collectionName;

    /**
     * Create a ReloadCollection request object.
     *
     * @param collectionName Path param -
     */
    public ReloadCollection(String collectionName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/collections/{collectionName}/reload"
              .replace("{" + "collectionName" + "}", collectionName));

      this.collectionName = collectionName;
      this.requestBody = new ReloadCollectionRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected ReloadCollectionResponse createResponse(SolrClient client) {
      return new ReloadCollectionResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class RenameCollectionResponse
      extends JacksonParsingResponse<SubResponseAccumulatingJerseyResponse> {
    public RenameCollectionResponse() {
      super(SubResponseAccumulatingJerseyResponse.class);
    }
  }

  public static class RenameCollection extends SolrRequest<RenameCollectionResponse> {
    private final RenameCollectionRequestBody requestBody;
    private final String collectionName;

    /**
     * Create a RenameCollection request object.
     *
     * @param collectionName Path param -
     */
    public RenameCollection(String collectionName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/collections/{collectionName}/rename"
              .replace("{" + "collectionName" + "}", collectionName));

      this.collectionName = collectionName;
      this.requestBody = new RenameCollectionRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setTo(String to) {
      this.requestBody.to = to;
    }
    // TODO find a way to add required parameters in the request body to the class constructor
    public void setFollowAliases(Boolean followAliases) {
      this.requestBody.followAliases = followAliases;
    }
    // TODO find a way to add required parameters in the request body to the class constructor
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected RenameCollectionResponse createResponse(SolrClient client) {
      return new RenameCollectionResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
