/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

public class ShardsApi {

  public static class ForceShardLeaderResponse extends JacksonParsingResponse<SolrJerseyResponse> {
    public ForceShardLeaderResponse() {
      super(SolrJerseyResponse.class);
    }
  }

  public static class ForceShardLeader extends SolrRequest<ForceShardLeaderResponse> {
    private final String collectionName;
    private final String shardName;

    /**
     * Create a ForceShardLeader request object.
     *
     * @param collectionName Path param -
     * @param shardName Path param -
     */
    public ForceShardLeader(String collectionName, String shardName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/collections/{collectionName}/shards/{shardName}/force-leader"
              .replace("{" + "collectionName" + "}", collectionName)
              .replace("{" + "shardName" + "}", shardName));

      this.collectionName = collectionName;
      this.shardName = shardName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected ForceShardLeaderResponse createResponse(SolrClient client) {
      return new ForceShardLeaderResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class SyncShardResponse extends JacksonParsingResponse<SolrJerseyResponse> {
    public SyncShardResponse() {
      super(SolrJerseyResponse.class);
    }
  }

  public static class SyncShard extends SolrRequest<SyncShardResponse> {
    private final String collectionName;
    private final String shardName;

    /**
     * Create a SyncShard request object.
     *
     * @param collectionName Path param -
     * @param shardName Path param -
     */
    public SyncShard(String collectionName, String shardName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/collections/{collectionName}/shards/{shardName}/sync"
              .replace("{" + "collectionName" + "}", collectionName)
              .replace("{" + "shardName" + "}", shardName));

      this.collectionName = collectionName;
      this.shardName = shardName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected SyncShardResponse createResponse(SolrClient client) {
      return new SyncShardResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
