/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBSolrClient;
import org.apache.solr.client.solrj.impl.SolrClientBuilder;
import org.apache.solr.common.params.ModifiableSolrParams;

@Deprecated(since="9.0")
public class LBHttpSolrClient
extends LBSolrClient {
    private final HttpClient httpClient;
    private final boolean clientIsInternal;
    private final ConcurrentHashMap<String, HttpSolrClient> urlToClient = new ConcurrentHashMap();
    private final HttpSolrClient.Builder httpSolrClientBuilder;
    private volatile Set<String> urlParamNames = new HashSet<String>();
    final int connectionTimeoutMillis;
    final int soTimeoutMillis;

    protected LBHttpSolrClient(Builder builder) {
        super(builder.baseSolrUrls);
        this.clientIsInternal = builder.httpClient == null;
        this.httpSolrClientBuilder = builder.httpSolrClientBuilder;
        this.httpClient = builder.httpClient == null ? this.constructClient(builder.baseSolrUrls.toArray(new String[0])) : builder.httpClient;
        this.defaultCollection = builder.defaultCollection;
        if (this.httpSolrClientBuilder != null && this.defaultCollection != null) {
            this.httpSolrClientBuilder.defaultCollection = this.defaultCollection;
        }
        this.connectionTimeoutMillis = builder.connectionTimeoutMillis;
        this.soTimeoutMillis = builder.socketTimeoutMillis;
        this.parser = builder.responseParser;
        this.aliveCheckIntervalMillis = builder.aliveCheckInterval;
        for (String baseUrl : builder.baseSolrUrls) {
            this.urlToClient.put(baseUrl, this.makeSolrClient(baseUrl));
        }
    }

    private HttpClient constructClient(String[] solrServerUrl) {
        ModifiableSolrParams params = new ModifiableSolrParams();
        if (solrServerUrl != null && solrServerUrl.length > 1) {
            params.set("retry", false);
        } else {
            params.set("retry", true);
        }
        return HttpClientUtil.createClient(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HttpSolrClient makeSolrClient(String server) {
        HttpSolrClient client;
        if (this.httpSolrClientBuilder != null) {
            LBHttpSolrClient lBHttpSolrClient = this;
            synchronized (lBHttpSolrClient) {
                this.httpSolrClientBuilder.withBaseSolrUrl(server).withHttpClient(this.httpClient);
                this.httpSolrClientBuilder.withConnectionTimeout(this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
                this.httpSolrClientBuilder.withSocketTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS);
                if (this.requestWriter != null) {
                    this.httpSolrClientBuilder.withRequestWriter(this.requestWriter);
                }
                if (this.urlParamNames != null) {
                    this.httpSolrClientBuilder.withTheseParamNamesInTheUrl(this.urlParamNames);
                }
                client = this.httpSolrClientBuilder.build();
            }
        } else {
            HttpSolrClient.Builder clientBuilder = (HttpSolrClient.Builder)((HttpSolrClient.Builder)new HttpSolrClient.Builder(server).withHttpClient(this.httpClient)).withResponseParser(this.parser);
            clientBuilder.withConnectionTimeout(this.connectionTimeoutMillis, TimeUnit.MILLISECONDS);
            clientBuilder.withSocketTimeout(this.soTimeoutMillis, TimeUnit.MILLISECONDS);
            if (this.requestWriter != null) {
                clientBuilder.withRequestWriter(this.requestWriter);
            }
            if (this.urlParamNames != null) {
                clientBuilder.withTheseParamNamesInTheUrl(this.urlParamNames);
            }
            client = clientBuilder.build();
        }
        return client;
    }

    @Override
    protected SolrClient getClient(String baseUrl) {
        SolrClient client = this.urlToClient.get(baseUrl);
        if (client == null) {
            return this.makeSolrClient(baseUrl);
        }
        return client;
    }

    @Override
    public String removeSolrServer(String server) {
        this.urlToClient.remove(server);
        return super.removeSolrServer(server);
    }

    @Override
    public void close() {
        super.close();
        if (this.clientIsInternal) {
            HttpClientUtil.close(this.httpClient);
        }
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    @Deprecated
    public Set<String> getQueryParams() {
        return this.urlParamNames;
    }

    @Deprecated
    public void setQueryParams(Set<String> urlParamNames) {
        this.urlParamNames = urlParamNames;
    }

    @Deprecated
    public void addQueryParams(String urlParamNames) {
        this.urlParamNames.add(urlParamNames);
    }

    public static class Builder
    extends SolrClientBuilder<Builder> {
        public static final int CHECK_INTERVAL = 60000;
        protected final List<String> baseSolrUrls = new ArrayList<String>();
        protected HttpSolrClient.Builder httpSolrClientBuilder;
        private int aliveCheckInterval = 60000;

        public Builder() {
            this.responseParser = new BinaryResponseParser();
        }

        public HttpSolrClient.Builder getHttpSolrClientBuilder() {
            return this.httpSolrClientBuilder;
        }

        public Builder withBaseSolrUrl(String baseSolrUrl) {
            this.baseSolrUrls.add(baseSolrUrl);
            return this;
        }

        public Builder withBaseSolrUrls(String ... solrUrls) {
            for (String baseSolrUrl : solrUrls) {
                this.baseSolrUrls.add(baseSolrUrl);
            }
            return this;
        }

        public Builder setAliveCheckInterval(int aliveCheckInterval) {
            if (aliveCheckInterval <= 0) {
                throw new IllegalArgumentException("Alive check interval must be positive, specified value = " + aliveCheckInterval);
            }
            this.aliveCheckInterval = aliveCheckInterval;
            return this;
        }

        public Builder withHttpSolrClientBuilder(HttpSolrClient.Builder builder) {
            this.httpSolrClientBuilder = builder;
            return this;
        }

        public LBHttpSolrClient build() {
            return new LBHttpSolrClient(this);
        }

        @Override
        public Builder getThis() {
            return this;
        }
    }
}

