/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.List;
import org.apache.solr.client.api.model.InstallCoreDataRequestBody;
import org.apache.solr.client.api.model.MergeIndexesRequestBody;
import org.apache.solr.client.api.model.RenameCoreRequestBody;
import org.apache.solr.client.api.model.RestoreCoreRequestBody;
import org.apache.solr.client.api.model.SolrJerseyResponse;
import org.apache.solr.client.api.model.SwapCoresRequestBody;
import org.apache.solr.client.api.model.UnloadCoreRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class CoresApi {

    public static class UnloadCore
    extends SolrRequest<UnloadCoreResponse> {
        private final UnloadCoreRequestBody requestBody;
        private final String coreName;

        public UnloadCore(String coreName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cores/{coreName}/unload".replace("{coreName}", coreName));
            this.coreName = coreName;
            this.requestBody = new UnloadCoreRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setDeleteIndex(Boolean deleteIndex) {
            this.requestBody.deleteIndex = deleteIndex;
        }

        public void setDeleteDataDir(Boolean deleteDataDir) {
            this.requestBody.deleteDataDir = deleteDataDir;
        }

        public void setDeleteInstanceDir(Boolean deleteInstanceDir) {
            this.requestBody.deleteInstanceDir = deleteInstanceDir;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected UnloadCoreResponse createResponse(SolrClient client) {
            return new UnloadCoreResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class UnloadCoreResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public UnloadCoreResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class SwapCores
    extends SolrRequest<SwapCoresResponse> {
        private final SwapCoresRequestBody requestBody;
        private final String coreName;

        public SwapCores(String coreName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cores/{coreName}/swap".replace("{coreName}", coreName));
            this.coreName = coreName;
            this.requestBody = new SwapCoresRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setWith(String with) {
            this.requestBody.with = with;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected SwapCoresResponse createResponse(SolrClient client) {
            return new SwapCoresResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class SwapCoresResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public SwapCoresResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class RestoreCore
    extends SolrRequest<RestoreCoreResponse> {
        private final RestoreCoreRequestBody requestBody;
        private final String coreName;

        public RestoreCore(String coreName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cores/{coreName}/restore".replace("{coreName}", coreName));
            this.coreName = coreName;
            this.requestBody = new RestoreCoreRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setName(String name) {
            this.requestBody.name = name;
        }

        public void setShardBackupId(String shardBackupId) {
            this.requestBody.shardBackupId = shardBackupId;
        }

        public void setLocation(String location) {
            this.requestBody.location = location;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        public void setBackupRepository(String backupRepository) {
            this.requestBody.backupRepository = backupRepository;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected RestoreCoreResponse createResponse(SolrClient client) {
            return new RestoreCoreResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class RestoreCoreResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public RestoreCoreResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class RenameCore
    extends SolrRequest<RenameCoreResponse> {
        private final RenameCoreRequestBody requestBody;
        private final String coreName;

        public RenameCore(String coreName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cores/{coreName}/rename".replace("{coreName}", coreName));
            this.coreName = coreName;
            this.requestBody = new RenameCoreRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setTo(String to) {
            this.requestBody.to = to;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected RenameCoreResponse createResponse(SolrClient client) {
            return new RenameCoreResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class RenameCoreResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public RenameCoreResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class ReloadCore
    extends SolrRequest<ReloadCoreResponse> {
        private final String coreName;

        public ReloadCore(String coreName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cores/{coreName}/reload".replace("{coreName}", coreName));
            this.coreName = coreName;
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected ReloadCoreResponse createResponse(SolrClient client) {
            return new ReloadCoreResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class ReloadCoreResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public ReloadCoreResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class MergeIndexes
    extends SolrRequest<MergeIndexesResponse> {
        private final MergeIndexesRequestBody requestBody;
        private final String coreName;

        public MergeIndexes(String coreName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cores/{coreName}/merge-indices".replace("{coreName}", coreName));
            this.coreName = coreName;
            this.requestBody = new MergeIndexesRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setIndexDirs(List<String> indexDirs) {
            this.requestBody.indexDirs = indexDirs;
        }

        public void setSrcCores(List<String> srcCores) {
            this.requestBody.srcCores = srcCores;
        }

        public void setAsync(String async) {
            this.requestBody.async = async;
        }

        public void setUpdateChain(String updateChain) {
            this.requestBody.updateChain = updateChain;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected MergeIndexesResponse createResponse(SolrClient client) {
            return new MergeIndexesResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class MergeIndexesResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public MergeIndexesResponse() {
            super(SolrJerseyResponse.class);
        }
    }

    public static class InstallCoreData
    extends SolrRequest<InstallCoreDataResponse> {
        private final InstallCoreDataRequestBody requestBody;
        private final String coreName;

        public InstallCoreData(String coreName) {
            super(SolrRequest.METHOD.valueOf("POST"), "/cores/{coreName}/install".replace("{coreName}", coreName));
            this.coreName = coreName;
            this.requestBody = new InstallCoreDataRequestBody();
            this.addHeader("Content-type", "application/json");
        }

        public void setLocation(String location) {
            this.requestBody.location = location;
        }

        public void setRepository(String repository) {
            this.requestBody.repository = repository;
        }

        public void setAsyncId(String asyncId) {
            this.requestBody.asyncId = asyncId;
        }

        @Override
        public RequestWriter.ContentWriter getContentWriter(String expectedType) {
            return new JacksonContentWriter(expectedType, this.requestBody);
        }

        @Override
        public String getRequestType() {
            return SolrRequest.SolrRequestType.ADMIN.toString();
        }

        @Override
        public SolrParams getParams() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            return params;
        }

        @Override
        protected InstallCoreDataResponse createResponse(SolrClient client) {
            return new InstallCoreDataResponse();
        }

        @Override
        public ResponseParser getResponseParser() {
            return new InputStreamResponseParser("json");
        }
    }

    public static class InstallCoreDataResponse
    extends JacksonParsingResponse<SolrJerseyResponse> {
        public InstallCoreDataResponse() {
            super(SolrJerseyResponse.class);
        }
    }
}

