/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLUtil {
    public static final Pattern URL_PREFIX = Pattern.compile("^([a-z]*?://).*");

    public static String removeScheme(String url) {
        Matcher matcher = URL_PREFIX.matcher(url);
        if (matcher.matches()) {
            return url.substring(matcher.group(1).length());
        }
        return url;
    }

    public static boolean hasScheme(String url) {
        Matcher matcher = URL_PREFIX.matcher(url);
        return matcher.matches();
    }

    public static String getScheme(String url) {
        Matcher matcher = URL_PREFIX.matcher(url);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static String extractBaseUrl(String coreUrl) {
        coreUrl = URLUtil.removeTrailingSlashIfPresent(coreUrl);
        return coreUrl.substring(0, coreUrl.lastIndexOf("/"));
    }

    public static String extractCoreFromCoreUrl(String coreUrl) {
        coreUrl = URLUtil.removeTrailingSlashIfPresent(coreUrl);
        return coreUrl.substring(coreUrl.lastIndexOf("/") + 1);
    }

    public static String buildCoreUrl(String baseUrl, String coreName) {
        baseUrl = URLUtil.removeTrailingSlashIfPresent(baseUrl);
        return baseUrl + "/" + coreName;
    }

    private static String removeTrailingSlashIfPresent(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }
}

