/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClientBase;
import org.apache.solr.client.solrj.request.RequestWriter;

public abstract class HttpSolrClientBuilderBase<B extends HttpSolrClientBuilderBase<?, ?>, C extends HttpSolrClientBase> {
    protected Long idleTimeoutMillis;
    protected Long connectionTimeoutMillis;
    protected Long requestTimeoutMillis;
    protected String basicAuthAuthorizationStr;
    protected Boolean followRedirects;
    protected String baseSolrUrl;
    protected RequestWriter requestWriter;
    protected ResponseParser responseParser;
    protected String defaultCollection;
    protected Set<String> urlParamNames;
    protected Integer maxConnectionsPerHost;
    protected ExecutorService executor;
    protected boolean useHttp1_1 = Boolean.getBoolean("solr.http1");
    protected String proxyHost;
    protected int proxyPort;
    protected boolean proxyIsSocks4;
    protected boolean proxyIsSecure;

    public abstract C build();

    public B withRequestWriter(RequestWriter requestWriter) {
        this.requestWriter = requestWriter;
        return (B)this;
    }

    public B withResponseParser(ResponseParser responseParser) {
        this.responseParser = responseParser;
        return (B)this;
    }

    public B withDefaultCollection(String defaultCoreOrCollection) {
        this.defaultCollection = defaultCoreOrCollection;
        return (B)this;
    }

    public B withFollowRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return (B)this;
    }

    public B withExecutor(ExecutorService executor) {
        this.executor = executor;
        return (B)this;
    }

    public B withBasicAuthCredentials(String user, String pass) {
        if (!(user == null && pass == null || user != null && pass != null)) {
            throw new IllegalStateException("Invalid Authentication credentials. Either both username and password or none must be provided");
        }
        this.basicAuthAuthorizationStr = Http2SolrClient.basicAuthCredentialsToAuthorizationString(user, pass);
        return (B)this;
    }

    public B withTheseParamNamesInTheUrl(Set<String> urlParamNames) {
        this.urlParamNames = urlParamNames;
        return (B)this;
    }

    public B withMaxConnectionsPerHost(int max) {
        this.maxConnectionsPerHost = max;
        return (B)this;
    }

    public B withIdleTimeout(long idleConnectionTimeout, TimeUnit unit) {
        this.idleTimeoutMillis = TimeUnit.MILLISECONDS.convert(idleConnectionTimeout, unit);
        return (B)this;
    }

    public Long getIdleTimeoutMillis() {
        return this.idleTimeoutMillis;
    }

    public B withConnectionTimeout(long connectionTimeout, TimeUnit unit) {
        this.connectionTimeoutMillis = TimeUnit.MILLISECONDS.convert(connectionTimeout, unit);
        return (B)this;
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeoutMillis;
    }

    public B withRequestTimeout(long requestTimeout, TimeUnit unit) {
        this.requestTimeoutMillis = TimeUnit.MILLISECONDS.convert(requestTimeout, unit);
        return (B)this;
    }

    public B useHttp1_1(boolean useHttp1_1) {
        this.useHttp1_1 = useHttp1_1;
        return (B)this;
    }

    public B withProxyConfiguration(String host, int port, boolean isSocks4, boolean isSecure) {
        this.proxyHost = host;
        this.proxyPort = port;
        this.proxyIsSocks4 = isSocks4;
        this.proxyIsSecure = isSecure;
        return (B)this;
    }

    public B withOptionalBasicAuthCredentials(String credentials) {
        if (credentials != null) {
            if (credentials.indexOf(58) == -1) {
                throw new IllegalStateException("Invalid Authentication credential formatting. Provide username and password in the 'username:password' format.");
            }
            String username = credentials.substring(0, credentials.indexOf(58));
            String password = credentials.substring(credentials.indexOf(58) + 1, credentials.length());
            this.withBasicAuthCredentials(username, password);
        }
        return (B)this;
    }
}

