/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.GetAliasByNameResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for aliases, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class AliasesApi {

  public static class DeleteAliasResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public DeleteAliasResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class DeleteAlias extends SolrRequest<DeleteAliasResponse> {
    private final String aliasName;
    private String async;

    /**
     * Create a DeleteAlias request object.
     *
     * @param aliasName Path param - The name of the alias to delete
     */
    public DeleteAlias(String aliasName) {
      super(
          SolrRequest.METHOD.valueOf("DELETE"),
          "/aliases/{aliasName}".replace("{" + "aliasName" + "}", aliasName));

      this.aliasName = aliasName;
    }

    public void setAsync(String async) {
      this.async = async;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (async != null) {

        params.add("async", async);
      }
      return params;
    }

    @Override
    protected DeleteAliasResponse createResponse(SolrClient client) {
      return new DeleteAliasResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetAliasByNameResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.GetAliasByNameResponse> {
    public GetAliasByNameResponse() {
      super(org.apache.solr.client.api.model.GetAliasByNameResponse.class);
    }
  }

  public static class GetAliasByName extends SolrRequest<GetAliasByNameResponse> {
    private final String aliasName;

    /**
     * Create a GetAliasByName request object.
     *
     * @param aliasName Path param - Alias name.
     */
    public GetAliasByName(String aliasName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/aliases/{aliasName}".replace("{" + "aliasName" + "}", aliasName));

      this.aliasName = aliasName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetAliasByNameResponse createResponse(SolrClient client) {
      return new GetAliasByNameResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetAliasesResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.ListAliasesResponse> {
    public GetAliasesResponse() {
      super(org.apache.solr.client.api.model.ListAliasesResponse.class);
    }
  }

  public static class GetAliases extends SolrRequest<GetAliasesResponse> {

    /** Create a GetAliases request object. */
    public GetAliases() {
      super(SolrRequest.METHOD.valueOf("GET"), "/aliases");
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetAliasesResponse createResponse(SolrClient client) {
      return new GetAliasesResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
