/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.CreateCollectionSnapshotRequestBody;
import org.apache.solr.client.api.model.CreateCollectionSnapshotResponse;
import org.apache.solr.client.api.model.DeleteCollectionSnapshotResponse;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for collectionSnapshots, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class CollectionSnapshotsApi {

  public static class CreateCollectionSnapshotResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.CreateCollectionSnapshotResponse> {
    public CreateCollectionSnapshotResponse() {
      super(org.apache.solr.client.api.model.CreateCollectionSnapshotResponse.class);
    }
  }

  public static class CreateCollectionSnapshot
      extends SolrRequest<CreateCollectionSnapshotResponse> {
    private final CreateCollectionSnapshotRequestBody requestBody;
    private final String collName;
    private final String snapshotName;

    /**
     * Create a CreateCollectionSnapshot request object.
     *
     * @param collName Path param - The name of the collection.
     * @param snapshotName Path param - The name of the snapshot to be created.
     */
    public CreateCollectionSnapshot(String collName, String snapshotName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/collections/{collName}/snapshots/{snapshotName}"
              .replace("{" + "collName" + "}", collName)
              .replace("{" + "snapshotName" + "}", snapshotName));

      this.collName = collName;
      this.snapshotName = snapshotName;
      this.requestBody = new CreateCollectionSnapshotRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setFollowAliases(Boolean followAliases) {
      this.requestBody.followAliases = followAliases;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected CreateCollectionSnapshotResponse createResponse(SolrClient client) {
      return new CreateCollectionSnapshotResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class DeleteCollectionSnapshotResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.DeleteCollectionSnapshotResponse> {
    public DeleteCollectionSnapshotResponse() {
      super(org.apache.solr.client.api.model.DeleteCollectionSnapshotResponse.class);
    }
  }

  public static class DeleteCollectionSnapshot
      extends SolrRequest<DeleteCollectionSnapshotResponse> {
    private final String collName;
    private final String snapshotName;
    private Boolean followAliases;
    private String async;

    /**
     * Create a DeleteCollectionSnapshot request object.
     *
     * @param collName Path param - The name of the collection.
     * @param snapshotName Path param - The name of the snapshot to be deleted.
     */
    public DeleteCollectionSnapshot(String collName, String snapshotName) {
      super(
          SolrRequest.METHOD.valueOf("DELETE"),
          "/collections/{collName}/snapshots/{snapshotName}"
              .replace("{" + "collName" + "}", collName)
              .replace("{" + "snapshotName" + "}", snapshotName));

      this.collName = collName;
      this.snapshotName = snapshotName;
    }

    /**
     * @param followAliases A flag that treats the collName parameter as a collection alias.
     */
    public void setFollowAliases(Boolean followAliases) {
      this.followAliases = followAliases;
    }

    public void setAsync(String async) {
      this.async = async;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (followAliases != null) {

        params.add("followAliases", followAliases.toString());
      }
      if (async != null) {

        params.add("async", async);
      }
      return params;
    }

    @Override
    protected DeleteCollectionSnapshotResponse createResponse(SolrClient client) {
      return new DeleteCollectionSnapshotResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
