/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.api.model.CreateCoreBackupRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for coreBackups, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class CoreBackupsApi {

  public static class CreateBackupResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public CreateBackupResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class CreateBackup extends SolrRequest<CreateBackupResponse> {
    private final CreateCoreBackupRequestBody requestBody;
    private final String coreName;

    /**
     * Create a CreateBackup request object.
     *
     * @param coreName Path param - The name of the core.
     */
    public CreateBackup(String coreName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/cores/{coreName}/backups".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
      this.requestBody = new CreateCoreBackupRequestBody();
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param repository The name of the repository to be used for backup.
     */
    public void setRepository(String repository) {
      this.requestBody.repository = repository;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param location The path where the backup will be created
     */
    public void setLocation(String location) {
      this.requestBody.location = location;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setShardBackupId(String shardBackupId) {
      this.requestBody.shardBackupId = shardBackupId;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setPrevShardBackupId(String prevShardBackupId) {
      this.requestBody.prevShardBackupId = prevShardBackupId;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param commitName The name of the commit which was used while taking a snapshot using the
     *     CREATESNAPSHOT command.
     */
    public void setCommitName(String commitName) {
      this.requestBody.commitName = commitName;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param incremental To turn on incremental backup feature
     */
    public void setIncremental(Boolean incremental) {
      this.requestBody.incremental = incremental;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param async Request ID to track this action which will be processed asynchronously.
     */
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param backupName A descriptive name for the backup. Only used by non-incremental backups.
     */
    public void setBackupName(String backupName) {
      this.requestBody.backupName = backupName;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected CreateBackupResponse createResponse(SolrClient client) {
      return new CreateBackupResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
