/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.impl;

import java.io.IOException;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.BaseHttpClusterStateProvider;
import org.apache.solr.client.solrj.impl.Http2SolrClient;

public class Http2ClusterStateProvider
extends BaseHttpClusterStateProvider {
    final Http2SolrClient httpClient;
    final boolean closeClient;

    public Http2ClusterStateProvider(List<String> solrUrls, Http2SolrClient httpClient) throws Exception {
        this.httpClient = httpClient == null ? new Http2SolrClient.Builder().build() : httpClient;
        this.closeClient = httpClient == null;
        this.initConfiguredNodes(solrUrls);
    }

    @Override
    public void close() throws IOException {
        if (this.closeClient && this.httpClient != null) {
            this.httpClient.close();
        }
    }

    @Override
    protected SolrClient getSolrClient(String baseUrl) {
        return new Http2SolrClient.Builder(baseUrl).withHttpClient(this.httpClient).build();
    }

    public Http2SolrClient getHttpClient() {
        return this.httpClient;
    }
}

