/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.TrieDateField;
import org.apache.solr.util.AbstractSolrTestCase;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseDistributedSearchTestCase
extends SolrTestCaseJ4 {
    public static Random r = random;
    protected int shardCount = 4;
    protected boolean fixShardCount = false;
    protected JettySolrRunner controlJetty;
    protected List<SolrServer> clients = new ArrayList<SolrServer>();
    protected List<JettySolrRunner> jettys = new ArrayList<JettySolrRunner>();
    protected String context = "/solr";
    protected String shards;
    protected File testDir;
    protected SolrServer controlClient;
    protected int stress = 2;
    protected boolean verifyStress = true;
    protected int nThreads = 3;
    public static int ORDERED = 1;
    public static int SKIP = 2;
    public static int SKIPVAL = 4;
    public static int UNORDERED = 8;
    protected int flags;
    protected Map<String, Integer> handle = new HashMap<String, Integer>();
    protected String id = "id";
    public static Logger log = LoggerFactory.getLogger(BaseDistributedSearchTestCase.class);
    public static RandVal rint = new RandVal(){

        public Object val() {
            return r.nextInt();
        }
    };
    public static RandVal rlong = new RandVal(){

        public Object val() {
            return r.nextLong();
        }
    };
    public static RandVal rfloat = new RandVal(){

        public Object val() {
            return Float.valueOf(r.nextFloat());
        }
    };
    public static RandVal rdouble = new RandVal(){

        public Object val() {
            return r.nextDouble();
        }
    };
    public static RandVal rdate = new RandDate();
    public static String[] fieldNames = new String[]{"n_ti1", "n_f1", "n_tf1", "n_d1", "n_td1", "n_l1", "n_tl1", "n_dt1", "n_tdt1"};
    public static RandVal[] randVals = new RandVal[]{rint, rfloat, rfloat, rdouble, rdouble, rlong, rlong, rdate, rdate};

    public abstract void doTest() throws Exception;

    protected String[] getFieldNames() {
        return fieldNames;
    }

    protected RandVal[] getRandValues() {
        return randVals;
    }

    public String getSolrHome() {
        return SolrTestCaseJ4.TEST_HOME();
    }

    @Override
    public void setUp() throws Exception {
        SolrTestCaseJ4.resetExceptionIgnores();
        super.setUp();
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        System.setProperty("solr.solr.home", this.getSolrHome());
        this.testDir = new File(TEMP_DIR, ((Object)((Object)this)).getClass().getName() + "-" + System.currentTimeMillis());
        this.testDir.mkdirs();
    }

    @Override
    public void tearDown() throws Exception {
        this.destroyServers();
        if (!AbstractSolrTestCase.recurseDelete(this.testDir)) {
            System.err.println("!!!! WARNING: best effort to remove " + this.testDir.getAbsolutePath() + " FAILED !!!!!");
        }
        super.tearDown();
    }

    private void createServers(int numShards) throws Exception {
        this.controlJetty = BaseDistributedSearchTestCase.createJetty(this.testDir, "control");
        this.controlClient = this.createNewSolrServer(this.controlJetty.getLocalPort());
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= numShards; ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            JettySolrRunner j = BaseDistributedSearchTestCase.createJetty(this.testDir, "shard" + i);
            this.jettys.add(j);
            this.clients.add(this.createNewSolrServer(j.getLocalPort()));
            sb.append("localhost:").append(j.getLocalPort()).append(this.context);
        }
        this.shards = sb.toString();
    }

    protected void destroyServers() throws Exception {
        this.controlJetty.stop();
        for (JettySolrRunner jetty : this.jettys) {
            jetty.stop();
        }
        this.clients.clear();
        this.jettys.clear();
    }

    public static JettySolrRunner createJetty(File baseDir, String dataDirName) throws Exception {
        File subDir = new File(baseDir, dataDirName);
        subDir.mkdirs();
        System.setProperty("solr.data.dir", subDir.toString());
        JettySolrRunner jetty = new JettySolrRunner("/solr", 0);
        jetty.start();
        return jetty;
    }

    protected SolrServer createNewSolrServer(int port) {
        try {
            String url = "http://localhost:" + port + this.context;
            CommonsHttpSolrServer s = new CommonsHttpSolrServer(url);
            s.setConnectionTimeout(100);
            s.setDefaultMaxConnectionsPerHost(100);
            s.setMaxTotalConnections(100);
            return s;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void addFields(SolrInputDocument doc, Object ... fields) {
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
    }

    protected void indexr(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        this.addFields(doc, fields);
        this.addFields(doc, "rnd_b", true);
        this.addFields(doc, BaseDistributedSearchTestCase.getRandFields(this.getFieldNames(), this.getRandValues()));
        this.indexDoc(doc);
    }

    protected void index(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        this.addFields(doc, fields);
        this.indexDoc(doc);
    }

    protected void indexDoc(SolrInputDocument doc) throws IOException, SolrServerException {
        this.controlClient.add(doc);
        int which = (doc.getField(this.id).toString().hashCode() & Integer.MAX_VALUE) % this.clients.size();
        SolrServer client = this.clients.get(which);
        client.add(doc);
    }

    protected void index_specific(int serverNumber, Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
        this.controlClient.add(doc);
        SolrServer client = this.clients.get(serverNumber);
        client.add(doc);
    }

    protected void del(String q) throws Exception {
        this.controlClient.deleteByQuery(q);
        for (SolrServer client : this.clients) {
            client.deleteByQuery(q);
        }
    }

    protected void commit() throws Exception {
        this.controlClient.commit();
        for (SolrServer client : this.clients) {
            client.commit();
        }
    }

    protected void query(Object ... q) throws Exception {
        final ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("reqid", new String[]{Integer.toString(random.nextInt())});
        for (int i = 0; i < q.length; i += 2) {
            params.add(q[i].toString(), new String[]{q[i + 1].toString()});
        }
        params.add("controlClient", new String[]{"true"});
        final QueryResponse controlRsp = this.controlClient.query((SolrParams)params);
        params.remove("controlClient");
        params.set("shards", new String[]{this.shards});
        int which = r.nextInt(this.clients.size());
        SolrServer client = this.clients.get(which);
        QueryResponse rsp = client.query((SolrParams)params);
        this.compareResponses(rsp, controlRsp);
        if (this.stress > 0) {
            log.info("starting stress...");
            Thread[] threads = new Thread[this.nThreads];
            for (int i = 0; i < threads.length; ++i) {
                threads[i] = new Thread(){

                    public void run() {
                        for (int j = 0; j < BaseDistributedSearchTestCase.this.stress; ++j) {
                            int which = r.nextInt(BaseDistributedSearchTestCase.this.clients.size());
                            SolrServer client = BaseDistributedSearchTestCase.this.clients.get(which);
                            try {
                                QueryResponse rsp = client.query((SolrParams)new ModifiableSolrParams((SolrParams)params));
                                if (!BaseDistributedSearchTestCase.this.verifyStress) continue;
                                BaseDistributedSearchTestCase.this.compareResponses(rsp, controlRsp);
                                continue;
                            }
                            catch (SolrServerException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                };
                threads[i].start();
            }
            for (Thread thread : threads) {
                thread.join();
            }
        }
    }

    public static boolean eq(String a, String b) {
        return a == b || a != null && a.equals(b);
    }

    public static int flags(Map<String, Integer> handle, Object key) {
        if (handle == null) {
            return 0;
        }
        Integer f = handle.get(key);
        return f == null ? 0 : f;
    }

    public static String compare(NamedList a, NamedList b, int flags, Map<String, Integer> handle) {
        boolean ordered = (flags & UNORDERED) == 0;
        int posa = 0;
        int posb = 0;
        int aSkipped = 0;
        int bSkipped = 0;
        while (posa < a.size() && posb < b.size()) {
            String cmp;
            int flagsa;
            Object vala;
            String namea;
            Object valb = null;
            while (true) {
                namea = a.getName(posa);
                vala = a.getVal(posa);
                ++posa;
                flagsa = BaseDistributedSearchTestCase.flags(handle, namea);
                if ((flagsa & SKIP) == 0) break;
                ++aSkipped;
            }
            if (!ordered) {
                posb = 0;
            }
            while (posb < b.size()) {
                String nameb = b.getName(posb);
                valb = b.getVal(posb);
                ++posb;
                int flagsb = BaseDistributedSearchTestCase.flags(handle, nameb);
                if ((flagsb & SKIP) != 0) {
                    ++bSkipped;
                    continue;
                }
                if (BaseDistributedSearchTestCase.eq(namea, nameb)) break;
                if (!ordered) continue;
                return BaseDistributedSearchTestCase.err("." + namea + "!=" + nameb + " (unordered or missing)");
            }
            if ((flagsa & SKIPVAL) != 0 || (cmp = BaseDistributedSearchTestCase.compare(vala, valb, flagsa, handle)) == null) continue;
            return "." + namea + cmp;
        }
        if (a.size() - aSkipped != b.size() - bSkipped) {
            return BaseDistributedSearchTestCase.err(".size()==" + a.size() + "," + b.size() + "skipped=" + aSkipped + "," + bSkipped);
        }
        return null;
    }

    public static String compare1(Map a, Map b, int flags, Map<String, Integer> handle) {
        for (Object keya : a.keySet()) {
            Object valb;
            String cmp;
            Object vala = a.get(keya);
            int flagsa = BaseDistributedSearchTestCase.flags(handle, keya);
            if ((flagsa & SKIP) != 0) continue;
            if (!b.containsKey(keya)) {
                return BaseDistributedSearchTestCase.err("[" + keya + "]==null");
            }
            if ((flagsa & SKIPVAL) != 0 || (cmp = BaseDistributedSearchTestCase.compare(vala, valb = b.get(keya), flagsa, handle)) == null) continue;
            return "[" + keya + "]" + cmp;
        }
        return null;
    }

    public static String compare(Map a, Map b, int flags, Map<String, Integer> handle) {
        String cmp = BaseDistributedSearchTestCase.compare1(a, b, flags, handle);
        if (cmp != null) {
            return cmp;
        }
        return BaseDistributedSearchTestCase.compare1(b, a, flags, handle);
    }

    public static String compare(SolrDocument a, SolrDocument b, int flags, Map<String, Integer> handle) {
        return BaseDistributedSearchTestCase.compare(a.getFieldValuesMap(), b.getFieldValuesMap(), flags, handle);
    }

    public static String compare(SolrDocumentList a, SolrDocumentList b, int flags, Map<String, Integer> handle) {
        String cmp;
        boolean ordered = (flags & UNORDERED) == 0;
        int f = BaseDistributedSearchTestCase.flags(handle, "maxScore");
        if ((f & SKIPVAL) == 0) {
            cmp = BaseDistributedSearchTestCase.compare(a.getMaxScore(), b.getMaxScore(), 0, handle);
            if (cmp != null) {
                return ".maxScore" + cmp;
            }
        } else if (b.getMaxScore() != null && a.getMaxScore() == null) {
            return BaseDistributedSearchTestCase.err(".maxScore missing");
        }
        if ((cmp = BaseDistributedSearchTestCase.compare(a.getNumFound(), b.getNumFound(), 0, handle)) != null) {
            return ".numFound" + cmp;
        }
        cmp = BaseDistributedSearchTestCase.compare(a.getStart(), b.getStart(), 0, handle);
        if (cmp != null) {
            return ".start" + cmp;
        }
        cmp = BaseDistributedSearchTestCase.compare(a.size(), b.size(), 0, handle);
        if (cmp != null) {
            return ".size()" + cmp;
        }
        if (ordered) {
            for (int i = 0; i < a.size(); ++i) {
                cmp = BaseDistributedSearchTestCase.compare((SolrDocument)a.get(i), (SolrDocument)b.get(i), 0, handle);
                if (cmp == null) continue;
                return "[" + i + "]" + cmp;
            }
            return null;
        }
        for (int i = 0; i < a.size(); ++i) {
            SolrDocument doc = (SolrDocument)a.get(i);
            Object key = doc.getFirstValue("id");
            SolrDocument docb = null;
            if (key == null) {
                docb = (SolrDocument)b.get(i);
            } else {
                for (int j = 0; j < b.size() && !key.equals((docb = (SolrDocument)b.get(j)).getFirstValue("id")); ++j) {
                }
            }
            cmp = BaseDistributedSearchTestCase.compare(doc, docb, 0, handle);
            if (cmp == null) continue;
            return "[id=" + key + "]" + cmp;
        }
        return null;
    }

    public static String compare(Object[] a, Object[] b, int flags, Map<String, Integer> handle) {
        if (a.length != b.length) {
            return BaseDistributedSearchTestCase.err(".length:" + a.length + "!=" + b.length);
        }
        for (int i = 0; i < a.length; ++i) {
            String cmp = BaseDistributedSearchTestCase.compare(a[i], b[i], flags, handle);
            if (cmp == null) continue;
            return "[" + i + "]" + cmp;
        }
        return null;
    }

    public static String compare(Object a, Object b, int flags, Map<String, Integer> handle) {
        if (a == b) {
            return null;
        }
        if (a == null || b == null) {
            return BaseDistributedSearchTestCase.err(":" + a + "!=" + b);
        }
        if (a instanceof NamedList && b instanceof NamedList) {
            return BaseDistributedSearchTestCase.compare((NamedList)a, (NamedList)b, flags, handle);
        }
        if (a instanceof SolrDocumentList && b instanceof SolrDocumentList) {
            return BaseDistributedSearchTestCase.compare((SolrDocumentList)a, (SolrDocumentList)b, flags, handle);
        }
        if (a instanceof SolrDocument && b instanceof SolrDocument) {
            return BaseDistributedSearchTestCase.compare((SolrDocument)a, (SolrDocument)b, flags, handle);
        }
        if (a instanceof Map && b instanceof Map) {
            return BaseDistributedSearchTestCase.compare((Map)a, (Map)b, flags, handle);
        }
        if (a instanceof Object[] && b instanceof Object[]) {
            return BaseDistributedSearchTestCase.compare((Object[])a, (Object[])b, flags, handle);
        }
        if (a instanceof byte[] && b instanceof byte[]) {
            if (!Arrays.equals((byte[])a, (byte[])b)) {
                return BaseDistributedSearchTestCase.err(":" + a + "!=" + b);
            }
            return null;
        }
        if (a instanceof List && b instanceof List) {
            return BaseDistributedSearchTestCase.compare(((List)a).toArray(), ((List)b).toArray(), flags, handle);
        }
        if (!a.equals(b)) {
            return BaseDistributedSearchTestCase.err(":" + a + "!=" + b);
        }
        return null;
    }

    public static String err(String msg) {
        return msg;
    }

    protected void compareResponses(QueryResponse a, QueryResponse b) {
        String cmp = BaseDistributedSearchTestCase.compare(a.getResponse(), b.getResponse(), this.flags, this.handle);
        if (cmp != null) {
            log.info("Mismatched responses:\n" + a + "\n" + b);
            TestCase.fail((String)cmp);
        }
    }

    @Test
    public void testDistribSearch() throws Exception {
        if (this.fixShardCount) {
            this.createServers(this.shardCount);
            RandVal.uniqueValues = new HashSet();
            this.doTest();
            this.destroyServers();
        } else {
            for (int nServers = 1; nServers < this.shardCount; ++nServers) {
                this.createServers(nServers);
                RandVal.uniqueValues = new HashSet();
                this.doTest();
                this.destroyServers();
            }
        }
    }

    public static Object[] getRandFields(String[] fields, RandVal[] randVals) {
        Object[] o = new Object[fields.length * 2];
        for (int i = 0; i < fields.length; ++i) {
            o[i * 2] = fields[i];
            o[i * 2 + 1] = randVals[i].uval();
        }
        return o;
    }

    static /* synthetic */ Random access$000() {
        return random;
    }

    public static class RandDate
    extends RandVal {
        public static TrieDateField df = new TrieDateField();

        public Object val() {
            long v = r.nextLong();
            Date d = new Date(v);
            return df.toExternal(d);
        }
    }

    public static abstract class RandVal {
        public static Random r = BaseDistributedSearchTestCase.access$000();
        public static Set uniqueValues = new HashSet();

        public abstract Object val();

        public Object uval() {
            Object v;
            while (!uniqueValues.add(v = this.val())) {
            }
            return v;
        }
    }
}

