/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.xpath.XPathExpressionException;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.JSONTestUtil;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.TestHarness;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class SolrTestCaseJ4
extends LuceneTestCase {
    static long numOpens;
    static long numCloses;
    protected static String configString;
    protected static String schemaString;
    protected static SolrConfig solrConfig;
    protected static TestHarness h;
    protected static TestHarness.LocalRequestFactory lrf;
    protected static File dataDir;
    public static Logger log;
    private static String factoryProp;

    @BeforeClass
    public static void beforeClassSolrTestCase() throws Exception {
        SolrTestCaseJ4.ignoreException("ignore_exception");
    }

    @AfterClass
    public static void afterClassSolrTestCase() throws Exception {
        SolrTestCaseJ4.deleteCore();
        SolrTestCaseJ4.resetExceptionIgnores();
    }

    public void setUp() throws Exception {
        super.setUp();
        log.info("###Starting " + this.getName());
    }

    public void tearDown() throws Exception {
        log.info("###Ending " + this.getName());
        super.tearDown();
    }

    public static void initCore(String config, String schema) throws Exception {
        SolrTestCaseJ4.initCore(config, schema, SolrTestCaseJ4.TEST_HOME());
    }

    public static void initCore(String config, String schema, String solrHome) throws Exception {
        SolrTestCaseJ4.startTrackingSearchers();
        configString = config;
        schemaString = schema;
        if (solrHome != null) {
            System.setProperty("solr.solr.home", solrHome);
        }
        SolrTestCaseJ4.initCore();
    }

    protected static void startTrackingSearchers() {
        numOpens = SolrIndexSearcher.numOpens.get();
        numCloses = SolrIndexSearcher.numCloses.get();
    }

    protected static void endTrackingSearchers() {
        long endNumCloses;
        long endNumOpens = SolrIndexSearcher.numOpens.get();
        if (endNumOpens - numOpens != (endNumCloses = SolrIndexSearcher.numCloses.get()) - numCloses) {
            String msg = "ERROR: SolrIndexSearcher opens=" + (endNumOpens - numOpens) + " closes=" + (endNumCloses - numCloses);
            log.error(msg);
        }
    }

    public static void ignoreException(String pattern) {
        if (SolrException.ignorePatterns == null) {
            SolrException.ignorePatterns = new HashSet();
        }
        SolrException.ignorePatterns.add(pattern);
    }

    public static void resetExceptionIgnores() {
        SolrException.ignorePatterns = null;
        SolrTestCaseJ4.ignoreException("ignore_exception");
    }

    protected static String getClassName() {
        StackTraceElement[] stack = new RuntimeException("WhoAmI").fillInStackTrace().getStackTrace();
        for (int i = stack.length - 1; i >= 0; --i) {
            StackTraceElement ste = stack[i];
            String cname = ste.getClassName();
            if (cname.indexOf(".lucene.") < 0 && cname.indexOf(".solr.") < 0) continue;
            return cname;
        }
        return SolrTestCaseJ4.class.getName();
    }

    protected static String getSimpleClassName() {
        String cname = SolrTestCaseJ4.getClassName();
        return cname.substring(cname.lastIndexOf(46) + 1);
    }

    public static String getSchemaFile() {
        return schemaString;
    }

    public static String getSolrConfigFile() {
        return configString;
    }

    public static void createTempDir() {
        String cname = SolrTestCaseJ4.getSimpleClassName();
        dataDir = new File(TEMP_DIR, "solrtest-" + cname + "-" + System.currentTimeMillis());
        dataDir.mkdirs();
    }

    public static void initCore() throws Exception {
        log.info("####initCore");
        SolrTestCaseJ4.ignoreException("ignore_exception");
        factoryProp = System.getProperty("solr.directoryFactory");
        if (factoryProp == null) {
            System.setProperty("solr.directoryFactory", "solr.RAMDirectoryFactory");
        }
        if (dataDir == null) {
            SolrTestCaseJ4.createTempDir();
        }
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        String configFile = SolrTestCaseJ4.getSolrConfigFile();
        if (configFile != null) {
            solrConfig = TestHarness.createConfig(SolrTestCaseJ4.getSolrConfigFile());
            h = new TestHarness(dataDir.getAbsolutePath(), solrConfig, SolrTestCaseJ4.getSchemaFile());
            lrf = h.getRequestFactory("standard", 0, 20, "version", "2.2");
        }
        log.info("####initCore end");
    }

    public void postSetUp() {
        log.info("####POSTSETUP " + this.getName());
    }

    public void preTearDown() {
        log.info("####PRETEARDOWN " + this.getName());
    }

    public static void deleteCore() throws Exception {
        log.info("###deleteCore");
        if (h != null) {
            h.close();
        }
        if (dataDir != null) {
            String skip = System.getProperty("solr.test.leavedatadir");
            if (null != skip && 0 != skip.trim().length()) {
                System.err.println("NOTE: per solr.test.leavedatadir, dataDir will not be removed: " + dataDir.getAbsolutePath());
            } else if (!SolrTestCaseJ4.recurseDelete(dataDir)) {
                System.err.println("!!!! WARNING: best effort to remove " + dataDir.getAbsolutePath() + " FAILED !!!!!");
            }
        }
        if (factoryProp == null) {
            System.clearProperty("solr.directoryFactory");
        }
        dataDir = null;
        solrConfig = null;
        h = null;
        lrf = null;
        schemaString = null;
        configString = null;
        SolrTestCaseJ4.endTrackingSearchers();
    }

    public static void assertU(String update) {
        SolrTestCaseJ4.assertU(null, update);
    }

    public static void assertU(String message, String update) {
        SolrTestCaseJ4.checkUpdateU(message, update, true);
    }

    public static void assertFailedU(String update) {
        SolrTestCaseJ4.assertFailedU(null, update);
    }

    public static void assertFailedU(String message, String update) {
        SolrTestCaseJ4.checkUpdateU(message, update, false);
    }

    private static void checkUpdateU(String message, String update, boolean shouldSucceed) {
        try {
            String m;
            String string = m = null == message ? "" : message + " ";
            if (shouldSucceed) {
                String res = h.validateUpdate(update);
                if (res != null) {
                    SolrTestCaseJ4.fail((String)(m + "update was not successful: " + res));
                }
            } else {
                String res = h.validateErrorUpdate(update);
                if (res != null) {
                    SolrTestCaseJ4.fail((String)(m + "update succeeded, but should have failed: " + res));
                }
            }
        }
        catch (SAXException e) {
            throw new RuntimeException("Invalid XML", e);
        }
    }

    public static void assertQ(SolrQueryRequest req, String ... tests) {
        SolrTestCaseJ4.assertQ(null, req, tests);
    }

    public static void assertQ(String message, SolrQueryRequest req, String ... tests) {
        try {
            String results;
            String m = null == message ? "" : message + " ";
            String response = h.query(req);
            if (req.getParams().getBool("facet", false)) {
                String[] allTests = new String[tests.length + 1];
                System.arraycopy(tests, 0, allTests, 1, tests.length);
                allTests[0] = "*[count(//lst[@name='facet_counts']/*[@name='exception'])=0]";
                tests = allTests;
            }
            if (null != (results = h.validateXPath(response, tests))) {
                String msg = "REQUEST FAILED: xpath=" + results + "\n\txml response was: " + response + "\n\trequest was:" + req.getParamString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
        }
        catch (XPathExpressionException e1) {
            throw new RuntimeException("XPath is invalid", e1);
        }
        catch (Exception e2) {
            SolrException.log((Logger)log, (String)("REQUEST FAILED: " + req.getParamString()), (Throwable)e2);
            throw new RuntimeException("Exception during query", e2);
        }
    }

    public static void assertJQ(SolrQueryRequest req, String ... tests) throws Exception {
        SolrTestCaseJ4.assertJQ(req, 1.0E-5, tests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertJQ(SolrQueryRequest req, double delta, String ... tests) throws Exception {
        SolrParams params = null;
        try {
            String response;
            params = req.getParams();
            if (!"json".equals(params.get("wt", "xml")) || params.get("indent") == null) {
                ModifiableSolrParams newParams = new ModifiableSolrParams(params);
                newParams.set("wt", new String[]{"json"});
                if (params.get("indent") == null) {
                    newParams.set("indent", new String[]{"true"});
                }
                req.setParams((SolrParams)newParams);
            }
            boolean failed = true;
            try {
                response = h.query(req);
                failed = false;
            }
            finally {
                if (failed) {
                    log.error("REQUEST FAILED: " + req.getParamString());
                }
            }
            for (String test : tests) {
                String testJSON = test.replace('\'', '\"');
                try {
                    failed = true;
                    String err = JSONTestUtil.match(response, testJSON, delta);
                    failed = false;
                    if (err == null) continue;
                    log.error("query failed JSON validation. error=" + err + "\n expected =" + testJSON + "\n response = " + response + "\n request = " + req.getParamString());
                    throw new RuntimeException(err);
                }
                finally {
                    if (failed) {
                        log.error("JSON query validation threw an exception.\n expected =" + testJSON + "\n response = " + response + "\n request = " + req.getParamString());
                    }
                }
            }
        }
        finally {
            if (params != null && params != req.getParams()) {
                req.setParams(params);
            }
        }
    }

    public static void assertQEx(String message, SolrQueryRequest req, int code) {
        try {
            h.query(req);
            SolrTestCaseJ4.fail((String)message);
        }
        catch (SolrException sex) {
            SolrTestCaseJ4.assertEquals((long)code, (long)sex.code());
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
    }

    public static void assertQEx(String message, SolrQueryRequest req, SolrException.ErrorCode code) {
        try {
            h.query(req);
            SolrTestCaseJ4.fail((String)message);
        }
        catch (SolrException e) {
            SolrTestCaseJ4.assertEquals((long)code.code, (long)e.code());
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
    }

    public static String optimize(String ... args) {
        return TestHarness.optimize(args);
    }

    public static String commit(String ... args) {
        return TestHarness.commit(args);
    }

    public static String adoc(String ... fieldsAndValues) {
        Doc d = SolrTestCaseJ4.doc(fieldsAndValues);
        return SolrTestCaseJ4.add(d, new String[0]);
    }

    public static String adoc(SolrInputDocument sdoc) {
        ArrayList<String> fields = new ArrayList<String>();
        for (SolrInputField sf : sdoc) {
            for (Object o : sf.getValues()) {
                fields.add(sf.getName());
                fields.add(o.toString());
            }
        }
        return SolrTestCaseJ4.adoc(fields.toArray(new String[fields.size()]));
    }

    public static String add(Doc doc, String ... args) {
        try {
            StringWriter r = new StringWriter();
            if (null == args || 0 == args.length) {
                r.write("<add>");
                r.write(doc.xml);
                r.write("</add>");
            } else {
                XML.writeUnescapedXML((Writer)r, (String)"add", (String)doc.xml, (Object[])args);
            }
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String delI(String id) {
        return TestHarness.deleteById(id);
    }

    public static String delQ(String q) {
        return TestHarness.deleteByQuery(q);
    }

    public static Doc doc(String ... fieldsAndValues) {
        Doc d = new Doc();
        d.xml = TestHarness.makeSimpleDoc(fieldsAndValues).toString();
        return d;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    public static SolrQueryRequest req(String ... q) {
        return lrf.makeRequest(q);
    }

    public static SolrQueryRequest req(String[] params, String ... moreParams) {
        String[] allParams = moreParams;
        if (params.length != 0) {
            int len = params.length + moreParams.length;
            allParams = new String[len];
            System.arraycopy(params, 0, allParams, 0, params.length);
            System.arraycopy(moreParams, 0, allParams, params.length, moreParams.length);
        }
        return lrf.makeRequest(allParams);
    }

    public static SolrQueryRequest req(SolrParams params, String ... moreParams) {
        ModifiableSolrParams mp = new ModifiableSolrParams(params);
        for (int i = 0; i < moreParams.length; i += 2) {
            mp.add(moreParams[i], new String[]{moreParams[i + 1]});
        }
        return new LocalSolrQueryRequest(h.getCore(), (SolrParams)mp);
    }

    public static boolean recurseDelete(File f) {
        if (f.isDirectory()) {
            for (File sub : f.listFiles()) {
                if (SolrTestCaseJ4.recurseDelete(sub)) continue;
                System.err.println("!!!! WARNING: best effort to remove " + sub.getAbsolutePath() + " FAILED !!!!!");
                return false;
            }
        }
        return f.delete();
    }

    public void clearIndex() {
        SolrTestCaseJ4.assertU(SolrTestCaseJ4.delQ("*:*"));
    }

    public static File getFile(String name) {
        try {
            File file = new File(name);
            if (!file.exists()) {
                file = new File(Thread.currentThread().getContextClassLoader().getResource(name).toURI());
            }
            return file;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot find resource: " + name);
        }
    }

    public static String TEST_HOME() {
        return SolrTestCaseJ4.getFile("solr/conf").getParent();
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable result = t;
        for (Throwable cause = t; null != cause; cause = cause.getCause()) {
            result = cause;
        }
        return result;
    }

    static {
        log = LoggerFactory.getLogger(SolrTestCaseJ4.class);
    }

    public static class Doc {
        public String xml;

        public String toString() {
            return this.xml;
        }
    }
}

