/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.cloud.AbstractDistribZkTestBase;
import org.apache.solr.cloud.ChaosMonkey;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneTestCase.Slow
public abstract class AbstractFullDistribZkTestBase
extends AbstractDistribZkTestBase {
    static Logger log = LoggerFactory.getLogger(AbstractFullDistribZkTestBase.class);
    public static final String SHARD1 = "shard1";
    public static final String SHARD2 = "shard2";
    protected boolean printLayoutOnTearDown = false;
    String t1 = "a_t";
    String i1 = "a_si";
    String nint = "n_i";
    String tint = "n_ti";
    String nfloat = "n_f";
    String tfloat = "n_tf";
    String ndouble = "n_d";
    String tdouble = "n_td";
    String nlong = "n_l";
    String tlong = "other_tl1";
    String ndate = "n_dt";
    String tdate = "n_tdt";
    String oddField = "oddField_s";
    String missingField = "ignore_exception__missing_but_valid_field_t";
    String invalidField = "ignore_exception__invalid_field_not_in_schema";
    protected int sliceCount;
    protected volatile CloudSolrServer cloudClient;
    protected List<CloudJettyRunner> cloudJettys = new ArrayList<CloudJettyRunner>();
    protected Map<String, List<CloudJettyRunner>> shardToJetty = new HashMap<String, List<CloudJettyRunner>>();
    private AtomicInteger jettyIntCntr = new AtomicInteger(0);
    protected ChaosMonkey chaosMonkey;
    protected volatile ZkStateReader zkStateReader;
    protected Map<String, CloudJettyRunner> shardToLeaderJetty = new HashMap<String, CloudJettyRunner>();

    @BeforeClass
    public static void beforeFullSolrCloudTest() {
        if (formatter != null) {
            formatter.setShorterFormat();
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        System.setProperty("numShards", Integer.toString(this.sliceCount));
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("solrcloud.update.delay", "0");
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("solrcloud.update.delay");
    }

    public AbstractFullDistribZkTestBase() {
        this.fixShardCount = true;
        this.shardCount = 4;
        this.sliceCount = 2;
        this.stress = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initCloud() throws Exception {
        if (this.zkStateReader == null) {
            AbstractFullDistribZkTestBase abstractFullDistribZkTestBase = this;
            synchronized (abstractFullDistribZkTestBase) {
                if (this.zkStateReader != null) {
                    return;
                }
                this.zkStateReader = new ZkStateReader(this.zkServer.getZkAddress(), 10000, 10000);
                this.zkStateReader.createClusterStateWatchersAndUpdate();
            }
            this.chaosMonkey = new ChaosMonkey(this.zkServer, this.zkStateReader, "collection1", this.shardToJetty, this.shardToLeaderJetty);
        }
        int cnt = 30;
        while (!this.zkStateReader.getClusterState().getCollections().contains("collection1")) {
            if (cnt == 0) {
                throw new RuntimeException("timeout waiting for collection1 in cluster state");
            }
            --cnt;
            Thread.sleep(500L);
        }
        cnt = 30;
        while (this.zkStateReader.getClusterState().getSlices("collection1").size() != this.sliceCount) {
            if (cnt == 0) {
                throw new RuntimeException("timeout waiting for collection shards to come up");
            }
            --cnt;
            Thread.sleep(500L);
        }
        if (this.cloudClient == null) {
            AbstractFullDistribZkTestBase abstractFullDistribZkTestBase = this;
            synchronized (abstractFullDistribZkTestBase) {
                if (this.cloudClient != null) {
                    return;
                }
                try {
                    CloudSolrServer server = new CloudSolrServer(this.zkServer.getZkAddress());
                    server.setDefaultCollection("collection1");
                    server.getLbServer().getHttpClient().getParams().setParameter("http.connection.timeout", (Object)5000);
                    server.getLbServer().getHttpClient().getParams().setParameter("http.socket.timeout", (Object)20000);
                    this.cloudClient = server;
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    protected void createServers(int numServers) throws Exception {
        System.setProperty("collection", "control_collection");
        String numShards = System.getProperty("numShards");
        System.clearProperty("numShards");
        this.controlJetty = this.createJetty(new File(this.getSolrHome()), this.testDir + "/control/data", "control_shard");
        System.clearProperty("collection");
        if (numShards != null) {
            System.setProperty("numShards", numShards);
        }
        this.controlClient = this.createNewSolrServer(this.controlJetty.getLocalPort());
        this.createJettys(numServers, true);
    }

    protected List<JettySolrRunner> createJettys(int numJettys) throws Exception {
        return this.createJettys(numJettys, false);
    }

    protected List<JettySolrRunner> createJettys(int numJettys, boolean checkCreatedVsState) throws Exception {
        int i;
        ArrayList<JettySolrRunner> jettys = new ArrayList<JettySolrRunner>();
        ArrayList<SolrServer> clients = new ArrayList<SolrServer>();
        StringBuilder sb = new StringBuilder();
        for (i = 1; i <= numJettys; ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            int cnt = this.jettyIntCntr.incrementAndGet();
            File jettyDir = new File(TEMP_DIR, "solrtest-jetty" + cnt + "-" + System.currentTimeMillis());
            jettyDir.mkdirs();
            FileUtils.copyDirectory((File)new File(this.getSolrHome()), (File)jettyDir);
            JettySolrRunner j = this.createJetty(jettyDir, this.testDir + "/jetty" + cnt, null, "solrconfig.xml", null);
            jettys.add(j);
            SolrServer client = this.createNewSolrServer(j.getLocalPort());
            clients.add(client);
        }
        this.initCloud();
        this.jettys.addAll(jettys);
        this.clients.addAll(clients);
        if (checkCreatedVsState) {
            int numShards = this.getNumShards("collection1");
            int retries = 0;
            while (numShards != this.shardCount && (numShards = this.getNumShards("collection1")) != this.shardCount) {
                if (retries++ == 60) {
                    this.printLayoutOnTearDown = true;
                    AbstractFullDistribZkTestBase.fail((String)("Shards in the state does not match what we set:" + numShards + " vs " + this.shardCount));
                }
                Thread.sleep(500L);
            }
            for (int i2 = 1; i2 <= this.sliceCount; ++i2) {
                this.zkStateReader.getLeaderProps("collection1", "shard" + i2, 10000);
            }
        }
        this.updateMappingsFromZk(this.jettys, this.clients);
        for (i = 1; i <= numJettys / 2; ++i) {
            JettySolrRunner j = (JettySolrRunner)this.jettys.get(i);
            JettySolrRunner j2 = (JettySolrRunner)this.jettys.get(i + (numJettys / 2 - 1));
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("127.0.0.1:").append(j.getLocalPort()).append(this.context);
            sb.append("|127.0.0.1:").append(j2.getLocalPort()).append(this.context);
        }
        this.shards = sb.toString();
        return jettys;
    }

    protected int getNumShards(String defaultCollection) {
        Map slices = this.zkStateReader.getClusterState().getSlices(defaultCollection);
        int cnt = 0;
        for (Map.Entry entry : slices.entrySet()) {
            cnt += ((Slice)entry.getValue()).getReplicasMap().size();
        }
        return cnt;
    }

    public JettySolrRunner createJetty(String dataDir, String shardList, String solrConfigOverride) throws Exception {
        JettySolrRunner jetty = new JettySolrRunner(this.getSolrHome(), "/solr", 0, solrConfigOverride, null, false);
        jetty.setShards(shardList);
        jetty.setDataDir(dataDir);
        jetty.start();
        return jetty;
    }

    protected void updateMappingsFromZk(List<JettySolrRunner> jettys, List<SolrServer> clients) throws Exception {
        this.zkStateReader.updateClusterState(true);
        this.cloudJettys.clear();
        this.shardToJetty.clear();
        ClusterState clusterState = this.zkStateReader.getClusterState();
        Map slices = clusterState.getSlices("collection1");
        if (slices == null) {
            throw new RuntimeException("No slices found for collection collection1 in " + clusterState.getCollections());
        }
        ArrayList<CloudSolrServerClient> theClients = new ArrayList<CloudSolrServerClient>();
        block0: for (SolrServer solrServer : clients) {
            for (Map.Entry slice : slices.entrySet()) {
                Map theShards = ((Slice)slice.getValue()).getReplicasMap();
                for (Map.Entry shard : theShards.entrySet()) {
                    int port = new URI(((HttpSolrServer)solrServer).getBaseURL()).getPort();
                    if (!((String)shard.getKey()).contains(":" + port + "_")) continue;
                    CloudSolrServerClient csc = new CloudSolrServerClient();
                    csc.solrClient = solrServer;
                    csc.port = port;
                    csc.shardName = ((Replica)shard.getValue()).getStr("node_name");
                    csc.info = (ZkNodeProps)shard.getValue();
                    theClients.add(csc);
                    continue block0;
                }
            }
        }
        block3: for (JettySolrRunner jettySolrRunner : jettys) {
            int port = jettySolrRunner.getLocalPort();
            if (port == -1) {
                throw new RuntimeException("Cannot find the port for jetty");
            }
            for (Map.Entry slice : slices.entrySet()) {
                Map theShards = ((Slice)slice.getValue()).getReplicasMap();
                for (Map.Entry shard : theShards.entrySet()) {
                    if (!((String)shard.getKey()).contains(":" + port + "_")) continue;
                    List<CloudJettyRunner> list = this.shardToJetty.get(slice.getKey());
                    if (list == null) {
                        list = new ArrayList<CloudJettyRunner>();
                        this.shardToJetty.put((String)slice.getKey(), list);
                    }
                    boolean isLeader = ((Replica)shard.getValue()).containsKey("leader");
                    CloudJettyRunner cjr = new CloudJettyRunner();
                    cjr.jetty = jettySolrRunner;
                    cjr.info = (ZkNodeProps)shard.getValue();
                    cjr.nodeName = ((Replica)shard.getValue()).getStr("node_name");
                    cjr.coreNodeName = (String)shard.getKey();
                    cjr.url = ((Replica)shard.getValue()).getStr("base_url") + "/" + ((Replica)shard.getValue()).getStr("core");
                    cjr.client = this.findClientByPort(port, theClients);
                    list.add(cjr);
                    if (isLeader) {
                        this.shardToLeaderJetty.put((String)slice.getKey(), cjr);
                    }
                    this.cloudJettys.add(cjr);
                    continue block3;
                }
            }
        }
        for (Map.Entry entry : slices.entrySet()) {
            List<CloudJettyRunner> jetties = this.shardToJetty.get(entry.getKey());
            AbstractFullDistribZkTestBase.assertNotNull((String)("Test setup problem: We found no jetties for shard: " + (String)entry.getKey() + " just:" + this.shardToJetty.keySet()), jetties);
            AbstractFullDistribZkTestBase.assertEquals((long)((Slice)entry.getValue()).getReplicasMap().size(), (long)jetties.size());
        }
    }

    private CloudSolrServerClient findClientByPort(int port, List<CloudSolrServerClient> theClients) {
        for (CloudSolrServerClient client : theClients) {
            if (client.port != port) continue;
            return client;
        }
        throw new IllegalArgumentException("Client with the give port does not exist:" + port);
    }

    @Override
    protected void setDistributedParams(ModifiableSolrParams params) {
        if (!r.nextBoolean()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.sliceCount; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append("shard" + (i + 1));
            }
            params.set("shards", new String[]{sb.toString()});
        }
    }

    @Override
    protected void indexDoc(SolrInputDocument doc) throws IOException, SolrServerException {
        this.controlClient.add(doc);
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(doc);
        ureq.process((SolrServer)this.cloudClient);
    }

    @Override
    protected void index_specific(int serverNumber, Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
        this.controlClient.add(doc);
        HttpSolrServer client = (HttpSolrServer)this.clients.get(serverNumber);
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(doc);
        ureq.process((SolrServer)client);
    }

    protected void index_specific(SolrServer client, Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(doc);
        ureq.process(client);
        this.controlClient.add(doc);
    }

    @Override
    protected void del(String q) throws Exception {
        this.controlClient.deleteByQuery(q);
        this.cloudClient.deleteByQuery(q);
    }

    protected void waitForRecoveriesToFinish(boolean verbose) throws Exception {
        super.waitForRecoveriesToFinish("collection1", this.zkStateReader, verbose);
    }

    protected void waitForRecoveriesToFinish(boolean verbose, int timeoutSeconds) throws Exception {
        super.waitForRecoveriesToFinish("collection1", this.zkStateReader, verbose, true, timeoutSeconds);
    }

    protected void checkQueries() throws Exception {
        this.handle.put("_version_", SKIPVAL);
        this.query("q", "*:*", "sort", "n_tl1 desc");
        this.handle.put("response", UNORDERED);
        String ids = "987654";
        for (int i = 0; i < 20; ++i) {
            this.query("qt", "/get", "id", Integer.toString(i));
            this.query("qt", "/get", "ids", Integer.toString(i));
            ids = ids + ',' + Integer.toString(i);
            this.query("qt", "/get", "ids", ids);
        }
        this.handle.remove("response");
        for (String f : fieldNames) {
            this.query("q", "*:*", "sort", f + " desc");
            this.query("q", "*:*", "sort", f + " asc");
        }
        this.query("q", "*:*", "sort", this.i1 + " desc");
        this.query("q", "*:*", "sort", this.i1 + " asc");
        this.query("q", "*:*", "sort", this.i1 + " desc", "fl", "*,score");
        this.query("q", "*:*", "sort", "n_tl1 asc", "fl", "score");
        this.query("q", "*:*", "sort", "n_tl1 desc");
        this.handle.put("maxScore", SKIPVAL);
        this.query("q", "{!func}" + this.i1);
        this.handle.remove("maxScore");
        this.query("q", "{!func}" + this.i1, "fl", "*,score");
        this.handle.put("highlighting", UNORDERED);
        this.handle.put("response", UNORDERED);
        this.handle.put("maxScore", SKIPVAL);
        this.query("q", "quick");
        this.query("q", "all", "fl", "id", "start", "0");
        this.query("q", "all", "fl", "foofoofoo", "start", "0");
        this.query("q", "all", "fl", "id", "start", "100");
        this.handle.put("score", SKIPVAL);
        this.query("q", "quick", "fl", "*,score");
        this.query("q", "all", "fl", "*,score", "start", "1");
        this.query("q", "all", "fl", "*,score", "start", "100");
        this.query("q", "now their fox sat had put", "fl", "*,score", "hl", "true", "hl.fl", this.t1);
        this.query("q", "now their fox sat had put", "fl", "foofoofoo", "hl", "true", "hl.fl", this.t1);
        this.query("q", "matchesnothing", "fl", "*,score");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "count");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "count", "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "index");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "index", "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", 1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.query", "quick", "facet.query", "all", "facet.query", "*:*");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.offset", 1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.query", "quick", "facet.query", "all", "facet.query", "*:*", "facet.field", this.t1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.query", "{!key=myquick}quick", "facet.query", "{!key=myall ex=a}all", "facet.query", "*:*", "facet.field", "{!key=mykey ex=a}" + this.t1, "facet.field", "{!key=other ex=b}" + this.t1, "facet.field", "{!key=again ex=a,b}" + this.t1, "facet.field", this.t1, "fq", "{!tag=a}id:[1 TO 7]", "fq", "{!tag=b}id:[3 TO 9]");
        this.query("q", "*:*", "facet", "true", "facet.field", "{!ex=t1}SubjectTerms_mfacet", "fq", "{!tag=t1}SubjectTerms_mfacet:(test 1)", "facet.limit", "10", "facet.mincount", "1");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.missingField, "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.oddField, "facet.mincount", 2);
        this.query("q", "*:*", "sort", this.i1 + " desc", "stats", "true", "stats.field", this.i1);
        this.handle.put("facet_fields", SKIPVAL);
        this.query("q", "*:*", "rows", 0, "facet", "true", "facet.field", this.t1, "facet.limit", 5, "facet.shard.limit", 5);
        this.query("q", "*:*", "rows", 0, "facet", "true", "facet.field", "{!key='a b/c \\' \\} foo'}" + this.t1, "facet.limit", 5, "facet.shard.limit", 5);
        this.handle.remove("facet_fields");
        this.query("q", "*:*", "sort", "n_tl1 desc");
        if (this.clients.size() >= 2) {
            this.index(this.id, 100, this.i1, 107, this.t1, "oh no, a duplicate!");
            for (int i = 0; i < this.shardCount; ++i) {
                this.index_specific(i, this.id, 100, this.i1, 107, this.t1, "oh no, a duplicate!");
            }
            this.commit();
            this.query("q", "duplicate", "hl", "true", "hl.fl", this.t1);
            this.query("q", "fox duplicate horses", "hl", "true", "hl.fl", this.t1);
            this.query("q", "*:*", "rows", 100);
        }
    }

    protected void indexAbunchOfDocs() throws Exception {
        int i;
        this.indexr(this.id, 2, this.i1, 50, this.tlong, 50, this.t1, "to come to the aid of their country.");
        this.indexr(this.id, 3, this.i1, 2, this.tlong, 2, this.t1, "how now brown cow");
        this.indexr(this.id, 4, this.i1, -100, this.tlong, 101, this.t1, "the quick fox jumped over the lazy dog");
        this.indexr(this.id, 5, this.i1, 500, this.tlong, 500, this.t1, "the quick fox jumped way over the lazy dog");
        this.indexr(this.id, 6, this.i1, -600, this.tlong, 600, this.t1, "humpty dumpy sat on a wall");
        this.indexr(this.id, 7, this.i1, 123, this.tlong, 123, this.t1, "humpty dumpy had a great fall");
        this.indexr(this.id, 8, this.i1, 876, this.tlong, 876, this.t1, "all the kings horses and all the kings men");
        this.indexr(this.id, 9, this.i1, 7, this.tlong, 7, this.t1, "couldn't put humpty together again");
        this.indexr(this.id, 10, this.i1, 4321, this.tlong, 4321, this.t1, "this too shall pass");
        this.indexr(this.id, 11, this.i1, -987, this.tlong, 987, this.t1, "An eye for eye only ends up making the whole world blind.");
        this.indexr(this.id, 12, this.i1, 379, this.tlong, 379, this.t1, "Great works are performed, not by strength, but by perseverance.");
        this.indexr(this.id, 13, this.i1, 232, this.tlong, 232, this.t1, "no eggs on wall, lesson learned", this.oddField, "odd man out");
        this.indexr(this.id, 14, "SubjectTerms_mfacet", new String[]{"mathematical models", "mathematical analysis"});
        this.indexr(this.id, 15, "SubjectTerms_mfacet", new String[]{"test 1", "test 2", "test3"});
        this.indexr(this.id, 16, "SubjectTerms_mfacet", new String[]{"test 1", "test 2", "test3"});
        String[] vals = new String[100];
        for (i = 0; i < 100; ++i) {
            vals[i] = "test " + i;
        }
        this.indexr(this.id, 17, "SubjectTerms_mfacet", vals);
        for (i = 100; i < 150; ++i) {
            this.indexr(this.id, i);
        }
    }

    protected void checkShardConsistency(String shard) throws Exception {
        this.checkShardConsistency(shard, false);
    }

    protected String checkShardConsistency(String shard, boolean verbose) throws Exception {
        List<CloudJettyRunner> solrJetties = this.shardToJetty.get(shard);
        if (solrJetties == null) {
            throw new RuntimeException("shard not found:" + shard + " keys:" + this.shardToJetty.keySet());
        }
        long num = -1L;
        long lastNum = -1L;
        String failMessage = null;
        if (verbose) {
            System.err.println("check const of " + shard);
        }
        int cnt = 0;
        AbstractFullDistribZkTestBase.assertEquals((String)("The client count does not match up with the shard count for slice:" + shard), (long)this.zkStateReader.getClusterState().getSlice("collection1", shard).getReplicasMap().size(), (long)solrJetties.size());
        CloudJettyRunner lastJetty = null;
        for (CloudJettyRunner cjetty : solrJetties) {
            boolean active;
            ZkNodeProps props = cjetty.info;
            if (verbose) {
                System.err.println("client" + cnt++);
            }
            if (verbose) {
                System.err.println("PROPS:" + props);
            }
            try {
                SolrQuery query = new SolrQuery("*:*");
                query.set("distrib", false);
                num = cjetty.client.solrClient.query((SolrParams)query).getResults().getNumFound();
            }
            catch (SolrServerException e) {
                if (!verbose) continue;
                System.err.println("error contacting client: " + e.getMessage() + "\n");
                continue;
            }
            catch (SolrException e) {
                if (!verbose) continue;
                System.err.println("error contacting client: " + e.getMessage() + "\n");
                continue;
            }
            boolean live = false;
            String nodeName = props.getStr("node_name");
            if (this.zkStateReader.getClusterState().liveNodesContain(nodeName)) {
                live = true;
            }
            if (verbose) {
                System.err.println(" live:" + live);
            }
            if (verbose) {
                System.err.println(" num:" + num + "\n");
            }
            if (!(active = props.getStr("state").equals("active")) || !live) continue;
            if (lastNum > -1L && lastNum != num && failMessage == null) {
                failMessage = shard + " is not consistent.  Got " + lastNum + " from " + lastJetty.url + "lastClient" + " and got " + num + " from " + cjetty.url;
                if (!verbose) {
                    // empty if block
                }
                System.err.println("######" + failMessage);
                SolrQuery query = new SolrQuery("*:*");
                query.set("distrib", false);
                query.set("fl", new String[]{"id,_version_"});
                query.set("rows", new String[]{"1000"});
                query.set("sort", new String[]{"id asc"});
                SolrDocumentList lst1 = lastJetty.client.solrClient.query((SolrParams)query).getResults();
                SolrDocumentList lst2 = cjetty.client.solrClient.query((SolrParams)query).getResults();
                this.showDiff(lst1, lst2, lastJetty.url, cjetty.url);
            }
            lastNum = num;
            lastJetty = cjetty;
        }
        return failMessage;
    }

    void showDiff(SolrDocumentList a, SolrDocumentList b, String aName, String bName) {
        System.err.println("######" + aName + ": " + a);
        System.err.println("######" + bName + ": " + b);
        System.err.println("###### sizes=" + a.size() + "," + b.size());
        HashSet setA = new HashSet();
        for (SolrDocument sdoc : a) {
            setA.add(new HashMap(sdoc));
        }
        HashSet setB = new HashSet();
        for (SolrDocument sdoc : b) {
            setB.add(new HashMap(sdoc));
        }
        HashSet onlyInA = new HashSet(setA);
        onlyInA.removeAll(setB);
        HashSet onlyInB = new HashSet(setB);
        onlyInB.removeAll(setA);
        if (onlyInA.size() > 0) {
            System.err.println("###### Only in " + aName + ": " + onlyInA);
        }
        if (onlyInB.size() > 0) {
            System.err.println("###### Only in " + bName + ": " + onlyInB);
        }
    }

    protected void checkShardConsistency() throws Exception {
        this.checkShardConsistency(true, false);
    }

    protected void checkShardConsistency(boolean checkVsControl, boolean verbose) throws Exception {
        long docs = this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        if (verbose) {
            System.err.println("Control Docs:" + docs);
        }
        this.updateMappingsFromZk(this.jettys, this.clients);
        Set<String> theShards = this.shardToJetty.keySet();
        String failMessage = null;
        for (String shard : theShards) {
            String shardFailMessage = this.checkShardConsistency(shard, verbose);
            if (shardFailMessage == null || failMessage != null) continue;
            failMessage = shardFailMessage;
        }
        if (failMessage != null) {
            AbstractFullDistribZkTestBase.fail(failMessage);
        }
        if (checkVsControl) {
            theShards = this.shardToJetty.keySet();
            int cnt = 0;
            block3: for (String s : theShards) {
                int times = this.shardToJetty.get(s).size();
                for (int i = 0; i < times; ++i) {
                    try {
                        CloudJettyRunner cjetty = this.shardToJetty.get(s).get(i);
                        ZkNodeProps props = cjetty.info;
                        SolrServer client = cjetty.client.solrClient;
                        boolean active = props.getStr("state").equals("active");
                        if (!active) continue;
                        SolrQuery query = new SolrQuery("*:*");
                        query.set("distrib", false);
                        long results = client.query((SolrParams)query).getResults().getNumFound();
                        if (verbose) {
                            System.err.println(new ZkCoreNodeProps(props).getCoreUrl() + " : " + results);
                        }
                        if (verbose) {
                            System.err.println("shard:" + props.getStr("shard"));
                        }
                        cnt = (int)((long)cnt + results);
                        continue block3;
                    }
                    catch (Exception e) {
                        if (i != times - 1) continue;
                        throw e;
                    }
                }
            }
            SolrQuery q = new SolrQuery("*:*");
            long cloudClientDocs = this.cloudClient.query((SolrParams)q).getResults().getNumFound();
            AbstractFullDistribZkTestBase.assertEquals((String)("adding up the # of docs on each shard does not match the control - cloud client returns:" + cloudClientDocs), (long)docs, (long)cnt);
        }
    }

    protected SolrServer getClient(String nodeName) {
        for (CloudJettyRunner cjetty : this.cloudJettys) {
            CloudSolrServerClient client = cjetty.client;
            if (!client.shardName.equals(nodeName)) continue;
            return client.solrClient;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertDocCounts(boolean verbose) throws Exception {
        ClusterState clusterState;
        if (verbose) {
            System.err.println("control docs:" + this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound() + "\n\n");
        }
        long controlCount = this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        ZkStateReader zk = new ZkStateReader(this.zkServer.getZkAddress(), 10000, 10000);
        Map slices = null;
        try {
            zk.createClusterStateWatchersAndUpdate();
            clusterState = zk.getClusterState();
            slices = clusterState.getSlices("collection1");
        }
        finally {
            zk.close();
        }
        if (slices == null) {
            throw new RuntimeException("Could not find collection collection1 in " + clusterState.getCollections());
        }
        for (CloudJettyRunner cjetty : this.cloudJettys) {
            CloudSolrServerClient client = cjetty.client;
            for (Map.Entry slice : slices.entrySet()) {
                Map theShards = ((Slice)slice.getValue()).getReplicasMap();
                for (Map.Entry shard : theShards.entrySet()) {
                    String shardName = new URI(((HttpSolrServer)client.solrClient).getBaseURL()).getPort() + "_solr_";
                    if (!verbose || !((String)shard.getKey()).endsWith(shardName)) continue;
                    System.err.println("shard:" + (String)slice.getKey());
                    System.err.println(shard.getValue());
                }
            }
            long count = 0L;
            String currentState = cjetty.info.getStr("state");
            if (currentState != null && currentState.equals("active") && this.zkStateReader.getClusterState().liveNodesContain(cjetty.info.getStr("node_name"))) {
                SolrQuery query = new SolrQuery("*:*");
                query.set("distrib", false);
                count = client.solrClient.query((SolrParams)query).getResults().getNumFound();
            }
            if (!verbose) continue;
            System.err.println("client docs:" + count + "\n\n");
        }
        if (verbose) {
            System.err.println("control docs:" + this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound() + "\n\n");
        }
        SolrQuery query = new SolrQuery("*:*");
        AbstractFullDistribZkTestBase.assertEquals((String)"Doc Counts do not add up", (long)controlCount, (long)this.cloudClient.query((SolrParams)query).getResults().getNumFound());
    }

    @Override
    protected QueryResponse queryServer(ModifiableSolrParams params) throws SolrServerException {
        if (r.nextBoolean()) {
            params.set("collection", new String[]{"collection1"});
        }
        QueryResponse rsp = this.cloudClient.query((SolrParams)params);
        return rsp;
    }

    public void waitForThingsToLevelOut(int waitForRecTimeSeconds) throws Exception {
        log.info("Wait for recoveries to finish - wait " + waitForRecTimeSeconds + " for each attempt");
        int cnt = 0;
        boolean retry = false;
        do {
            this.waitForRecoveriesToFinish(VERBOSE, waitForRecTimeSeconds);
            try {
                this.commit();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.updateMappingsFromZk(this.jettys, this.clients);
            Set<String> theShards = this.shardToJetty.keySet();
            String failMessage = null;
            for (String shard : theShards) {
                failMessage = this.checkShardConsistency(shard, false);
            }
            if (failMessage != null) {
                retry = true;
            }
            if (++cnt > 4) break;
            Thread.sleep(2000L);
        } while (retry);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (VERBOSE || this.printLayoutOnTearDown) {
            super.printLayout();
        }
        ((HttpSolrServer)this.controlClient).shutdown();
        if (this.cloudClient != null) {
            this.cloudClient.shutdown();
        }
        if (this.zkStateReader != null) {
            this.zkStateReader.close();
        }
        super.tearDown();
        System.clearProperty("zkHost");
        System.clearProperty("numShards");
    }

    @Override
    protected void commit() throws Exception {
        this.controlClient.commit();
        this.cloudClient.commit();
    }

    @Override
    protected void destroyServers() throws Exception {
        ChaosMonkey.stop(this.controlJetty);
        for (JettySolrRunner jetty : this.jettys) {
            try {
                ChaosMonkey.stop(jetty);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        this.clients.clear();
        this.jettys.clear();
    }

    @Override
    protected SolrServer createNewSolrServer(int port) {
        try {
            String url = "http://127.0.0.1:" + port + this.context + "/" + "collection1";
            HttpSolrServer s = new HttpSolrServer(url);
            s.setConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT);
            s.setSoTimeout(40000);
            s.setDefaultMaxConnectionsPerHost(100);
            s.setMaxTotalConnections(100);
            return s;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void waitToSeeNotLive(ZkStateReader zkStateReader, CloudJettyRunner cjetty) throws InterruptedException {
        int tries = 0;
        while (zkStateReader.getClusterState().liveNodesContain(cjetty.info.getStr("node_name"))) {
            if (tries++ == 220) {
                AbstractFullDistribZkTestBase.fail((String)"Shard still reported as live in zk");
            }
            Thread.sleep(1000L);
        }
    }

    class StopableSearchThread
    extends StopableThread {
        private volatile boolean stop;
        protected final AtomicInteger fails;
        private String[] QUERIES;

        public StopableSearchThread() {
            super("StopableSearchThread");
            this.stop = false;
            this.fails = new AtomicInteger();
            this.QUERIES = new String[]{"to come", "their country", "aid", "co*"};
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Random random = LuceneTestCase.random();
            int numSearches = 0;
            while (!this.stop) {
                ++numSearches;
                try {
                    AbstractFullDistribZkTestBase.this.cloudClient.query((SolrParams)new SolrQuery(this.QUERIES[random.nextInt(this.QUERIES.length)]));
                }
                catch (Exception e) {
                    System.err.println("QUERY REQUEST FAILED:");
                    e.printStackTrace();
                    if (e instanceof SolrServerException) {
                        System.err.println("ROOT CAUSE:");
                        ((SolrServerException)((Object)e)).getRootCause().printStackTrace();
                    }
                    this.fails.incrementAndGet();
                }
                try {
                    Thread.sleep(random.nextInt(4000) + 300);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            System.err.println("num searches done:" + numSearches + " with " + this.fails + " fails");
        }

        @Override
        public void safeStop() {
            this.stop = true;
        }

        public int getFails() {
            return this.fails.get();
        }
    }

    class StopableIndexingThread
    extends StopableThread {
        private volatile boolean stop;
        protected final int startI;
        protected final List<Integer> deletes;
        protected final AtomicInteger fails;
        protected boolean doDeletes;

        public StopableIndexingThread(int startI, boolean doDeletes) {
            super("StopableIndexingThread");
            this.stop = false;
            this.deletes = new ArrayList<Integer>();
            this.fails = new AtomicInteger();
            this.startI = startI;
            this.doDeletes = doDeletes;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            int i = this.startI;
            int numDeletes = 0;
            int numAdds = 0;
            while (!this.stop) {
                ++i;
                if (this.doDeletes && LuceneTestCase.random().nextBoolean() && this.deletes.size() > 0) {
                    Integer delete = this.deletes.remove(0);
                    try {
                        ++numDeletes;
                        AbstractFullDistribZkTestBase.this.controlClient.deleteById(Integer.toString(delete));
                        AbstractFullDistribZkTestBase.this.cloudClient.deleteById(Integer.toString(delete));
                    }
                    catch (Exception e) {
                        System.err.println("REQUEST FAILED:");
                        e.printStackTrace();
                        if (e instanceof SolrServerException) {
                            System.err.println("ROOT CAUSE:");
                            ((SolrServerException)((Object)e)).getRootCause().printStackTrace();
                        }
                        this.fails.incrementAndGet();
                    }
                }
                try {
                    ++numAdds;
                    AbstractFullDistribZkTestBase.this.indexr(new Object[]{AbstractFullDistribZkTestBase.this.id, i, AbstractFullDistribZkTestBase.this.i1, 50, AbstractFullDistribZkTestBase.this.tlong, 50, AbstractFullDistribZkTestBase.this.t1, "to come to the aid of their country."});
                }
                catch (Exception e) {
                    System.err.println("REQUEST FAILED:");
                    e.printStackTrace();
                    if (e instanceof SolrServerException) {
                        System.err.println("ROOT CAUSE:");
                        ((SolrServerException)((Object)e)).getRootCause().printStackTrace();
                    }
                    this.fails.incrementAndGet();
                }
                if (!this.doDeletes || !LuceneTestCase.random().nextBoolean()) continue;
                this.deletes.add(i);
            }
            System.err.println("added docs:" + numAdds + " with " + this.fails + " fails" + " deletes:" + numDeletes);
        }

        @Override
        public void safeStop() {
            this.stop = true;
        }

        public int getFails() {
            return this.fails.get();
        }
    }

    abstract class StopableThread
    extends Thread {
        public StopableThread(String name) {
            super(name);
        }

        public abstract void safeStop();
    }

    static class CloudSolrServerClient {
        SolrServer solrClient;
        String shardName;
        int port;
        public ZkNodeProps info;

        public CloudSolrServerClient() {
        }

        public CloudSolrServerClient(SolrServer client) {
            this.solrClient = client;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.solrClient == null ? 0 : this.solrClient.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CloudSolrServerClient other = (CloudSolrServerClient)obj;
            return !(this.solrClient == null ? other.solrClient != null : !this.solrClient.equals(other.solrClient));
        }
    }

    public static class CloudJettyRunner {
        public JettySolrRunner jetty;
        public String nodeName;
        public String coreNodeName;
        public String url;
        public CloudSolrServerClient client;
        public ZkNodeProps info;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CloudJettyRunner other = (CloudJettyRunner)obj;
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }
    }
}

