/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.util.HashMap;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.zookeeper.CreateMode;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZkTestCase
extends SolrTestCaseJ4 {
    static final int TIMEOUT = 10000;
    private static final boolean DEBUG = false;
    protected static Logger log = LoggerFactory.getLogger(AbstractZkTestCase.class);
    public static File SOLRHOME;
    protected static ZkTestServer zkServer;
    protected static String zkDir;

    @BeforeClass
    public static void azt_beforeClass() throws Exception {
        System.out.println("azt beforeclass");
        AbstractZkTestCase.createTempDir();
        zkDir = dataDir.getAbsolutePath() + File.separator + "zookeeper/server1/data";
        zkServer = new ZkTestServer(zkDir);
        zkServer.run();
        System.setProperty("solrcloud.skip.autorecovery", "true");
        System.setProperty("zkHost", zkServer.getZkAddress());
        System.setProperty("jetty.port", "0000");
        AbstractZkTestCase.buildZooKeeper(zkServer.getZkHost(), zkServer.getZkAddress(), SOLRHOME, "solrconfig.xml", "schema.xml");
        AbstractZkTestCase.initCore("solrconfig.xml", "schema.xml");
    }

    static void buildZooKeeper(String zkHost, String zkAddress, String config, String schema) throws Exception {
        AbstractZkTestCase.buildZooKeeper(zkHost, zkAddress, SOLRHOME, config, schema);
    }

    static void buildZooKeeper(String zkHost, String zkAddress, File solrhome, String config, String schema) throws Exception {
        SolrZkClient zkClient = new SolrZkClient(zkHost, 10000);
        zkClient.makePath("/solr", false, true);
        zkClient.close();
        zkClient = new SolrZkClient(zkAddress, 10000);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("configName", "conf1");
        ZkNodeProps zkProps = new ZkNodeProps(props);
        zkClient.makePath("/collections/collection1", ZkStateReader.toJSON((Object)zkProps), CreateMode.PERSISTENT, true);
        zkClient.makePath("/collections/collection1/shards", CreateMode.PERSISTENT, true);
        zkClient.makePath("/collections/control_collection", ZkStateReader.toJSON((Object)zkProps), CreateMode.PERSISTENT, true);
        zkClient.makePath("/collections/control_collection/shards", CreateMode.PERSISTENT, true);
        AbstractZkTestCase.putConfig(zkClient, solrhome, config);
        AbstractZkTestCase.putConfig(zkClient, solrhome, schema);
        AbstractZkTestCase.putConfig(zkClient, solrhome, "solrconfig.xml");
        AbstractZkTestCase.putConfig(zkClient, solrhome, "stopwords.txt");
        AbstractZkTestCase.putConfig(zkClient, solrhome, "protwords.txt");
        AbstractZkTestCase.putConfig(zkClient, solrhome, "currency.xml");
        AbstractZkTestCase.putConfig(zkClient, solrhome, "open-exchange-rates.json");
        AbstractZkTestCase.putConfig(zkClient, solrhome, "mapping-ISOLatin1Accent.txt");
        AbstractZkTestCase.putConfig(zkClient, solrhome, "old_synonyms.txt");
        AbstractZkTestCase.putConfig(zkClient, solrhome, "synonyms.txt");
        zkClient.close();
    }

    private static void putConfig(SolrZkClient zkClient, File solrhome, String name) throws Exception {
        String path = "/configs/conf1/" + name;
        File file = new File(solrhome, "collection1" + File.separator + "conf" + File.separator + name);
        if (!file.exists()) {
            log.info("skipping " + file.getAbsolutePath() + " because it doesn't exist");
            return;
        }
        log.info("put " + file.getAbsolutePath() + " to " + path);
        zkClient.makePath(path, file, false, true);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @AfterClass
    public static void azt_afterClass() throws Exception {
        System.clearProperty("zkHost");
        System.clearProperty("solr.test.sys.prop1");
        System.clearProperty("solr.test.sys.prop2");
        System.clearProperty("solrcloud.skip.autorecovery");
        System.clearProperty("jetty.port");
        zkServer.shutdown();
        Thread.sleep(2000L);
    }

    protected void printLayout(String zkHost) throws Exception {
        SolrZkClient zkClient = new SolrZkClient(zkHost, 10000);
        zkClient.printLayoutToStdOut();
        zkClient.close();
    }

    public static void makeSolrZkNode(String zkHost) throws Exception {
        SolrZkClient zkClient = new SolrZkClient(zkHost, 10000);
        zkClient.makePath("/solr", false, true);
        zkClient.close();
    }

    public static void tryCleanSolrZkNode(String zkHost) throws Exception {
        AbstractZkTestCase.tryCleanPath(zkHost, "/solr");
    }

    static void tryCleanPath(String zkHost, String path) throws Exception {
        SolrZkClient zkClient = new SolrZkClient(zkHost, 10000);
        if (zkClient.exists(path, true).booleanValue()) {
            zkClient.clean(path);
        }
        zkClient.close();
    }

    static {
        try {
            SOLRHOME = new File(AbstractZkTestCase.TEST_HOME());
        }
        catch (RuntimeException e) {
            log.warn("TEST_HOME() does not exist - solrj test?");
        }
    }
}

