/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.core.CachingDirectoryFactory;

public class MockDirectoryFactory
extends CachingDirectoryFactory {
    protected Directory create(String path) throws IOException {
        BaseDirectoryWrapper dir = LuceneTestCase.newDirectory();
        if (dir instanceof MockDirectoryWrapper) {
            ((MockDirectoryWrapper)dir).setAssertNoUnrefencedFilesOnClose(false);
        }
        return dir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists(String path) {
        String fullPath = new File(path).getAbsolutePath();
        MockDirectoryFactory mockDirectoryFactory = this;
        synchronized (mockDirectoryFactory) {
            CachingDirectoryFactory.CacheValue cacheValue = (CachingDirectoryFactory.CacheValue)this.byPathCache.get(fullPath);
            Directory directory = null;
            if (cacheValue != null) {
                directory = cacheValue.directory;
            }
            return directory != null;
            {
            }
        }
    }
}

