/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.solr.BaseDistributedSearchTestCase;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.cloud.AbstractZkTestCase;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.Diagnostics;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class AbstractDistribZkTestBase
extends BaseDistributedSearchTestCase {
    protected static final String DEFAULT_COLLECTION = "collection1";
    private static final boolean DEBUG = false;
    protected ZkTestServer zkServer;
    private AtomicInteger homeCount = new AtomicInteger();

    @BeforeClass
    public static void beforeThisClass() throws Exception {
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        AbstractDistribZkTestBase.createTempDir();
        String zkDir = this.testDir.getAbsolutePath() + File.separator + "zookeeper/server1/data";
        this.zkServer = new ZkTestServer(zkDir);
        this.zkServer.run();
        System.setProperty("zkHost", this.zkServer.getZkAddress());
        System.setProperty("enable.update.log", "true");
        System.setProperty("remove.version.field", "true");
        String schema = AbstractDistribZkTestBase.getSchemaFile();
        if (schema == null) {
            schema = "schema.xml";
        }
        AbstractZkTestCase.buildZooKeeper(this.zkServer.getZkHost(), this.zkServer.getZkAddress(), "solrconfig.xml", schema);
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
    }

    @Override
    protected void createServers(int numShards) throws Exception {
        int i;
        File controlHome = new File(new File(this.getSolrHome()).getParentFile(), "control" + this.homeCount.incrementAndGet());
        FileUtils.copyDirectory((File)new File(this.getSolrHome()), (File)controlHome);
        System.setProperty("collection", "control_collection");
        String numShardsS = System.getProperty("numShards");
        System.setProperty("numShards", "1");
        this.controlJetty = this.createJetty(controlHome, null);
        System.clearProperty("collection");
        if (numShardsS != null) {
            System.setProperty("numShards", numShardsS);
        } else {
            System.clearProperty("numShards");
        }
        this.controlClient = this.createNewSolrServer(this.controlJetty.getLocalPort());
        StringBuilder sb = new StringBuilder();
        for (i = 1; i <= numShards; ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            File jettyHome = new File(new File(this.getSolrHome()).getParentFile(), "jetty" + this.homeCount.incrementAndGet());
            FileUtils.copyDirectory((File)new File(this.getSolrHome()), (File)jettyHome);
            JettySolrRunner j = this.createJetty(jettyHome, null, "shard" + (i + 2));
            this.jettys.add(j);
            this.clients.add(this.createNewSolrServer(j.getLocalPort()));
            sb.append("127.0.0.1:").append(j.getLocalPort()).append(this.context);
        }
        this.shards = sb.toString();
        for (i = 1; i <= numShards; ++i) {
            ZkStateReader zkStateReader = ((SolrDispatchFilter)((JettySolrRunner)this.jettys.get(0)).getDispatchFilter().getFilter()).getCores().getZkController().getZkStateReader();
            zkStateReader.getLeaderRetry(DEFAULT_COLLECTION, "shard" + (i + 2), 15000);
        }
    }

    protected void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose) throws Exception {
        this.waitForRecoveriesToFinish(collection, zkStateReader, verbose, true);
    }

    protected void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose, boolean failOnTimeout) throws Exception {
        this.waitForRecoveriesToFinish(collection, zkStateReader, verbose, failOnTimeout, 230);
    }

    protected void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose, boolean failOnTimeout, int timeoutSeconds) throws Exception {
        log.info("Wait for recoveries to finish - collection: " + collection + " failOnTimeout:" + failOnTimeout + " timeout (sec):" + timeoutSeconds);
        boolean cont = true;
        int cnt = 0;
        while (cont) {
            if (verbose) {
                System.out.println("-");
            }
            boolean sawLiveRecovering = false;
            zkStateReader.updateClusterState(true);
            ClusterState clusterState = zkStateReader.getClusterState();
            Map slices = clusterState.getSlicesMap(collection);
            AbstractDistribZkTestBase.assertNotNull((String)("Could not find collection:" + collection), (Object)slices);
            for (Map.Entry entry : slices.entrySet()) {
                Map shards = ((Slice)entry.getValue()).getReplicasMap();
                for (Map.Entry shard : shards.entrySet()) {
                    String state;
                    if (verbose) {
                        System.out.println("rstate:" + ((Replica)shard.getValue()).getStr("state") + " live:" + clusterState.liveNodesContain(((Replica)shard.getValue()).getStr("node_name")));
                    }
                    if (!(state = ((Replica)shard.getValue()).getStr("state")).equals("recovering") && !state.equals("sync") && !state.equals("down") || !clusterState.liveNodesContain(((Replica)shard.getValue()).getStr("node_name"))) continue;
                    sawLiveRecovering = true;
                }
            }
            if (!sawLiveRecovering || cnt == timeoutSeconds) {
                if (!sawLiveRecovering) {
                    if (verbose) {
                        System.out.println("no one is recoverying");
                    }
                } else {
                    if (verbose) {
                        System.out.println("Gave up waiting for recovery to finish..");
                    }
                    if (failOnTimeout) {
                        Diagnostics.logThreadDumps((String)"Gave up waiting for recovery to finish.  THREAD DUMP:");
                        this.printLayout();
                        AbstractDistribZkTestBase.fail((String)("There are still nodes recoverying - waited for " + timeoutSeconds + " seconds"));
                        return;
                    }
                }
                cont = false;
            } else {
                Thread.sleep(1000L);
            }
            ++cnt;
        }
        log.info("Recoveries finished - collection: " + collection);
    }

    protected void assertAllActive(String collection, ZkStateReader zkStateReader) throws KeeperException, InterruptedException {
        zkStateReader.updateClusterState(true);
        ClusterState clusterState = zkStateReader.getClusterState();
        Map slices = clusterState.getSlicesMap(collection);
        if (slices == null) {
            throw new IllegalArgumentException("Cannot find collection:" + collection);
        }
        for (Map.Entry entry : slices.entrySet()) {
            Map shards = ((Slice)entry.getValue()).getReplicasMap();
            for (Map.Entry shard : shards.entrySet()) {
                String state = ((Replica)shard.getValue()).getStr("state");
                if (state.equals("active")) continue;
                AbstractDistribZkTestBase.fail((String)("Not all shards are ACTIVE - found a shard that is: " + state));
            }
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.zkServer.shutdown();
        System.clearProperty("zkHost");
        System.clearProperty("collection");
        System.clearProperty("enable.update.log");
        System.clearProperty("remove.version.field");
        System.clearProperty("solr.directoryFactory");
        System.clearProperty("solr.test.sys.prop1");
        System.clearProperty("solr.test.sys.prop2");
        AbstractDistribZkTestBase.resetExceptionIgnores();
        super.tearDown();
    }

    protected void printLayout() throws Exception {
        SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkHost(), 10000);
        zkClient.printLayoutToStdOut();
        zkClient.close();
    }
}

