/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.UpdateRequestHandler;
import org.apache.solr.logging.ListenerConfig;
import org.apache.solr.logging.LogWatcher;
import org.apache.solr.logging.jul.JulWatcher;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.servlet.DirectSolrConnection;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestHarness {
    String coreName;
    protected volatile CoreContainer container;
    private final ThreadLocal<DocumentBuilder> builderTL = new ThreadLocal();
    private final ThreadLocal<XPath> xpathTL = new ThreadLocal();
    public UpdateRequestHandler updater;

    public static SolrConfig createConfig(String solrHome, String coreName, String confFile) {
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        try {
            return new SolrConfig(solrHome + File.separator + coreName, confFile, null);
        }
        catch (Exception xany) {
            throw new RuntimeException(xany);
        }
    }

    public static SolrConfig createConfig(String solrHome, String confFile) {
        return TestHarness.createConfig(solrHome, "collection1", confFile);
    }

    public TestHarness(String dataDirectory, SolrConfig solrConfig, String schemaFile) {
        this(dataDirectory, solrConfig, new IndexSchema(solrConfig, schemaFile, null));
    }

    public TestHarness(String dataDirectory, SolrConfig solrConfig, IndexSchema indexSchema) {
        this(null, new Initializer(null, dataDirectory, solrConfig, indexSchema));
    }

    public TestHarness(String coreName, CoreContainer.Initializer init) {
        try {
            this.container = init.initialize();
            if (coreName == null) {
                coreName = "collection1";
            }
            this.coreName = coreName;
            this.updater = new UpdateRequestHandler();
            this.updater.init(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DocumentBuilder getXmlDocumentBuilder() {
        try {
            DocumentBuilder builder = this.builderTL.get();
            if (builder == null) {
                builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                this.builderTL.set(builder);
            }
            return builder;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private XPath getXpath() {
        try {
            XPath xpath = this.xpathTL.get();
            if (xpath == null) {
                xpath = XPathFactory.newInstance().newXPath();
                this.xpathTL.set(xpath);
            }
            return xpath;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CoreContainer getCoreContainer() {
        return this.container;
    }

    public SolrCore getCore() {
        SolrCore core = this.container.getCore(this.coreName);
        if (core != null) {
            core.close();
        }
        return core;
    }

    public SolrCore getCoreInc() {
        return this.container.getCore(this.coreName);
    }

    public void reload() throws Exception {
        this.container.reload(this.coreName);
    }

    public String update(String xml) {
        SolrCore core = this.getCoreInc();
        DirectSolrConnection connection = new DirectSolrConnection(core);
        SolrRequestHandler handler = core.getRequestHandler("/update");
        if (handler == null) {
            handler = this.updater;
        }
        try {
            String string = connection.request(handler, null, xml);
            return string;
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
        }
        finally {
            core.close();
        }
    }

    public String validateUpdate(String xml) throws SAXException {
        return this.checkUpdateStatus(xml, "0");
    }

    public String validateErrorUpdate(String xml) throws SAXException {
        try {
            return this.checkUpdateStatus(xml, "1");
        }
        catch (SolrException e) {
            return null;
        }
    }

    public String checkUpdateStatus(String xml, String code) throws SAXException {
        try {
            String res = this.update(xml);
            String valid = this.validateXPath(res, "//int[@name='status']=" + code);
            return null == valid ? null : res;
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException("?!? static xpath has bug?", e);
        }
    }

    public String validateQuery(SolrQueryRequest req, String ... tests) throws Exception {
        String res = this.query(req);
        return this.validateXPath(res, tests);
    }

    public String query(SolrQueryRequest req) throws Exception {
        return this.query(req.getParams().get("qt"), req);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String query(String handler, SolrQueryRequest req) throws Exception {
        SolrCore core = this.getCoreInc();
        try {
            SolrQueryResponse rsp = new SolrQueryResponse();
            SolrRequestInfo.setRequestInfo((SolrRequestInfo)new SolrRequestInfo(req, rsp));
            core.execute(core.getRequestHandler(handler), req, rsp);
            if (rsp.getException() != null) {
                throw rsp.getException();
            }
            StringWriter sw = new StringWriter(32000);
            QueryResponseWriter responseWriter = core.getQueryResponseWriter(req);
            responseWriter.write((Writer)sw, req, rsp);
            req.close();
            String string = sw.toString();
            return string;
        }
        finally {
            req.close();
            SolrRequestInfo.clearRequestInfo();
            core.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrQueryResponse queryAndResponse(String handler, SolrQueryRequest req) throws Exception {
        SolrCore core = this.getCoreInc();
        try {
            SolrQueryResponse rsp = new SolrQueryResponse();
            core.execute(core.getRequestHandler(handler), req, rsp);
            if (rsp.getException() != null) {
                throw rsp.getException();
            }
            SolrQueryResponse solrQueryResponse = rsp;
            return solrQueryResponse;
        }
        finally {
            core.close();
        }
    }

    public String validateXPath(String xml, String ... tests) throws XPathExpressionException, SAXException {
        if (tests == null || tests.length == 0) {
            return null;
        }
        Document document = null;
        try {
            document = this.getXmlDocumentBuilder().parse(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e1) {
            throw new RuntimeException("Totally weird UTF-8 exception", e1);
        }
        catch (IOException e2) {
            throw new RuntimeException("Totally weird io exception", e2);
        }
        for (String xp : tests) {
            xp = xp.trim();
            Boolean bool = (Boolean)this.getXpath().evaluate(xp, document, XPathConstants.BOOLEAN);
            if (bool.booleanValue()) continue;
            return xp;
        }
        return null;
    }

    public void close() {
        if (this.container != null) {
            for (SolrCore c : this.container.getCores()) {
                if (c.getOpenCount() <= 1) continue;
                throw new RuntimeException("SolrCore.getOpenCount()==" + c.getOpenCount());
            }
        }
        if (this.container != null) {
            this.container.shutdown();
            this.container = null;
        }
    }

    public static StringBuffer makeSimpleDoc(String ... fieldsAndValues) {
        try {
            StringWriter w = new StringWriter();
            w.append("<doc>");
            for (int i = 0; i < fieldsAndValues.length; i += 2) {
                XML.writeXML((Writer)w, (String)"field", (String)fieldsAndValues[i + 1], (Object[])new Object[]{"name", fieldsAndValues[i]});
            }
            w.append("</doc>");
            return w.getBuffer();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String deleteByQuery(String q, String ... args) {
        try {
            StringWriter r = new StringWriter();
            XML.writeXML((Writer)r, (String)"query", (String)q);
            return TestHarness.delete(r.getBuffer().toString(), args);
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String deleteById(String id, String ... args) {
        try {
            StringWriter r = new StringWriter();
            XML.writeXML((Writer)r, (String)"id", (String)id);
            return TestHarness.delete(r.getBuffer().toString(), args);
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    private static String delete(String val, String ... args) {
        try {
            StringWriter r = new StringWriter();
            XML.writeUnescapedXML((Writer)r, (String)"delete", (String)val, (Object[])args);
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String optimize(String ... args) {
        return TestHarness.simpleTag("optimize", args);
    }

    private static String simpleTag(String tag, String ... args) {
        try {
            StringWriter r = new StringWriter();
            if (null == args || 0 == args.length) {
                XML.writeXML((Writer)r, (String)tag, null);
            } else {
                XML.writeXML((Writer)r, (String)tag, null, (Object[])args);
            }
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String commit(String ... args) {
        return TestHarness.simpleTag("commit", args);
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit) {
        LocalRequestFactory f = new LocalRequestFactory();
        f.qtype = qtype;
        f.start = start;
        f.limit = limit;
        return f;
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit, String ... args) {
        LocalRequestFactory f = this.getRequestFactory(qtype, start, limit);
        for (int i = 0; i < args.length; i += 2) {
            f.args.put(args[i], args[i + 1]);
        }
        return f;
    }

    public LocalRequestFactory getRequestFactory(String qtype, int start, int limit, Map<String, String> args) {
        LocalRequestFactory f = this.getRequestFactory(qtype, start, limit);
        f.args.putAll(args);
        return f;
    }

    public class LocalRequestFactory {
        public String qtype = null;
        public int start = 0;
        public int limit = 1000;
        public Map<String, String> args = new HashMap<String, String>();

        public LocalSolrQueryRequest makeRequest(String ... q) {
            if (q.length == 1) {
                return new LocalSolrQueryRequest(TestHarness.this.getCore(), q[0], this.qtype, this.start, this.limit, this.args);
            }
            if (q.length % 2 != 0) {
                throw new RuntimeException("The length of the string array (query arguments) needs to be even");
            }
            NamedList.NamedListEntry[] entries = new NamedList.NamedListEntry[q.length / 2];
            for (int i = 0; i < q.length; i += 2) {
                entries[i / 2] = new NamedList.NamedListEntry(q[i], (Object)q[i + 1]);
            }
            return new LocalSolrQueryRequest(TestHarness.this.getCore(), new NamedList((Map.Entry[])entries));
        }
    }

    static class Initializer
    extends CoreContainer.Initializer {
        String coreName;
        String dataDirectory;
        SolrConfig solrConfig;
        IndexSchema indexSchema;

        public Initializer(String coreName, String dataDirectory, SolrConfig solrConfig, IndexSchema indexSchema) {
            if (coreName == null) {
                coreName = "collection1";
            }
            this.coreName = coreName;
            this.dataDirectory = dataDirectory;
            this.solrConfig = solrConfig;
            this.indexSchema = indexSchema;
        }

        public String getCoreName() {
            return this.coreName;
        }

        public CoreContainer initialize() {
            CoreContainer container = new CoreContainer(new SolrResourceLoader(SolrResourceLoader.locateSolrHome())){
                {
                    this.hostPort = System.getProperty("hostPort");
                    this.hostContext = "solr";
                    this.defaultCoreName = "collection1";
                    this.initShardHandler(null);
                    this.initZooKeeper(System.getProperty("zkHost"), 10000);
                }
            };
            JulWatcher logging = new JulWatcher("test");
            logging.registerListener(new ListenerConfig(), container);
            container.setLogging((LogWatcher)logging);
            CoreDescriptor dcore = new CoreDescriptor(container, this.coreName, this.solrConfig.getResourceLoader().getInstanceDir());
            dcore.setConfigName(this.solrConfig.getResourceName());
            dcore.setSchemaName(this.indexSchema.getResourceName());
            SolrCore core = new SolrCore(this.coreName, this.dataDirectory, this.solrConfig, this.indexSchema, dcore);
            container.register(this.coreName, core, false);
            if (container.getZkController() == null && core.getUpdateHandler().getUpdateLog() != null) {
                core.getUpdateHandler().getUpdateLog().recoverFromLog();
            }
            return container;
        }
    }
}

