/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.store.BaseDirectoryWrapper;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MockDirectoryWrapper;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.store.RateLimitedDirectoryWrapper;
import org.apache.lucene.store.TrackingDirectoryWrapper;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.StandardDirectoryFactory;

public class MockFSDirectoryFactory
extends StandardDirectoryFactory {
    public Directory create(String path, DirectoryFactory.DirContext dirContext) throws IOException {
        BaseDirectoryWrapper dir = LuceneTestCase.newFSDirectory((File)new File(path));
        Directory cdir = this.reduce((Directory)dir);
        cdir = this.reduce(cdir);
        if ((cdir = this.reduce(cdir)) instanceof MockDirectoryWrapper) {
            ((MockDirectoryWrapper)cdir).setAssertNoUnrefencedFilesOnClose(false);
            ((MockDirectoryWrapper)cdir).setPreventDoubleWrite(false);
            ((MockDirectoryWrapper)cdir).setEnableVirusScanner(false);
        }
        return dir;
    }

    public boolean isAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    private Directory reduce(Directory dir) {
        Directory cdir = dir;
        if (dir instanceof NRTCachingDirectory) {
            cdir = ((NRTCachingDirectory)dir).getDelegate();
        }
        if (cdir instanceof RateLimitedDirectoryWrapper) {
            cdir = ((RateLimitedDirectoryWrapper)dir).getDelegate();
        }
        if (cdir instanceof TrackingDirectoryWrapper) {
            cdir = ((TrackingDirectoryWrapper)dir).getDelegate();
        }
        return cdir;
    }
}

