/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.commons.io.FileUtils;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.util.ExternalPaths;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrJettyTestBase
extends SolrTestCaseJ4 {
    private static Logger log = LoggerFactory.getLogger(SolrJettyTestBase.class);
    private static boolean manageSslProps = true;
    private static File TEST_KEYSTORE;
    private static final Map<String, String> SSL_PROPS;
    public static JettySolrRunner jetty;
    public static int port;
    public static SolrServer server;
    public static String context;

    public String getSolrHome() {
        return ExternalPaths.EXAMPLE_HOME;
    }

    protected static File getExampleKeystoreFile() {
        return TEST_KEYSTORE;
    }

    @BeforeClass
    public static void beforeSolrJettyTestBase() throws Exception {
        boolean trySsl = SolrJettyTestBase.random().nextBoolean();
        boolean trySslClientAuth = SolrJettyTestBase.random().nextBoolean();
        if (null == SolrJettyTestBase.getExampleKeystoreFile()) {
            log.info("Solr's example keystore not defined (not a solr test?) skipping SSL randomization");
            manageSslProps = false;
            return;
        }
        SolrJettyTestBase.assertTrue((String)("test keystore does not exist, randomized ssl testing broken: " + SolrJettyTestBase.getExampleKeystoreFile().getAbsolutePath()), (boolean)SolrJettyTestBase.getExampleKeystoreFile().exists());
        Properties sysprops = System.getProperties();
        for (String prop : SSL_PROPS.keySet()) {
            if (!sysprops.containsKey(prop)) continue;
            log.info("System property explicitly set, so skipping randomized ssl properties: " + prop);
            manageSslProps = false;
            return;
        }
        if (manageSslProps) {
            log.info("Randomized ssl ({}) and clientAuth ({})", (Object)trySsl, (Object)trySslClientAuth);
            for (String prop : SSL_PROPS.keySet()) {
                System.setProperty(prop, SSL_PROPS.get(prop));
            }
            System.setProperty("tests.jettySsl", String.valueOf(trySsl));
            System.setProperty("tests.jettySsl.clientAuth", String.valueOf(trySslClientAuth));
        }
    }

    public static JettySolrRunner createJetty(String solrHome, String configFile, String schemaFile, String context, boolean stopAtShutdown, SortedMap<ServletHolder, String> extraServlets) throws Exception {
        SolrJettyTestBase.initCore(null, null, solrHome);
        SolrJettyTestBase.ignoreException("maxWarmingSearchers");
        System.setProperty("solr.data.dir", dataDir.getCanonicalPath());
        SolrJettyTestBase.context = context = context == null ? "/solr" : context;
        jetty = new JettySolrRunner(solrHome, context, 0, configFile, schemaFile, stopAtShutdown, extraServlets);
        jetty.start();
        port = jetty.getLocalPort();
        log.info("Jetty Assigned Port#" + port);
        return jetty;
    }

    public static JettySolrRunner createJetty(String solrHome, String configFile, String context) throws Exception {
        return SolrJettyTestBase.createJetty(solrHome, configFile, null, context, true, null);
    }

    @AfterClass
    public static void afterSolrJettyTestBase() throws Exception {
        if (jetty != null) {
            jetty.stop();
            jetty = null;
        }
        server = null;
        if (manageSslProps) {
            for (String prop : SSL_PROPS.keySet()) {
                System.clearProperty(prop);
            }
        }
    }

    public SolrServer getSolrServer() {
        if (server == null) {
            server = this.createNewSolrServer();
        }
        return server;
    }

    public SolrServer createNewSolrServer() {
        if (jetty != null) {
            try {
                String url = jetty.getBaseUrl().toString() + "/" + "collection1";
                HttpSolrServer s = new HttpSolrServer(url);
                s.setConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT);
                s.setDefaultMaxConnectionsPerHost(100);
                s.setMaxTotalConnections(100);
                return s;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return new EmbeddedSolrServer(h.getCoreContainer(), "");
    }

    public static void setupJettyTestHome(File solrHome, String collection) throws Exception {
        if (solrHome.exists()) {
            FileUtils.deleteDirectory((File)solrHome);
        }
        SolrJettyTestBase.copySolrHomeToTemp(solrHome, collection);
    }

    public static void cleanUpJettyHome(File solrHome) throws Exception {
        if (solrHome.exists()) {
            FileUtils.deleteDirectory((File)solrHome);
        }
    }

    static {
        SSL_PROPS = new HashMap<String, String>();
        TEST_KEYSTORE = null == ExternalPaths.SOURCE_HOME ? null : new File(ExternalPaths.SOURCE_HOME, "example/etc/solrtest.keystore");
        String keystorePath = null == TEST_KEYSTORE ? null : TEST_KEYSTORE.getAbsolutePath();
        SSL_PROPS.put("tests.jettySsl", "false");
        SSL_PROPS.put("tests.jettySsl.clientAuth", "false");
        SSL_PROPS.put("javax.net.ssl.keyStore", keystorePath);
        SSL_PROPS.put("javax.net.ssl.keyStorePassword", "secret");
        SSL_PROPS.put("javax.net.ssl.trustStore", keystorePath);
        SSL_PROPS.put("javax.net.ssl.trustStorePassword", "secret");
        server = null;
    }
}

