/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.CloudSolrServer;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.cloud.AbstractDistribZkTestBase;
import org.apache.solr.cloud.ChaosMonkey;
import org.apache.solr.cloud.OverseerCollectionProcessor;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.SolrResourceLoader;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneTestCase.Slow
public abstract class AbstractFullDistribZkTestBase
extends AbstractDistribZkTestBase {
    static Logger log = LoggerFactory.getLogger(AbstractFullDistribZkTestBase.class);
    public static final String SHARD1 = "shard1";
    public static final String SHARD2 = "shard2";
    protected boolean printLayoutOnTearDown = false;
    String t1 = "a_t";
    String i1 = "a_si";
    String nint = "n_i";
    String tint = "n_ti";
    String nfloat = "n_f";
    String tfloat = "n_tf";
    String ndouble = "n_d";
    String tdouble = "n_td";
    String nlong = "n_l";
    String tlong = "other_tl1";
    String ndate = "n_dt";
    String tdate = "n_tdt";
    String oddField = "oddField_s";
    String missingField = "ignore_exception__missing_but_valid_field_t";
    String invalidField = "ignore_exception__invalid_field_not_in_schema";
    protected int sliceCount;
    protected CloudSolrServer controlClientCloud;
    protected volatile CloudSolrServer cloudClient;
    protected List<CloudJettyRunner> cloudJettys = new ArrayList<CloudJettyRunner>();
    protected Map<String, List<CloudJettyRunner>> shardToJetty = new HashMap<String, List<CloudJettyRunner>>();
    private AtomicInteger jettyIntCntr = new AtomicInteger(0);
    protected ChaosMonkey chaosMonkey;
    protected Map<String, CloudJettyRunner> shardToLeaderJetty = new HashMap<String, CloudJettyRunner>();
    private boolean cloudInit;
    protected boolean checkCreatedVsState;
    protected boolean useJettyDataDir = true;
    volatile CloudSolrServer commondCloudSolrServer;

    @BeforeClass
    public static void beforeFullSolrCloudTest() {
        if (formatter != null) {
            formatter.setShorterFormat();
        }
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (this.sliceCount > 0) {
            System.setProperty("numShards", Integer.toString(this.sliceCount));
        } else {
            System.clearProperty("numShards");
        }
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("solrcloud.update.delay", "0");
    }

    @AfterClass
    public static void afterClass() {
        System.clearProperty("solrcloud.update.delay");
        System.clearProperty("genericCoreNodeNames");
    }

    public AbstractFullDistribZkTestBase() {
        this.fixShardCount = true;
        this.shardCount = 4;
        this.sliceCount = 2;
        this.stress = 0;
        this.useExplicitNodeNames = AbstractFullDistribZkTestBase.random().nextBoolean();
    }

    protected String getDataDir(String dataDir) throws IOException {
        return dataDir;
    }

    protected void initCloud() throws Exception {
        assert (!this.cloudInit);
        this.cloudInit = true;
        try {
            this.cloudClient = this.createCloudClient("collection1");
            this.cloudClient.connect();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        this.chaosMonkey = new ChaosMonkey(this.zkServer, zkStateReader, "collection1", this.shardToJetty, this.shardToLeaderJetty);
    }

    protected CloudSolrServer createCloudClient(String defaultCollection) throws MalformedURLException {
        CloudSolrServer server = new CloudSolrServer(this.zkServer.getZkAddress(), AbstractFullDistribZkTestBase.random().nextBoolean());
        server.setParallelUpdates(AbstractFullDistribZkTestBase.random().nextBoolean());
        if (defaultCollection != null) {
            server.setDefaultCollection(defaultCollection);
        }
        server.getLbServer().getHttpClient().getParams().setParameter("http.connection.timeout", (Object)5000);
        server.getLbServer().getHttpClient().getParams().setParameter("http.socket.timeout", (Object)30000);
        return server;
    }

    @Override
    protected void createServers(int numServers) throws Exception {
        System.setProperty("collection", "control_collection");
        String numShards = System.getProperty("numShards");
        System.setProperty("numShards", "1");
        File controlJettyDir = new File(TEMP_DIR, ((Object)((Object)this)).getClass().getName() + "-controljetty-" + System.currentTimeMillis());
        this.setupJettySolrHome(controlJettyDir);
        this.controlJetty = this.createJetty(controlJettyDir, this.testDir + "/control/data");
        System.clearProperty("collection");
        if (numShards != null) {
            System.setProperty("numShards", numShards);
        } else {
            System.clearProperty("numShards");
        }
        this.controlClient = this.createNewSolrServer(this.controlJetty.getLocalPort());
        if (this.sliceCount <= 0) {
            this.controlClientCloud = this.createCloudClient("control_collection");
            this.controlClientCloud.connect();
            this.waitForCollection(this.controlClientCloud.getZkStateReader(), "control_collection", 0);
            this.cloudClient = this.controlClientCloud;
            return;
        }
        this.initCloud();
        this.createJettys(numServers, this.checkCreatedVsState).size();
        int cnt = this.getTotalReplicas("collection1");
        if (cnt > 0) {
            this.waitForCollection(this.cloudClient.getZkStateReader(), "collection1", this.sliceCount);
        }
    }

    protected void waitForCollection(ZkStateReader reader, String collection, int slices) throws Exception {
        int cnt = 30;
        while (!reader.getClusterState().getCollections().contains(collection)) {
            if (cnt == 0) {
                throw new RuntimeException("timeout waiting for collection in cluster state: collection=" + collection);
            }
            --cnt;
            Thread.sleep(500L);
        }
        cnt = 30;
        while (reader.getClusterState().getSlices(collection).size() < slices) {
            if (cnt == 0) {
                throw new RuntimeException("timeout waiting for collection shards to come up: collection=" + collection + ", slices.expected=" + slices + " slices.actual= " + reader.getClusterState().getSlices(collection).size() + " slices : " + reader.getClusterState().getSlices(collection));
            }
            --cnt;
            Thread.sleep(500L);
        }
    }

    protected List<JettySolrRunner> createJettys(int numJettys) throws Exception {
        return this.createJettys(numJettys, false);
    }

    protected List<JettySolrRunner> createJettys(int numJettys, boolean checkCreatedVsState) throws Exception {
        ArrayList<JettySolrRunner> jettys = new ArrayList<JettySolrRunner>();
        ArrayList<SolrServer> clients = new ArrayList<SolrServer>();
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= numJettys; ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            int cnt = this.jettyIntCntr.incrementAndGet();
            File jettyDir = new File(TEMP_DIR, ((Object)((Object)this)).getClass().getName() + "-jetty" + cnt + "-" + System.currentTimeMillis());
            jettyDir.mkdirs();
            this.setupJettySolrHome(jettyDir);
            JettySolrRunner j = this.createJetty(jettyDir, this.useJettyDataDir ? this.getDataDir(this.testDir + "/jetty" + cnt) : null, null, "solrconfig.xml", null);
            jettys.add(j);
            SolrServer client = this.createNewSolrServer(j.getLocalPort());
            clients.add(client);
        }
        this.jettys.addAll(jettys);
        this.clients.addAll(clients);
        int numShards = this.getTotalReplicas("collection1");
        if (checkCreatedVsState) {
            int retries = 0;
            while (numShards != this.shardCount && (numShards = this.getTotalReplicas("collection1")) != this.shardCount) {
                if (retries++ == 60) {
                    this.printLayoutOnTearDown = true;
                    AbstractFullDistribZkTestBase.fail((String)("Shards in the state does not match what we set:" + numShards + " vs " + this.shardCount));
                }
                Thread.sleep(500L);
            }
            ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
            for (int i = 1; i <= this.sliceCount; ++i) {
                zkStateReader.getLeaderRetry("collection1", "shard" + i, 10000);
            }
        }
        if (numShards > 0) {
            this.updateMappingsFromZk(this.jettys, this.clients);
        }
        for (int i = 1; i <= numJettys / 2; ++i) {
            JettySolrRunner j = (JettySolrRunner)this.jettys.get(i);
            JettySolrRunner j2 = (JettySolrRunner)this.jettys.get(i + (numJettys / 2 - 1));
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append("127.0.0.1:").append(j.getLocalPort()).append(this.context);
            sb.append("|127.0.0.1:").append(j2.getLocalPort()).append(this.context);
        }
        this.shards = sb.toString();
        return jettys;
    }

    protected SolrServer startCloudJetty(String collection, String shard) throws Exception {
        collection = "collection1";
        int totalReplicas = this.getTotalReplicas(collection);
        int cnt = this.jettyIntCntr.incrementAndGet();
        File jettyDir = new File(TEMP_DIR, ((Object)((Object)this)).getClass().getName() + "-jetty" + cnt + "-" + System.currentTimeMillis());
        jettyDir.mkdirs();
        FileUtils.copyDirectory((File)new File(this.getSolrHome()), (File)jettyDir);
        JettySolrRunner j = this.createJetty(jettyDir, this.testDir + "/jetty" + cnt, shard, "solrconfig.xml", null);
        this.jettys.add(j);
        SolrServer client = this.createNewSolrServer(j.getLocalPort());
        this.clients.add(client);
        int retries = 60;
        while (--retries >= 0 && this.getTotalReplicas(collection) == totalReplicas) {
            Thread.sleep(500L);
        }
        if (retries <= 0) {
            AbstractFullDistribZkTestBase.fail((String)("Timeout waiting for " + j + " to appear in clusterstate"));
            this.printLayout();
        }
        this.updateMappingsFromZk(this.jettys, this.clients);
        return client;
    }

    protected int getTotalReplicas(String collection) {
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        DocCollection coll = (DocCollection)zkStateReader.getClusterState().getCollectionStates().get(collection);
        if (coll == null) {
            return 0;
        }
        int cnt = 0;
        for (Slice slices : coll.getSlices()) {
            cnt += slices.getReplicas().size();
        }
        return cnt;
    }

    public JettySolrRunner createJetty(String dataDir, String ulogDir, String shardList, String solrConfigOverride) throws Exception {
        JettySolrRunner jetty = new JettySolrRunner(this.getSolrHome(), this.context, 0, solrConfigOverride, null, false, this.getExtraServlets());
        jetty.setShards(shardList);
        jetty.setDataDir(this.getDataDir(dataDir));
        jetty.start();
        return jetty;
    }

    @Override
    public JettySolrRunner createJetty(File solrHome, String dataDir, String shardList, String solrConfigOverride, String schemaOverride) throws Exception {
        if (AbstractFullDistribZkTestBase.random().nextBoolean()) {
            solrHome = this.getRelativeSolrHomePath(solrHome);
        }
        JettySolrRunner jetty = new JettySolrRunner(solrHome.getPath(), this.context, 0, solrConfigOverride, schemaOverride, false, this.getExtraServlets());
        jetty.setShards(shardList);
        jetty.setDataDir(this.getDataDir(dataDir));
        jetty.start();
        return jetty;
    }

    private File getRelativeSolrHomePath(File solrHome) {
        String path = SolrResourceLoader.normalizeDir((String)new File(".").getAbsolutePath());
        String base = new File(solrHome.getPath()).getAbsolutePath();
        if (base.startsWith(".")) {
            // empty if block
        }
        base.replaceFirst("\\.", new File(".").getName());
        if (path.endsWith(File.separator + ".")) {
            path = path.substring(0, path.length() - 2);
        }
        int splits = path.split("\\" + File.separator).length;
        StringBuilder p = new StringBuilder();
        for (int i = 0; i < splits - 2; ++i) {
            p.append(".." + File.separator);
        }
        String prefix = FilenameUtils.getPrefix((String)path);
        if (base.startsWith(prefix)) {
            base = base.substring(prefix.length());
        }
        solrHome = new File(p.toString() + base);
        return solrHome;
    }

    protected void updateMappingsFromZk(List<JettySolrRunner> jettys, List<SolrServer> clients) throws Exception {
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        zkStateReader.updateClusterState(true);
        this.cloudJettys.clear();
        this.shardToJetty.clear();
        ClusterState clusterState = zkStateReader.getClusterState();
        DocCollection coll = clusterState.getCollection("collection1");
        ArrayList<CloudSolrServerClient> theClients = new ArrayList<CloudSolrServerClient>();
        block0: for (SolrServer client : clients) {
            for (Slice slice : coll.getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    int port = new URI(((HttpSolrServer)client).getBaseURL()).getPort();
                    if (!replica.getNodeName().contains(":" + port + "_")) continue;
                    CloudSolrServerClient csc = new CloudSolrServerClient();
                    csc.solrClient = client;
                    csc.port = port;
                    csc.shardName = replica.getStr("node_name");
                    csc.info = replica;
                    theClients.add(csc);
                    continue block0;
                }
            }
        }
        block3: for (JettySolrRunner jetty : jettys) {
            int port = jetty.getLocalPort();
            if (port == -1) {
                throw new RuntimeException("Cannot find the port for jetty");
            }
            for (Slice slice : coll.getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    if (!replica.getNodeName().contains(":" + port + "_")) continue;
                    List<CloudJettyRunner> list = this.shardToJetty.get(slice.getName());
                    if (list == null) {
                        list = new ArrayList<CloudJettyRunner>();
                        this.shardToJetty.put(slice.getName(), list);
                    }
                    boolean isLeader = slice.getLeader() == replica;
                    CloudJettyRunner cjr = new CloudJettyRunner();
                    cjr.jetty = jetty;
                    cjr.info = replica;
                    cjr.nodeName = replica.getStr("node_name");
                    cjr.coreNodeName = replica.getNodeName();
                    cjr.url = replica.getStr("base_url") + "/" + replica.getStr("core");
                    cjr.client = this.findClientByPort(port, theClients);
                    list.add(cjr);
                    if (isLeader) {
                        this.shardToLeaderJetty.put(slice.getName(), cjr);
                    }
                    this.cloudJettys.add(cjr);
                    continue block3;
                }
            }
        }
        for (Slice slice : coll.getSlices()) {
            List<CloudJettyRunner> jetties = this.shardToJetty.get(slice.getName());
            AbstractFullDistribZkTestBase.assertNotNull((String)("Test setup problem: We found no jetties for shard: " + slice.getName() + " just:" + this.shardToJetty.keySet()), jetties);
            AbstractFullDistribZkTestBase.assertEquals((String)("slice:" + slice.getName()), (long)slice.getReplicas().size(), (long)jetties.size());
        }
    }

    private CloudSolrServerClient findClientByPort(int port, List<CloudSolrServerClient> theClients) {
        for (CloudSolrServerClient client : theClients) {
            if (client.port != port) continue;
            return client;
        }
        throw new IllegalArgumentException("Client with the given port does not exist:" + port);
    }

    @Override
    protected void setDistributedParams(ModifiableSolrParams params) {
        if (!r.nextBoolean()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.sliceCount; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append("shard" + (i + 1));
            }
            params.set("shards", new String[]{sb.toString()});
        }
    }

    @Override
    protected void indexDoc(SolrInputDocument doc) throws IOException, SolrServerException {
        this.controlClient.add(doc);
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(doc);
        ureq.process((SolrServer)this.cloudClient);
    }

    @Override
    protected void index_specific(int serverNumber, Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
        this.controlClient.add(doc);
        HttpSolrServer client = (HttpSolrServer)this.clients.get(serverNumber);
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(doc);
        ureq.process((SolrServer)client);
    }

    protected void index_specific(SolrServer client, Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(doc);
        ureq.process(client);
        this.controlClient.add(doc);
    }

    @Override
    protected void del(String q) throws Exception {
        this.controlClient.deleteByQuery(q);
        this.cloudClient.deleteByQuery(q);
    }

    protected void waitForRecoveriesToFinish(boolean verbose) throws Exception {
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        super.waitForRecoveriesToFinish("collection1", zkStateReader, verbose);
    }

    protected void waitForRecoveriesToFinish(String collection, boolean verbose) throws Exception {
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        super.waitForRecoveriesToFinish(collection, zkStateReader, verbose);
    }

    protected void waitForRecoveriesToFinish(boolean verbose, int timeoutSeconds) throws Exception {
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        super.waitForRecoveriesToFinish("collection1", zkStateReader, verbose, true, timeoutSeconds);
    }

    protected void checkQueries() throws Exception {
        this.handle.put("_version_", SKIPVAL);
        this.query("q", "*:*", "sort", "n_tl1 desc");
        this.handle.put("response", UNORDERED);
        String ids = "987654";
        for (int i = 0; i < 20; ++i) {
            this.query("qt", "/get", "id", Integer.toString(i));
            this.query("qt", "/get", "ids", Integer.toString(i));
            ids = ids + ',' + Integer.toString(i);
            this.query("qt", "/get", "ids", ids);
        }
        this.handle.remove("response");
        for (String f : fieldNames) {
            this.query("q", "*:*", "sort", f + " desc");
            this.query("q", "*:*", "sort", f + " asc");
        }
        this.query("q", "*:*", "sort", this.i1 + " desc");
        this.query("q", "*:*", "sort", this.i1 + " asc");
        this.query("q", "*:*", "sort", this.i1 + " desc", "fl", "*,score");
        this.query("q", "*:*", "sort", "n_tl1 asc", "fl", "score");
        this.query("q", "*:*", "sort", "n_tl1 desc");
        this.handle.put("maxScore", SKIPVAL);
        this.query("q", "{!func}" + this.i1);
        this.handle.remove("maxScore");
        this.query("q", "{!func}" + this.i1, "fl", "*,score");
        this.handle.put("highlighting", UNORDERED);
        this.handle.put("response", UNORDERED);
        this.handle.put("maxScore", SKIPVAL);
        this.query("q", "quick");
        this.query("q", "all", "fl", "id", "start", "0");
        this.query("q", "all", "fl", "foofoofoo", "start", "0");
        this.query("q", "all", "fl", "id", "start", "100");
        this.handle.put("score", SKIPVAL);
        this.query("q", "quick", "fl", "*,score");
        this.query("q", "all", "fl", "*,score", "start", "1");
        this.query("q", "all", "fl", "*,score", "start", "100");
        this.query("q", "now their fox sat had put", "fl", "*,score", "hl", "true", "hl.fl", this.t1);
        this.query("q", "now their fox sat had put", "fl", "foofoofoo", "hl", "true", "hl.fl", this.t1);
        this.query("q", "matchesnothing", "fl", "*,score");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "count");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "count", "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "index");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "index", "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", 1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.query", "quick", "facet.query", "all", "facet.query", "*:*");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.offset", 1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.query", "quick", "facet.query", "all", "facet.query", "*:*", "facet.field", this.t1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.query", "{!key=myquick}quick", "facet.query", "{!key=myall ex=a}all", "facet.query", "*:*", "facet.field", "{!key=mykey ex=a}" + this.t1, "facet.field", "{!key=other ex=b}" + this.t1, "facet.field", "{!key=again ex=a,b}" + this.t1, "facet.field", this.t1, "fq", "{!tag=a}id:[1 TO 7]", "fq", "{!tag=b}id:[3 TO 9]");
        this.query("q", "*:*", "facet", "true", "facet.field", "{!ex=t1}SubjectTerms_mfacet", "fq", "{!tag=t1}SubjectTerms_mfacet:(test 1)", "facet.limit", "10", "facet.mincount", "1");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.missingField, "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.oddField, "facet.mincount", 2);
        this.query("q", "*:*", "sort", this.i1 + " desc", "stats", "true", "stats.field", this.i1);
        this.handle.put("facet_fields", SKIPVAL);
        this.query("q", "*:*", "rows", 0, "facet", "true", "facet.field", this.t1, "facet.limit", 5, "facet.shard.limit", 5);
        this.query("q", "*:*", "rows", 0, "facet", "true", "facet.field", "{!key='a b/c \\' \\} foo'}" + this.t1, "facet.limit", 5, "facet.shard.limit", 5);
        this.handle.remove("facet_fields");
        this.query("q", "*:*", "sort", "n_tl1 desc");
        if (this.clients.size() >= 2) {
            this.index(this.id, 100, this.i1, 107, this.t1, "oh no, a duplicate!");
            for (int i = 0; i < this.shardCount; ++i) {
                this.index_specific(i, this.id, 100, this.i1, 107, this.t1, "oh no, a duplicate!");
            }
            this.commit();
            this.query("q", "duplicate", "hl", "true", "hl.fl", this.t1);
            this.query("q", "fox duplicate horses", "hl", "true", "hl.fl", this.t1);
            this.query("q", "*:*", "rows", 100);
        }
    }

    protected void indexAbunchOfDocs() throws Exception {
        int i;
        this.indexr(this.id, 2, this.i1, 50, this.tlong, 50, this.t1, "to come to the aid of their country.");
        this.indexr(this.id, 3, this.i1, 2, this.tlong, 2, this.t1, "how now brown cow");
        this.indexr(this.id, 4, this.i1, -100, this.tlong, 101, this.t1, "the quick fox jumped over the lazy dog");
        this.indexr(this.id, 5, this.i1, 500, this.tlong, 500, this.t1, "the quick fox jumped way over the lazy dog");
        this.indexr(this.id, 6, this.i1, -600, this.tlong, 600, this.t1, "humpty dumpy sat on a wall");
        this.indexr(this.id, 7, this.i1, 123, this.tlong, 123, this.t1, "humpty dumpy had a great fall");
        this.indexr(this.id, 8, this.i1, 876, this.tlong, 876, this.t1, "all the kings horses and all the kings men");
        this.indexr(this.id, 9, this.i1, 7, this.tlong, 7, this.t1, "couldn't put humpty together again");
        this.indexr(this.id, 10, this.i1, 4321, this.tlong, 4321, this.t1, "this too shall pass");
        this.indexr(this.id, 11, this.i1, -987, this.tlong, 987, this.t1, "An eye for eye only ends up making the whole world blind.");
        this.indexr(this.id, 12, this.i1, 379, this.tlong, 379, this.t1, "Great works are performed, not by strength, but by perseverance.");
        this.indexr(this.id, 13, this.i1, 232, this.tlong, 232, this.t1, "no eggs on wall, lesson learned", this.oddField, "odd man out");
        this.indexr(this.id, 14, "SubjectTerms_mfacet", new String[]{"mathematical models", "mathematical analysis"});
        this.indexr(this.id, 15, "SubjectTerms_mfacet", new String[]{"test 1", "test 2", "test3"});
        this.indexr(this.id, 16, "SubjectTerms_mfacet", new String[]{"test 1", "test 2", "test3"});
        String[] vals = new String[100];
        for (i = 0; i < 100; ++i) {
            vals[i] = "test " + i;
        }
        this.indexr(this.id, 17, "SubjectTerms_mfacet", vals);
        for (i = 100; i < 150; ++i) {
            this.indexr(this.id, i);
        }
    }

    public QueryResponse queryAndCompareReplicas(SolrParams params, String shard) throws Exception {
        ArrayList<SolrServer> shardClients = new ArrayList<SolrServer>(7);
        this.updateMappingsFromZk(this.jettys, this.clients);
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        List<CloudJettyRunner> solrJetties = this.shardToJetty.get(shard);
        AbstractFullDistribZkTestBase.assertNotNull((String)("no jetties found for shard: " + shard), solrJetties);
        for (CloudJettyRunner cjetty : solrJetties) {
            ZkNodeProps props = cjetty.info;
            String nodeName = props.getStr("node_name");
            boolean active = props.getStr("state").equals("active");
            boolean live = zkStateReader.getClusterState().liveNodesContain(nodeName);
            if (!active || !live) continue;
            shardClients.add(cjetty.client.solrClient);
        }
        return this.queryAndCompare(params, shardClients);
    }

    public void queryAndCompareShards(SolrParams params) throws Exception {
        this.updateMappingsFromZk(this.jettys, this.clients);
        ArrayList<String> shards = new ArrayList<String>(this.shardToJetty.keySet());
        for (String shard : shards) {
            this.queryAndCompareReplicas(params, shard);
        }
    }

    protected void checkShardConsistency(String shard) throws Exception {
        this.checkShardConsistency(shard, false, false);
    }

    protected String checkShardConsistency(String shard, boolean expectFailure, boolean verbose) throws Exception {
        List<CloudJettyRunner> solrJetties = this.shardToJetty.get(shard);
        if (solrJetties == null) {
            throw new RuntimeException("shard not found:" + shard + " keys:" + this.shardToJetty.keySet());
        }
        long num = -1L;
        long lastNum = -1L;
        String failMessage = null;
        if (verbose) {
            System.err.println("check const of " + shard);
        }
        int cnt = 0;
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        AbstractFullDistribZkTestBase.assertEquals((String)("The client count does not match up with the shard count for slice:" + shard), (long)zkStateReader.getClusterState().getSlice("collection1", shard).getReplicasMap().size(), (long)solrJetties.size());
        CloudJettyRunner lastJetty = null;
        for (CloudJettyRunner cjetty : solrJetties) {
            boolean active;
            ZkNodeProps props = cjetty.info;
            if (verbose) {
                System.err.println("client" + cnt++);
            }
            if (verbose) {
                System.err.println("PROPS:" + props);
            }
            try {
                ModifiableSolrParams query = AbstractFullDistribZkTestBase.params("q", "*:*", "rows", "0", "distrib", "false", "tests", "checkShardConsistency");
                num = cjetty.client.solrClient.query((SolrParams)query).getResults().getNumFound();
            }
            catch (SolrServerException e) {
                if (!verbose) continue;
                System.err.println("error contacting client: " + e.getMessage() + "\n");
                continue;
            }
            catch (SolrException e) {
                if (!verbose) continue;
                System.err.println("error contacting client: " + e.getMessage() + "\n");
                continue;
            }
            boolean live = false;
            String nodeName = props.getStr("node_name");
            if (zkStateReader.getClusterState().liveNodesContain(nodeName)) {
                live = true;
            }
            if (verbose) {
                System.err.println(" live:" + live);
            }
            if (verbose) {
                System.err.println(" num:" + num + "\n");
            }
            if (!(active = props.getStr("state").equals("active")) || !live) continue;
            if (lastNum > -1L && lastNum != num && failMessage == null) {
                failMessage = shard + " is not consistent.  Got " + lastNum + " from " + lastJetty.url + "lastClient" + " and got " + num + " from " + cjetty.url;
                if (!expectFailure || verbose) {
                    System.err.println("######" + failMessage);
                    SolrQuery query = new SolrQuery("*:*");
                    query.set("distrib", false);
                    query.set("fl", new String[]{"id,_version_"});
                    query.set("rows", new String[]{"100000"});
                    query.set("sort", new String[]{"id asc"});
                    query.set("tests", new String[]{"checkShardConsistency/showDiff"});
                    SolrDocumentList lst1 = lastJetty.client.solrClient.query((SolrParams)query).getResults();
                    SolrDocumentList lst2 = cjetty.client.solrClient.query((SolrParams)query).getResults();
                    this.showDiff(lst1, lst2, lastJetty.url, cjetty.url);
                }
            }
            lastNum = num;
            lastJetty = cjetty;
        }
        return failMessage;
    }

    public void showCounts() {
        Set<String> theShards = this.shardToJetty.keySet();
        for (String shard : theShards) {
            List<CloudJettyRunner> solrJetties = this.shardToJetty.get(shard);
            for (CloudJettyRunner cjetty : solrJetties) {
                ZkNodeProps props = cjetty.info;
                System.err.println("PROPS:" + props);
                try {
                    ModifiableSolrParams query = AbstractFullDistribZkTestBase.params("q", "*:*", "rows", "0", "distrib", "false", "tests", "checkShardConsistency");
                    long num = cjetty.client.solrClient.query((SolrParams)query).getResults().getNumFound();
                    System.err.println("DOCS:" + num);
                }
                catch (SolrServerException e) {
                    System.err.println("error contacting client: " + e.getMessage() + "\n");
                    continue;
                }
                catch (SolrException e) {
                    System.err.println("error contacting client: " + e.getMessage() + "\n");
                    continue;
                }
                boolean live = false;
                String nodeName = props.getStr("node_name");
                ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
                if (zkStateReader.getClusterState().liveNodesContain(nodeName)) {
                    live = true;
                }
                System.err.println(" live:" + live);
            }
        }
    }

    private String toStr(SolrDocumentList lst, int maxSz) {
        if (lst.size() <= maxSz) {
            return lst.toString();
        }
        StringBuilder sb = new StringBuilder("SolrDocumentList[sz=" + lst.size());
        if ((long)lst.size() != lst.getNumFound()) {
            sb.append(" numFound=" + lst.getNumFound());
        }
        sb.append("]=");
        sb.append(lst.subList(0, maxSz / 2).toString());
        sb.append(" , [...] , ");
        sb.append(lst.subList(lst.size() - maxSz / 2, lst.size()).toString());
        return sb.toString();
    }

    Set<Map> showDiff(SolrDocumentList a, SolrDocumentList b, String aName, String bName) {
        System.err.println("######" + aName + ": " + this.toStr(a, 10));
        System.err.println("######" + bName + ": " + this.toStr(b, 10));
        System.err.println("###### sizes=" + a.size() + "," + b.size());
        HashSet setA = new HashSet();
        for (SolrDocument sdoc : a) {
            setA.add(new HashMap(sdoc));
        }
        HashSet setB = new HashSet();
        for (SolrDocument sdoc : b) {
            setB.add(new HashMap(sdoc));
        }
        HashSet<Map> onlyInA = new HashSet<Map>(setA);
        onlyInA.removeAll(setB);
        HashSet onlyInB = new HashSet(setB);
        onlyInB.removeAll(setA);
        if (onlyInA.size() > 0) {
            System.err.println("###### Only in " + aName + ": " + onlyInA);
        }
        if (onlyInB.size() > 0) {
            System.err.println("###### Only in " + bName + ": " + onlyInB);
        }
        onlyInA.addAll(onlyInB);
        return onlyInA;
    }

    protected void checkShardConsistency() throws Exception {
        this.checkShardConsistency(true, false);
    }

    protected void checkShardConsistency(boolean checkVsControl, boolean verbose) throws Exception {
        this.updateMappingsFromZk(this.jettys, this.clients);
        Set<String> theShards = this.shardToJetty.keySet();
        String failMessage = null;
        for (String shard : theShards) {
            String shardFailMessage = this.checkShardConsistency(shard, false, verbose);
            if (shardFailMessage == null || failMessage != null) continue;
            failMessage = shardFailMessage;
        }
        if (failMessage != null) {
            AbstractFullDistribZkTestBase.fail(failMessage);
        }
        if (!checkVsControl) {
            return;
        }
        ModifiableSolrParams q = AbstractFullDistribZkTestBase.params("q", "*:*", "rows", "0", "tests", "checkShardConsistency(vsControl)");
        SolrDocumentList controlDocList = this.controlClient.query((SolrParams)q).getResults();
        long controlDocs = controlDocList.getNumFound();
        SolrDocumentList cloudDocList = this.cloudClient.query((SolrParams)q).getResults();
        long cloudClientDocs = cloudDocList.getNumFound();
        theShards = this.shardToJetty.keySet();
        int cnt = 0;
        block3: for (String s : theShards) {
            int times = this.shardToJetty.get(s).size();
            for (int i = 0; i < times; ++i) {
                try {
                    CloudJettyRunner cjetty = this.shardToJetty.get(s).get(i);
                    ZkNodeProps props = cjetty.info;
                    SolrServer client = cjetty.client.solrClient;
                    boolean active = props.getStr("state").equals("active");
                    if (!active) continue;
                    SolrQuery query = new SolrQuery("*:*");
                    query.set("distrib", false);
                    long results = client.query((SolrParams)query).getResults().getNumFound();
                    if (verbose) {
                        System.err.println(new ZkCoreNodeProps(props).getCoreUrl() + " : " + results);
                    }
                    if (verbose) {
                        System.err.println("shard:" + props.getStr("shard"));
                    }
                    cnt = (int)((long)cnt + results);
                    continue block3;
                }
                catch (Exception e) {
                    if (i != times - 1) continue;
                    throw e;
                }
            }
        }
        if (controlDocs != (long)cnt || cloudClientDocs != controlDocs) {
            String msg = "document count mismatch.  control=" + controlDocs + " sum(shards)=" + cnt + " cloudClient=" + cloudClientDocs;
            log.error(msg);
            q = AbstractFullDistribZkTestBase.params("q", "*:*", "rows", "100000", "fl", "id", "tests", "checkShardConsistency(vsControl)/getIds");
            controlDocList = this.controlClient.query((SolrParams)q).getResults();
            if (controlDocs != controlDocList.getNumFound()) {
                log.error("Something changed! control now " + controlDocList.getNumFound());
            }
            if (cloudClientDocs != (cloudDocList = this.cloudClient.query((SolrParams)q).getResults()).getNumFound()) {
                log.error("Something changed! cloudClient now " + cloudDocList.getNumFound());
            }
            Set<Map> differences = this.showDiff(controlDocList, cloudDocList, "controlDocList", "cloudDocList");
            boolean foundId = false;
            StringBuilder ids = new StringBuilder("id:(");
            for (Map doc : differences) {
                ids.append(" " + doc.get("id"));
                foundId = true;
            }
            ids.append(")");
            if (foundId) {
                q = AbstractFullDistribZkTestBase.params("q", ids.toString(), "rows", "100000", "fl", "id,_version_", "sort", "id asc", "tests", "checkShardConsistency(vsControl)/getVers");
                SolrDocumentList a = this.controlClient.query((SolrParams)q).getResults();
                SolrDocumentList b = this.cloudClient.query((SolrParams)q).getResults();
                log.error("controlClient :" + a + "\n\tcloudClient :" + b);
            }
            AbstractFullDistribZkTestBase.fail((String)msg);
        }
    }

    protected SolrServer getClient(String nodeName) {
        for (CloudJettyRunner cjetty : this.cloudJettys) {
            CloudSolrServerClient client = cjetty.client;
            if (!client.shardName.equals(nodeName)) continue;
            return client.solrClient;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertDocCounts(boolean verbose) throws Exception {
        ClusterState clusterState;
        if (verbose) {
            System.err.println("control docs:" + this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound() + "\n\n");
        }
        long controlCount = this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        ZkStateReader zk = new ZkStateReader(this.zkServer.getZkAddress(), 10000, 10000);
        Map slices = null;
        try {
            zk.createClusterStateWatchersAndUpdate();
            clusterState = zk.getClusterState();
            slices = clusterState.getSlicesMap("collection1");
        }
        finally {
            zk.close();
        }
        if (slices == null) {
            throw new RuntimeException("Could not find collection collection1 in " + clusterState.getCollections());
        }
        for (CloudJettyRunner cjetty : this.cloudJettys) {
            CloudSolrServerClient client = cjetty.client;
            for (Map.Entry slice : slices.entrySet()) {
                Map theShards = ((Slice)slice.getValue()).getReplicasMap();
                for (Map.Entry shard : theShards.entrySet()) {
                    String shardName = new URI(((HttpSolrServer)client.solrClient).getBaseURL()).getPort() + "_solr_";
                    if (!verbose || !((String)shard.getKey()).endsWith(shardName)) continue;
                    System.err.println("shard:" + (String)slice.getKey());
                    System.err.println(shard.getValue());
                }
            }
            ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
            long count = 0L;
            String currentState = cjetty.info.getStr("state");
            if (currentState != null && currentState.equals("active") && zkStateReader.getClusterState().liveNodesContain(cjetty.info.getStr("node_name"))) {
                SolrQuery query = new SolrQuery("*:*");
                query.set("distrib", false);
                count = client.solrClient.query((SolrParams)query).getResults().getNumFound();
            }
            if (!verbose) continue;
            System.err.println("client docs:" + count + "\n\n");
        }
        if (verbose) {
            System.err.println("control docs:" + this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound() + "\n\n");
        }
        SolrQuery query = new SolrQuery("*:*");
        AbstractFullDistribZkTestBase.assertEquals((String)"Doc Counts do not add up", (long)controlCount, (long)this.cloudClient.query((SolrParams)query).getResults().getNumFound());
    }

    @Override
    protected QueryResponse queryServer(ModifiableSolrParams params) throws SolrServerException {
        if (r.nextBoolean()) {
            params.set("collection", new String[]{"collection1"});
        }
        QueryResponse rsp = this.cloudClient.query((SolrParams)params);
        return rsp;
    }

    public void waitForThingsToLevelOut(int waitForRecTimeSeconds) throws Exception {
        log.info("Wait for recoveries to finish - wait " + waitForRecTimeSeconds + " for each attempt");
        int cnt = 0;
        boolean retry = false;
        do {
            this.waitForRecoveriesToFinish(VERBOSE, waitForRecTimeSeconds);
            try {
                this.commit();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.updateMappingsFromZk(this.jettys, this.clients);
            Set<String> theShards = this.shardToJetty.keySet();
            String failMessage = null;
            for (String shard : theShards) {
                failMessage = this.checkShardConsistency(shard, true, false);
            }
            if (failMessage != null) {
                retry = true;
            }
            if (++cnt > 20) break;
            Thread.sleep(2000L);
        } while (retry);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        if (VERBOSE || this.printLayoutOnTearDown) {
            super.printLayout();
        }
        if (this.commondCloudSolrServer != null) {
            this.commondCloudSolrServer.shutdown();
        }
        if (this.controlClient != null) {
            ((HttpSolrServer)this.controlClient).shutdown();
        }
        if (this.cloudClient != null) {
            this.cloudClient.shutdown();
        }
        if (this.controlClientCloud != null) {
            this.controlClientCloud.shutdown();
        }
        super.tearDown();
        System.clearProperty("zkHost");
        System.clearProperty("numShards");
    }

    @Override
    protected void commit() throws Exception {
        this.controlClient.commit();
        this.cloudClient.commit();
    }

    @Override
    protected void destroyServers() throws Exception {
        if (this.controlJetty != null) {
            ChaosMonkey.stop(this.controlJetty);
        }
        for (JettySolrRunner jetty : this.jettys) {
            try {
                ChaosMonkey.stop(jetty);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        this.clients.clear();
        this.jettys.clear();
    }

    protected void createCollection(String collectionName, int numShards, int numReplicas, int maxShardsPerNode) throws SolrServerException, IOException {
        this.createCollection(null, collectionName, numShards, numReplicas, maxShardsPerNode, null, null);
    }

    protected void createCollection(Map<String, List<Integer>> collectionInfos, String collectionName, Map<String, Object> collectionProps, SolrServer client) throws SolrServerException, IOException {
        this.createCollection(collectionInfos, collectionName, collectionProps, client, null);
    }

    protected void createCollection(Map<String, List<Integer>> collectionInfos, String collectionName, Map<String, Object> collectionProps, SolrServer client, String confSetName) throws SolrServerException, IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CollectionParams.CollectionAction.CREATE.toString()});
        for (Map.Entry<String, Object> entry : collectionProps.entrySet()) {
            if (entry.getValue() == null) continue;
            params.set(entry.getKey(), new String[]{String.valueOf(entry.getValue())});
        }
        Integer numShards = (Integer)collectionProps.get("numShards");
        if (numShards == null) {
            String shardNames = (String)collectionProps.get("shards");
            numShards = StrUtils.splitSmart((String)shardNames, (char)',').size();
        }
        Integer numReplicas = (Integer)collectionProps.get("replicationFactor");
        if (numShards == null) {
            numShards = (Integer)OverseerCollectionProcessor.COLL_PROPS.get("replicationFactor");
        }
        if (confSetName != null) {
            params.set("collection.configName", new String[]{confSetName});
        }
        int clientIndex = AbstractFullDistribZkTestBase.random().nextInt(2);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(numShards);
        list.add(numReplicas);
        if (collectionInfos != null) {
            collectionInfos.put(collectionName, list);
        }
        params.set("name", new String[]{collectionName});
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath("/admin/collections");
        if (client == null) {
            String baseUrl = this.getBaseUrl((HttpSolrServer)this.clients.get(clientIndex));
            this.createNewSolrServer("", baseUrl).request((SolrRequest)request);
        } else {
            client.request((SolrRequest)request);
        }
    }

    protected void runCollectionAdminCommand(ModifiableSolrParams params) {
    }

    protected void createCollection(Map<String, List<Integer>> collectionInfos, String collectionName, int numShards, int numReplicas, int maxShardsPerNode, SolrServer client, String createNodeSetStr) throws SolrServerException, IOException {
        this.createCollection(collectionInfos, collectionName, ZkNodeProps.makeMap((Object[])new Object[]{"numShards", numShards, "replicationFactor", numReplicas, "createNodeSet", createNodeSetStr, "maxShardsPerNode", maxShardsPerNode}), client);
    }

    protected void createCollection(Map<String, List<Integer>> collectionInfos, String collectionName, int numShards, int numReplicas, int maxShardsPerNode, SolrServer client, String createNodeSetStr, String configName) throws SolrServerException, IOException {
        this.createCollection(collectionInfos, collectionName, ZkNodeProps.makeMap((Object[])new Object[]{"numShards", numShards, "replicationFactor", numReplicas, "createNodeSet", createNodeSetStr, "maxShardsPerNode", maxShardsPerNode}), client, configName);
    }

    @Override
    protected SolrServer createNewSolrServer(int port) {
        try {
            String url = "http://127.0.0.1:" + port + this.context + (this.context.endsWith("/") ? "" : "/") + "collection1";
            HttpSolrServer s = new HttpSolrServer(url);
            s.setConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT);
            s.setSoTimeout(60000);
            s.setDefaultMaxConnectionsPerHost(100);
            s.setMaxTotalConnections(100);
            return s;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected SolrServer createNewSolrServer(String collection, String baseUrl) {
        try {
            HttpSolrServer s = new HttpSolrServer(baseUrl + "/" + collection);
            s.setConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT);
            s.setDefaultMaxConnectionsPerHost(100);
            s.setMaxTotalConnections(100);
            return s;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String getBaseUrl(HttpSolrServer client) {
        return client.getBaseURL().substring(0, client.getBaseURL().length() - "collection1".length() - 1);
    }

    protected SolrInputDocument getDoc(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        this.addFields(doc, fields);
        return doc;
    }

    private String checkCollectionExpectations(String collectionName, List<Integer> numShardsNumReplicaList, List<String> nodesAllowedToRunShards) {
        ClusterState clusterState = this.getCommonCloudSolrServer().getZkStateReader().getClusterState();
        int expectedSlices = numShardsNumReplicaList.get(0);
        int expectedShardsPerSlice = numShardsNumReplicaList.get(1);
        int expectedTotalShards = expectedSlices * expectedShardsPerSlice;
        Map collections = clusterState.getCollectionStates();
        if (collections.containsKey(collectionName)) {
            Map slices = ((DocCollection)collections.get(collectionName)).getSlicesMap();
            if (slices.size() != expectedSlices) {
                return "Found new collection " + collectionName + ", but mismatch on number of slices. Expected: " + expectedSlices + ", actual: " + slices.size();
            }
            int totalShards = 0;
            for (String sliceName : slices.keySet()) {
                for (Replica replica : ((Slice)slices.get(sliceName)).getReplicas()) {
                    if (nodesAllowedToRunShards == null || nodesAllowedToRunShards.contains(replica.getStr("node_name"))) continue;
                    return "Shard " + replica.getName() + " created on node " + replica.getNodeName() + " not allowed to run shards for the created collection " + collectionName;
                }
                totalShards += ((Slice)slices.get(sliceName)).getReplicas().size();
            }
            if (totalShards != expectedTotalShards) {
                return "Found new collection " + collectionName + " with correct number of slices, but mismatch on number of shards. Expected: " + expectedTotalShards + ", actual: " + totalShards;
            }
            return null;
        }
        return "Could not find new collection " + collectionName;
    }

    protected void checkForCollection(String collectionName, List<Integer> numShardsNumReplicaList, List<String> nodesAllowedToRunShards) throws Exception {
        long timeoutAt = System.currentTimeMillis() + 120000L;
        boolean success = false;
        String checkResult = "Didnt get to perform a single check";
        while (System.currentTimeMillis() < timeoutAt) {
            checkResult = this.checkCollectionExpectations(collectionName, numShardsNumReplicaList, nodesAllowedToRunShards);
            if (checkResult == null) {
                success = true;
                break;
            }
            Thread.sleep(500L);
        }
        if (!success) {
            super.printLayout();
            AbstractFullDistribZkTestBase.fail((String)checkResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloudSolrServer getCommonCloudSolrServer() {
        if (this.commondCloudSolrServer == null) {
            AbstractFullDistribZkTestBase abstractFullDistribZkTestBase = this;
            synchronized (abstractFullDistribZkTestBase) {
                try {
                    this.commondCloudSolrServer = new CloudSolrServer(this.zkServer.getZkAddress(), AbstractFullDistribZkTestBase.random().nextBoolean());
                    this.commondCloudSolrServer.setParallelUpdates(AbstractFullDistribZkTestBase.random().nextBoolean());
                    this.commondCloudSolrServer.setDefaultCollection("collection1");
                    this.commondCloudSolrServer.connect();
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.commondCloudSolrServer;
    }

    class StopableSearchThread
    extends StopableThread {
        private volatile boolean stop;
        protected final AtomicInteger fails;
        private String[] QUERIES;

        public StopableSearchThread() {
            super("StopableSearchThread");
            this.stop = false;
            this.fails = new AtomicInteger();
            this.QUERIES = new String[]{"to come", "their country", "aid", "co*"};
            this.setDaemon(true);
        }

        @Override
        public void run() {
            Random random = LuceneTestCase.random();
            int numSearches = 0;
            while (!this.stop) {
                ++numSearches;
                try {
                    AbstractFullDistribZkTestBase.this.cloudClient.query((SolrParams)new SolrQuery(this.QUERIES[random.nextInt(this.QUERIES.length)]));
                }
                catch (Exception e) {
                    System.err.println("QUERY REQUEST FAILED:");
                    e.printStackTrace();
                    if (e instanceof SolrServerException) {
                        System.err.println("ROOT CAUSE:");
                        ((SolrServerException)((Object)e)).getRootCause().printStackTrace();
                    }
                    this.fails.incrementAndGet();
                }
                try {
                    Thread.sleep(random.nextInt(4000) + 300);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            System.err.println("num searches done:" + numSearches + " with " + this.fails + " fails");
        }

        @Override
        public void safeStop() {
            this.stop = true;
        }

        public int getFails() {
            return this.fails.get();
        }
    }

    class StopableIndexingThread
    extends StopableThread {
        private volatile boolean stop;
        protected final int startI;
        protected final List<Integer> deletes;
        protected final AtomicInteger fails;
        protected boolean doDeletes;
        private int numCycles;

        public StopableIndexingThread(int startI, boolean doDeletes) {
            this(startI, doDeletes, -1);
        }

        public StopableIndexingThread(int startI, boolean doDeletes, int numCycles) {
            super("StopableIndexingThread");
            this.stop = false;
            this.deletes = new ArrayList<Integer>();
            this.fails = new AtomicInteger();
            this.startI = startI;
            this.doDeletes = doDeletes;
            this.numCycles = numCycles;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            int i = this.startI;
            int numDone = 0;
            int numDeletes = 0;
            int numAdds = 0;
            while (!(this.stop || this.numCycles != -1 && numDone > this.numCycles)) {
                ++numDone;
                ++i;
                boolean addFailed = false;
                if (this.doDeletes && LuceneTestCase.random().nextBoolean() && this.deletes.size() > 0) {
                    Integer delete = this.deletes.remove(0);
                    try {
                        ++numDeletes;
                        AbstractFullDistribZkTestBase.this.controlClient.deleteById(Integer.toString(delete));
                        AbstractFullDistribZkTestBase.this.cloudClient.deleteById(Integer.toString(delete));
                    }
                    catch (Exception e) {
                        System.err.println("REQUEST FAILED:");
                        e.printStackTrace();
                        if (e instanceof SolrServerException) {
                            System.err.println("ROOT CAUSE:");
                            ((SolrServerException)((Object)e)).getRootCause().printStackTrace();
                        }
                        this.fails.incrementAndGet();
                    }
                }
                try {
                    ++numAdds;
                    AbstractFullDistribZkTestBase.this.indexr(new Object[]{AbstractFullDistribZkTestBase.this.id, i, AbstractFullDistribZkTestBase.this.i1, 50, AbstractFullDistribZkTestBase.this.tlong, 50, AbstractFullDistribZkTestBase.this.t1, "to come to the aid of their country."});
                }
                catch (Exception e) {
                    addFailed = true;
                    System.err.println("REQUEST FAILED:");
                    e.printStackTrace();
                    if (e instanceof SolrServerException) {
                        System.err.println("ROOT CAUSE:");
                        ((SolrServerException)((Object)e)).getRootCause().printStackTrace();
                    }
                    this.fails.incrementAndGet();
                }
                if (!addFailed && this.doDeletes && LuceneTestCase.random().nextBoolean()) {
                    this.deletes.add(i);
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(LuceneTestCase.random().nextInt(100));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            System.err.println("added docs:" + numAdds + " with " + this.fails + " fails" + " deletes:" + numDeletes);
        }

        @Override
        public void safeStop() {
            System.out.println("safe stop:");
            this.stop = true;
        }

        public int getFails() {
            return this.fails.get();
        }
    }

    abstract class StopableThread
    extends Thread {
        public StopableThread(String name) {
            super(name);
        }

        public abstract void safeStop();
    }

    static class CloudSolrServerClient {
        SolrServer solrClient;
        String shardName;
        int port;
        public ZkNodeProps info;

        public CloudSolrServerClient() {
        }

        public CloudSolrServerClient(SolrServer client) {
            this.solrClient = client;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.solrClient == null ? 0 : this.solrClient.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CloudSolrServerClient other = (CloudSolrServerClient)obj;
            return !(this.solrClient == null ? other.solrClient != null : !this.solrClient.equals(other.solrClient));
        }
    }

    public static class CloudJettyRunner {
        public JettySolrRunner jetty;
        public String nodeName;
        public String coreNodeName;
        public String url;
        public CloudSolrServerClient client;
        public ZkNodeProps info;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CloudJettyRunner other = (CloudJettyRunner)obj;
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }

        public String toString() {
            return "CloudJettyRunner [url=" + this.url + "]";
        }
    }
}

