/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.io.File;
import java.util.SortedMap;
import org.apache.commons.io.FileUtils;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.HttpSolrServer;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrJettyTestBase
extends SolrTestCaseJ4 {
    private static Logger log = LoggerFactory.getLogger(SolrJettyTestBase.class);
    public static JettySolrRunner jetty;
    public static int port;
    public static SolrServer server;
    public static String context;

    @BeforeClass
    public static void beforeSolrJettyTestBase() throws Exception {
    }

    public static JettySolrRunner createJetty(String solrHome, String configFile, String schemaFile, String context, boolean stopAtShutdown, SortedMap<ServletHolder, String> extraServlets) throws Exception {
        SolrJettyTestBase.initCore(null, null, solrHome);
        SolrJettyTestBase.ignoreException("maxWarmingSearchers");
        System.setProperty("solr.data.dir", dataDir.getCanonicalPath());
        SolrJettyTestBase.context = context = context == null ? "/solr" : context;
        jetty = new JettySolrRunner(solrHome, context, 0, configFile, schemaFile, stopAtShutdown, extraServlets, (SSLConfig)sslConfig);
        jetty.start();
        port = jetty.getLocalPort();
        log.info("Jetty Assigned Port#" + port);
        return jetty;
    }

    public static JettySolrRunner createJetty(String solrHome, String configFile, String context) throws Exception {
        return SolrJettyTestBase.createJetty(solrHome, configFile, null, context, true, null);
    }

    @AfterClass
    public static void afterSolrJettyTestBase() throws Exception {
        if (jetty != null) {
            jetty.stop();
            jetty = null;
        }
        server = null;
    }

    public SolrServer getSolrServer() {
        if (server == null) {
            server = this.createNewSolrServer();
        }
        return server;
    }

    public SolrServer createNewSolrServer() {
        if (jetty != null) {
            try {
                String url = jetty.getBaseUrl().toString() + "/" + "collection1";
                HttpSolrServer s = new HttpSolrServer(url);
                s.setConnectionTimeout(DEFAULT_CONNECTION_TIMEOUT);
                s.setDefaultMaxConnectionsPerHost(100);
                s.setMaxTotalConnections(100);
                return s;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return new EmbeddedSolrServer(h.getCoreContainer(), "");
    }

    public static void setupJettyTestHome(File solrHome, String collection) throws Exception {
        if (solrHome.exists()) {
            FileUtils.deleteDirectory((File)solrHome);
        }
        SolrJettyTestBase.copySolrHomeToTemp(solrHome, collection);
    }

    public static void cleanUpJettyHome(File solrHome) throws Exception {
        if (solrHome.exists()) {
            FileUtils.deleteDirectory((File)solrHome);
        }
    }

    static {
        server = null;
    }
}

