/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import javax.management.JMException;
import org.apache.zookeeper.jmx.ManagedUtil;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkTestServer {
    public static final int TICK_TIME = 1000;
    private static Logger log = LoggerFactory.getLogger(ZkTestServer.class);
    protected final ZKServerMain zkServer = new ZKServerMain();
    private String zkDir;
    private int clientPort;
    private Thread zooThread;
    private int theTickTime = 1000;

    public ZkTestServer(String zkDir) {
        this.zkDir = zkDir;
    }

    public ZkTestServer(String zkDir, int port) {
        this.zkDir = zkDir;
        this.clientPort = port;
    }

    public String getZkHost() {
        return "127.0.0.1:" + this.zkServer.getLocalPort();
    }

    public String getZkAddress() {
        return "127.0.0.1:" + this.zkServer.getLocalPort() + "/solr";
    }

    public int getPort() {
        return this.zkServer.getLocalPort();
    }

    public void expire(final long sessionId) {
        this.zkServer.zooKeeperServer.expire(new SessionTracker.Session(){

            public long getSessionId() {
                return sessionId;
            }

            public int getTimeout() {
                return 4000;
            }

            public boolean isClosing() {
                return false;
            }
        });
    }

    public void run() throws InterruptedException {
        log.info("STARTING ZK TEST SERVER");
        this.zooThread = new Thread(){

            @Override
            public void run() {
                ServerConfig config = new ServerConfig(){
                    {
                        this.setClientPort(ZkTestServer.this.clientPort);
                        this.dataDir = ZkTestServer.this.zkDir;
                        this.dataLogDir = ZkTestServer.this.zkDir;
                        this.tickTime = ZkTestServer.this.theTickTime;
                    }

                    public void setClientPort(int clientPort) {
                        if (this.clientPortAddress != null) {
                            try {
                                this.clientPortAddress = new InetSocketAddress(InetAddress.getByName(this.clientPortAddress.getHostName()), clientPort);
                            }
                            catch (UnknownHostException e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            this.clientPortAddress = new InetSocketAddress(clientPort);
                        }
                        System.out.println("client port:" + this.clientPortAddress);
                    }
                };
                try {
                    ZkTestServer.this.zkServer.runFromConfig(config);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.zooThread.setDaemon(true);
        this.zooThread.start();
        int cnt = 0;
        int port = -1;
        try {
            port = this.getPort();
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        while (port < 1) {
            Thread.sleep(100L);
            try {
                port = this.getPort();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (cnt == 500) {
                throw new RuntimeException("Could not get the port for ZooKeeper server");
            }
            ++cnt;
        }
        log.info("start zk server on port:" + port);
    }

    public void shutdown() throws IOException {
        this.zkServer.shutdown();
    }

    public static boolean waitForServerDown(String hp, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                HostPort hpobj = ZkTestServer.parseHostPortList(hp).get(0);
                ZkTestServer.send4LetterWord(hpobj.host, hpobj.port, "stat");
            }
            catch (IOException e) {
                return true;
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {}
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String send4LetterWord(String host, int port, String cmd) throws IOException {
        log.info("connecting to " + host + " " + port);
        Socket sock = new Socket(host, port);
        BufferedReader reader = null;
        try {
            String line;
            OutputStream outstream = sock.getOutputStream();
            outstream.write(cmd.getBytes("US-ASCII"));
            outstream.flush();
            sock.shutdownOutput();
            reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), "US-ASCII"));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            sock.close();
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static List<HostPort> parseHostPortList(String hplist) {
        ArrayList<HostPort> alist = new ArrayList<HostPort>();
        for (String hp : hplist.split(",")) {
            int port;
            int idx = hp.lastIndexOf(58);
            String host = hp.substring(0, idx);
            try {
                port = Integer.parseInt(hp.substring(idx + 1));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Problem parsing " + hp + e.toString());
            }
            alist.add(new HostPort(host, port));
        }
        return alist;
    }

    public int getTheTickTime() {
        return this.theTickTime;
    }

    public void setTheTickTime(int theTickTime) {
        this.theTickTime = theTickTime;
    }

    public String getZkDir() {
        return this.zkDir;
    }

    public static class HostPort {
        String host;
        int port;

        HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    class ZKServerMain {
        private ServerCnxnFactory cnxnFactory;
        private ZooKeeperServer zooKeeperServer;

        ZKServerMain() {
        }

        protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException {
            try {
                ManagedUtil.registerLog4jMBeans();
            }
            catch (JMException e) {
                log.warn("Unable to register log4j JMX control", (Throwable)e);
            }
            ServerConfig config = new ServerConfig();
            if (args.length == 1) {
                config.parse(args[0]);
            } else {
                config.parse(args);
            }
            this.runFromConfig(config);
        }

        public void runFromConfig(ServerConfig config) throws IOException {
            log.info("Starting server");
            try {
                this.zooKeeperServer = new ZooKeeperServer();
                FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(config.getDataLogDir()), new File(config.getDataDir()));
                this.zooKeeperServer.setTxnLogFactory(ftxn);
                this.zooKeeperServer.setTickTime(config.getTickTime());
                this.zooKeeperServer.setMinSessionTimeout(config.getMinSessionTimeout());
                this.zooKeeperServer.setMaxSessionTimeout(config.getMaxSessionTimeout());
                this.cnxnFactory = ServerCnxnFactory.createFactory();
                this.cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
                this.cnxnFactory.startup(this.zooKeeperServer);
                this.cnxnFactory.join();
                if (this.zooKeeperServer.isRunning()) {
                    ZkTestServer.this.zkServer.shutdown();
                }
            }
            catch (InterruptedException e) {
                log.warn("Server interrupted", (Throwable)e);
            }
        }

        protected void shutdown() throws IOException {
            this.zooKeeperServer.shutdown();
            ZKDatabase zkDb = this.zooKeeperServer.getZKDatabase();
            if (zkDb != null) {
                zkDb.close();
            }
            if (this.cnxnFactory != null && this.cnxnFactory.getLocalPort() != 0) {
                ZkTestServer.waitForServerDown(ZkTestServer.this.getZkHost() + ":" + ZkTestServer.this.getPort(), 5000L);
            }
            if (this.cnxnFactory != null) {
                this.cnxnFactory.shutdown();
            }
        }

        public int getLocalPort() {
            int port;
            if (this.cnxnFactory == null) {
                throw new IllegalStateException("A port has not yet been selected");
            }
            try {
                port = this.cnxnFactory.getLocalPort();
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("A port has not yet been selected");
            }
            if (port == 0) {
                throw new IllegalStateException("A port has not yet been selected");
            }
            return port;
        }
    }
}

