/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;

public class MockTokenizerFactory
extends TokenizerFactory {
    final CharacterRunAutomaton pattern;
    final boolean enableChecks;

    public MockTokenizerFactory(Map<String, String> args) {
        super(args);
        String patternArg = this.get(args, "pattern", Arrays.asList("keyword", "simple", "whitespace"));
        this.pattern = "keyword".equalsIgnoreCase(patternArg) ? MockTokenizer.KEYWORD : ("simple".equalsIgnoreCase(patternArg) ? MockTokenizer.SIMPLE : MockTokenizer.WHITESPACE);
        this.enableChecks = this.getBoolean(args, "enableChecks", true);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    public MockTokenizer create(AttributeFactory factory, Reader input) {
        MockTokenizer t = new MockTokenizer(factory, input, this.pattern, false);
        t.setEnableChecks(this.enableChecks);
        return t;
    }
}

