/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.util.Map;
import java.util.regex.Pattern;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.core.CoreContainer;

public abstract class AbstractBadConfigTestBase
extends SolrTestCaseJ4 {
    protected final void assertConfigs(String solrconfigFile, String schemaFile, String errString) throws Exception {
        this.assertConfigs(solrconfigFile, schemaFile, null, errString);
    }

    protected final void assertConfigs(String solrconfigFile, String schemaFile, String solrHome, String errString) throws Exception {
        AbstractBadConfigTestBase.ignoreException(Pattern.quote(errString));
        try {
            if (null == solrHome) {
                AbstractBadConfigTestBase.initCore(solrconfigFile, schemaFile);
            } else {
                AbstractBadConfigTestBase.initCore(solrconfigFile, schemaFile, solrHome);
            }
            CoreContainer cc = h.getCoreContainer();
            for (Map.Entry entry : cc.getCoreInitFailures().entrySet()) {
                if (!AbstractBadConfigTestBase.matches((Exception)entry.getValue(), errString)) continue;
                return;
            }
        }
        catch (Exception e) {
            if (AbstractBadConfigTestBase.matches(e, errString)) {
                return;
            }
            throw e;
        }
        finally {
            AbstractBadConfigTestBase.deleteCore();
            AbstractBadConfigTestBase.resetExceptionIgnores();
        }
        AbstractBadConfigTestBase.fail((String)("Did not encounter any exception from: " + solrconfigFile + " using " + schemaFile));
    }

    private static boolean matches(Exception e, String errString) {
        for (Throwable t = e; t != null; t = t.getCause()) {
            if (t.getMessage() == null || -1 == t.getMessage().indexOf(errString)) continue;
            return true;
        }
        return false;
    }
}

