/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniSolrCloudCluster {
    private static Logger log = LoggerFactory.getLogger(MiniSolrCloudCluster.class);
    private ZkTestServer zkServer;
    private List<JettySolrRunner> jettys;
    private File testDir;
    private CloudSolrClient solrClient;

    public MiniSolrCloudCluster(int numServers, String hostContext, File baseDir, File solrXml, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class, String> extraRequestFilters) throws Exception {
        this.testDir = baseDir;
        String zkDir = this.testDir.getAbsolutePath() + File.separator + "zookeeper/server1/data";
        this.zkServer = new ZkTestServer(zkDir);
        this.zkServer.run();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkHost(), 10000, 45000, null);){
            zkClient.makePath("/solr/solr.xml", solrXml, false, true);
        }
        System.setProperty("solr.solrxml.location", "zookeeper");
        System.setProperty("zkHost", this.zkServer.getZkAddress());
        this.jettys = new LinkedList<JettySolrRunner>();
        for (int i = 0; i < numServers; ++i) {
            this.startJettySolrRunner(hostContext, extraServlets, extraRequestFilters);
        }
        this.solrClient = this.buildSolrClient();
    }

    public ZkTestServer getZkServer() {
        return this.zkServer;
    }

    public List<JettySolrRunner> getJettySolrRunners() {
        return Collections.unmodifiableList(this.jettys);
    }

    public JettySolrRunner startJettySolrRunner(String hostContext, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class, String> extraRequestFilters) throws Exception {
        String context = MiniSolrCloudCluster.getHostContextSuitableForServletContext(hostContext);
        JettySolrRunner jetty = new JettySolrRunner(this.testDir.getAbsolutePath(), context, 0, null, null, true, extraServlets, null, extraRequestFilters);
        jetty.start();
        this.jettys.add(jetty);
        return jetty;
    }

    public JettySolrRunner stopJettySolrRunner(int index) throws Exception {
        JettySolrRunner jetty = this.jettys.get(index);
        jetty.stop();
        this.jettys.remove(index);
        return jetty;
    }

    public void uploadConfigDir(File configDir, String configName) throws IOException, KeeperException, InterruptedException {
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 10000, 45000, null);){
            ZkController.uploadConfigDir((SolrZkClient)zkClient, (File)configDir, (String)configName);
        }
    }

    public NamedList<Object> createCollection(String name, int numShards, int replicationFactor, String configName, Map<String, String> collectionProperties) throws SolrServerException, IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CollectionParams.CollectionAction.CREATE.name()});
        params.set("name", new String[]{name});
        params.set("numShards", numShards);
        params.set("replicationFactor", replicationFactor);
        params.set("collection.configName", new String[]{configName});
        if (collectionProperties != null) {
            for (Map.Entry<String, String> property : collectionProperties.entrySet()) {
                params.set("property." + property.getKey(), new String[]{property.getValue()});
            }
        }
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath("/admin/collections");
        return this.solrClient.request((SolrRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        try {
            this.solrClient.shutdown();
            for (int i = this.jettys.size() - 1; i >= 0; --i) {
                this.stopJettySolrRunner(i);
            }
        }
        finally {
            try {
                this.zkServer.shutdown();
            }
            finally {
                System.clearProperty("solr.solrxml.location");
                System.clearProperty("zkHost");
            }
        }
    }

    public CloudSolrClient getSolrClient() {
        return this.solrClient;
    }

    protected CloudSolrClient buildSolrClient() {
        return new CloudSolrClient(this.getZkServer().getZkAddress());
    }

    private static String getHostContextSuitableForServletContext(String ctx) {
        if (ctx == null || "".equals(ctx)) {
            ctx = "/solr";
        }
        if (ctx.endsWith("/")) {
            ctx = ctx.substring(0, ctx.length() - 1);
        }
        if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        return ctx;
    }
}

