/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniSolrCloudCluster {
    private static Logger log = LoggerFactory.getLogger(MiniSolrCloudCluster.class);
    private final ZkTestServer zkServer;
    private final List<JettySolrRunner> jettys = new LinkedList<JettySolrRunner>();
    private final File testDir;
    private final CloudSolrClient solrClient;
    private final JettyConfig jettyConfig;
    private final ExecutorService executor = Executors.newCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("jetty-launcher"));

    public MiniSolrCloudCluster(int numServers, String hostContext, File baseDir, File solrXml, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters) throws Exception {
        this(numServers, hostContext, baseDir, solrXml, extraServlets, extraRequestFilters, null);
    }

    public MiniSolrCloudCluster(int numServers, String hostContext, File baseDir, File solrXml, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters, SSLConfig sslConfig) throws Exception {
        this(numServers, baseDir, solrXml, JettyConfig.builder().setContext(hostContext).withSSLConfig(sslConfig).withFilters(extraRequestFilters).withServlets(extraServlets).build());
    }

    public MiniSolrCloudCluster(int numServers, File baseDir, File solrXml, final JettyConfig jettyConfig) throws Exception {
        this.testDir = baseDir;
        this.jettyConfig = jettyConfig;
        String zkDir = this.testDir.getAbsolutePath() + File.separator + "zookeeper/server1/data";
        this.zkServer = new ZkTestServer(zkDir);
        this.zkServer.run();
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkHost(), 10000, 45000, null);){
            zkClient.makePath("/solr/solr.xml", solrXml, false, true);
            if (jettyConfig.sslConfig != null && jettyConfig.sslConfig.isSSLMode()) {
                zkClient.makePath("/solr/clusterprops.json", "{'urlScheme':'https'}".getBytes(Charsets.UTF_8), true);
            }
        }
        System.setProperty("solr.solrxml.location", "zookeeper");
        System.setProperty("zkHost", this.zkServer.getZkAddress());
        ArrayList<1> startups = new ArrayList<1>(numServers);
        for (int i = 0; i < numServers; ++i) {
            startups.add(new Callable<JettySolrRunner>(){

                @Override
                public JettySolrRunner call() throws Exception {
                    return MiniSolrCloudCluster.this.startJettySolrRunner(jettyConfig);
                }
            });
        }
        List<Future<JettySolrRunner>> futures = this.executor.invokeAll(startups);
        Exception startupError = this.checkForExceptions("Error starting up MiniSolrCloudCluster", futures);
        if (startupError != null) {
            try {
                this.shutdown();
            }
            catch (Throwable t) {
                startupError.addSuppressed(t);
            }
            throw startupError;
        }
        this.solrClient = this.buildSolrClient();
    }

    public ZkTestServer getZkServer() {
        return this.zkServer;
    }

    public List<JettySolrRunner> getJettySolrRunners() {
        return Collections.unmodifiableList(this.jettys);
    }

    public JettySolrRunner startJettySolrRunner(String hostContext, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters) throws Exception {
        return this.startJettySolrRunner(hostContext, extraServlets, extraRequestFilters, null);
    }

    public JettySolrRunner startJettySolrRunner(String hostContext, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters, SSLConfig sslConfig) throws Exception {
        return this.startJettySolrRunner(hostContext, JettyConfig.builder().withServlets(extraServlets).withFilters(extraRequestFilters).withSSLConfig(sslConfig).build());
    }

    public JettySolrRunner startJettySolrRunner(JettyConfig config) throws Exception {
        return this.startJettySolrRunner(config.context, config);
    }

    public JettySolrRunner startJettySolrRunner(String hostContext, JettyConfig config) throws Exception {
        String context = MiniSolrCloudCluster.getHostContextSuitableForServletContext(hostContext);
        JettyConfig newConfig = JettyConfig.builder((JettyConfig)config).setContext(context).build();
        JettySolrRunner jetty = new JettySolrRunner(this.testDir.getAbsolutePath(), newConfig);
        jetty.start();
        this.jettys.add(jetty);
        return jetty;
    }

    public JettySolrRunner startJettySolrRunner() throws Exception {
        return this.startJettySolrRunner(this.jettyConfig);
    }

    public JettySolrRunner stopJettySolrRunner(int index) throws Exception {
        JettySolrRunner jetty = this.jettys.get(index);
        jetty.stop();
        this.jettys.remove(index);
        return jetty;
    }

    protected JettySolrRunner stopJettySolrRunner(JettySolrRunner jetty) throws Exception {
        jetty.stop();
        return jetty;
    }

    public void uploadConfigDir(File configDir, String configName) throws IOException, KeeperException, InterruptedException {
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 10000, 45000, null);){
            ZkConfigManager manager = new ZkConfigManager(zkClient);
            manager.uploadConfigDir(configDir.toPath(), configName);
        }
    }

    public NamedList<Object> createCollection(String name, int numShards, int replicationFactor, String configName, Map<String, String> collectionProperties) throws SolrServerException, IOException {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CollectionParams.CollectionAction.CREATE.name()});
        params.set("name", new String[]{name});
        params.set("numShards", numShards);
        params.set("replicationFactor", replicationFactor);
        params.set("collection.configName", new String[]{configName});
        if (collectionProperties != null) {
            for (Map.Entry<String, String> property : collectionProperties.entrySet()) {
                params.set("property." + property.getKey(), new String[]{property.getValue()});
            }
        }
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath("/admin/collections");
        return this.solrClient.request((SolrRequest)request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        try {
            if (this.solrClient != null) {
                this.solrClient.close();
            }
            ArrayList<2> shutdowns = new ArrayList<2>(this.jettys.size());
            for (final JettySolrRunner jetty : this.jettys) {
                shutdowns.add(new Callable<JettySolrRunner>(){

                    @Override
                    public JettySolrRunner call() throws Exception {
                        return MiniSolrCloudCluster.this.stopJettySolrRunner(jetty);
                    }
                });
            }
            this.jettys.clear();
            List<Future<JettySolrRunner>> futures = this.executor.invokeAll(shutdowns);
            Exception shutdownError = this.checkForExceptions("Error shutting down MiniSolrCloudCluster", futures);
            if (shutdownError != null) {
                throw shutdownError;
            }
        }
        finally {
            this.executor.shutdown();
            this.executor.awaitTermination(2L, TimeUnit.SECONDS);
            try {
                this.zkServer.shutdown();
            }
            finally {
                System.clearProperty("solr.solrxml.location");
                System.clearProperty("zkHost");
            }
        }
    }

    public CloudSolrClient getSolrClient() {
        return this.solrClient;
    }

    protected CloudSolrClient buildSolrClient() {
        return new CloudSolrClient(this.getZkServer().getZkAddress());
    }

    private static String getHostContextSuitableForServletContext(String ctx) {
        if (ctx == null || "".equals(ctx)) {
            ctx = "/solr";
        }
        if (ctx.endsWith("/")) {
            ctx = ctx.substring(0, ctx.length() - 1);
        }
        if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        return ctx;
    }

    private Exception checkForExceptions(String message, Collection<Future<JettySolrRunner>> futures) throws InterruptedException {
        Exception parsed = new Exception(message);
        boolean ok = true;
        for (Future<JettySolrRunner> future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                parsed.addSuppressed(e.getCause());
                ok = false;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw e;
            }
        }
        return ok ? null : parsed;
    }
}

