/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpTables {
    static final Logger log = LoggerFactory.getLogger(IpTables.class);
    private static final boolean ENABLED = Boolean.getBoolean("solr.tests.use.iptables");
    private static final Set<Integer> BLOCK_PORTS = Collections.synchronizedSet(new HashSet());

    public static void blockPort(int port) throws IOException, InterruptedException {
        if (ENABLED) {
            log.info("Block port with iptables: " + port);
            BLOCK_PORTS.add(port);
            IpTables.runCmd(("iptables -A INPUT -p tcp --dport " + port + " -j DROP").split("\\s"));
            IpTables.runCmd(("iptables -A OUTPUT -p tcp --dport " + port + " -j DROP").split("\\s"));
        }
    }

    public static void unblockPort(int port) throws IOException, InterruptedException {
        if (ENABLED && BLOCK_PORTS.contains(port)) {
            log.info("Unblock port with iptables: " + port);
            IpTables.runCmd(("iptables -D INPUT -p tcp --dport " + port + " -j DROP").split("\\s"));
            IpTables.runCmd(("iptables -D OUTPUT -p tcp --dport " + port + " -j DROP").split("\\s"));
            BLOCK_PORTS.remove(port);
        }
    }

    public static void unblockAllPorts() throws IOException, InterruptedException {
        if (ENABLED) {
            Integer[] ports;
            log.info("Unblocking any ports previously blocked with iptables...");
            for (Integer port : ports = BLOCK_PORTS.toArray(new Integer[BLOCK_PORTS.size()])) {
                IpTables.unblockPort(port);
            }
        }
    }

    private static void runCmd(String ... cmd) throws IOException, InterruptedException {
        int exitCode = new ProcessBuilder(cmd).inheritIO().start().waitFor();
        if (exitCode != 0) {
            throw new IOException("iptables process did not exit successfully, exit code was: " + exitCode);
        }
    }
}

