/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudInspectUtil {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static boolean checkIfDiffIsLegal(SolrDocumentList a, SolrDocumentList b, String aName, String bName, Set<String> bAddFails, Set<String> bDeleteFails) {
        boolean legal = true;
        HashSet setA = new HashSet();
        for (SolrDocument sdoc : a) {
            setA.add(new HashMap(sdoc));
        }
        HashSet setB = new HashSet();
        for (SolrDocument sdoc : b) {
            setB.add(new HashMap(sdoc));
        }
        HashSet onlyInA = new HashSet(setA);
        onlyInA.removeAll(setB);
        HashSet onlyInB = new HashSet(setB);
        onlyInB.removeAll(setA);
        if (onlyInA.size() == 0 && onlyInB.size() == 0) {
            throw new IllegalArgumentException("No difference between list a and b");
        }
        System.err.println("###### Only in " + aName + ": " + onlyInA);
        System.err.println("###### Only in " + bName + ": " + onlyInB);
        for (Map doc : onlyInA) {
            if (bAddFails == null || !bAddFails.contains(doc.get("id"))) {
                legal = false;
                continue;
            }
            System.err.println("###### Only in " + aName + ": " + doc.get("id") + ", but this is expected because we found an add fail for " + doc.get("id"));
        }
        for (Map doc : onlyInB) {
            if (bDeleteFails == null || !bDeleteFails.contains(doc.get("id"))) {
                legal = false;
                continue;
            }
            System.err.println("###### Only in " + bName + ": " + doc.get("id") + ", but this is expected because we found a delete fail for " + doc.get("id"));
        }
        return legal;
    }

    public static Set<Map> showDiff(SolrDocumentList a, SolrDocumentList b, String aName, String bName) {
        System.err.println("######" + aName + ": " + CloudInspectUtil.toStr(a, 10));
        System.err.println("######" + bName + ": " + CloudInspectUtil.toStr(b, 10));
        System.err.println("###### sizes=" + a.size() + "," + b.size());
        HashSet setA = new HashSet();
        for (SolrDocument sdoc : a) {
            setA.add(new HashMap(sdoc));
        }
        HashSet setB = new HashSet();
        for (SolrDocument sdoc : b) {
            setB.add(new HashMap(sdoc));
        }
        HashSet<Map> onlyInA = new HashSet<Map>(setA);
        onlyInA.removeAll(setB);
        HashSet onlyInB = new HashSet(setB);
        onlyInB.removeAll(setA);
        if (onlyInA.size() > 0) {
            System.err.println("###### Only in " + aName + ": " + onlyInA);
        }
        if (onlyInB.size() > 0) {
            System.err.println("###### Only in " + bName + ": " + onlyInB);
        }
        onlyInA.addAll(onlyInB);
        return onlyInA;
    }

    private static String toStr(SolrDocumentList lst, int maxSz) {
        if (lst.size() <= maxSz) {
            return lst.toString();
        }
        StringBuilder sb = new StringBuilder("SolrDocumentList[sz=" + lst.size());
        if ((long)lst.size() != lst.getNumFound()) {
            sb.append(" numFound=").append(lst.getNumFound());
        }
        sb.append("]=");
        sb.append(lst.subList(0, maxSz / 2).toString());
        sb.append(" , [...] , ");
        sb.append(lst.subList(lst.size() - maxSz / 2, lst.size()).toString());
        return sb.toString();
    }

    public static boolean compareResults(SolrClient controlClient, SolrClient cloudClient) throws SolrServerException, IOException {
        return CloudInspectUtil.compareResults(controlClient, cloudClient, null, null);
    }

    public static boolean compareResults(SolrClient controlClient, SolrClient cloudClient, Set<String> addFails, Set<String> deleteFails) throws SolrServerException, IOException {
        boolean legal;
        ModifiableSolrParams q = SolrTestCaseJ4.params("q", "*:*", "rows", "0", "tests", "checkShardConsistency(vsControl)");
        SolrDocumentList controlDocList = controlClient.query((SolrParams)q).getResults();
        long controlDocs = controlDocList.getNumFound();
        SolrDocumentList cloudDocList = cloudClient.query((SolrParams)q).getResults();
        long cloudClientDocs = cloudDocList.getNumFound();
        q = SolrTestCaseJ4.params("q", "*:*", "rows", "100000", "fl", "id", "tests", "checkShardConsistency(vsControl)/getIds");
        controlDocList = controlClient.query((SolrParams)q).getResults();
        if (controlDocs != controlDocList.getNumFound()) {
            log.error("Something changed! control now " + controlDocList.getNumFound());
        }
        if (cloudClientDocs != (cloudDocList = cloudClient.query((SolrParams)q).getResults()).getNumFound()) {
            log.error("Something changed! cloudClient now " + cloudDocList.getNumFound());
        }
        if (controlDocs != cloudClientDocs && (addFails != null || deleteFails != null) && (legal = CloudInspectUtil.checkIfDiffIsLegal(controlDocList, cloudDocList, "controlDocList", "cloudDocList", addFails, deleteFails))) {
            return false;
        }
        Set<Map> differences = CloudInspectUtil.showDiff(controlDocList, cloudDocList, "controlDocList", "cloudDocList");
        try {
            boolean foundId = false;
            StringBuilder ids = new StringBuilder("id:(");
            for (Map doc : differences) {
                ids.append(" ").append(doc.get("id"));
                foundId = true;
            }
            ids.append(")");
            if (foundId) {
                q = SolrTestCaseJ4.params("q", ids.toString(), "rows", "100000", "fl", "id,_version_", "sort", "id asc", "tests", "checkShardConsistency(vsControl)/getVers");
                SolrDocumentList a = controlClient.query((SolrParams)q, SolrRequest.METHOD.POST).getResults();
                SolrDocumentList b = cloudClient.query((SolrParams)q, SolrRequest.METHOD.POST).getResults();
                log.error("controlClient :" + a + "\n\tcloudClient :" + b);
            }
        }
        catch (Exception e) {
            log.error("Unable to find versions for mismatched ids", (Throwable)e);
        }
        return true;
    }
}

