/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.JSONTestUtil;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.NoOpResponseParser;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.servlet.DirectSolrConnection;
import org.noggit.JSONUtil;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SolrTestCaseJ4.SuppressSSL
public class SolrTestCaseHS
extends SolrTestCaseJ4 {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @SafeVarargs
    public static <T> Set<T> set(T ... a) {
        LinkedHashSet<T> s = new LinkedHashSet<T>();
        for (T t : a) {
            s.add(t);
        }
        return s;
    }

    public static <T> T rand(T ... vals) {
        return vals[SolrTestCaseHS.random().nextInt(vals.length)];
    }

    public static ModifiableSolrParams params(SolrParams params, String ... moreParams) {
        ModifiableSolrParams msp = new ModifiableSolrParams(params);
        for (int i = 0; i < moreParams.length; i += 2) {
            msp.add(moreParams[i], new String[]{moreParams[i + 1]});
        }
        return msp;
    }

    public static Map<String, Object> toObject(SolrTestCaseJ4.Doc doc, IndexSchema schema, Collection<String> fieldNames) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (SolrTestCaseJ4.Fld fld : doc.fields) {
            if (fieldNames != null && !fieldNames.contains(fld.ftype.fname)) continue;
            SchemaField sf = schema.getField(fld.ftype.fname);
            if (!sf.multiValued()) {
                result.put(fld.ftype.fname, fld.vals.get(0));
                continue;
            }
            result.put(fld.ftype.fname, fld.vals);
        }
        return result;
    }

    public static Object createDocObjects(Map<Comparable, SolrTestCaseJ4.Doc> fullModel, Comparator sort, int rows, Collection<String> fieldNames) {
        ArrayList<SolrTestCaseJ4.Doc> docList = new ArrayList<SolrTestCaseJ4.Doc>(fullModel.values());
        Collections.sort(docList, sort);
        ArrayList<Map<String, Object>> sortedDocs = new ArrayList<Map<String, Object>>(rows);
        for (SolrTestCaseJ4.Doc doc : docList) {
            if (sortedDocs.size() >= rows) break;
            Map<String, Object> odoc = SolrTestCaseHS.toObject(doc, h.getCore().getLatestSchema(), fieldNames);
            sortedDocs.add(SolrTestCaseHS.toObject(doc, h.getCore().getLatestSchema(), fieldNames));
        }
        return sortedDocs;
    }

    public static void compare(SolrQueryRequest req, String path, Object model, Map<Comparable, SolrTestCaseJ4.Doc> fullModel) throws Exception {
        String strResponse = h.query(req);
        Object realResponse = ObjectBuilder.fromJSON((String)strResponse);
        String err = JSONTestUtil.matchObj(path, realResponse, model);
        if (err != null) {
            log.error("RESPONSE MISMATCH: " + err + "\n\trequest=" + req + "\n\tresult=" + strResponse + "\n\texpected=" + JSONUtil.toJSON((Object)model) + "\n\tmodel=" + fullModel);
            String rsp = h.query(req);
            SolrTestCaseHS.fail((String)err);
        }
    }

    public static void assertJQ(SolrClient client, SolrParams args, String ... tests) throws Exception {
        String resp = SolrTestCaseHS.getJSON(client, args);
        SolrTestCaseHS.matchJSON(resp, tests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void matchJSON(String response, String ... tests) throws Exception {
        boolean failed = false;
        for (String test : tests) {
            if (test == null || test.length() == 0) continue;
            try {
                failed = true;
                String err = JSONTestUtil.match(response, test, 1.0E-5);
                failed = false;
                if (err == null) continue;
                log.error("query failed JSON validation. error=" + err + "\n expected =" + test + "\n response = " + response);
                throw new RuntimeException(err);
            }
            finally {
                if (failed) {
                    log.error("JSON query validation threw an exception.\n expected =" + test + "\n response = " + response);
                }
            }
        }
    }

    public static void clearQueryCache() {
        SolrQueryRequest req = SolrTestCaseHS.req(new String[0]);
        req.getSearcher();
        req.close();
    }

    public static String getQueryResponse(SolrClient client, String wt, SolrParams params) throws Exception {
        if (client == null) {
            return SolrTestCaseHS.getQueryResponse(wt, params);
        }
        ModifiableSolrParams p = new ModifiableSolrParams(params);
        p.set("wt", new String[]{wt});
        String path = p.get("qt");
        p.remove("qt");
        p.set("indent", new String[]{"true"});
        QueryRequest query = new QueryRequest((SolrParams)p);
        if (path != null) {
            query.setPath(path);
        }
        query.setResponseParser((ResponseParser)new NoOpResponseParser(wt));
        NamedList rsp = client.request((SolrRequest)query);
        String raw = (String)rsp.get("response");
        return raw;
    }

    public static String getQueryResponse(String wt, SolrParams params) throws Exception {
        ModifiableSolrParams p = new ModifiableSolrParams(params);
        p.set("wt", new String[]{wt});
        String path = p.get("qt");
        p.remove("qt");
        p.set("indent", new String[]{"true"});
        DirectSolrConnection connection = new DirectSolrConnection(h.getCore());
        String raw = connection.request(path, (SolrParams)p, null);
        return raw;
    }

    public static String getJSON(SolrClient client, SolrParams params) throws Exception {
        return SolrTestCaseHS.getQueryResponse(client, "json", params);
    }

    public static Long add(SolrClient client, SolrInputDocument sdoc, ModifiableSolrParams params) throws Exception {
        if (client == null) {
            Long version = SolrTestCaseHS.addAndGetVersion(sdoc, (SolrParams)params);
            return version;
        }
        UpdateRequest updateRequest = new UpdateRequest();
        if (params != null) {
            updateRequest.setParams(params);
        }
        updateRequest.add(sdoc);
        UpdateResponse rsp = (UpdateResponse)updateRequest.process(client);
        return null;
    }

    static /* synthetic */ Logger access$000() {
        return log;
    }

    public static class SolrInstances {
        public List<SolrInstance> slist;
        public Client client;

        public SolrInstances(int numServers, String solrconfig, String schema) throws Exception {
            this.slist = new ArrayList<SolrInstance>(numServers);
            for (int i = 0; i < numServers; ++i) {
                SolrInstance instance = new SolrInstance(LuceneTestCase.createTempDir((String)("s" + i)).toFile(), solrconfig, schema);
                this.slist.add(instance);
                instance.start();
            }
        }

        public void stop() throws Exception {
            for (SolrInstance instance : this.slist) {
                instance.stop();
            }
        }

        public String getShards() {
            return SolrInstances.getShardsParam(this.slist);
        }

        public List<SolrClient> getSolrJs() {
            ArrayList<SolrClient> solrjs = new ArrayList<SolrClient>(this.slist.size());
            for (SolrInstance instance : this.slist) {
                solrjs.add(instance.getSolrJ());
            }
            return solrjs;
        }

        public Client getClient(int seed) {
            if (this.client == null) {
                this.client = new Client(this.getSolrJs(), seed);
            }
            return this.client;
        }

        public static String getShardsParam(List<SolrInstance> instances) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (SolrInstance instance : instances) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(instance.getShardURL());
            }
            return sb.toString();
        }
    }

    public static class SolrInstance {
        private static Logger log = SolrTestCaseHS.access$000();
        private String collection = "collection1";
        private int port = 0;
        private String solrconfigFile;
        private String schemaFile;
        private File baseDir;
        private JettySolrRunner jetty;
        private SolrClient solrj;
        private boolean homeCreated = false;

        public SolrInstance(File homeDir, String solrconfigFile, String schemaFile) {
            this.baseDir = homeDir;
            this.solrconfigFile = solrconfigFile;
            this.schemaFile = schemaFile;
        }

        public String getBaseDir() {
            return this.baseDir.toString();
        }

        public String getBaseURL() {
            return (SolrTestCaseJ4.isSSLMode() ? "https" : "http") + "://127.0.0.1:" + this.port + "/solr";
        }

        public String getCollectionURL() {
            return this.getBaseURL() + "/" + this.collection;
        }

        public String getShardURL() {
            return "127.0.0.1:" + this.port + "/solr" + "/" + this.collection;
        }

        public SolrClient getSolrJ() {
            if (this.solrj == null) {
                this.solrj = new HttpSolrClient(this.getCollectionURL());
            }
            return this.solrj;
        }

        public void setPort(int port) {
            this.port = port;
        }

        public void createHome() throws Exception {
            this.homeCreated = true;
            SolrTestCaseJ4.copySolrHomeToTemp(this.baseDir, this.collection);
            SolrInstance.copyConfFile(this.baseDir, this.collection, this.solrconfigFile);
            SolrInstance.copyConfFile(this.baseDir, this.collection, this.schemaFile);
            File collDir = new File(this.baseDir, this.collection);
            try (OutputStreamWriter w = new OutputStreamWriter(Files.newOutputStream(collDir.toPath().resolve("core.properties"), new OpenOption[0]), Charsets.UTF_8);){
                Properties coreProps = new Properties();
                coreProps.put("name", "collection1");
                coreProps.put("config", this.solrconfigFile);
                coreProps.put("schema", this.schemaFile);
                coreProps.store(w, "");
            }
        }

        public void start() throws Exception {
            if (!this.homeCreated) {
                this.createHome();
            }
            if (this.jetty == null) {
                this.jetty = new JettySolrRunner(this.baseDir.getAbsolutePath(), "/solr", this.port, this.solrconfigFile, this.schemaFile, true, null, null, null);
            }
            System.setProperty("solr.tests.maxBufferedDocs", String.valueOf(100000));
            this.jetty.start();
            this.port = this.jetty.getLocalPort();
            log.info("===> Started solr server port=" + this.port + " home=" + this.getBaseDir());
        }

        public void stop() throws Exception {
            this.jetty.stop();
            if (this.solrj != null) {
                this.solrj.close();
            }
        }

        public void tearDown() throws Exception {
            IOUtils.deleteFilesIfExist((Path[])new Path[]{this.baseDir.toPath()});
        }

        private static void copyConfFile(File dstRoot, String destCollection, String file) throws Exception {
            File subHome = new File(dstRoot, destCollection + File.separator + "conf");
            String top = SolrTestCaseJ4.TEST_HOME() + "/collection1/conf";
            FileUtils.copyFile((File)new File(top, file), (File)new File(subHome, file));
        }

        public void copyConfigFile(File dstRoot, String destCollection, String file) throws Exception {
            if (!this.homeCreated) {
                this.createHome();
            }
            File subHome = new File(dstRoot, destCollection + File.separator + "conf");
            String top = SolrTestCaseJ4.TEST_HOME() + "/collection1/conf";
            FileUtils.copyFile((File)new File(top, file), (File)new File(subHome, file));
        }
    }

    public static class ClientProvider {
        public static String idField = "id";
        List<SolrClient> clients;
        Random r;
        int hashSeed;

        public ClientProvider(List<SolrClient> clients, int seed) {
            this.hashSeed = Client.hash(seed);
            this.clients = clients;
            this.r = new Random(seed);
        }

        public SolrClient client(SolrInputDocument sdoc, SolrParams params) {
            String idStr = null;
            if (sdoc != null) {
                idStr = sdoc.getFieldValue(idField).toString();
            } else if (params != null) {
                idStr = params.get(idField);
            }
            int hash = idStr != null ? idStr.hashCode() ^ this.hashSeed : this.r.nextInt();
            return this.clients.get((hash & Integer.MAX_VALUE) % this.clients.size());
        }

        public List<SolrClient> all() {
            return this.clients;
        }
    }

    public static class Client {
        ClientProvider provider;
        ModifiableSolrParams queryDefaults;
        public Tester tester = new Tester();
        public static Client localClient = new Client(null, 1);

        public static Client localClient() {
            return new Client(null, 1);
        }

        public Client(List<SolrClient> clients, int seed) {
            if (clients != null) {
                this.provider = new ClientProvider(clients, seed);
            }
        }

        public static int hash(int x) {
            x = (x >>> 16 ^ x) * 73244475;
            x = (x >>> 16 ^ x) * 73244475;
            x = x >>> 16 ^ x;
            return x;
        }

        public ModifiableSolrParams queryDefaults() {
            if (this.queryDefaults == null) {
                this.queryDefaults = new ModifiableSolrParams();
            }
            return this.queryDefaults;
        }

        public boolean local() {
            return this.provider == null;
        }

        public void testJQ(SolrParams args, String ... tests) throws Exception {
            if (this.queryDefaults != null) {
                ModifiableSolrParams newParams = SolrTestCaseHS.params((SolrParams)this.queryDefaults, new String[0]);
                newParams.add(args);
                args = newParams;
            }
            SolrClient client = this.provider == null ? null : this.provider.client(null, args);
            this.tester.assertJQ(client, args, tests);
        }

        public Long add(SolrInputDocument sdoc, ModifiableSolrParams params) throws Exception {
            SolrClient client = this.provider == null ? null : this.provider.client(sdoc, (SolrParams)params);
            return SolrTestCaseHS.add(client, sdoc, params);
        }

        public void commit() throws IOException, SolrServerException {
            if (this.local()) {
                SolrTestCaseJ4.assertU(SolrTestCaseJ4.commit(new String[0]));
                return;
            }
            for (SolrClient client : this.provider.all()) {
                client.commit();
            }
        }

        public void deleteByQuery(String query, ModifiableSolrParams params) throws IOException, SolrServerException {
            if (this.local()) {
                SolrTestCaseJ4.assertU(SolrTestCaseJ4.delQ(query));
                return;
            }
            for (SolrClient client : this.provider.all()) {
                client.deleteByQuery(query);
            }
        }

        public static class Tester {
            public void assertJQ(SolrClient client, SolrParams args, String ... tests) throws Exception {
                SolrTestCaseHS.assertJQ(client, args, tests);
            }
        }
    }
}

