/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZkTestCase
extends SolrTestCaseJ4 {
    private static final String ZOOKEEPER_FORCE_SYNC = "zookeeper.forceSync";
    public static final int TIMEOUT = 45000;
    private static final boolean DEBUG = false;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static File SOLRHOME;
    protected static ZkTestServer zkServer;
    protected static String zkDir;

    @BeforeClass
    public static void azt_beforeClass() throws Exception {
        zkDir = AbstractZkTestCase.createTempDir((String)"zkData").toFile().getAbsolutePath();
        zkServer = new ZkTestServer(zkDir);
        zkServer.run();
        System.setProperty("solrcloud.skip.autorecovery", "true");
        System.setProperty("zkHost", zkServer.getZkAddress());
        System.setProperty("jetty.port", "0000");
        System.setProperty(ZOOKEEPER_FORCE_SYNC, "false");
        AbstractZkTestCase.buildZooKeeper(zkServer.getZkHost(), zkServer.getZkAddress(), SOLRHOME, "solrconfig.xml", "schema.xml");
        AbstractZkTestCase.initCore("solrconfig.xml", "schema.xml");
    }

    static void buildZooKeeper(String zkHost, String zkAddress, String config, String schema) throws Exception {
        AbstractZkTestCase.buildZooKeeper(zkHost, zkAddress, SOLRHOME, config, schema);
    }

    public static void buildZooKeeper(String zkHost, String zkAddress, File solrhome, String config, String schema) throws Exception {
        SolrZkClient zkClient = new SolrZkClient(zkHost, 45000, 45000, null);
        zkClient.makePath("/solr", false, true);
        zkClient.close();
        zkClient = new SolrZkClient(zkAddress, 45000);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("configName", "conf1");
        ZkNodeProps zkProps = new ZkNodeProps(props);
        zkClient.makePath("/collections/collection1", Utils.toJSON((Object)zkProps), CreateMode.PERSISTENT, true);
        zkClient.makePath("/collections/collection1/shards", CreateMode.PERSISTENT, true);
        zkClient.makePath("/collections/control_collection", Utils.toJSON((Object)zkProps), CreateMode.PERSISTENT, true);
        zkClient.makePath("/collections/control_collection/shards", CreateMode.PERSISTENT, true);
        AbstractZkTestCase.putConfig("conf1", zkClient, solrhome, config, "solrconfig.xml");
        AbstractZkTestCase.putConfig("conf1", zkClient, solrhome, schema, "schema.xml");
        AbstractZkTestCase.putConfig("conf1", zkClient, solrhome, "solrconfig.snippet.randomindexconfig.xml");
        AbstractZkTestCase.putConfig("conf1", zkClient, solrhome, "stopwords.txt");
        AbstractZkTestCase.putConfig("conf1", zkClient, solrhome, "protwords.txt");
        AbstractZkTestCase.putConfig("conf1", zkClient, solrhome, "currency.xml");
        AbstractZkTestCase.putConfig("conf1", zkClient, solrhome, "enumsConfig.xml");
        AbstractZkTestCase.putConfig("conf1", zkClient, solrhome, "open-exchange-rates.json");
        AbstractZkTestCase.putConfig("conf1", zkClient, solrhome, "mapping-ISOLatin1Accent.txt");
        AbstractZkTestCase.putConfig("conf1", zkClient, solrhome, "old_synonyms.txt");
        AbstractZkTestCase.putConfig("conf1", zkClient, solrhome, "synonyms.txt");
        zkClient.close();
    }

    public static void putConfig(String confName, SolrZkClient zkClient, File solrhome, String name) throws Exception {
        AbstractZkTestCase.putConfig(confName, zkClient, solrhome, name, name);
    }

    public static void putConfig(String confName, SolrZkClient zkClient, File solrhome, String srcName, String destName) throws Exception {
        File file = new File(solrhome, "collection1" + File.separator + "conf" + File.separator + srcName);
        if (!file.exists()) {
            log.info("skipping " + file.getAbsolutePath() + " because it doesn't exist");
            return;
        }
        String destPath = "/configs/" + confName + "/" + destName;
        log.info("put " + file.getAbsolutePath() + " to " + destPath);
        zkClient.makePath(destPath, file, false, true);
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @AfterClass
    public static void azt_afterClass() throws Exception {
        AbstractZkTestCase.deleteCore();
        System.clearProperty("zkHost");
        System.clearProperty("solr.test.sys.prop1");
        System.clearProperty("solr.test.sys.prop2");
        System.clearProperty("solrcloud.skip.autorecovery");
        System.clearProperty("jetty.port");
        System.clearProperty(ZOOKEEPER_FORCE_SYNC);
        if (zkServer != null) {
            zkServer.shutdown();
            zkServer = null;
        }
        zkDir = null;
    }

    protected void printLayout(String zkHost) throws Exception {
        SolrZkClient zkClient = new SolrZkClient(zkHost, 45000);
        zkClient.printLayoutToStdOut();
        zkClient.close();
    }

    public static void makeSolrZkNode(String zkHost) throws Exception {
        SolrZkClient zkClient = new SolrZkClient(zkHost, 45000);
        zkClient.makePath("/solr", false, true);
        zkClient.close();
    }

    public static void tryCleanSolrZkNode(String zkHost) throws Exception {
        AbstractZkTestCase.tryCleanPath(zkHost, "/solr");
    }

    static void tryCleanPath(String zkHost, String path) throws Exception {
        SolrZkClient zkClient = new SolrZkClient(zkHost, 45000);
        if (zkClient.exists(path, true).booleanValue()) {
            zkClient.clean(path);
        }
        zkClient.close();
    }

    static {
        try {
            SOLRHOME = new File(AbstractZkTestCase.TEST_HOME());
        }
        catch (RuntimeException e) {
            log.warn("TEST_HOME() does not exist - solrj test?");
        }
    }
}

