/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.solr.BaseDistributedSearchTestCase;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.cloud.AbstractZkTestCase;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.Diagnostics;
import org.apache.zookeeper.KeeperException;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDistribZkTestBase
extends BaseDistributedSearchTestCase {
    private static final String REMOVE_VERSION_FIELD = "remove.version.field";
    private static final String ENABLE_UPDATE_LOG = "enable.update.log";
    private static final String ZK_HOST = "zkHost";
    private static final String ZOOKEEPER_FORCE_SYNC = "zookeeper.forceSync";
    protected static final String DEFAULT_COLLECTION = "collection1";
    private static final boolean DEBUG = false;
    protected ZkTestServer zkServer;
    private AtomicInteger homeCount = new AtomicInteger();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @BeforeClass
    public static void beforeThisClass() throws Exception {
    }

    @Override
    public void distribSetUp() throws Exception {
        super.distribSetUp();
        String zkDir = this.testDir.getAbsolutePath() + File.separator + "zookeeper/server1/data";
        this.zkServer = new ZkTestServer(zkDir);
        this.zkServer.run();
        System.setProperty(ZK_HOST, this.zkServer.getZkAddress());
        System.setProperty(ENABLE_UPDATE_LOG, "true");
        System.setProperty(REMOVE_VERSION_FIELD, "true");
        System.setProperty(ZOOKEEPER_FORCE_SYNC, "false");
        System.setProperty("solr.tests.allow_reading_files_still_open_for_write", "true");
        String schema = this.getCloudSchemaFile();
        if (schema == null) {
            schema = "schema.xml";
        }
        AbstractZkTestCase.buildZooKeeper(this.zkServer.getZkHost(), this.zkServer.getZkAddress(), this.getCloudSolrConfig(), schema);
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
    }

    protected String getCloudSolrConfig() {
        return "solrconfig-tlog.xml";
    }

    protected String getCloudSchemaFile() {
        return AbstractDistribZkTestBase.getSchemaFile();
    }

    @Override
    protected void createServers(int numShards) throws Exception {
        int i;
        File controlHome = new File(new File(this.getSolrHome()).getParentFile(), "control" + this.homeCount.incrementAndGet());
        FileUtils.copyDirectory((File)new File(this.getSolrHome()), (File)controlHome);
        this.setupJettySolrHome(controlHome);
        System.setProperty("collection", "control_collection");
        String numShardsS = System.getProperty("numShards");
        System.setProperty("numShards", "1");
        this.controlJetty = this.createJetty(controlHome, null);
        System.clearProperty("collection");
        if (numShardsS != null) {
            System.setProperty("numShards", numShardsS);
        } else {
            System.clearProperty("numShards");
        }
        this.controlClient = this.createNewSolrClient(this.controlJetty.getLocalPort());
        StringBuilder sb = new StringBuilder();
        for (i = 1; i <= numShards; ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            File jettyHome = new File(new File(this.getSolrHome()).getParentFile(), "jetty" + this.homeCount.incrementAndGet());
            this.setupJettySolrHome(jettyHome);
            JettySolrRunner j = this.createJetty(jettyHome, null, "shard" + (i + 2));
            this.jettys.add(j);
            this.clients.add(this.createNewSolrClient(j.getLocalPort()));
            sb.append(this.buildUrl(j.getLocalPort()));
        }
        this.shards = sb.toString();
        for (i = 1; i <= numShards; ++i) {
            ZkStateReader zkStateReader = ((JettySolrRunner)this.jettys.get(0)).getCoreContainer().getZkController().getZkStateReader();
            zkStateReader.getLeaderRetry(DEFAULT_COLLECTION, "shard" + (i + 2), 15000);
        }
    }

    protected void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose) throws Exception {
        this.waitForRecoveriesToFinish(collection, zkStateReader, verbose, true);
    }

    protected void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose, boolean failOnTimeout) throws Exception {
        AbstractDistribZkTestBase.waitForRecoveriesToFinish(collection, zkStateReader, verbose, failOnTimeout, 330);
    }

    public static void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose, boolean failOnTimeout, int timeoutSeconds) throws Exception {
        log.info("Wait for recoveries to finish - collection: " + collection + " failOnTimeout:" + failOnTimeout + " timeout (sec):" + timeoutSeconds);
        boolean cont = true;
        int cnt = 0;
        while (cont) {
            if (verbose) {
                System.out.println("-");
            }
            boolean sawLiveRecovering = false;
            ClusterState clusterState = zkStateReader.getClusterState();
            Map slices = clusterState.getSlicesMap(collection);
            AbstractDistribZkTestBase.assertNotNull((String)("Could not find collection:" + collection), (Object)slices);
            for (Map.Entry entry : slices.entrySet()) {
                Slice slice = (Slice)entry.getValue();
                if (slice.getState() == Slice.State.CONSTRUCTION) {
                    if (verbose) {
                        System.out.println("Found a slice in construction state; will wait.");
                    }
                    sawLiveRecovering = true;
                }
                Map shards = slice.getReplicasMap();
                for (Map.Entry shard : shards.entrySet()) {
                    Replica.State state;
                    if (verbose) {
                        System.out.println("replica:" + ((Replica)shard.getValue()).getName() + " rstate:" + ((Replica)shard.getValue()).getStr("state") + " live:" + clusterState.liveNodesContain(((Replica)shard.getValue()).getNodeName()));
                    }
                    if ((state = ((Replica)shard.getValue()).getState()) != Replica.State.RECOVERING && state != Replica.State.DOWN && state != Replica.State.RECOVERY_FAILED || !clusterState.liveNodesContain(((Replica)shard.getValue()).getStr("node_name"))) continue;
                    sawLiveRecovering = true;
                }
            }
            if (!sawLiveRecovering || cnt == timeoutSeconds) {
                if (!sawLiveRecovering) {
                    if (verbose) {
                        System.out.println("no one is recoverying");
                    }
                } else {
                    if (verbose) {
                        System.out.println("Gave up waiting for recovery to finish..");
                    }
                    if (failOnTimeout) {
                        Diagnostics.logThreadDumps((String)"Gave up waiting for recovery to finish.  THREAD DUMP:");
                        zkStateReader.getZkClient().printLayoutToStdOut();
                        AbstractDistribZkTestBase.fail((String)("There are still nodes recoverying - waited for " + timeoutSeconds + " seconds"));
                        return;
                    }
                }
                cont = false;
            } else {
                Thread.sleep(1000L);
            }
            ++cnt;
        }
        log.info("Recoveries finished - collection: " + collection);
    }

    public static void waitForCollectionToDisappear(String collection, ZkStateReader zkStateReader, boolean verbose, boolean failOnTimeout, int timeoutSeconds) throws Exception {
        log.info("Wait for collection to disappear - collection: " + collection + " failOnTimeout:" + failOnTimeout + " timeout (sec):" + timeoutSeconds);
        boolean cont = true;
        int cnt = 0;
        while (cont) {
            ClusterState clusterState;
            if (verbose) {
                System.out.println("-");
            }
            if (!(clusterState = zkStateReader.getClusterState()).hasCollection(collection)) break;
            if (cnt == timeoutSeconds) {
                if (verbose) {
                    System.out.println("Gave up waiting for " + collection + " to disappear..");
                }
                if (failOnTimeout) {
                    Diagnostics.logThreadDumps((String)("Gave up waiting for " + collection + " to disappear.  THREAD DUMP:"));
                    zkStateReader.getZkClient().printLayoutToStdOut();
                    AbstractDistribZkTestBase.fail((String)("The collection (" + collection + ") is still present - waited for " + timeoutSeconds + " seconds"));
                    return;
                }
                cont = false;
            } else {
                Thread.sleep(1000L);
            }
            ++cnt;
        }
        log.info("Collection has disappeared - collection: " + collection);
    }

    public static void verifyReplicaStatus(ZkStateReader reader, String collection, String shard, String coreNodeName, Replica.State expectedState) throws InterruptedException {
        int maxIterations = 100;
        Replica.State coreState = null;
        while (maxIterations-- > 0) {
            Replica replica;
            Slice slice = reader.getClusterState().getSlice(collection, shard);
            if (slice != null && (replica = (Replica)slice.getReplicasMap().get(coreNodeName)) != null && (coreState = replica.getState()) == expectedState) {
                return;
            }
            Thread.sleep(50L);
        }
        AbstractDistribZkTestBase.fail((String)("Illegal state, was: " + coreState + " expected:" + expectedState + " clusterState:" + reader.getClusterState()));
    }

    protected static void assertAllActive(String collection, ZkStateReader zkStateReader) throws KeeperException, InterruptedException {
        zkStateReader.forceUpdateCollection(collection);
        ClusterState clusterState = zkStateReader.getClusterState();
        Map slices = clusterState.getSlicesMap(collection);
        if (slices == null) {
            throw new IllegalArgumentException("Cannot find collection:" + collection);
        }
        for (Map.Entry entry : slices.entrySet()) {
            Slice slice = (Slice)entry.getValue();
            if (slice.getState() != Slice.State.ACTIVE) {
                AbstractDistribZkTestBase.fail((String)("Not all shards are ACTIVE - found a shard " + slice.getName() + " that is: " + slice.getState()));
            }
            Map shards = slice.getReplicasMap();
            for (Map.Entry shard : shards.entrySet()) {
                Replica replica = (Replica)shard.getValue();
                if (replica.getState() == Replica.State.ACTIVE) continue;
                AbstractDistribZkTestBase.fail((String)("Not all replicas are ACTIVE - found a replica " + replica.getName() + " that is: " + replica.getState()));
            }
        }
    }

    @Override
    public void distribTearDown() throws Exception {
        System.clearProperty(ZK_HOST);
        System.clearProperty("collection");
        System.clearProperty(ENABLE_UPDATE_LOG);
        System.clearProperty(REMOVE_VERSION_FIELD);
        System.clearProperty("solr.directoryFactory");
        System.clearProperty("solr.test.sys.prop1");
        System.clearProperty("solr.test.sys.prop2");
        System.clearProperty(ZOOKEEPER_FORCE_SYNC);
        System.clearProperty("solr.tests.allow_reading_files_still_open_for_write");
        AbstractDistribZkTestBase.resetExceptionIgnores();
        try {
            super.distribTearDown();
        }
        finally {
            this.zkServer.shutdown();
        }
    }

    protected void printLayout() throws Exception {
        SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkHost(), 45000);
        zkClient.printLayoutToStdOut();
        zkClient.close();
    }

    protected void restartZk(int pauseMillis) throws Exception {
        log.info("Restarting ZK with a pause of {}ms in between", (Object)pauseMillis);
        this.zkServer.shutdown();
        Thread.sleep(pauseMillis);
        this.zkServer = new ZkTestServer(this.zkServer.getZkDir(), this.zkServer.getPort());
        this.zkServer.run();
    }
}

