/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.AtomicLongMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.management.JMException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.jmx.ManagedUtil;
import org.apache.zookeeper.server.NIOServerCnxn;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerCnxn;
import org.apache.zookeeper.server.ServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.SessionTracker;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkTestServer {
    public static final int TICK_TIME = 1000;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected final ZKServerMain zkServer = new ZKServerMain();
    private String zkDir;
    private int clientPort;
    private volatile Thread zooThread;
    private int theTickTime = 1000;

    public ZkTestServer(String zkDir) {
        this.zkDir = zkDir;
    }

    public ZkTestServer(String zkDir, int port) {
        String limiterAction;
        this.zkDir = zkDir;
        this.clientPort = port;
        String reportAction = System.getProperty("tests.zk.violationReportAction");
        if (reportAction != null) {
            log.info("Overriding violation report action to: {}", (Object)reportAction);
            this.setViolationReportAction(LimitViolationAction.valueOf(reportAction));
        }
        if ((limiterAction = System.getProperty("tests.zk.limiterAction")) != null) {
            log.info("Overriding limiter action to: {}", (Object)limiterAction);
            this.getLimiter().setAction(LimitViolationAction.valueOf(limiterAction));
        }
    }

    public String getZkHost() {
        return "127.0.0.1:" + this.zkServer.getLocalPort();
    }

    public String getZkAddress() {
        return this.getZkAddress("/solr");
    }

    public String getZkAddress(String chroot) {
        if (!chroot.startsWith("/")) {
            chroot = "/" + chroot;
        }
        return "127.0.0.1:" + this.zkServer.getLocalPort() + chroot;
    }

    public void ensurePathExists(String path) throws IOException {
        try (SolrZkClient client = new SolrZkClient(this.getZkHost(), 10000);){
            client.makePath(path, false);
        }
        catch (InterruptedException | KeeperException e) {
            throw new IOException("Error checking path " + path, SolrZkClient.checkInterrupted((Throwable)e));
        }
    }

    public int getPort() {
        return this.zkServer.getLocalPort();
    }

    public void expire(final long sessionId) {
        this.zkServer.zooKeeperServer.expire(new SessionTracker.Session(){

            public long getSessionId() {
                return sessionId;
            }

            public int getTimeout() {
                return 4000;
            }

            public boolean isClosing() {
                return false;
            }
        });
    }

    public ZKDatabase getZKDatabase() {
        return this.zkServer.zooKeeperServer.getZKDatabase();
    }

    public void setZKDatabase(ZKDatabase zkDb) {
        this.zkServer.zooKeeperServer.setZKDatabase(zkDb);
    }

    public void run() throws InterruptedException {
        log.info("STARTING ZK TEST SERVER");
        this.zooThread = new Thread(){

            @Override
            public void run() {
                ServerConfig config = new ServerConfig(){
                    {
                        this.setClientPort(ZkTestServer.this.clientPort);
                        this.dataDir = ZkTestServer.this.zkDir;
                        this.dataLogDir = ZkTestServer.this.zkDir;
                        this.tickTime = ZkTestServer.this.theTickTime;
                    }

                    public void setClientPort(int clientPort) {
                        if (this.clientPortAddress != null) {
                            try {
                                this.clientPortAddress = new InetSocketAddress(InetAddress.getByName(this.clientPortAddress.getHostName()), clientPort);
                            }
                            catch (UnknownHostException e) {
                                throw new RuntimeException(e);
                            }
                        } else {
                            this.clientPortAddress = new InetSocketAddress(clientPort);
                        }
                        log.info("client port:" + this.clientPortAddress);
                    }
                };
                try {
                    ZkTestServer.this.zkServer.runFromConfig(config);
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.zooThread.setDaemon(true);
        this.zooThread.start();
        int cnt = 0;
        int port = -1;
        try {
            port = this.getPort();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        while (port < 1) {
            Thread.sleep(100L);
            try {
                port = this.getPort();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (cnt == 500) {
                throw new RuntimeException("Could not get the port for ZooKeeper server");
            }
            ++cnt;
        }
        log.info("start zk server on port:" + port);
    }

    public void shutdown() throws IOException, InterruptedException {
        this.zkServer.shutdown();
        try {
            this.zooThread.join();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static boolean waitForServerDown(String hp, long timeoutMs) {
        TimeOut timeout = new TimeOut(timeoutMs, TimeUnit.MILLISECONDS);
        while (true) {
            try {
                HostPort hpobj = ZkTestServer.parseHostPortList(hp).get(0);
                ZkTestServer.send4LetterWord(hpobj.host, hpobj.port, "stat");
            }
            catch (IOException e) {
                return true;
            }
            if (timeout.hasTimedOut()) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    /*
     * Loose catch block
     */
    public static String send4LetterWord(String host, int port, String cmd) throws IOException {
        log.info("connecting to " + host + " " + port);
        try (BufferedReader reader = null;){
            try (Socket sock = new Socket(host, port);){
                String line;
                OutputStream outstream = sock.getOutputStream();
                outstream.write(cmd.getBytes(StandardCharsets.US_ASCII));
                outstream.flush();
                sock.shutdownOutput();
                reader = new BufferedReader(new InputStreamReader(sock.getInputStream(), "US-ASCII"));
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                String string = sb.toString();
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public static List<HostPort> parseHostPortList(String hplist) {
        ArrayList<HostPort> alist = new ArrayList<HostPort>();
        for (String hp : hplist.split(",")) {
            int port;
            int idx = hp.lastIndexOf(58);
            String host = hp.substring(0, idx);
            try {
                port = Integer.parseInt(hp.substring(idx + 1));
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Problem parsing " + hp + e.toString());
            }
            alist.add(new HostPort(host, port));
        }
        return alist;
    }

    public int getTheTickTime() {
        return this.theTickTime;
    }

    public void setTheTickTime(int theTickTime) {
        this.theTickTime = theTickTime;
    }

    public String getZkDir() {
        return this.zkDir;
    }

    public void setViolationReportAction(LimitViolationAction violationReportAction) {
        this.zkServer.setViolationReportAction(violationReportAction);
    }

    public ZKServerMain.WatchLimiter getLimiter() {
        return this.zkServer.getLimiter();
    }

    public static class HostPort {
        String host;
        int port;

        HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    class ZKServerMain {
        private ServerCnxnFactory cnxnFactory;
        private ZooKeeperServer zooKeeperServer;
        private LimitViolationAction violationReportAction = LimitViolationAction.REPORT;
        private WatchLimiter limiter = new WatchLimiter(1L, LimitViolationAction.IGNORE);

        ZKServerMain() {
        }

        protected void initializeAndRun(String[] args) throws QuorumPeerConfig.ConfigException, IOException {
            try {
                ManagedUtil.registerLog4jMBeans();
            }
            catch (JMException e) {
                log.warn("Unable to register log4j JMX control", (Throwable)e);
            }
            ServerConfig config = new ServerConfig();
            if (args.length == 1) {
                config.parse(args[0]);
            } else {
                config.parse(args);
            }
            this.runFromConfig(config);
        }

        public void runFromConfig(ServerConfig config) throws IOException {
            log.info("Starting server");
            try {
                String limitViolations;
                System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
                FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(config.getDataLogDir()), new File(config.getDataDir()));
                this.zooKeeperServer = new ZooKeeperServer(ftxn, config.getTickTime(), config.getMinSessionTimeout(), config.getMaxSessionTimeout(), null, (ZKDatabase)new TestZKDatabase(ftxn, this.limiter));
                this.cnxnFactory = new TestServerCnxnFactory(this.limiter);
                this.cnxnFactory.configure(config.getClientPortAddress(), config.getMaxClientCnxns());
                this.cnxnFactory.startup(this.zooKeeperServer);
                this.cnxnFactory.join();
                ZkTestServer.this.zkServer.shutdown();
                if (this.violationReportAction != LimitViolationAction.IGNORE && !(limitViolations = this.limiter.reportLimitViolations()).isEmpty()) {
                    log.warn("Watch limit violations: {}", (Object)limitViolations);
                    if (this.violationReportAction == LimitViolationAction.FAIL) {
                        throw new AssertionError((Object)"Parallel watch limits violated");
                    }
                }
            }
            catch (InterruptedException e) {
                log.warn("Server interrupted", (Throwable)e);
            }
        }

        protected void shutdown() throws IOException {
            this.zooKeeperServer.shutdown();
            ZKDatabase zkDb = this.zooKeeperServer.getZKDatabase();
            if (this.cnxnFactory != null && this.cnxnFactory.getLocalPort() != 0) {
                ZkTestServer.waitForServerDown(ZkTestServer.this.getZkHost() + ":" + ZkTestServer.this.getPort(), 5000L);
            }
            if (this.cnxnFactory != null) {
                this.cnxnFactory.shutdown();
                try {
                    this.cnxnFactory.join();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (zkDb != null) {
                zkDb.close();
            }
        }

        public int getLocalPort() {
            int port;
            if (this.cnxnFactory == null) {
                throw new IllegalStateException("A port has not yet been selected");
            }
            try {
                port = this.cnxnFactory.getLocalPort();
            }
            catch (NullPointerException e) {
                throw new IllegalStateException("A port has not yet been selected");
            }
            if (port == 0) {
                throw new IllegalStateException("A port has not yet been selected");
            }
            return port;
        }

        public void setViolationReportAction(LimitViolationAction violationReportAction) {
            this.violationReportAction = violationReportAction;
        }

        public WatchLimiter getLimiter() {
            return this.limiter;
        }

        private class TestZKDatabase
        extends ZKDatabase {
            private final WatchLimiter limiter;

            public TestZKDatabase(FileTxnSnapLog snapLog, WatchLimiter limiter) {
                super(snapLog);
                this.limiter = limiter;
            }

            public Stat statNode(String path, ServerCnxn serverCnxn) throws KeeperException.NoNodeException {
                this.limiter.statLimit.updateForWatch(path, (Watcher)serverCnxn);
                return super.statNode(path, serverCnxn);
            }

            public byte[] getData(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
                this.limiter.dataLimit.updateForWatch(path, watcher);
                return super.getData(path, stat, watcher);
            }

            public List<String> getChildren(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
                this.limiter.childrenLimit.updateForWatch(path, watcher);
                return super.getChildren(path, stat, watcher);
            }
        }

        private class TestServerCnxnFactory
        extends NIOServerCnxnFactory {
            private final WatchLimiter limiter;

            public TestServerCnxnFactory(WatchLimiter limiter) throws IOException {
                this.limiter = limiter;
            }

            protected NIOServerCnxn createConnection(SocketChannel sock, SelectionKey sk) throws IOException {
                return new TestServerCnxn(this.zkServer, sock, sk, this, this.limiter);
            }
        }

        private class TestServerCnxn
        extends NIOServerCnxn {
            private final WatchLimiter limiter;

            public TestServerCnxn(ZooKeeperServer zk, SocketChannel sock, SelectionKey sk, NIOServerCnxnFactory factory, WatchLimiter limiter) throws IOException {
                super(zk, sock, sk, factory);
                this.limiter = limiter;
            }

            public synchronized void process(WatchedEvent event) {
                this.limiter.updateForFire(event);
                super.process(event);
            }
        }

        public class WatchLimiter {
            WatchLimit statLimit;
            WatchLimit dataLimit;
            WatchLimit childrenLimit;

            private WatchLimiter(long limit, LimitViolationAction action) {
                this.statLimit = new WatchLimit(limit, "create/delete", action);
                this.dataLimit = new WatchLimit(limit, "data", action);
                this.childrenLimit = new WatchLimit(limit, "children", action);
            }

            public void setAction(LimitViolationAction action) {
                this.statLimit.setAction(action);
                this.dataLimit.setAction(action);
                this.childrenLimit.setAction(action);
            }

            public void setLimit(long limit) {
                this.statLimit.setLimit(limit);
                this.dataLimit.setLimit(limit);
                this.childrenLimit.setLimit(limit);
            }

            public String reportLimitViolations() {
                return this.statLimit.reportLimitViolations() + this.dataLimit.reportLimitViolations() + this.childrenLimit.reportLimitViolations();
            }

            private void updateForFire(WatchedEvent event) {
                switch (event.getType()) {
                    case None: {
                        break;
                    }
                    case NodeCreated: 
                    case NodeDeleted: {
                        this.statLimit.updateForFire(event);
                        break;
                    }
                    case NodeDataChanged: {
                        this.dataLimit.updateForFire(event);
                        break;
                    }
                    case NodeChildrenChanged: {
                        this.childrenLimit.updateForFire(event);
                    }
                }
            }
        }

        private class WatchLimit {
            private long limit;
            private final String desc;
            private LimitViolationAction action;
            private AtomicLongMap<String> counters = AtomicLongMap.create();
            private ConcurrentHashMap<String, Long> maxCounters = new ConcurrentHashMap();

            WatchLimit(long limit, String desc, LimitViolationAction action) {
                this.limit = limit;
                this.desc = desc;
                this.action = action;
            }

            public void setAction(LimitViolationAction action) {
                this.action = action;
            }

            public void setLimit(long limit) {
                this.limit = limit;
            }

            public void updateForWatch(String key, Watcher watcher) {
                if (watcher != null) {
                    log.debug("Watch added: {}: {}", (Object)this.desc, (Object)key);
                    long count = this.counters.incrementAndGet((Object)key);
                    Long lastCount = this.maxCounters.get(key);
                    if (lastCount == null || count > lastCount) {
                        this.maxCounters.put(key, count);
                    }
                    if (count > this.limit && this.action != LimitViolationAction.IGNORE) {
                        String msg = "Number of watches created in parallel for data: " + key + ", type: " + this.desc + " exceeds limit (" + count + " > " + this.limit + ")";
                        log.warn("{}", (Object)msg);
                        if (this.action == LimitViolationAction.FAIL) {
                            throw new AssertionError((Object)msg);
                        }
                    }
                }
            }

            public void updateForFire(WatchedEvent event) {
                log.debug("Watch fired: {}: {}", (Object)this.desc, (Object)event.getPath());
                this.counters.decrementAndGet((Object)event.getPath());
            }

            private String reportLimitViolations() {
                Object[] maxKeys = ((ConcurrentHashMap.CollectionView)((Object)this.maxCounters.keySet())).toArray();
                Arrays.sort(maxKeys, new Comparator<Object>(){
                    private final Comparator<Long> valComp = Ordering.natural().reverse();

                    @Override
                    public int compare(Object o1, Object o2) {
                        return this.valComp.compare((Long)WatchLimit.this.maxCounters.get(o1), (Long)WatchLimit.this.maxCounters.get(o2));
                    }
                });
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Object key : maxKeys) {
                    long value = this.maxCounters.get(key);
                    if (value <= this.limit) continue;
                    if (first) {
                        sb.append("\nMaximum concurrent ").append(this.desc).append(" watches above limit:\n\n");
                        first = false;
                    }
                    sb.append("\t").append(this.maxCounters.get(key)).append('\t').append(key).append('\n');
                }
                return sb.toString();
            }
        }
    }

    public static enum LimitViolationAction {
        IGNORE,
        REPORT,
        FAIL;

    }
}

