/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.io.File;
import java.net.MalformedURLException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.UnrecoverableKeyException;
import java.util.Random;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.util.ExternalPaths;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.CertificateUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLTestConfig
extends SSLConfig {
    public static File TEST_KEYSTORE = ExternalPaths.SERVER_HOME == null ? null : new File(ExternalPaths.SERVER_HOME, "../etc/test/solrtest.keystore");
    private static String TEST_KEYSTORE_PATH = TEST_KEYSTORE != null && TEST_KEYSTORE.exists() ? TEST_KEYSTORE.getAbsolutePath() : null;
    private static final String TEST_KEYSTORE_RESOURCE = "SSLTestConfig.testing.keystore";
    private static final String TEST_KEYSTORE_PASSWORD = "secret";
    private final Resource keyStore;
    private final Resource trustStore;
    private static final HttpClientConfigurer HTTP_ONLY_NO_SSL_CONFIGURER = new HttpClientConfigurer(){

        public void configure(DefaultHttpClient httpClient, SolrParams config) {
            super.configure(httpClient, config);
            SchemeRegistry registry = httpClient.getConnectionManager().getSchemeRegistry();
            registry.unregister("https");
        }
    };

    public SSLTestConfig() {
        this(false, false);
    }

    public SSLTestConfig(boolean useSSL, boolean clientAuth) {
        super(useSSL, clientAuth, null, TEST_KEYSTORE_PASSWORD, null, TEST_KEYSTORE_PASSWORD);
        this.trustStore = this.keyStore = Resource.newClassPathResource((String)TEST_KEYSTORE_RESOURCE);
        if (null == this.keyStore || !this.keyStore.exists()) {
            throw new IllegalStateException("Unable to locate keystore resource file in classpath: SSLTestConfig.testing.keystore");
        }
    }

    @Deprecated
    public SSLTestConfig(boolean useSSL, boolean clientAuth, String keyStore, String keyStorePassword, String trustStore, String trustStorePassword) {
        super(useSSL, clientAuth, keyStore, keyStorePassword, trustStore, trustStorePassword);
        this.keyStore = SSLTestConfig.tryNewResource(keyStore, "KeyStore");
        this.trustStore = SSLTestConfig.tryNewResource(trustStore, "TrustStore");
    }

    private static final Resource tryNewResource(String userInput, String type) {
        Resource result;
        if (null == userInput) {
            return null;
        }
        try {
            result = Resource.newResource((String)userInput);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Can't build " + type + " Resource: " + e.getMessage(), e);
        }
        if (!result.exists()) {
            throw new IllegalArgumentException(type + " Resource does not exist " + result.getName());
        }
        return result;
    }

    public String getKeyStore() {
        return super.getKeyStore();
    }

    public String getTrustStore() {
        return super.getTrustStore();
    }

    public HttpClientConfigurer getHttpClientConfigurer() {
        try {
            return this.isSSLMode() ? new SSLHttpClientConfigurer(this.buildClientSSLContext()) : HTTP_ONLY_NO_SSL_CONFIGURER;
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalStateException("Unable to setup HttpClientConfigurer test SSL", e);
        }
    }

    public SSLContext buildClientSSLContext() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        assert (this.isSSLMode());
        SSLContextBuilder builder = SSLContexts.custom();
        builder.setSecureRandom(NotSecurePsuedoRandom.INSTANCE);
        builder.loadTrustMaterial(SSLTestConfig.buildKeyStore(this.keyStore, this.getKeyStorePassword()), (TrustStrategy)new TrustSelfSignedStrategy()).build();
        if (this.isClientAuthMode()) {
            builder.loadKeyMaterial(SSLTestConfig.buildKeyStore(this.trustStore, this.getTrustStorePassword()), this.getTrustStorePassword().toCharArray());
        }
        return builder.build();
    }

    public SSLContext buildServerSSLContext() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        assert (this.isSSLMode());
        SSLContextBuilder builder = SSLContexts.custom();
        builder.setSecureRandom(NotSecurePsuedoRandom.INSTANCE);
        builder.loadKeyMaterial(SSLTestConfig.buildKeyStore(this.keyStore, this.getKeyStorePassword()), this.getKeyStorePassword().toCharArray());
        if (this.isClientAuthMode()) {
            builder.loadTrustMaterial(SSLTestConfig.buildKeyStore(this.trustStore, this.getTrustStorePassword()), (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        return builder.build();
    }

    public SslContextFactory createContextFactory() {
        if (!this.isSSLMode()) {
            return null;
        }
        SslContextFactory factory = new SslContextFactory(false);
        try {
            factory.setSslContext(this.buildServerSSLContext());
        }
        catch (Exception e) {
            throw new RuntimeException("ssl context init failure: " + e.getMessage(), e);
        }
        factory.setNeedClientAuth(this.isClientAuthMode());
        return factory;
    }

    protected static KeyStore buildKeyStore(Resource resource, String password) {
        try {
            return CertificateUtils.getKeyStore((Resource)resource, (String)"JKS", null, (String)password);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to build KeyStore from resource: " + resource.getName(), ex);
        }
    }

    public SSLConnectionSocketFactory buildClientSSLConnectionSocketFactory() {
        SSLConnectionSocketFactory sslConnectionFactory;
        if (!this.isSSLMode()) {
            return null;
        }
        try {
            boolean sslCheckPeerName = SSLTestConfig.toBooleanDefaultIfNull(SSLTestConfig.toBooleanObject(System.getProperty("solr.ssl.checkPeerName")), true);
            SSLContext sslContext = this.buildClientSSLContext();
            sslConnectionFactory = !sslCheckPeerName ? new SSLConnectionSocketFactory(sslContext, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER) : new SSLConnectionSocketFactory(sslContext);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalStateException("Unable to setup https scheme for HTTPClient to test SSL.", e);
        }
        return sslConnectionFactory;
    }

    public static boolean toBooleanDefaultIfNull(Boolean bool, boolean valueIfNull) {
        if (bool == null) {
            return valueIfNull;
        }
        return bool != false;
    }

    public static Boolean toBooleanObject(String str) {
        if ("true".equalsIgnoreCase(str)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Deprecated
    public static void setSSLSystemProperties() {
        System.setProperty("javax.net.ssl.keyStore", TEST_KEYSTORE_PATH);
        System.setProperty("javax.net.ssl.keyStorePassword", TEST_KEYSTORE_PASSWORD);
        System.setProperty("javax.net.ssl.trustStore", TEST_KEYSTORE_PATH);
        System.setProperty("javax.net.ssl.trustStorePassword", TEST_KEYSTORE_PASSWORD);
    }

    @Deprecated
    public static void clearSSLSystemProperties() {
        System.clearProperty("javax.net.ssl.keyStore");
        System.clearProperty("javax.net.ssl.keyStorePassword");
        System.clearProperty("javax.net.ssl.trustStore");
        System.clearProperty("javax.net.ssl.trustStorePassword");
    }

    private static class NotSecurePsuedoRandom
    extends SecureRandom {
        public static final SecureRandom INSTANCE = new NotSecurePsuedoRandom();
        private static final Random RAND = new Random(42L);
        private static final SecureRandomSpi NOT_SECURE_SPI = new SecureRandomSpi(){

            @Override
            public byte[] engineGenerateSeed(int numBytes) {
                return NotSecurePsuedoRandom.fillData(new byte[numBytes]);
            }

            @Override
            public void engineNextBytes(byte[] bytes) {
                NotSecurePsuedoRandom.fillData(bytes);
            }

            @Override
            public void engineSetSeed(byte[] seed) {
            }
        };

        private static final byte[] fillData(byte[] data) {
            RAND.nextBytes(data);
            return data;
        }

        private NotSecurePsuedoRandom() {
            super(NOT_SECURE_SPI, null);
        }

        @Override
        public byte[] generateSeed(int numBytes) {
            return NotSecurePsuedoRandom.fillData(new byte[numBytes]);
        }

        @Override
        public synchronized void nextBytes(byte[] bytes) {
            NotSecurePsuedoRandom.fillData(bytes);
        }

        @Override
        public synchronized void setSeed(byte[] seed) {
        }

        @Override
        public synchronized void setSeed(long seed) {
        }
    }

    private static class SSLHttpClientConfigurer
    extends HttpClientConfigurer {
        private final SSLContext sslContext;

        public SSLHttpClientConfigurer(SSLContext sslContext) {
            this.sslContext = sslContext;
        }

        public void configure(DefaultHttpClient httpClient, SolrParams config) {
            super.configure(httpClient, config);
            SchemeRegistry registry = httpClient.getConnectionManager().getSchemeRegistry();
            registry.unregister("http");
            registry.register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(this.sslContext)));
        }
    }
}

