/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import com.carrotsearch.randomizedtesting.RandomizedContext;
import com.carrotsearch.randomizedtesting.TraceFormatting;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakFilters;
import com.carrotsearch.randomizedtesting.rules.SystemPropertiesRestoreRule;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.HttpClient;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.MockAnalyzer;
import org.apache.lucene.analysis.MockTokenizer;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.QuickPatchThreadsFilter;
import org.apache.lucene.util.TestUtil;
import org.apache.solr.JSONTestUtil;
import org.apache.solr.SolrIgnoredThreadsFilter;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.impl.HttpClientConfigurer;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.LBHttpSolrClient;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.cloud.IpTables;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.MultiMapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoresLocator;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.SolrXmlConfig;
import org.apache.solr.handler.UpdateRequestHandler;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrQueryRequestBase;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.servlet.DirectSolrConnection;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.util.LogLevel;
import org.apache.solr.util.RandomizeSSL;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.RevertDefaultThreadHandlerRule;
import org.apache.solr.util.SSLTestConfig;
import org.apache.solr.util.TestHarness;
import org.apache.solr.util.TestInjection;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.noggit.CharArr;
import org.noggit.JSONUtil;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@ThreadLeakFilters(defaultFilters=true, filters={SolrIgnoredThreadsFilter.class, QuickPatchThreadsFilter.class})
@LuceneTestCase.SuppressSysoutChecks(bugUrl="Solr dumps tons of logs to console.")
@LuceneTestCase.SuppressFileSystems(value={"ExtrasFS"})
@RandomizeSSL
public abstract class SolrTestCaseJ4
extends LuceneTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final List<String> DEFAULT_STACK_FILTERS = Arrays.asList("org.junit.", "junit.framework.", "sun.", "java.lang.reflect.", "com.carrotsearch.randomizedtesting.");
    public static final String DEFAULT_TEST_COLLECTION_NAME = "collection1";
    public static final String DEFAULT_TEST_CORENAME = "collection1";
    protected static final String CORE_PROPERTIES_FILENAME = "core.properties";
    public static final String SYSTEM_PROPERTY_SOLR_TESTS_MERGEPOLICYFACTORY = "solr.tests.mergePolicyFactory";
    @Deprecated
    public static final String SYSTEM_PROPERTY_SOLR_TESTS_MERGEPOLICY = "solr.tests.mergePolicy";
    @Deprecated
    public static final String SYSTEM_PROPERTY_SOLR_TESTS_USEMERGEPOLICYFACTORY = "solr.tests.useMergePolicyFactory";
    @Deprecated
    public static final String SYSTEM_PROPERTY_SOLR_TESTS_USEMERGEPOLICY = "solr.tests.useMergePolicy";
    public static final boolean PREFER_POINT_FIELDS = Boolean.getBoolean("solr.tests.preferPointFields");
    private static String coreName = "collection1";
    public static int DEFAULT_CONNECTION_TIMEOUT = 60000;
    protected static volatile SSLTestConfig sslConfig;
    @ClassRule
    public static TestRule solrClassRules;
    @Rule
    public TestRule solrTestRules = RuleChain.outerRule((TestRule)new SystemPropertiesRestoreRule());
    private static Map<String, String> savedClassLogLevels;
    private Map<String, String> savedMethodLogLevels = new HashMap<String, String>();
    private static boolean changedFactory;
    private static String savedFactory;
    static long numOpens;
    static long numCloses;
    protected static String configString;
    protected static String schemaString;
    protected static Path testSolrHome;
    protected static SolrConfig solrConfig;
    protected static TestHarness h;
    protected static TestHarness.LocalRequestFactory lrf;
    protected static volatile File initCoreDataDir;
    protected static String hdfsDataDir;
    private static String factoryProp;
    public static final IRange ZERO_ONE;
    public static final IRange ZERO_TWO;
    public static final IRange ONE_ONE;

    protected void writeCoreProperties(Path coreDirectory, String corename) throws IOException {
        Properties props = new Properties();
        props.setProperty("name", corename);
        props.setProperty("configSet", "collection1");
        props.setProperty("config", "${solrconfig:solrconfig.xml}");
        props.setProperty("schema", "${schema:schema.xml}");
        SolrTestCaseJ4.writeCoreProperties(coreDirectory, props, this.getTestName());
    }

    public static void writeCoreProperties(Path coreDirectory, Properties properties, String testname) throws IOException {
        log.info("Writing core.properties file to {}", (Object)coreDirectory);
        Files.createDirectories(coreDirectory, new FileAttribute[0]);
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(coreDirectory.resolve(CORE_PROPERTIES_FILENAME), new OpenOption[0]), Charset.forName("UTF-8"));){
            properties.store(writer, testname);
        }
    }

    @BeforeClass
    public static void setupTestCases() {
        SolrTestCaseJ4.initClassLogLevels();
        initCoreDataDir = SolrTestCaseJ4.createTempDir((String)"init-core-data").toFile();
        System.err.println("Creating dataDir: " + initCoreDataDir.getAbsolutePath());
        System.setProperty("zookeeper.forceSync", "no");
        System.setProperty("jetty.testMode", "true");
        System.setProperty("enable.update.log", SolrTestCaseJ4.usually() ? "true" : "false");
        System.setProperty("tests.shardhandler.randomSeed", Long.toString(SolrTestCaseJ4.random().nextLong()));
        System.setProperty("solr.clustering.enabled", "false");
        System.setProperty("solr.peerSync.useRangeVersions", String.valueOf(SolrTestCaseJ4.random().nextBoolean()));
        System.setProperty("solr.cloud.wait-for-updates-with-stale-state-pause", "500");
        SolrTestCaseJ4.startTrackingSearchers();
        SolrTestCaseJ4.ignoreException("ignore_exception");
        SolrTestCaseJ4.newRandomConfig();
        sslConfig = SolrTestCaseJ4.buildSSLConfig();
        HttpClientUtil.setConfigurer((HttpClientConfigurer)sslConfig.getHttpClientConfigurer());
        if (SolrTestCaseJ4.isSSLMode()) {
            System.setProperty("urlScheme", "https");
        }
    }

    @AfterClass
    public static void teardownTestCases() throws Exception {
        try {
            SolrTestCaseJ4.deleteCore();
            SolrTestCaseJ4.resetExceptionIgnores();
            if (suiteFailureMarker.wasSuccessful()) {
                if (!RandomizedContext.current().getTargetClass().isAnnotationPresent(SuppressObjectReleaseTracker.class)) {
                    String orr = SolrTestCaseJ4.clearObjectTrackerAndCheckEmpty(20, false);
                    SolrTestCaseJ4.assertNull((String)orr, (Object)orr);
                } else {
                    SolrTestCaseJ4.clearObjectTrackerAndCheckEmpty(20, true);
                }
            }
            SolrTestCaseJ4.resetFactory();
            coreName = "collection1";
        }
        finally {
            ObjectReleaseTracker.clear();
            TestInjection.reset();
            initCoreDataDir = null;
            System.clearProperty("zookeeper.forceSync");
            System.clearProperty("jetty.testMode");
            System.clearProperty("tests.shardhandler.randomSeed");
            System.clearProperty("enable.update.log");
            System.clearProperty("useCompoundFile");
            System.clearProperty("urlScheme");
            System.clearProperty("solr.peerSync.useRangeVersions");
            HttpClientUtil.resetConfigurers();
            sslConfig = null;
            testSolrHome = null;
        }
        IpTables.unblockAllPorts();
        LogLevel.Configurer.restoreLogLevels(savedClassLogLevels);
        savedClassLogLevels.clear();
    }

    public static String clearObjectTrackerAndCheckEmpty(int waitSeconds) {
        return SolrTestCaseJ4.clearObjectTrackerAndCheckEmpty(waitSeconds, false);
    }

    public static String clearObjectTrackerAndCheckEmpty(int waitSeconds, boolean tryClose) {
        String result;
        int retries = 0;
        while ((result = ObjectReleaseTracker.checkEmpty()) != null) {
            try {
                if (retries % 10 == 0) {
                    log.info("Waiting for all tracked resources to be released");
                    if (retries > 10) {
                        TraceFormatting tf = new TraceFormatting(DEFAULT_STACK_FILTERS);
                        Map<Thread, StackTraceElement[]> stacksMap = Thread.getAllStackTraces();
                        Set<Map.Entry<Thread, StackTraceElement[]>> entries = stacksMap.entrySet();
                        for (Map.Entry<Thread, StackTraceElement[]> entry : entries) {
                            String stack = tf.formatStackTrace(entry.getValue());
                            System.err.println(entry.getKey().getName() + ":\n" + stack);
                        }
                    }
                }
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                break;
            }
            if (retries++ < waitSeconds) continue;
        }
        log.info("------------------------------------------------------- Done waiting for tracked resources to be released");
        if (tryClose && result != null && RandomizedContext.current().getTargetClass().isAnnotationPresent(SuppressObjectReleaseTracker.class)) {
            log.warn("Some resources were not closed, shutdown, or released. This has been ignored due to the SuppressObjectReleaseTracker annotation, trying to close them now.");
            ObjectReleaseTracker.tryClose();
        }
        ObjectReleaseTracker.clear();
        return result;
    }

    public static void initClassLogLevels() {
        Class currentClass = RandomizedContext.current().getTargetClass();
        LogLevel annotation = currentClass.getAnnotation(LogLevel.class);
        if (annotation == null) {
            return;
        }
        Map<String, String> previousLevels = LogLevel.Configurer.setLevels(annotation.value());
        savedClassLogLevels.putAll(previousLevels);
    }

    @Before
    public void initMethodLogLevels() {
        Method method = RandomizedContext.current().getTargetMethod();
        LogLevel annotation = method.getAnnotation(LogLevel.class);
        if (annotation == null) {
            return;
        }
        Map<String, String> previousLevels = LogLevel.Configurer.setLevels(annotation.value());
        this.savedMethodLogLevels.putAll(previousLevels);
    }

    @After
    public void restoreMethodLogLevels() {
        LogLevel.Configurer.restoreLogLevels(this.savedMethodLogLevels);
        this.savedMethodLogLevels.clear();
    }

    protected static boolean isSSLMode() {
        return sslConfig != null && sslConfig.isSSLMode();
    }

    public static void useFactory(String factory) throws Exception {
        if (!changedFactory) {
            savedFactory = System.getProperty("solr.DirectoryFactory");
        }
        if (factory == null) {
            factory = SolrTestCaseJ4.random().nextInt(100) < 75 ? "solr.NRTCachingDirectoryFactory" : "solr.StandardDirectoryFactory";
        }
        System.setProperty("solr.directoryFactory", factory);
        changedFactory = true;
    }

    public static void resetFactory() throws Exception {
        if (!changedFactory) {
            return;
        }
        changedFactory = false;
        if (savedFactory != null) {
            System.setProperty("solr.directoryFactory", savedFactory);
        } else {
            System.clearProperty("solr.directoryFactory");
        }
    }

    private static SSLTestConfig buildSSLConfig() {
        RandomizeSSL.SSLRandomizer sslRandomizer = RandomizeSSL.SSLRandomizer.getSSLRandomizerForClass(RandomizedContext.current().getTargetClass());
        if (Constants.MAC_OS_X) {
            sslRandomizer = new RandomizeSSL.SSLRandomizer(sslRandomizer.ssl, 0.0, sslRandomizer.debug + " w/ MAC_OS_X supressed clientAuth");
        }
        SSLTestConfig result = sslRandomizer.createSSLTestConfig();
        log.info("Randomized ssl ({}) and clientAuth ({}) via: {}", new Object[]{result.isSSLMode(), result.isClientAuthMode(), sslRandomizer.debug});
        return result;
    }

    protected static JettyConfig buildJettyConfig(String context) {
        return JettyConfig.builder().setContext(context).withSSLConfig((SSLConfig)sslConfig).build();
    }

    protected static String buildUrl(int port, String context) {
        return (SolrTestCaseJ4.isSSLMode() ? "https" : "http") + "://127.0.0.1:" + port + context;
    }

    protected static MockTokenizer whitespaceMockTokenizer(Reader input) throws IOException {
        MockTokenizer mockTokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        mockTokenizer.setReader(input);
        return mockTokenizer;
    }

    protected static MockTokenizer whitespaceMockTokenizer(String input) throws IOException {
        MockTokenizer mockTokenizer = new MockTokenizer(MockTokenizer.WHITESPACE, false);
        mockTokenizer.setReader((Reader)new StringReader(input));
        return mockTokenizer;
    }

    public static void setupNoCoreTest(Path solrHome, String xmlStr) throws Exception {
        if (xmlStr == null) {
            xmlStr = "<solr></solr>";
        }
        Files.write(solrHome.resolve("solr.xml"), xmlStr.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        h = new TestHarness(SolrXmlConfig.fromSolrHome((Path)solrHome));
        lrf = h.getRequestFactory("standard", 0, 20, "version", "2.2");
    }

    public static void newRandomConfig() {
        IndexWriterConfig iwc = SolrTestCaseJ4.newIndexWriterConfig((Analyzer)new MockAnalyzer(SolrTestCaseJ4.random()));
        System.setProperty("useCompoundFile", String.valueOf(iwc.getUseCompoundFile()));
        System.setProperty("solr.tests.maxBufferedDocs", String.valueOf(iwc.getMaxBufferedDocs()));
        System.setProperty("solr.tests.ramBufferSizeMB", String.valueOf(iwc.getRAMBufferSizeMB()));
        String mergeSchedulerClass = iwc.getMergeScheduler().getClass().getName();
        if (mergeSchedulerClass.contains("$")) {
            mergeSchedulerClass = "org.apache.lucene.index.ConcurrentMergeScheduler";
        }
        System.setProperty("solr.tests.mergeScheduler", mergeSchedulerClass);
        if (RandomizedContext.current().getTargetClass().isAnnotationPresent(SuppressPointFields.class) || !PREFER_POINT_FIELDS && SolrTestCaseJ4.random().nextBoolean()) {
            log.info("Using TrieFields");
            System.setProperty("solr.tests.intClass", "int");
            System.setProperty("solr.tests.longClass", "long");
            System.setProperty("solr.tests.doubleClass", "double");
            System.setProperty("solr.tests.floatClass", "float");
            System.setProperty("solr.tests.dateClass", "date");
        } else {
            log.info("Using PointFields");
            System.setProperty("solr.tests.intClass", "pint");
            System.setProperty("solr.tests.longClass", "plong");
            System.setProperty("solr.tests.doubleClass", "pdouble");
            System.setProperty("solr.tests.floatClass", "pfloat");
            System.setProperty("solr.tests.dateClass", "pdate");
        }
    }

    public static Throwable getWrappedException(Throwable e) {
        while (e != null && e.getCause() != e && e.getCause() != null) {
            e = e.getCause();
        }
        return e;
    }

    public void setUp() throws Exception {
        super.setUp();
        log.info("###Starting " + this.getTestName());
    }

    public void tearDown() throws Exception {
        log.info("###Ending " + this.getTestName());
        super.tearDown();
    }

    public static void initCore(String config, String schema) throws Exception {
        SolrTestCaseJ4.initCore(config, schema, SolrTestCaseJ4.TEST_HOME());
    }

    public static void initCore(String config, String schema, String solrHome) throws Exception {
        SolrTestCaseJ4.assertNotNull((Object)solrHome);
        configString = config;
        schemaString = schema;
        testSolrHome = Paths.get(solrHome, new String[0]);
        System.setProperty("solr.solr.home", solrHome);
        SolrTestCaseJ4.initCore();
    }

    public static void initCore(String config, String schema, String solrHome, String pCoreName) throws Exception {
        coreName = pCoreName;
        SolrTestCaseJ4.initCore(config, schema, solrHome);
    }

    public static void startTrackingSearchers() {
        numOpens = SolrIndexSearcher.numOpens.getAndSet(0L);
        numCloses = SolrIndexSearcher.numCloses.getAndSet(0L);
        if (numOpens != 0L || numCloses != 0L) {
            log.warn("startTrackingSearchers: numOpens=" + numOpens + " numCloses=" + numCloses);
            numCloses = 0L;
            numOpens = 0L;
        }
    }

    public static void ignoreException(String pattern) {
        if (SolrException.ignorePatterns == null) {
            SolrException.ignorePatterns = new HashSet();
        }
        SolrException.ignorePatterns.add(pattern);
    }

    public static void unIgnoreException(String pattern) {
        if (SolrException.ignorePatterns != null) {
            SolrException.ignorePatterns.remove(pattern);
        }
    }

    public static void resetExceptionIgnores() {
        SolrException.ignorePatterns = null;
        SolrTestCaseJ4.ignoreException("ignore_exception");
    }

    protected static String getClassName() {
        return SolrTestCaseJ4.getTestClass().getName();
    }

    protected static String getSimpleClassName() {
        return SolrTestCaseJ4.getTestClass().getSimpleName();
    }

    public static String getSchemaFile() {
        return schemaString;
    }

    public static String getSolrConfigFile() {
        return configString;
    }

    public static void initCore() throws Exception {
        log.info("####initCore");
        SolrTestCaseJ4.ignoreException("ignore_exception");
        factoryProp = System.getProperty("solr.directoryFactory");
        if (factoryProp == null) {
            System.setProperty("solr.directoryFactory", "solr.RAMDirectoryFactory");
        }
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
        String configFile = SolrTestCaseJ4.getSolrConfigFile();
        if (configFile != null) {
            SolrTestCaseJ4.createCore();
        }
        log.info("####initCore end");
    }

    public static void createCore() {
        SolrTestCaseJ4.assertNotNull((Object)testSolrHome);
        solrConfig = TestHarness.createConfig(testSolrHome, coreName, SolrTestCaseJ4.getSolrConfigFile());
        h = new TestHarness(coreName, hdfsDataDir == null ? initCoreDataDir.getAbsolutePath() : hdfsDataDir, solrConfig, SolrTestCaseJ4.getSchemaFile());
        lrf = h.getRequestFactory("standard", 0, 20, "version", "2.2");
    }

    public static CoreContainer createCoreContainer(Path solrHome, String solrXML) {
        testSolrHome = Objects.requireNonNull(solrHome);
        h = new TestHarness(solrHome, solrXML);
        lrf = h.getRequestFactory("standard", 0, 20, "version", "2.2");
        return h.getCoreContainer();
    }

    public static CoreContainer createCoreContainer(NodeConfig config, CoresLocator locator) {
        testSolrHome = config.getSolrResourceLoader().getInstancePath();
        h = new TestHarness(config, locator);
        lrf = h.getRequestFactory("standard", 0, 20, "version", "2.2");
        return h.getCoreContainer();
    }

    public static CoreContainer createCoreContainer(String coreName, String dataDir, String solrConfig, String schema) {
        NodeConfig nodeConfig = TestHarness.buildTestNodeConfig(new SolrResourceLoader(SolrTestCaseJ4.TEST_PATH()));
        TestHarness.TestCoresLocator locator = new TestHarness.TestCoresLocator(coreName, dataDir, solrConfig, schema);
        CoreContainer cc = SolrTestCaseJ4.createCoreContainer(nodeConfig, locator);
        SolrTestCaseJ4.h.coreName = coreName;
        return cc;
    }

    public static CoreContainer createDefaultCoreContainer(Path solrHome) {
        testSolrHome = Objects.requireNonNull(solrHome);
        h = new TestHarness("collection1", initCoreDataDir.getAbsolutePath(), "solrconfig.xml", "schema.xml");
        lrf = h.getRequestFactory("standard", 0, 20, "version", "2.2");
        return h.getCoreContainer();
    }

    public static boolean hasInitException(String message) {
        for (Map.Entry entry : h.getCoreContainer().getCoreInitFailures().entrySet()) {
            if (!((CoreContainer.CoreLoadFailure)entry.getValue()).exception.getMessage().contains(message)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasInitException(Class<? extends Exception> exceptionType) {
        for (Map.Entry entry : h.getCoreContainer().getCoreInitFailures().entrySet()) {
            if (!exceptionType.isAssignableFrom(((CoreContainer.CoreLoadFailure)entry.getValue()).exception.getClass())) continue;
            return true;
        }
        return false;
    }

    public void postSetUp() {
        log.info("####POSTSETUP " + this.getTestName());
    }

    public void preTearDown() {
        log.info("####PRETEARDOWN " + this.getTestName());
    }

    public static void deleteCore() {
        log.info("###deleteCore");
        if (h != null) {
            CoreContainer cc = h.getCoreContainer();
            if (!cc.getCores().isEmpty() && cc.isZooKeeperAware()) {
                try {
                    cc.getZkController().getZkClient().exists("/", false);
                }
                catch (KeeperException e) {
                    log.error("Testing connectivity to ZK by checking for root path failed", (Throwable)e);
                    SolrTestCaseJ4.fail((String)"Trying to tear down a ZK aware core container with ZK not reachable");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            h.close();
        }
        if (factoryProp == null) {
            System.clearProperty("solr.directoryFactory");
        }
        solrConfig = null;
        h = null;
        lrf = null;
        schemaString = null;
        configString = null;
    }

    protected static int getNextAvailablePort() throws Exception {
        int port = -1;
        try (ServerSocket s = new ServerSocket(0);){
            port = s.getLocalPort();
        }
        return port;
    }

    public static void assertU(String update) {
        SolrTestCaseJ4.assertU(null, update);
    }

    public static void assertU(String message, String update) {
        SolrTestCaseJ4.checkUpdateU(message, update, true);
    }

    public static void assertFailedU(String update) {
        SolrTestCaseJ4.assertFailedU(null, update);
    }

    public static void assertFailedU(String message, String update) {
        SolrTestCaseJ4.checkUpdateU(message, update, false);
    }

    private static void checkUpdateU(String message, String update, boolean shouldSucceed) {
        try {
            String m;
            String string = m = null == message ? "" : message + " ";
            if (shouldSucceed) {
                String res = h.validateUpdate(update);
                if (res != null) {
                    SolrTestCaseJ4.fail((String)(m + "update was not successful: " + res));
                }
            } else {
                String res = h.validateErrorUpdate(update);
                if (res != null) {
                    SolrTestCaseJ4.fail((String)(m + "update succeeded, but should have failed: " + res));
                }
            }
        }
        catch (SAXException e) {
            throw new RuntimeException("Invalid XML", e);
        }
    }

    public static void assertQ(SolrQueryRequest req, String ... tests) {
        SolrTestCaseJ4.assertQ(null, req, tests);
    }

    public static void assertQ(String message, SolrQueryRequest req, String ... tests) {
        try {
            String results;
            String m = null == message ? "" : message + " ";
            String response = h.query(req);
            if (req.getParams().getBool("facet", false)) {
                String[] allTests = new String[tests.length + 1];
                System.arraycopy(tests, 0, allTests, 1, tests.length);
                allTests[0] = "*[count(//lst[@name='facet_counts']/*[@name='exception'])=0]";
                tests = allTests;
            }
            if (null != (results = TestHarness.validateXPath(response, tests))) {
                String msg = "REQUEST FAILED: xpath=" + results + "\n\txml response was: " + response + "\n\trequest was:" + req.getParamString();
                log.error(msg);
                throw new RuntimeException(msg);
            }
        }
        catch (XPathExpressionException e1) {
            throw new RuntimeException("XPath is invalid", e1);
        }
        catch (Exception e2) {
            SolrException.log((Logger)log, (String)("REQUEST FAILED: " + req.getParamString()), (Throwable)e2);
            throw new RuntimeException("Exception during query", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String JQ(SolrQueryRequest req) throws Exception {
        String response;
        SolrParams params = req.getParams();
        if (!"json".equals(params.get("wt", "xml")) || params.get("indent") == null) {
            ModifiableSolrParams newParams = new ModifiableSolrParams(params);
            newParams.set("wt", new String[]{"json"});
            if (params.get("indent") == null) {
                newParams.set("indent", new String[]{"true"});
            }
            req.setParams((SolrParams)newParams);
        }
        boolean failed = true;
        try {
            response = h.query(req);
            failed = false;
        }
        finally {
            if (failed) {
                log.error("REQUEST FAILED: " + req.getParamString());
            }
        }
        return response;
    }

    public static String assertJQ(SolrQueryRequest req, String ... tests) throws Exception {
        return SolrTestCaseJ4.assertJQ(req, 1.0E-5, tests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String assertJQ(SolrQueryRequest req, double delta, String ... tests) throws Exception {
        SolrParams params = null;
        try {
            String response;
            params = req.getParams();
            if (!"json".equals(params.get("wt", "xml")) || params.get("indent") == null) {
                ModifiableSolrParams newParams = new ModifiableSolrParams(params);
                newParams.set("wt", new String[]{"json"});
                if (params.get("indent") == null) {
                    newParams.set("indent", new String[]{"true"});
                }
                req.setParams((SolrParams)newParams);
            }
            boolean failed = true;
            try {
                response = h.query(req);
                failed = false;
            }
            finally {
                if (failed) {
                    log.error("REQUEST FAILED: " + req.getParamString());
                }
            }
            for (String test : tests) {
                if (test == null || test.length() == 0) continue;
                String testJSON = SolrTestCaseJ4.json(test);
                try {
                    failed = true;
                    String err = JSONTestUtil.match(response, testJSON, delta);
                    failed = false;
                    if (err == null) continue;
                    log.error("query failed JSON validation. error=" + err + "\n expected =" + testJSON + "\n response = " + response + "\n request = " + req.getParamString());
                    throw new RuntimeException(err);
                }
                finally {
                    if (failed) {
                        log.error("JSON query validation threw an exception.\n expected =" + testJSON + "\n response = " + response + "\n request = " + req.getParamString());
                    }
                }
            }
            String string = response;
            return string;
        }
        finally {
            if (params != null && params != req.getParams()) {
                req.setParams(params);
            }
        }
    }

    public static void assertQEx(String message, SolrQueryRequest req, int code) {
        try {
            SolrTestCaseJ4.ignoreException(".");
            h.query(req);
            SolrTestCaseJ4.fail((String)message);
        }
        catch (SolrException sex) {
            SolrTestCaseJ4.assertEquals((long)code, (long)sex.code());
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
        finally {
            SolrTestCaseJ4.unIgnoreException(".");
        }
    }

    public static void assertQEx(String message, SolrQueryRequest req, SolrException.ErrorCode code) {
        try {
            SolrTestCaseJ4.ignoreException(".");
            h.query(req);
            SolrTestCaseJ4.fail((String)message);
        }
        catch (SolrException e) {
            SolrTestCaseJ4.assertEquals((long)code.code, (long)e.code());
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
        finally {
            SolrTestCaseJ4.unIgnoreException(".");
        }
    }

    public static void assertQEx(String failMessage, String exceptionMessage, SolrQueryRequest req, SolrException.ErrorCode code) {
        try {
            SolrTestCaseJ4.ignoreException(".");
            h.query(req);
            SolrTestCaseJ4.fail((String)failMessage);
        }
        catch (SolrException e) {
            SolrTestCaseJ4.assertEquals((long)code.code, (long)e.code());
            SolrTestCaseJ4.assertTrue((String)("Unexpected error message. Expecting \"" + exceptionMessage + "\" but got \"" + e.getMessage() + "\""), (e.getMessage() != null && e.getMessage().contains(exceptionMessage) ? 1 : 0) != 0);
        }
        catch (Exception e2) {
            throw new RuntimeException("Exception during query", e2);
        }
        finally {
            SolrTestCaseJ4.unIgnoreException(".");
        }
    }

    public static String optimize(String ... args) {
        return TestHarness.optimize(args);
    }

    public static String commit(String ... args) {
        return TestHarness.commit(args);
    }

    public static String adoc(String ... fieldsAndValues) {
        XmlDoc d = SolrTestCaseJ4.doc(fieldsAndValues);
        return SolrTestCaseJ4.add(d, new String[0]);
    }

    public static String adoc(SolrInputDocument sdoc) {
        StringWriter out = new StringWriter(512);
        try {
            out.append("<add>");
            ClientUtils.writeXML((SolrInputDocument)sdoc, (Writer)out);
            out.append("</add>");
        }
        catch (IOException e) {
            throw new RuntimeException("Inexplicable IO error from StringWriter", e);
        }
        return out.toString();
    }

    public static void addDoc(String doc, String updateRequestProcessorChain) throws Exception {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        MultiMapSolrParams mmparams = new MultiMapSolrParams(params);
        params.put("update.chain", new String[]{updateRequestProcessorChain});
        SolrQueryRequestBase req = new SolrQueryRequestBase(h.getCore(), (SolrParams)mmparams){};
        UpdateRequestHandler handler = new UpdateRequestHandler();
        handler.init(null);
        ArrayList<ContentStreamBase.StringStream> streams = new ArrayList<ContentStreamBase.StringStream>(2);
        streams.add(new ContentStreamBase.StringStream(doc));
        req.setContentStreams(streams);
        handler.handleRequestBody((SolrQueryRequest)req, new SolrQueryResponse());
        req.close();
    }

    public static String add(XmlDoc doc, String ... args) {
        try {
            StringWriter r = new StringWriter();
            if (null == args || 0 == args.length) {
                r.write("<add>");
                r.write(doc.xml);
                r.write("</add>");
            } else {
                XML.writeUnescapedXML((Writer)r, (String)"add", (String)doc.xml, (Object[])args);
            }
            return r.getBuffer().toString();
        }
        catch (IOException e) {
            throw new RuntimeException("this should never happen with a StringWriter", e);
        }
    }

    public static String delI(String id) {
        return TestHarness.deleteById(id, new String[0]);
    }

    public static String delQ(String q) {
        return TestHarness.deleteByQuery(q, new String[0]);
    }

    public static XmlDoc doc(String ... fieldsAndValues) {
        XmlDoc d = new XmlDoc();
        d.xml = TestHarness.makeSimpleDoc(fieldsAndValues);
        return d;
    }

    public static ModifiableSolrParams params(String ... params) {
        ModifiableSolrParams msp = new ModifiableSolrParams();
        for (int i = 0; i < params.length; i += 2) {
            msp.add(params[i], new String[]{params[i + 1]});
        }
        return msp;
    }

    public static Map map(Object ... params) {
        LinkedHashMap<Object, Object> ret = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < params.length; i += 2) {
            Object object = ret.put(params[i], params[i + 1]);
        }
        return ret;
    }

    public static SolrQueryRequest req(String ... q) {
        return lrf.makeRequest(q);
    }

    public static SolrQueryRequest req(String[] params, String ... moreParams) {
        String[] allParams = moreParams;
        if (params.length != 0) {
            int len = params.length + moreParams.length;
            allParams = new String[len];
            System.arraycopy(params, 0, allParams, 0, params.length);
            System.arraycopy(moreParams, 0, allParams, params.length, moreParams.length);
        }
        return lrf.makeRequest(allParams);
    }

    public static SolrQueryRequest req(SolrParams params, String ... moreParams) {
        ModifiableSolrParams mp = new ModifiableSolrParams(params);
        for (int i = 0; i < moreParams.length; i += 2) {
            mp.add(moreParams[i], new String[]{moreParams[i + 1]});
        }
        return new LocalSolrQueryRequest(h.getCore(), (SolrParams)mp);
    }

    public void clearIndex() {
        try {
            SolrTestCaseJ4.deleteByQueryAndGetVersion("*:*", (SolrParams)SolrTestCaseJ4.params("_version_", Long.toString(-9223372036854775807L), "update.distrib", DistributedUpdateProcessor.DistribPhase.FROMLEADER.toString()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String updateJ(String json, SolrParams args) throws Exception {
        SolrCore core = h.getCore();
        if (args == null) {
            args = SolrTestCaseJ4.params("wt", "json", "indent", "true");
        } else {
            ModifiableSolrParams newArgs = new ModifiableSolrParams(args);
            if (newArgs.get("wt") == null) {
                newArgs.set("wt", new String[]{"json"});
            }
            if (newArgs.get("indent") == null) {
                newArgs.set("indent", new String[]{"true"});
            }
            args = newArgs;
        }
        DirectSolrConnection connection = new DirectSolrConnection(core);
        SolrRequestHandler handler = core.getRequestHandler("/update/json");
        if (handler == null) {
            handler = new UpdateRequestHandler();
            handler.init(null);
        }
        return connection.request(handler, args, json);
    }

    public static SolrInputDocument sdoc(Object ... fieldsAndValues) {
        SolrInputDocument sd = new SolrInputDocument(new String[0]);
        for (int i = 0; i < fieldsAndValues.length; i += 2) {
            sd.addField((String)fieldsAndValues[i], fieldsAndValues[i + 1]);
        }
        return sd;
    }

    public SolrInputDocument sdocWithChildren(String id, String version) {
        return this.sdocWithChildren(id, version, 2);
    }

    public SolrInputDocument sdocWithChildren(String id, String version, int childCount) {
        SolrInputDocument doc = SolrTestCaseJ4.sdoc("id", id, "_version_", version);
        for (int i = 1; i <= childCount; ++i) {
            doc.addChildDocument(SolrTestCaseJ4.sdoc("id", id + "_child" + i));
        }
        return doc;
    }

    public SolrInputDocument sdocWithChildren(Integer id, String version, int childCount) {
        SolrInputDocument doc = SolrTestCaseJ4.sdoc("id", id, "_version_", version);
        for (int i = 1; i <= childCount; ++i) {
            doc.addChildDocument(SolrTestCaseJ4.sdoc("id", 1000 * id + i));
        }
        return doc;
    }

    public static List<SolrInputDocument> sdocs(SolrInputDocument ... docs) {
        return Arrays.asList(docs);
    }

    public static String json(String testJSON) {
        return testJSON;
    }

    public static String json(SolrInputDocument doc) {
        CharArr out = new CharArr();
        SolrTestCaseJ4.json(doc, out);
        return out.toString();
    }

    public static void json(SolrInputDocument doc, CharArr out) {
        try {
            out.append('{');
            boolean firstField = true;
            for (SolrInputField sfield : doc) {
                if (firstField) {
                    firstField = false;
                } else {
                    out.append(',');
                }
                JSONUtil.writeString((CharSequence)sfield.getName(), (int)0, (int)sfield.getName().length(), (CharArr)out);
                out.append(':');
                if (sfield.getValueCount() > 1) {
                    out.append('[');
                    boolean firstVal = true;
                    for (Object val : sfield) {
                        if (firstVal) {
                            firstVal = false;
                        } else {
                            out.append(',');
                        }
                        out.append((CharSequence)JSONUtil.toJSON(val));
                    }
                    out.append(']');
                    continue;
                }
                out.append((CharSequence)JSONUtil.toJSON((Object)sfield.getValue()));
            }
            boolean firstChildDoc = true;
            if (doc.hasChildDocuments()) {
                out.append((CharSequence)",\"_childDocuments_\": [");
                List childDocuments = doc.getChildDocuments();
                for (SolrInputDocument childDocument : childDocuments) {
                    if (firstChildDoc) {
                        firstChildDoc = false;
                    } else {
                        out.append(',');
                    }
                    SolrTestCaseJ4.json(childDocument, out);
                }
                out.append(']');
            }
            out.append('}');
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String jsonAdd(SolrInputDocument ... docs) {
        CharArr out = new CharArr();
        try {
            out.append('[');
            boolean firstField = true;
            for (SolrInputDocument doc : docs) {
                if (firstField) {
                    firstField = false;
                } else {
                    out.append(',');
                }
                out.append((CharSequence)SolrTestCaseJ4.json(doc));
            }
            out.append(']');
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public static String jsonDelId(Object ... ids) {
        CharArr out = new CharArr();
        try {
            out.append('{');
            boolean first = true;
            for (Object id : ids) {
                if (first) {
                    first = false;
                } else {
                    out.append(',');
                }
                out.append((CharSequence)"\"delete\":{\"id\":");
                out.append((CharSequence)JSONUtil.toJSON((Object)id));
                out.append('}');
            }
            out.append('}');
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public static String jsonDelQ(String ... queries) {
        CharArr out = new CharArr();
        try {
            out.append('{');
            boolean first = true;
            for (String q : queries) {
                if (first) {
                    first = false;
                } else {
                    out.append(',');
                }
                out.append((CharSequence)"\"delete\":{\"query\":");
                out.append((CharSequence)JSONUtil.toJSON((Object)q));
                out.append('}');
            }
            out.append('}');
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public static Long addAndGetVersion(SolrInputDocument sdoc, SolrParams params) throws Exception {
        String response;
        Map rsp;
        List lst;
        if (params == null || params.get("versions") == null) {
            ModifiableSolrParams mparams = new ModifiableSolrParams(params);
            mparams.set("versions", new String[]{"true"});
            params = mparams;
        }
        if ((lst = (List)(rsp = (Map)ObjectBuilder.fromJSON((String)(response = SolrTestCaseJ4.updateJ(SolrTestCaseJ4.jsonAdd(sdoc), params)))).get("adds")) == null || lst.size() == 0) {
            return null;
        }
        return (Long)lst.get(1);
    }

    public static Long deleteAndGetVersion(String id, SolrParams params) throws Exception {
        String response;
        Map rsp;
        List lst;
        if (params == null || params.get("versions") == null) {
            ModifiableSolrParams mparams = new ModifiableSolrParams(params);
            mparams.set("versions", new String[]{"true"});
            params = mparams;
        }
        if ((lst = (List)(rsp = (Map)ObjectBuilder.fromJSON((String)(response = SolrTestCaseJ4.updateJ(SolrTestCaseJ4.jsonDelId(id), params)))).get("deletes")) == null || lst.size() == 0) {
            return null;
        }
        return (Long)lst.get(1);
    }

    public static Long deleteByQueryAndGetVersion(String q, SolrParams params) throws Exception {
        String response;
        Map rsp;
        List lst;
        if (params == null || params.get("versions") == null) {
            ModifiableSolrParams mparams = new ModifiableSolrParams(params);
            mparams.set("versions", new String[]{"true"});
            params = mparams;
        }
        if ((lst = (List)(rsp = (Map)ObjectBuilder.fromJSON((String)(response = SolrTestCaseJ4.updateJ(SolrTestCaseJ4.jsonDelQ(q), params)))).get("deleteByQuery")) == null || lst.size() == 0) {
            return null;
        }
        return (Long)lst.get(1);
    }

    public Map<Comparable, Doc> indexDocs(List<FldType> descriptor, Map<Comparable, Doc> model, int nDocs) throws Exception {
        if (model == null) {
            model = new LinkedHashMap<Comparable, Doc>();
        }
        int commitOneOutOf = Math.max(nDocs / 10, 10);
        for (int i = 0; i < nDocs; ++i) {
            Doc doc = SolrTestCaseJ4.createDoc(descriptor);
            SolrTestCaseJ4.updateJ(SolrTestCaseJ4.toJSON(doc), null);
            model.put(doc.id, doc);
            if (SolrTestCaseJ4.random().nextInt(commitOneOutOf) == 0) {
                SolrTestCaseJ4.assertU(SolrTestCaseJ4.commit(new String[0]));
            }
            if (SolrTestCaseJ4.random().nextInt(10) != 0) continue;
            SolrTestCaseJ4.updateJ(SolrTestCaseJ4.toJSON(doc), null);
            model.put(doc.id, doc);
        }
        if (SolrTestCaseJ4.random().nextInt(10) == 0) {
            SolrTestCaseJ4.assertU(SolrTestCaseJ4.optimize(new String[0]));
        } else if (SolrTestCaseJ4.random().nextInt(10) == 0) {
            SolrTestCaseJ4.assertU(SolrTestCaseJ4.commit(new String[0]));
        } else {
            SolrTestCaseJ4.assertU(SolrTestCaseJ4.commit("softCommit", "true"));
        }
        String responseStr = h.query(SolrTestCaseJ4.req("q", "*:*", "fl", "id", "sort", "_docid_ asc", "rows", Integer.toString(model.size() * 2), "wt", "json", "indent", "true"));
        Object response = ObjectBuilder.fromJSON((String)responseStr);
        response = ((Map)response).get("response");
        response = ((Map)response).get("docs");
        List docList = (List)response;
        int order = 0;
        for (Map doc : docList) {
            Object id = doc.get("id");
            Doc modelDoc = model.get(id);
            if (modelDoc == null) continue;
            modelDoc.order = order++;
        }
        SolrTestCaseJ4.assertEquals((long)order, (long)model.size());
        return model;
    }

    public static Doc createDoc(List<FldType> descriptor) {
        Doc doc = new Doc();
        doc.fields = new ArrayList<Fld>();
        for (FldType ftype : descriptor) {
            Fld fld = ftype.createField();
            if (fld == null) continue;
            doc.fields.add(fld);
            if (!"id".equals(ftype.fname)) continue;
            doc.id = fld.vals.get(0);
        }
        return doc;
    }

    public static Comparator<Doc> createSort(IndexSchema schema, List<FldType> fieldTypes, String[] out) {
        StringBuilder sortSpec = new StringBuilder();
        int nSorts = SolrTestCaseJ4.random().nextInt(4);
        ArrayList<Comparator<Doc>> comparators = new ArrayList<Comparator<Doc>>();
        for (int i = 0; i < nSorts; ++i) {
            if (i > 0) {
                sortSpec.append(',');
            }
            int which = SolrTestCaseJ4.random().nextInt(fieldTypes.size() + 2);
            boolean asc = SolrTestCaseJ4.random().nextBoolean();
            if (which == fieldTypes.size()) {
                sortSpec.append("score").append(asc ? " asc" : " desc");
                comparators.add(SolrTestCaseJ4.createComparator("score", asc, false, false, false));
                continue;
            }
            if (which == fieldTypes.size() + 1) {
                sortSpec.append("_docid_").append(asc ? " asc" : " desc");
                comparators.add(SolrTestCaseJ4.createComparator("_docid_", asc, false, false, false));
                continue;
            }
            String field = fieldTypes.get((int)which).fname;
            sortSpec.append(field).append(asc ? " asc" : " desc");
            SchemaField sf = schema.getField(field);
            comparators.add(SolrTestCaseJ4.createComparator(field, asc, sf.sortMissingLast(), sf.sortMissingFirst(), !sf.sortMissingLast() && !sf.sortMissingFirst()));
        }
        String string = out[0] = sortSpec.length() > 0 ? sortSpec.toString() : null;
        if (comparators.size() == 0) {
            comparators.add(SolrTestCaseJ4.createComparator("score", false, false, false, false));
        }
        return SolrTestCaseJ4.createComparator(comparators);
    }

    public static Comparator<Doc> createComparator(final String field, boolean asc, final boolean sortMissingLast, final boolean sortMissingFirst, boolean sortMissingAsZero) {
        int mul;
        int n = mul = asc ? 1 : -1;
        if (field.equals("_docid_")) {
            return (o1, o2) -> (o1.order - o2.order) * mul;
        }
        if (field.equals("score")) {
            return SolrTestCaseJ4.createComparator("score_f", asc, sortMissingLast, sortMissingFirst, sortMissingAsZero);
        }
        return new Comparator<Doc>(){

            private Comparable zeroVal(Comparable template) {
                if (template == null) {
                    return null;
                }
                if (template instanceof String) {
                    return null;
                }
                if (template instanceof Integer) {
                    return Integer.valueOf(0);
                }
                if (template instanceof Long) {
                    return Long.valueOf(0L);
                }
                if (template instanceof Float) {
                    return Float.valueOf(0.0f);
                }
                if (template instanceof Double) {
                    return Double.valueOf(0.0);
                }
                if (template instanceof Short) {
                    return Short.valueOf((short)0);
                }
                if (template instanceof Byte) {
                    return Byte.valueOf((byte)0);
                }
                if (template instanceof Character) {
                    return Character.valueOf('\u0000');
                }
                return null;
            }

            @Override
            public int compare(Doc o1, Doc o2) {
                Comparable v1 = o1.getFirstValue(field);
                Comparable v2 = o2.getFirstValue(field);
                v1 = v1 == null ? this.zeroVal(v2) : v1;
                v2 = v2 == null ? this.zeroVal(v1) : v2;
                int c = 0;
                c = v1 == v2 ? 0 : (v1 == null ? (sortMissingLast ? mul : (sortMissingFirst ? -mul : -1)) : (v2 == null ? (sortMissingLast ? -mul : (sortMissingFirst ? mul : 1)) : v1.compareTo(v2)));
                return c *= mul;
            }
        };
    }

    public static Comparator<Doc> createComparator(List<Comparator<Doc>> comparators) {
        return (o1, o2) -> {
            int c = 0;
            for (Comparator comparator : comparators) {
                c = comparator.compare(o1, o2);
                if (c == 0) continue;
                return c;
            }
            return o1.order - o2.order;
        };
    }

    public static String toJSON(Doc doc) {
        CharArr out = new CharArr();
        try {
            out.append((CharSequence)"{\"add\":{\"doc\":{");
            boolean firstField = true;
            for (Fld fld : doc.fields) {
                if (firstField) {
                    firstField = false;
                } else {
                    out.append(',');
                }
                JSONUtil.writeString((CharSequence)fld.ftype.fname, (int)0, (int)fld.ftype.fname.length(), (CharArr)out);
                out.append(':');
                if (fld.vals.size() > 1) {
                    out.append('[');
                }
                boolean firstVal = true;
                for (Comparable val : fld.vals) {
                    if (firstVal) {
                        firstVal = false;
                    } else {
                        out.append(',');
                    }
                    out.append((CharSequence)JSONUtil.toJSON((Object)val));
                }
                if (fld.vals.size() <= 1) continue;
                out.append(']');
            }
            out.append((CharSequence)"}}}");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public Map<Comparable, List<Comparable>> invertField(Map<Comparable, Doc> model, String field) {
        HashMap<Comparable, List<Comparable>> value_to_id = new HashMap<Comparable, List<Comparable>>();
        for (Comparable key : model.keySet()) {
            Doc doc = model.get(key);
            List<Comparable> vals = doc.getValues(field);
            if (vals == null) continue;
            for (Comparable val : vals) {
                ArrayList<Comparable> ids = (ArrayList<Comparable>)value_to_id.get(val);
                if (ids == null) {
                    ids = new ArrayList<Comparable>(2);
                    value_to_id.put(val, ids);
                }
                ids.add(key);
            }
        }
        return value_to_id;
    }

    public static File getFile(String name) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(name.replace(File.separatorChar, '/'));
        if (url != null) {
            try {
                return new File(url.toURI());
            }
            catch (Exception e) {
                throw new RuntimeException("Resource was found on classpath, but cannot be resolved to a normal file (maybe it is part of a JAR file): " + name);
            }
        }
        File file = new File(name);
        if (file.exists()) {
            return file;
        }
        throw new RuntimeException("Cannot find resource in classpath or in file-system (relative to CWD): " + name);
    }

    public static String TEST_HOME() {
        return SolrTestCaseJ4.getFile("solr/collection1").getParent();
    }

    public static Path TEST_PATH() {
        return SolrTestCaseJ4.getFile("solr/collection1").getParentFile().toPath();
    }

    public static Path configset(String name) {
        return SolrTestCaseJ4.TEST_PATH().resolve("configsets").resolve(name).resolve("conf");
    }

    public static Throwable getRootCause(Throwable t) {
        Throwable result = t;
        for (Throwable cause = t; null != cause; cause = cause.getCause()) {
            result = cause;
        }
        return result;
    }

    public static void assertXmlFile(File file, String ... xpath) throws IOException, SAXException {
        try {
            String xml = FileUtils.readFileToString((File)file, (String)"UTF-8");
            String results = TestHarness.validateXPath(xml, xpath);
            if (null != results) {
                String msg = "File XPath failure: file=" + file.getPath() + " xpath=" + results + "\n\nxml was: " + xml;
                SolrTestCaseJ4.fail((String)msg);
            }
        }
        catch (XPathExpressionException e2) {
            throw new RuntimeException("XPath is invalid", e2);
        }
    }

    public static void assertFieldValues(SolrDocumentList documents, String fieldName, Object ... expectedValues) {
        if (documents.size() != expectedValues.length) {
            SolrTestCaseJ4.fail((String)("Number of documents (" + documents.size() + ") is different from number of expected values (" + expectedValues.length));
        }
        for (int docNum = 1; docNum <= documents.size(); ++docNum) {
            SolrDocument doc = (SolrDocument)documents.get(docNum - 1);
            Object expected = expectedValues[docNum - 1];
            Object actual = doc.get((Object)fieldName);
            if (!(null == expected && null != actual || null != expected && null == actual) && (null == expected || null == actual || expected.equals(actual))) continue;
            SolrTestCaseJ4.fail((String)("Unexpected " + fieldName + " field value in document #" + docNum + ": expected=[" + expected + "], actual=[" + actual + "]"));
        }
    }

    public static void copyMinConf(File dstRoot) throws IOException {
        SolrTestCaseJ4.copyMinConf(dstRoot, null);
    }

    public static void copyMinConf(File dstRoot, String propertiesContent) throws IOException {
        SolrTestCaseJ4.copyMinConf(dstRoot, propertiesContent, "solrconfig-minimal.xml");
    }

    public static void copyMinConf(File dstRoot, String propertiesContent, String solrconfigXmlName) throws IOException {
        File subHome = new File(dstRoot, "conf");
        if (!dstRoot.exists()) {
            SolrTestCaseJ4.assertTrue((String)"Failed to make subdirectory ", (boolean)dstRoot.mkdirs());
        }
        Files.createFile(dstRoot.toPath().resolve(CORE_PROPERTIES_FILENAME), new FileAttribute[0]);
        if (propertiesContent != null) {
            FileUtils.writeStringToFile((File)new File(dstRoot, CORE_PROPERTIES_FILENAME), (String)propertiesContent, (Charset)StandardCharsets.UTF_8);
        }
        String top = SolrTestCaseJ4.TEST_HOME() + "/collection1/conf";
        FileUtils.copyFile((File)new File(top, "schema-tiny.xml"), (File)new File(subHome, "schema.xml"));
        FileUtils.copyFile((File)new File(top, solrconfigXmlName), (File)new File(subHome, "solrconfig.xml"));
        FileUtils.copyFile((File)new File(top, "solrconfig.snippet.randomindexconfig.xml"), (File)new File(subHome, "solrconfig.snippet.randomindexconfig.xml"));
    }

    public static void copyMinFullSetup(File dstRoot) throws IOException {
        if (!dstRoot.exists()) {
            SolrTestCaseJ4.assertTrue((String)"Failed to make subdirectory ", (boolean)dstRoot.mkdirs());
        }
        File xmlF = new File(SolrTestCaseJ4.TEST_HOME(), "solr.xml");
        FileUtils.copyFile((File)xmlF, (File)new File(dstRoot, "solr.xml"));
        SolrTestCaseJ4.copyMinConf(dstRoot);
    }

    public static void copyXmlToHome(File dstRoot, String fromFile) throws IOException {
        if (!dstRoot.exists()) {
            SolrTestCaseJ4.assertTrue((String)"Failed to make subdirectory ", (boolean)dstRoot.mkdirs());
        }
        File xmlF = new File(SolrTestCaseJ4.TEST_HOME(), fromFile);
        FileUtils.copyFile((File)xmlF, (File)new File(dstRoot, "solr.xml"));
    }

    public static void copySolrHomeToTemp(File dstRoot, String collection) throws IOException {
        if (!dstRoot.exists()) {
            SolrTestCaseJ4.assertTrue((String)"Failed to make subdirectory ", (boolean)dstRoot.mkdirs());
        }
        FileUtils.copyFile((File)new File(SolrTestCaseJ4.TEST_HOME(), "solr.xml"), (File)new File(dstRoot, "solr.xml"));
        File subHome = new File(dstRoot, collection + File.separator + "conf");
        String top = SolrTestCaseJ4.TEST_HOME() + "/collection1/conf";
        FileUtils.copyFile((File)new File(top, "currency.xml"), (File)new File(subHome, "currency.xml"));
        FileUtils.copyFile((File)new File(top, "mapping-ISOLatin1Accent.txt"), (File)new File(subHome, "mapping-ISOLatin1Accent.txt"));
        FileUtils.copyFile((File)new File(top, "old_synonyms.txt"), (File)new File(subHome, "old_synonyms.txt"));
        FileUtils.copyFile((File)new File(top, "open-exchange-rates.json"), (File)new File(subHome, "open-exchange-rates.json"));
        FileUtils.copyFile((File)new File(top, "protwords.txt"), (File)new File(subHome, "protwords.txt"));
        FileUtils.copyFile((File)new File(top, "schema.xml"), (File)new File(subHome, "schema.xml"));
        FileUtils.copyFile((File)new File(top, "enumsConfig.xml"), (File)new File(subHome, "enumsConfig.xml"));
        FileUtils.copyFile((File)new File(top, "solrconfig.snippet.randomindexconfig.xml"), (File)new File(subHome, "solrconfig.snippet.randomindexconfig.xml"));
        FileUtils.copyFile((File)new File(top, "solrconfig.xml"), (File)new File(subHome, "solrconfig.xml"));
        FileUtils.copyFile((File)new File(top, "stopwords.txt"), (File)new File(subHome, "stopwords.txt"));
        FileUtils.copyFile((File)new File(top, "synonyms.txt"), (File)new File(subHome, "synonyms.txt"));
    }

    public boolean compareSolrDocument(Object expected, Object actual) {
        if (!(expected instanceof SolrDocument) || !(actual instanceof SolrDocument)) {
            return false;
        }
        if (expected == actual) {
            return true;
        }
        SolrDocument solrDocument1 = (SolrDocument)expected;
        SolrDocument solrDocument2 = (SolrDocument)actual;
        if (solrDocument1.getFieldNames().size() != solrDocument2.getFieldNames().size()) {
            return false;
        }
        Iterator iter1 = solrDocument1.getFieldNames().iterator();
        Iterator iter2 = solrDocument2.getFieldNames().iterator();
        if (iter1.hasNext()) {
            String key1 = (String)iter1.next();
            String key2 = (String)iter2.next();
            Collection val1 = solrDocument1.getFieldValues(key1);
            Collection val2 = solrDocument2.getFieldValues(key2);
            if (!key1.equals(key2) || !((Object)val1).equals(val2)) {
                return false;
            }
        }
        if (solrDocument1.getChildDocuments() == null && solrDocument2.getChildDocuments() == null) {
            return true;
        }
        if (solrDocument1.getChildDocuments() == null || solrDocument2.getChildDocuments() == null) {
            return false;
        }
        if (solrDocument1.getChildDocuments().size() != solrDocument2.getChildDocuments().size()) {
            return false;
        }
        Iterator childDocsIter1 = solrDocument1.getChildDocuments().iterator();
        Iterator childDocsIter2 = solrDocument2.getChildDocuments().iterator();
        while (childDocsIter1.hasNext()) {
            if (this.compareSolrDocument(childDocsIter1.next(), childDocsIter2.next())) continue;
            return false;
        }
        return true;
    }

    public boolean compareSolrDocumentList(Object expected, Object actual) {
        if (!(expected instanceof SolrDocumentList) || !(actual instanceof SolrDocumentList)) {
            return false;
        }
        if (expected == actual) {
            return true;
        }
        SolrDocumentList list1 = (SolrDocumentList)expected;
        SolrDocumentList list2 = (SolrDocumentList)actual;
        if (Float.compare(list1.getMaxScore().floatValue(), list2.getMaxScore().floatValue()) != 0 || list1.getNumFound() != list2.getNumFound() || list1.getStart() != list2.getStart()) {
            return false;
        }
        int i = 0;
        while ((long)i < list1.getNumFound()) {
            if (!this.compareSolrDocument(list1.get(i), list2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean compareSolrInputDocument(Object expected, Object actual) {
        if (!(expected instanceof SolrInputDocument) || !(actual instanceof SolrInputDocument)) {
            return false;
        }
        if (expected == actual) {
            return true;
        }
        SolrInputDocument sdoc1 = (SolrInputDocument)expected;
        SolrInputDocument sdoc2 = (SolrInputDocument)actual;
        if (Float.compare(sdoc1.getDocumentBoost(), sdoc2.getDocumentBoost()) != 0) {
            return false;
        }
        if (sdoc1.getFieldNames().size() != sdoc2.getFieldNames().size()) {
            return false;
        }
        Iterator iter1 = sdoc1.getFieldNames().iterator();
        Iterator iter2 = sdoc2.getFieldNames().iterator();
        if (iter1.hasNext()) {
            String key1 = (String)iter1.next();
            String key2 = (String)iter2.next();
            Collection val1 = sdoc1.getFieldValues(key1);
            Collection val2 = sdoc2.getFieldValues(key2);
            if (!key1.equals(key2) || !((Object)val1).equals(val2)) {
                return false;
            }
        }
        if (sdoc1.getChildDocuments() == null && sdoc2.getChildDocuments() == null) {
            return true;
        }
        if (sdoc1.getChildDocuments() == null || sdoc2.getChildDocuments() == null) {
            return false;
        }
        if (sdoc1.getChildDocuments().size() != sdoc2.getChildDocuments().size()) {
            return false;
        }
        Iterator childDocsIter1 = sdoc1.getChildDocuments().iterator();
        Iterator childDocsIter2 = sdoc2.getChildDocuments().iterator();
        while (childDocsIter1.hasNext()) {
            if (this.compareSolrInputDocument(childDocsIter1.next(), childDocsIter2.next())) continue;
            return false;
        }
        return true;
    }

    public boolean assertSolrInputFieldEquals(Object expected, Object actual) {
        if (!(expected instanceof SolrInputField) || !(actual instanceof SolrInputField)) {
            return false;
        }
        if (expected == actual) {
            return true;
        }
        SolrInputField sif1 = (SolrInputField)expected;
        SolrInputField sif2 = (SolrInputField)actual;
        if (!sif1.getName().equals(sif2.getName())) {
            return false;
        }
        if (!sif1.getValue().equals(sif2.getValue())) {
            return false;
        }
        return Float.compare(sif1.getBoost(), sif2.getBoost()) == 0;
    }

    public static Object skewed(Object likely, Object unlikely) {
        return 0 == TestUtil.nextInt((Random)SolrTestCaseJ4.random(), (int)0, (int)9) ? unlikely : likely;
    }

    public static CloudSolrClient getCloudSolrClient(String zkHost) {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new CloudSolrClient(zkHost);
        }
        return new CloudSolrClientBuilder().withZkHost(zkHost).build();
    }

    public static CloudSolrClient getCloudSolrClient(String zkHost, HttpClient httpClient) {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new CloudSolrClient(zkHost, httpClient);
        }
        return new CloudSolrClientBuilder().withZkHost(zkHost).withHttpClient(httpClient).build();
    }

    public static CloudSolrClient getCloudSolrClient(String zkHost, boolean shardLeadersOnly) {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new CloudSolrClient(zkHost, shardLeadersOnly);
        }
        if (shardLeadersOnly) {
            return new CloudSolrClientBuilder().withZkHost(zkHost).sendUpdatesOnlyToShardLeaders().build();
        }
        return new CloudSolrClientBuilder().withZkHost(zkHost).sendUpdatesToAllReplicasInShard().build();
    }

    public static CloudSolrClient getCloudSolrClient(String zkHost, boolean shardLeadersOnly, HttpClient httpClient) {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new CloudSolrClient(zkHost, shardLeadersOnly, httpClient);
        }
        if (shardLeadersOnly) {
            return new CloudSolrClientBuilder().withZkHost(zkHost).withHttpClient(httpClient).sendUpdatesOnlyToShardLeaders().build();
        }
        return new CloudSolrClientBuilder().withZkHost(zkHost).withHttpClient(httpClient).sendUpdatesToAllReplicasInShard().build();
    }

    public static ConcurrentUpdateSolrClient getConcurrentUpdateSolrClient(String baseSolrUrl, int queueSize, int threadCount) {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new ConcurrentUpdateSolrClient(baseSolrUrl, queueSize, threadCount);
        }
        return new ConcurrentUpdateSolrClient.Builder(baseSolrUrl).withQueueSize(queueSize).withThreadCount(threadCount).build();
    }

    public static ConcurrentUpdateSolrClient getConcurrentUpdateSolrClient(String baseSolrUrl, HttpClient httpClient, int queueSize, int threadCount) {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new ConcurrentUpdateSolrClient(baseSolrUrl, httpClient, queueSize, threadCount);
        }
        return new ConcurrentUpdateSolrClient.Builder(baseSolrUrl).withHttpClient(httpClient).withQueueSize(queueSize).withThreadCount(threadCount).build();
    }

    public static LBHttpSolrClient getLBHttpSolrClient(HttpClient client, String ... solrUrls) {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new LBHttpSolrClient(client, solrUrls);
        }
        return new LBHttpSolrClient.Builder().withHttpClient(client).withBaseSolrUrls(solrUrls).build();
    }

    public static LBHttpSolrClient getLBHttpSolrClient(String ... solrUrls) throws MalformedURLException {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new LBHttpSolrClient(solrUrls);
        }
        return new LBHttpSolrClient.Builder().withBaseSolrUrls(solrUrls).build();
    }

    public static HttpSolrClient getHttpSolrClient(String url, HttpClient httpClient, ResponseParser responseParser, boolean compression) {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new HttpSolrClient(url, httpClient, responseParser, compression);
        }
        return new HttpSolrClient.Builder(url).withHttpClient(httpClient).withResponseParser(responseParser).allowCompression(compression).build();
    }

    public static HttpSolrClient getHttpSolrClient(String url, HttpClient httpClient, ResponseParser responseParser) {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new HttpSolrClient(url, httpClient, responseParser);
        }
        return new HttpSolrClient.Builder(url).withHttpClient(httpClient).withResponseParser(responseParser).build();
    }

    public static HttpSolrClient getHttpSolrClient(String url, HttpClient httpClient) {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new HttpSolrClient(url, httpClient);
        }
        return new HttpSolrClient.Builder(url).withHttpClient(httpClient).build();
    }

    public static HttpSolrClient getHttpSolrClient(String url) {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            return new HttpSolrClient(url);
        }
        return new HttpSolrClient.Builder(url).build();
    }

    public static String randomDate() {
        return Instant.ofEpochMilli(SolrTestCaseJ4.random().nextLong()).toString();
    }

    public static String randomSkewedDate() {
        return String.format(Locale.ROOT, "2010-10-31T10:31:%02d.000Z", TestUtil.nextInt((Random)SolrTestCaseJ4.random(), (int)0, (int)59));
    }

    public static String randomXmlUsableUnicodeString() {
        String result = TestUtil.randomRealisticUnicodeString((Random)SolrTestCaseJ4.random());
        if (result.matches(".*\\p{InSpecials}.*")) {
            result = TestUtil.randomSimpleString((Random)SolrTestCaseJ4.random());
        }
        return result;
    }

    protected void waitForWarming() throws InterruptedException {
        RefCounted registeredSearcher = h.getCore().getRegisteredSearcher();
        RefCounted newestSearcher = h.getCore().getNewestSearcher(false);
        while (registeredSearcher == null || registeredSearcher.get() != newestSearcher.get()) {
            if (registeredSearcher != null) {
                registeredSearcher.decref();
            }
            newestSearcher.decref();
            Thread.sleep(50L);
            registeredSearcher = h.getCore().getRegisteredSearcher();
            newestSearcher = h.getCore().getNewestSearcher(false);
        }
        registeredSearcher.decref();
        newestSearcher.decref();
    }

    @BeforeClass
    public static void chooseMPForMP() throws Exception {
        if (SolrTestCaseJ4.random().nextBoolean()) {
            System.setProperty(SYSTEM_PROPERTY_SOLR_TESTS_USEMERGEPOLICYFACTORY, "true");
            System.setProperty(SYSTEM_PROPERTY_SOLR_TESTS_USEMERGEPOLICY, "false");
        } else {
            System.setProperty(SYSTEM_PROPERTY_SOLR_TESTS_USEMERGEPOLICYFACTORY, "false");
            System.setProperty(SYSTEM_PROPERTY_SOLR_TESTS_USEMERGEPOLICY, "true");
        }
    }

    @AfterClass
    public static void unchooseMPForMP() {
        System.clearProperty(SYSTEM_PROPERTY_SOLR_TESTS_USEMERGEPOLICYFACTORY);
        System.clearProperty(SYSTEM_PROPERTY_SOLR_TESTS_USEMERGEPOLICY);
    }

    @Deprecated
    protected static void systemSetPropertySolrTestsMergePolicy(String value) {
        System.setProperty(SYSTEM_PROPERTY_SOLR_TESTS_MERGEPOLICY, value);
    }

    @Deprecated
    protected static void systemClearPropertySolrTestsMergePolicy() {
        System.clearProperty(SYSTEM_PROPERTY_SOLR_TESTS_MERGEPOLICY);
    }

    protected static void systemSetPropertySolrTestsMergePolicyFactory(String value) {
        System.setProperty(SYSTEM_PROPERTY_SOLR_TESTS_MERGEPOLICYFACTORY, value);
    }

    protected static void systemClearPropertySolrTestsMergePolicyFactory() {
        System.clearProperty(SYSTEM_PROPERTY_SOLR_TESTS_MERGEPOLICYFACTORY);
    }

    protected <T> T pickRandom(T ... options) {
        return options[SolrTestCaseJ4.random().nextInt(options.length)];
    }

    static {
        solrClassRules = RuleChain.outerRule((TestRule)new SystemPropertiesRestoreRule()).around((TestRule)new RevertDefaultThreadHandlerRule());
        savedClassLogLevels = new HashMap<String, String>();
        changedFactory = false;
        ZERO_ONE = new IRange(0, 1);
        ZERO_TWO = new IRange(0, 2);
        ONE_ONE = new IRange(1, 1);
    }

    public static class CloudSolrClientBuilder
    extends CloudSolrClient.Builder {
        private boolean configuredDUTflag = false;

        public CloudSolrClient.Builder sendDirectUpdatesToShardLeadersOnly() {
            this.configuredDUTflag = true;
            return super.sendDirectUpdatesToShardLeadersOnly();
        }

        public CloudSolrClient.Builder sendDirectUpdatesToAnyShardReplica() {
            this.configuredDUTflag = true;
            return super.sendDirectUpdatesToAnyShardReplica();
        }

        private void randomlyChooseDirectUpdatesToLeadersOnly() {
            if (LuceneTestCase.random().nextBoolean()) {
                this.sendDirectUpdatesToShardLeadersOnly();
            } else {
                this.sendDirectUpdatesToAnyShardReplica();
            }
        }

        public CloudSolrClient build() {
            if (!this.configuredDUTflag) {
                if (LuceneTestCase.random().nextBoolean()) {
                    this.randomlyChooseDirectUpdatesToLeadersOnly();
                } else {
                    this.configuredDUTflag = true;
                }
            }
            return super.build();
        }
    }

    protected static class FldType {
        public String fname;
        public IVals numValues;
        public Vals vals;

        public FldType(String fname, Vals vals) {
            this(fname, ZERO_ONE, vals);
        }

        public FldType(String fname, IVals numValues, Vals vals) {
            this.fname = fname;
            this.numValues = numValues;
            this.vals = vals;
        }

        public Comparable createValue() {
            return this.vals.get();
        }

        public List<Comparable> createValues() {
            int nVals = this.numValues.getInt();
            if (nVals <= 0) {
                return null;
            }
            ArrayList<Comparable> vals = new ArrayList<Comparable>(nVals);
            for (int i = 0; i < nVals; ++i) {
                vals.add(this.createValue());
            }
            return vals;
        }

        public Fld createField() {
            List<Comparable> vals = this.createValues();
            if (vals == null) {
                return null;
            }
            Fld fld = new Fld();
            fld.ftype = this;
            fld.vals = vals;
            return fld;
        }
    }

    public static class Fld {
        public FldType ftype;
        public List<Comparable> vals;

        public String toString() {
            return this.ftype.fname + "=" + (this.vals.size() == 1 ? this.vals.get(0).toString() : this.vals.toString());
        }
    }

    public static class Doc
    implements Comparable {
        public Comparable id;
        public List<Fld> fields;
        public int order;

        public String toString() {
            return "Doc(" + this.order + "):" + this.fields.toString();
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Doc)) {
                return false;
            }
            Doc other = (Doc)o;
            return this == other || this.id != null && this.id.equals(other.id);
        }

        public int compareTo(Object o) {
            if (!(o instanceof Doc)) {
                return this.getClass().hashCode() - o.getClass().hashCode();
            }
            Doc other = (Doc)o;
            return this.id.compareTo(other.id);
        }

        public List<Comparable> getValues(String field) {
            for (Fld fld : this.fields) {
                if (!fld.ftype.fname.equals(field)) continue;
                return fld.vals;
            }
            return null;
        }

        public Comparable getFirstValue(String field) {
            List<Comparable> vals = this.getValues(field);
            return vals == null || vals.size() == 0 ? null : vals.get(0);
        }

        public Map<String, Object> toObject(IndexSchema schema) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Fld fld : this.fields) {
                SchemaField sf = schema.getField(fld.ftype.fname);
                if (!sf.multiValued()) {
                    result.put(fld.ftype.fname, fld.vals.get(0));
                    continue;
                }
                result.put(fld.ftype.fname, fld.vals);
            }
            return result;
        }
    }

    public static class SVal
    extends Vals {
        char start;
        char end;
        int minLength;
        int maxLength;

        public SVal() {
            this('a', 'z', 1, 10);
        }

        public SVal(char start, char end, int minLength, int maxLength) {
            this.start = start;
            this.end = end;
            this.minLength = minLength;
            this.maxLength = maxLength;
        }

        @Override
        public Comparable get() {
            char[] arr = new char[this.between(this.minLength, this.maxLength)];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = (char)this.between(this.start, this.end);
            }
            return new String(arr);
        }
    }

    public static class FVal
    extends Vals {
        final float min;
        final float max;

        public FVal(float min, float max) {
            this.min = min;
            this.max = max;
        }

        public float getFloat() {
            if (this.min >= this.max) {
                return this.min;
            }
            return this.min + LuceneTestCase.random().nextFloat() * (this.max - this.min);
        }

        @Override
        public Comparable get() {
            return Float.valueOf(this.getFloat());
        }
    }

    public static class IValsPercent
    extends IVals {
        final int[] percentAndValue;

        public IValsPercent(int ... percentAndValue) {
            this.percentAndValue = percentAndValue;
        }

        @Override
        public int getInt() {
            int r = this.between(0, 99);
            int cumulative = 0;
            for (int i = 0; i < this.percentAndValue.length; i += 2) {
                if (r >= (cumulative += this.percentAndValue[i])) continue;
                return this.percentAndValue[i + 1];
            }
            return this.percentAndValue[this.percentAndValue.length - 1];
        }

        @Override
        public Comparable get() {
            return Integer.valueOf(this.getInt());
        }
    }

    public static class IRange
    extends IVals {
        final int min;
        final int max;

        public IRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public int getInt() {
            return this.between(this.min, this.max);
        }

        @Override
        public Comparable get() {
            return Integer.valueOf(this.getInt());
        }
    }

    public static abstract class IVals
    extends Vals {
        public abstract int getInt();
    }

    public static abstract class Vals {
        public abstract Comparable get();

        public String toJSON(Comparable val) {
            return JSONUtil.toJSON((Object)val);
        }

        protected int between(int min, int max) {
            return min != max ? LuceneTestCase.random().nextInt(max - min + 1) + min : min;
        }
    }

    public static class XmlDoc {
        public String xml;

        public String toString() {
            return this.xml;
        }
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressPointFields {
        public String bugUrl() default "None";
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressObjectReleaseTracker {
        public String bugUrl();
    }

    @Documented
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface SuppressSSL {
        public String bugUrl() default "None";
    }
}

