/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Properties;
import java.util.SortedMap;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.util.ExternalPaths;
import org.eclipse.jetty.servlet.ServletHolder;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SolrJettyTestBase
extends SolrTestCaseJ4 {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static JettySolrRunner jetty;
    public static int port;
    public static SolrClient client;
    public static String context;

    @BeforeClass
    public static void beforeSolrJettyTestBase() throws Exception {
    }

    public static JettySolrRunner createJetty(String solrHome, String configFile, String schemaFile, String context, boolean stopAtShutdown, SortedMap<ServletHolder, String> extraServlets) throws Exception {
        SolrJettyTestBase.context = context = context == null ? "/solr" : context;
        JettyConfig jettyConfig = JettyConfig.builder().setContext(context).stopAtShutdown(stopAtShutdown).withServlets(extraServlets).withSSLConfig((SSLConfig)sslConfig).build();
        Properties nodeProps = new Properties();
        if (configFile != null) {
            nodeProps.setProperty("solrconfig", configFile);
        }
        if (schemaFile != null) {
            nodeProps.setProperty("schema", schemaFile);
        }
        if (System.getProperty("solr.data.dir") == null && System.getProperty("solr.hdfs.home") == null) {
            nodeProps.setProperty("solr.data.dir", SolrJettyTestBase.createTempDir().toFile().getCanonicalPath());
        }
        return SolrJettyTestBase.createJetty(solrHome, nodeProps, jettyConfig);
    }

    public static JettySolrRunner createJetty(String solrHome, String configFile, String context) throws Exception {
        return SolrJettyTestBase.createJetty(solrHome, configFile, null, context, true, null);
    }

    public static JettySolrRunner createJetty(String solrHome, JettyConfig jettyConfig) throws Exception {
        return SolrJettyTestBase.createJetty(solrHome, new Properties(), jettyConfig);
    }

    public static JettySolrRunner createJetty(String solrHome) throws Exception {
        return SolrJettyTestBase.createJetty(solrHome, new Properties(), JettyConfig.builder().withSSLConfig((SSLConfig)sslConfig).build());
    }

    public static JettySolrRunner createJetty(String solrHome, Properties nodeProperties, JettyConfig jettyConfig) throws Exception {
        SolrJettyTestBase.initCore(null, null, solrHome);
        Path coresDir = SolrJettyTestBase.createTempDir().resolve("cores");
        Properties props = new Properties();
        props.setProperty("name", "collection1");
        props.setProperty("configSet", "collection1");
        props.setProperty("config", "${solrconfig:solrconfig.xml}");
        props.setProperty("schema", "${schema:schema.xml}");
        SolrJettyTestBase.writeCoreProperties(coresDir.resolve("core"), props, "RestTestBase");
        Properties nodeProps = new Properties(nodeProperties);
        nodeProps.setProperty("coreRootDirectory", coresDir.toString());
        nodeProps.setProperty("configSetBaseDir", solrHome);
        jetty = new JettySolrRunner(solrHome, nodeProps, jettyConfig);
        jetty.start();
        port = jetty.getLocalPort();
        log.info("Jetty Assigned Port#" + port);
        return jetty;
    }

    @After
    public void afterClass() throws Exception {
        if (client != null) {
            client.close();
        }
        client = null;
    }

    @AfterClass
    public static void afterSolrJettyTestBase() throws Exception {
        if (jetty != null) {
            jetty.stop();
            jetty = null;
        }
    }

    public SolrClient getSolrClient() {
        if (client == null) {
            client = this.createNewSolrClient();
        }
        return client;
    }

    public SolrClient createNewSolrClient() {
        if (jetty != null) {
            try {
                String url = jetty.getBaseUrl().toString() + "/" + "collection1";
                HttpSolrClient client = SolrJettyTestBase.getHttpSolrClient(url, DEFAULT_CONNECTION_TIMEOUT);
                return client;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return new EmbeddedSolrServer(h.getCoreContainer(), "collection1"){

            public void close() {
            }
        };
    }

    public static void setupJettyTestHome(File solrHome, String collection) throws Exception {
        SolrJettyTestBase.copySolrHomeToTemp(solrHome, collection);
    }

    public static void cleanUpJettyHome(File solrHome) throws Exception {
        if (solrHome.exists()) {
            FileUtils.deleteDirectory((File)solrHome);
        }
    }

    public static void initCore() throws Exception {
        String exampleHome = SolrJettyTestBase.legacyExampleCollection1SolrHome();
        String exampleConfig = exampleHome + "/collection1/conf/solrconfig.xml";
        String exampleSchema = exampleHome + "/collection1/conf/schema.xml";
        SolrJettyTestBase.initCore(exampleConfig, exampleSchema, exampleHome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String legacyExampleCollection1SolrHome() {
        String sourceHome = ExternalPaths.SOURCE_HOME;
        if (sourceHome == null) {
            throw new IllegalStateException("No source home! Cannot create the legacy example solr home directory.");
        }
        String legacyExampleSolrHome = null;
        try {
            File tempSolrHome = LuceneTestCase.createTempDir().toFile();
            FileUtils.copyFileToDirectory((File)new File(sourceHome, "server/solr/solr.xml"), (File)tempSolrHome);
            File collection1Dir = new File(tempSolrHome, "collection1");
            FileUtils.forceMkdir((File)collection1Dir);
            File configSetDir = new File(sourceHome, "server/solr/configsets/sample_techproducts_configs/conf");
            FileUtils.copyDirectoryToDirectory((File)configSetDir, (File)collection1Dir);
            Properties props = new Properties();
            props.setProperty("name", "collection1");
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)FileUtils.openOutputStream((File)new File(collection1Dir, "core.properties")), "UTF-8");
                props.store(writer, null);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
            legacyExampleSolrHome = tempSolrHome.getAbsolutePath();
        }
        catch (Exception exc) {
            if (exc instanceof RuntimeException) {
                throw (RuntimeException)exc;
            }
            throw new RuntimeException(exc);
        }
        return legacyExampleSolrHome;
    }

    static {
        client = null;
    }
}

