/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.client.solrj.response.CoreAdminResponse;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.client.solrj.response.RequestStatusState;
import org.apache.solr.cloud.AbstractDistribZkTestBase;
import org.apache.solr.cloud.ChaosMonkey;
import org.apache.solr.cloud.CloudInspectUtil;
import org.apache.solr.cloud.SocketProxy;
import org.apache.solr.cloud.ZkShardTerms;
import org.apache.solr.cloud.api.collections.OverseerCollectionMessageHandler;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.Diagnostics;
import org.apache.solr.core.SolrCore;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.DirectUpdateHandler2;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.RestTestHarness;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.noggit.CharArr;
import org.noggit.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@LuceneTestCase.Slow
public abstract class AbstractFullDistribZkTestBase
extends AbstractDistribZkTestBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SHARD1 = "shard1";
    public static final String SHARD2 = "shard2";
    protected boolean printLayoutOnTearDown = false;
    String t1 = "a_t";
    String i1 = "a_i1";
    String tlong = "other_tl1";
    String oddField = "oddField_s";
    String missingField = "ignore_exception__missing_but_valid_field_t";
    protected int sliceCount = 2;
    protected CloudSolrClient controlClientCloud;
    protected volatile CloudSolrClient cloudClient;
    protected List<SolrClient> coreClients = new ArrayList<SolrClient>();
    protected List<CloudJettyRunner> cloudJettys = new ArrayList<CloudJettyRunner>();
    protected Map<String, List<CloudJettyRunner>> shardToJetty = new HashMap<String, List<CloudJettyRunner>>();
    private AtomicInteger jettyIntCntr = new AtomicInteger(0);
    protected ChaosMonkey chaosMonkey;
    protected Map<String, CloudJettyRunner> shardToLeaderJetty = new HashMap<String, CloudJettyRunner>();
    private boolean cloudInit;
    protected boolean useJettyDataDir = true;
    private List<RestTestHarness> restTestHarnesses = new ArrayList<RestTestHarness>();
    protected Map<URI, SocketProxy> proxies = new HashMap<URI, SocketProxy>();
    protected String defaultStateFormat = String.valueOf(1 + AbstractFullDistribZkTestBase.random().nextInt(2));
    private CloudSolrClient commonCloudSolrClient;

    @BeforeClass
    public static void beforeFullSolrCloudTest() {
    }

    protected static void setErrorHook() {
        SolrCmdDistributor.testing_errorHook = new Diagnostics.Callable(){

            public void call(Object ... data) {
                Exception e = (Exception)data[0];
                if (e == null) {
                    return;
                }
                String msg = e.getMessage();
                if (msg != null && msg.contains("Timeout")) {
                    Diagnostics.logThreadDumps((String)("REQUESTING THREAD DUMP DUE TO TIMEOUT: " + e.getMessage()));
                }
            }
        };
    }

    protected static void clearErrorHook() {
        SolrCmdDistributor.testing_errorHook = null;
    }

    @Override
    public void distribSetUp() throws Exception {
        super.distribSetUp();
        if (this.sliceCount > 0) {
            System.setProperty("numShards", Integer.toString(this.sliceCount));
        } else {
            System.clearProperty("numShards");
        }
        if (AbstractFullDistribZkTestBase.isSSLMode()) {
            System.clearProperty("urlScheme");
            try (ZkStateReader zkStateReader = new ZkStateReader(this.zkServer.getZkAddress(), 45000, 45000);){
                try {
                    zkStateReader.getZkClient().create("/clusterprops.json", Utils.toJSON(Collections.singletonMap("urlScheme", "https")), CreateMode.PERSISTENT, true);
                }
                catch (KeeperException.NodeExistsException e) {
                    ZkNodeProps props = ZkNodeProps.load((byte[])zkStateReader.getZkClient().getData("/clusterprops.json", null, null, true));
                    zkStateReader.getZkClient().setData("/clusterprops.json", Utils.toJSON((Object)props.plus("urlScheme", (Object)"https")), true);
                }
            }
        }
        if (this.useTlogReplicas()) {
            log.info("Will use {} replicas unless explicitly asked otherwise", (Object)Replica.Type.TLOG);
        } else {
            log.info("Will use {} replicas unless explicitly asked otherwise", (Object)Replica.Type.NRT);
        }
    }

    @BeforeClass
    public static void beforeClass() {
        System.setProperty("solrcloud.update.delay", "0");
    }

    @AfterClass
    public static void afterClass() throws Exception {
        System.clearProperty("solrcloud.update.delay");
        System.clearProperty("genericCoreNodeNames");
    }

    public AbstractFullDistribZkTestBase() {
        this.fixShardCount(4);
        this.stress = 0;
        this.useExplicitNodeNames = AbstractFullDistribZkTestBase.random().nextBoolean();
    }

    protected String getDataDir(String dataDir) throws IOException {
        return dataDir;
    }

    protected void initCloud() throws Exception {
        assert (!this.cloudInit);
        this.cloudInit = true;
        this.cloudClient = this.createCloudClient("collection1");
        this.cloudClient.connect();
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        this.chaosMonkey = new ChaosMonkey(this.zkServer, zkStateReader, "collection1", this.shardToJetty, this.shardToLeaderJetty);
    }

    protected boolean useTlogReplicas() {
        return false;
    }

    protected CloudSolrClient createCloudClient(String defaultCollection) {
        CloudSolrClient client = AbstractFullDistribZkTestBase.getCloudSolrClient(this.zkServer.getZkAddress(), AbstractFullDistribZkTestBase.random().nextBoolean(), 30000, 60000);
        if (defaultCollection != null) {
            client.setDefaultCollection(defaultCollection);
        }
        return client;
    }

    @Override
    protected void createServers(int numServers) throws Exception {
        File controlJettyDir = AbstractFullDistribZkTestBase.createTempDir((String)"control").toFile();
        this.setupJettySolrHome(controlJettyDir);
        this.controlJetty = this.createJetty(controlJettyDir, this.useJettyDataDir ? this.getDataDir(this.testDir + "/control/data") : null);
        try (CloudSolrClient client = this.createCloudClient("control_collection");){
            AbstractFullDistribZkTestBase.assertEquals((long)0L, (long)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)"control_collection", (String)"conf1", (int)1, (int)1).setCreateNodeSet(this.controlJetty.getNodeName()).process((SolrClient)client)).getStatus());
        }
        this.controlClient = new HttpSolrClient.Builder(this.controlJetty.getBaseUrl() + "/control_collection").build();
        if (this.sliceCount <= 0) {
            this.controlClientCloud = this.createCloudClient("control_collection");
            this.controlClientCloud.connect();
            AbstractFullDistribZkTestBase.waitForCollection(this.controlClientCloud.getZkStateReader(), "control_collection", 0);
            this.cloudClient = this.controlClientCloud;
            return;
        }
        this.initCloud();
        this.createJettys(numServers);
        int cnt = this.getTotalReplicas("collection1");
        if (cnt > 0) {
            AbstractFullDistribZkTestBase.waitForCollection(this.cloudClient.getZkStateReader(), "collection1", this.sliceCount);
        }
    }

    public static void waitForCollection(ZkStateReader reader, String collection, int slices) throws Exception {
        int cnt = 30;
        while (!reader.getClusterState().hasCollection(collection)) {
            if (cnt == 0) {
                throw new RuntimeException("timeout waiting for collection in cluster state: collection=" + collection);
            }
            --cnt;
            Thread.sleep(500L);
        }
        cnt = 30;
        while (reader.getClusterState().getCollection(collection).getSlices().size() < slices) {
            if (cnt == 0) {
                throw new RuntimeException("timeout waiting for collection shards to come up: collection=" + collection + ", slices.expected=" + slices + " slices.actual= " + reader.getClusterState().getCollection(collection).getSlices().size() + " slices : " + reader.getClusterState().getCollection(collection).getSlices());
            }
            --cnt;
            Thread.sleep(500L);
        }
    }

    protected String getStateFormat() {
        String stateFormat = System.getProperty("tests.solr.stateFormat", null);
        if (stateFormat != null) {
            this.defaultStateFormat = stateFormat;
        }
        return this.defaultStateFormat;
    }

    protected List<JettySolrRunner> createJettys(int numJettys) throws Exception {
        int i;
        ArrayList<JettySolrRunner> jettys = new ArrayList<JettySolrRunner>();
        ArrayList<SolrClient> clients = new ArrayList<SolrClient>();
        StringBuilder sb = new StringBuilder();
        AbstractFullDistribZkTestBase.assertEquals((long)0L, (long)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)"collection1", (String)"conf1", (int)this.sliceCount, (int)1).setStateFormat(Integer.valueOf(Integer.parseInt(this.getStateFormat()))).setCreateNodeSet("").process((SolrClient)this.cloudClient)).getStatus());
        int numOtherReplicas = numJettys - this.getPullReplicaCount() * this.sliceCount;
        for (int i2 = 1; i2 <= numJettys; ++i2) {
            CollectionAdminResponse response;
            JettySolrRunner j;
            if (sb.length() > 0) {
                sb.append(',');
            }
            int cnt = this.jettyIntCntr.incrementAndGet();
            File jettyDir = AbstractFullDistribZkTestBase.createTempDir((String)("shard-" + i2)).toFile();
            jettyDir.mkdirs();
            this.setupJettySolrHome(jettyDir);
            if (numOtherReplicas > 0) {
                --numOtherReplicas;
                if (this.useTlogReplicas()) {
                    log.info("create jetty {} in directory {} of type {}", new Object[]{i2, jettyDir, Replica.Type.TLOG});
                    j = this.createJetty(jettyDir, this.useJettyDataDir ? this.getDataDir(this.testDir + "/jetty" + cnt) : null, null, "solrconfig.xml", null, Replica.Type.TLOG);
                    response = (CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"collection1", (String)("shard" + (i2 % this.sliceCount + 1))).setNode(j.getNodeName()).setType(Replica.Type.TLOG).process((SolrClient)this.cloudClient);
                } else {
                    log.info("create jetty {} in directory {} of type {}", new Object[]{i2, jettyDir, Replica.Type.NRT});
                    j = this.createJetty(jettyDir, this.useJettyDataDir ? this.getDataDir(this.testDir + "/jetty" + cnt) : null, null, "solrconfig.xml", null, null);
                    response = (CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"collection1", (String)("shard" + (i2 % this.sliceCount + 1))).setNode(j.getNodeName()).setType(Replica.Type.NRT).process((SolrClient)this.cloudClient);
                }
            } else {
                log.info("create jetty {} in directory {} of type {}", new Object[]{i2, jettyDir, Replica.Type.PULL});
                j = this.createJetty(jettyDir, this.useJettyDataDir ? this.getDataDir(this.testDir + "/jetty" + cnt) : null, null, "solrconfig.xml", null, Replica.Type.PULL);
                response = (CollectionAdminResponse)CollectionAdminRequest.addReplicaToShard((String)"collection1", (String)("shard" + (i2 % this.sliceCount + 1))).setNode(j.getNodeName()).setType(Replica.Type.PULL).process((SolrClient)this.cloudClient);
            }
            jettys.add(j);
            AbstractFullDistribZkTestBase.assertTrue((boolean)response.isSuccess());
            String coreName = (String)response.getCollectionCoresStatus().keySet().iterator().next();
            this.coreClients.add(this.createNewSolrClient(coreName, j.getLocalPort()));
            SolrClient client = this.createNewSolrClient(j.getLocalPort());
            clients.add(client);
        }
        this.jettys.addAll(jettys);
        this.clients.addAll(clients);
        int numReplicas = this.getTotalReplicas("collection1");
        int expectedNumReplicas = numJettys;
        int retries = 0;
        while (numReplicas != expectedNumReplicas && (numReplicas = this.getTotalReplicas("collection1")) != expectedNumReplicas) {
            if (retries++ == 60) {
                this.printLayoutOnTearDown = true;
                AbstractFullDistribZkTestBase.fail((String)("Number of replicas in the state does not match what we set:" + numReplicas + " vs " + expectedNumReplicas));
            }
            Thread.sleep(500L);
        }
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        for (i = 1; i <= this.sliceCount; ++i) {
            zkStateReader.getLeaderRetry("collection1", "shard" + i, 10000);
        }
        if (numReplicas > 0) {
            this.updateMappingsFromZk(this.jettys, this.clients);
        }
        for (i = 1; i <= numJettys / 2; ++i) {
            JettySolrRunner j = (JettySolrRunner)this.jettys.get(i);
            JettySolrRunner j2 = (JettySolrRunner)this.jettys.get(i + (numJettys / 2 - 1));
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(this.buildUrl(j.getLocalPort()));
            sb.append("|").append(this.buildUrl(j2.getLocalPort()));
        }
        this.shards = sb.toString();
        return jettys;
    }

    protected int getPullReplicaCount() {
        return 0;
    }

    protected int getTotalReplicas(String collection) {
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        DocCollection coll = zkStateReader.getClusterState().getCollectionOrNull(collection);
        if (coll == null) {
            return 0;
        }
        int cnt = 0;
        for (Slice slices : coll.getSlices()) {
            cnt += slices.getReplicas().size();
        }
        return cnt;
    }

    public JettySolrRunner createJetty(String dataDir, String ulogDir, String shardList, String solrConfigOverride) throws Exception {
        JettyConfig jettyconfig = JettyConfig.builder().setContext(this.context).stopAtShutdown(false).withServlets(this.getExtraServlets()).withFilters(this.getExtraRequestFilters()).withSSLConfig((SSLConfig)sslConfig).build();
        Properties props = new Properties();
        props.setProperty("solr.data.dir", this.getDataDir(dataDir));
        props.setProperty("shards", shardList);
        props.setProperty("solr.ulog.dir", ulogDir);
        props.setProperty("solrconfig", solrConfigOverride);
        JettySolrRunner jetty = new JettySolrRunner(this.getSolrHome(), props, jettyconfig);
        jetty.start();
        return jetty;
    }

    @Override
    public final JettySolrRunner createJetty(File solrHome, String dataDir, String shardList, String solrConfigOverride, String schemaOverride) throws Exception {
        return this.createJetty(solrHome, dataDir, shardList, solrConfigOverride, schemaOverride, null);
    }

    public JettySolrRunner createJetty(File solrHome, String dataDir, String shardList, String solrConfigOverride, String schemaOverride, Replica.Type replicaType) throws Exception {
        if (AbstractFullDistribZkTestBase.random().nextBoolean()) {
            solrHome = this.getRelativeSolrHomePath(solrHome);
        }
        JettyConfig jettyconfig = JettyConfig.builder().setContext(this.context).stopAtShutdown(false).withServlets(this.getExtraServlets()).withFilters(this.getExtraRequestFilters()).withSSLConfig((SSLConfig)sslConfig).build();
        Properties props = new Properties();
        if (solrConfigOverride != null) {
            props.setProperty("solrconfig", solrConfigOverride);
        }
        if (schemaOverride != null) {
            props.setProperty("schema", schemaOverride);
        }
        if (shardList != null) {
            props.setProperty("shards", shardList);
        }
        if (dataDir != null) {
            props.setProperty("solr.data.dir", this.getDataDir(dataDir));
        }
        if (replicaType != null) {
            props.setProperty("replicaType", replicaType.toString());
        } else if (AbstractFullDistribZkTestBase.random().nextBoolean()) {
            props.setProperty("replicaType", Replica.Type.NRT.toString());
        }
        props.setProperty("coreRootDirectory", solrHome.toPath().resolve("cores").toAbsolutePath().toString());
        JettySolrRunner jetty = new JettySolrRunner(solrHome.getPath(), props, jettyconfig);
        jetty.start();
        return jetty;
    }

    public JettySolrRunner createProxiedJetty(File solrHome, String dataDir, String shardList, String solrConfigOverride, String schemaOverride, Replica.Type replicaType) throws Exception {
        JettyConfig jettyconfig = JettyConfig.builder().setContext(this.context).stopAtShutdown(false).withServlets(this.getExtraServlets()).withFilters(this.getExtraRequestFilters()).withSSLConfig((SSLConfig)sslConfig).build();
        Properties props = new Properties();
        if (solrConfigOverride != null) {
            props.setProperty("solrconfig", solrConfigOverride);
        }
        if (schemaOverride != null) {
            props.setProperty("schema", schemaOverride);
        }
        if (shardList != null) {
            props.setProperty("shards", shardList);
        }
        if (dataDir != null) {
            props.setProperty("solr.data.dir", this.getDataDir(dataDir));
        }
        if (replicaType != null) {
            props.setProperty("replicaType", replicaType.toString());
        } else if (AbstractFullDistribZkTestBase.random().nextBoolean()) {
            props.setProperty("replicaType", Replica.Type.NRT.toString());
        }
        props.setProperty("coreRootDirectory", solrHome.toPath().resolve("cores").toAbsolutePath().toString());
        JettySolrRunner jetty = new JettySolrRunner(solrHome.getPath(), props, jettyconfig);
        SocketProxy proxy = new SocketProxy(0, sslConfig != null && sslConfig.isSSLMode());
        jetty.setProxyPort(proxy.getListenPort());
        jetty.start();
        proxy.open(jetty.getBaseUrl().toURI());
        this.proxies.put(proxy.getUrl(), proxy);
        return jetty;
    }

    protected int getReplicaPort(Replica replica) {
        String replicaNode = replica.getNodeName();
        String tmp = replicaNode.substring(replicaNode.indexOf(58) + 1);
        if (tmp.indexOf(95) != -1) {
            tmp = tmp.substring(0, tmp.indexOf(95));
        }
        return Integer.parseInt(tmp);
    }

    protected JettySolrRunner getJettyOnPort(int port) {
        JettySolrRunner theJetty = null;
        for (JettySolrRunner jetty : this.jettys) {
            if (port != jetty.getLocalPort()) continue;
            theJetty = jetty;
            break;
        }
        if (theJetty == null && this.controlJetty.getLocalPort() == port) {
            theJetty = this.controlJetty;
        }
        if (theJetty == null) {
            AbstractFullDistribZkTestBase.fail((String)("Not able to find JettySolrRunner for port: " + port));
        }
        return theJetty;
    }

    protected SocketProxy getProxyForReplica(Replica replica) throws Exception {
        String replicaBaseUrl = replica.getStr("base_url");
        AbstractFullDistribZkTestBase.assertNotNull((Object)replicaBaseUrl);
        URL baseUrl = new URL(replicaBaseUrl);
        SocketProxy proxy = this.proxies.get(baseUrl.toURI());
        if (proxy == null && !baseUrl.toExternalForm().endsWith("/")) {
            baseUrl = new URL(baseUrl.toExternalForm() + "/");
            proxy = this.proxies.get(baseUrl.toURI());
        }
        AbstractFullDistribZkTestBase.assertNotNull((String)("No proxy found for " + baseUrl + "!"), (Object)proxy);
        return proxy;
    }

    private File getRelativeSolrHomePath(File solrHome) {
        Path solrHomePath = solrHome.toPath();
        Path curDirPath = new File("").getAbsoluteFile().toPath();
        if (!solrHomePath.getRoot().equals(curDirPath.getRoot())) {
            return solrHome;
        }
        Path root = solrHomePath.getRoot();
        File relativizedCurDir = new File(curDirPath.toFile(), curDirPath.relativize(root).toString());
        Path solrHomeRelativeToRoot = root.relativize(solrHomePath);
        return new File(relativizedCurDir, solrHomeRelativeToRoot.toString()).getAbsoluteFile();
    }

    protected void updateMappingsFromZk(List<JettySolrRunner> jettys, List<SolrClient> clients) throws Exception {
        this.updateMappingsFromZk(jettys, clients, false);
    }

    protected void updateMappingsFromZk(List<JettySolrRunner> jettys, List<SolrClient> clients, boolean allowOverSharding) throws Exception {
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        zkStateReader.forceUpdateCollection("collection1");
        this.cloudJettys.clear();
        this.shardToJetty.clear();
        ClusterState clusterState = zkStateReader.getClusterState();
        DocCollection coll = clusterState.getCollection("collection1");
        ArrayList<CloudSolrServerClient> theClients = new ArrayList<CloudSolrServerClient>();
        block0: for (SolrClient client : clients) {
            for (Slice slice : coll.getSlices()) {
                for (Replica replica : slice.getReplicas()) {
                    int port = new URI(((HttpSolrClient)client).getBaseURL()).getPort();
                    if (!replica.getStr("base_url").contains(":" + port)) continue;
                    CloudSolrServerClient csc = new CloudSolrServerClient();
                    csc.solrClient = client;
                    csc.port = port;
                    csc.shardName = replica.getStr("node_name");
                    csc.info = replica;
                    theClients.add(csc);
                    continue block0;
                }
            }
        }
        block3: for (JettySolrRunner jetty : jettys) {
            int port = jetty.getLocalPort();
            if (port == -1) {
                throw new RuntimeException("Cannot find the port for jetty");
            }
            for (Slice slice : coll.getSlices()) {
                Set entries = slice.getReplicasMap().entrySet();
                for (Map.Entry entry : entries) {
                    Replica replica = (Replica)entry.getValue();
                    if (!replica.getStr("base_url").contains(":" + port)) continue;
                    List<CloudJettyRunner> list = this.shardToJetty.get(slice.getName());
                    if (list == null) {
                        list = new ArrayList<CloudJettyRunner>();
                        this.shardToJetty.put(slice.getName(), list);
                    }
                    boolean isLeader = slice.getLeader() == replica;
                    CloudJettyRunner cjr = new CloudJettyRunner();
                    cjr.jetty = jetty;
                    cjr.info = replica;
                    cjr.nodeName = replica.getStr("node_name");
                    cjr.coreNodeName = (String)entry.getKey();
                    cjr.url = replica.getStr("base_url") + "/" + replica.getStr("core");
                    cjr.client = this.findClientByPort(port, theClients);
                    list.add(cjr);
                    if (isLeader) {
                        this.shardToLeaderJetty.put(slice.getName(), cjr);
                    }
                    this.cloudJettys.add(cjr);
                    continue block3;
                }
            }
        }
        for (Slice slice : coll.getSlices()) {
            List<CloudJettyRunner> jetties = this.shardToJetty.get(slice.getName());
            if (allowOverSharding) continue;
            AbstractFullDistribZkTestBase.assertNotNull((String)("Test setup problem: We found no jetties for shard: " + slice.getName() + " just:" + this.shardToJetty.keySet()), jetties);
            AbstractFullDistribZkTestBase.assertEquals((String)("slice:" + slice.getName()), (long)slice.getReplicas().size(), (long)jetties.size());
        }
    }

    private CloudSolrServerClient findClientByPort(int port, List<CloudSolrServerClient> theClients) {
        for (CloudSolrServerClient client : theClients) {
            if (client.port != port) continue;
            return client;
        }
        throw new IllegalArgumentException("Client with the given port does not exist:" + port);
    }

    @Override
    protected void setDistributedParams(ModifiableSolrParams params) {
        if (!r.nextBoolean()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.sliceCount; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append("shard" + (i + 1));
            }
            params.set("shards", new String[]{sb.toString()});
        }
    }

    protected int sendDocsWithRetry(List<SolrInputDocument> batch, int minRf, int maxRetries, int waitBeforeRetry) throws Exception {
        return AbstractFullDistribZkTestBase.sendDocsWithRetry(this.cloudClient, this.cloudClient.getDefaultCollection(), batch, minRf, maxRetries, waitBeforeRetry);
    }

    protected static int sendDocsWithRetry(CloudSolrClient cloudClient, String collection, List<SolrInputDocument> batch, int minRf, int maxRetries, int waitBeforeRetry) throws Exception {
        UpdateRequest up = new UpdateRequest();
        up.setParam("min_rf", String.valueOf(minRf));
        up.add(batch);
        NamedList resp = null;
        int numRetries = 0;
        while (true) {
            try {
                resp = cloudClient.request((SolrRequest)up, collection);
                return cloudClient.getMinAchievedReplicationFactor(cloudClient.getDefaultCollection(), resp);
            }
            catch (Exception exc) {
                Throwable rootCause = SolrException.getRootCause((Throwable)exc);
                if (++numRetries <= maxRetries) {
                    log.warn("ERROR: " + rootCause + " ... Sleeping for " + waitBeforeRetry + " seconds before re-try ...");
                    Thread.sleep((long)waitBeforeRetry * 1000L);
                    continue;
                }
                log.error("No more retries available! Add batch failed due to: " + rootCause);
                throw exc;
            }
            break;
        }
    }

    @Override
    protected void indexDoc(SolrInputDocument doc) throws IOException, SolrServerException {
        UpdateRequest req = new UpdateRequest();
        req.add(doc);
        req.setParam("CONTROL", "TRUE");
        req.process(this.controlClient);
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(doc);
        ureq.process((SolrClient)this.cloudClient);
    }

    @Override
    protected void index_specific(int serverNumber, Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
        this.controlClient.add(doc);
        HttpSolrClient client = (HttpSolrClient)this.clients.get(serverNumber);
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(doc);
        ureq.process((SolrClient)client);
    }

    protected void index_specific(SolrClient client, Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        for (int i = 0; i < fields.length; i += 2) {
            doc.addField((String)fields[i], fields[i + 1]);
        }
        UpdateRequest ureq = new UpdateRequest();
        ureq.add(doc);
        ureq.process(client);
        this.controlClient.add(doc);
    }

    protected ZkCoreNodeProps getLeaderUrlFromZk(String collection, String slice) {
        ClusterState clusterState = this.getCommonCloudSolrClient().getZkStateReader().getClusterState();
        DocCollection docCollection = clusterState.getCollectionOrNull(collection);
        if (docCollection != null && docCollection.getLeader(slice) != null) {
            return new ZkCoreNodeProps((ZkNodeProps)docCollection.getLeader(slice));
        }
        throw new RuntimeException("Could not find leader:" + collection + " " + slice);
    }

    @Override
    protected void del(String q) throws Exception {
        this.controlClient.deleteByQuery(q);
        this.cloudClient.deleteByQuery(q);
    }

    protected void waitForRecoveriesToFinish(boolean verbose) throws Exception {
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        super.waitForRecoveriesToFinish("collection1", zkStateReader, verbose);
    }

    protected void waitForRecoveriesToFinish(String collection, boolean verbose) throws Exception {
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        super.waitForRecoveriesToFinish(collection, zkStateReader, verbose);
    }

    protected void waitForRecoveriesToFinish(boolean verbose, int timeoutSeconds) throws Exception {
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        AbstractDistribZkTestBase.waitForRecoveriesToFinish("collection1", zkStateReader, verbose, true, timeoutSeconds);
    }

    protected void checkQueries() throws Exception {
        this.handle.put("_version_", SKIPVAL);
        this.query("q", "*:*", "sort", "n_tl1 desc");
        this.handle.put("response", UNORDERED);
        String ids = "987654";
        for (int i = 0; i < 20; ++i) {
            this.query("qt", "/get", "id", Integer.toString(i));
            this.query("qt", "/get", "ids", Integer.toString(i));
            ids = ids + ',' + Integer.toString(i);
            this.query("qt", "/get", "ids", ids);
        }
        this.handle.remove("response");
        for (String f : fieldNames) {
            this.query("q", "*:*", "sort", f + " desc");
            this.query("q", "*:*", "sort", f + " asc");
        }
        this.query("q", "*:*", "sort", this.i1 + " desc");
        this.query("q", "*:*", "sort", this.i1 + " asc");
        this.query("q", "*:*", "sort", this.i1 + " desc", "fl", "*,score");
        this.query("q", "*:*", "sort", "n_tl1 asc", "fl", "score");
        this.query("q", "*:*", "sort", "n_tl1 desc");
        this.handle.put("maxScore", SKIPVAL);
        this.query("q", "{!func}" + this.i1);
        this.handle.remove("maxScore");
        this.query("q", "{!func}" + this.i1, "fl", "*,score");
        this.handle.put("highlighting", UNORDERED);
        this.handle.put("response", UNORDERED);
        this.handle.put("maxScore", SKIPVAL);
        this.query("q", "quick");
        this.query("q", "all", "fl", "id", "start", "0");
        this.query("q", "all", "fl", "foofoofoo", "start", "0");
        this.query("q", "all", "fl", "id", "start", "100");
        this.handle.put("score", SKIPVAL);
        this.query("q", "quick", "fl", "*,score");
        this.query("q", "all", "fl", "*,score", "start", "1");
        this.query("q", "all", "fl", "*,score", "start", "100");
        this.query("q", "now their fox sat had put", "fl", "*,score", "hl", "true", "hl.fl", this.t1);
        this.query("q", "now their fox sat had put", "fl", "foofoofoo", "hl", "true", "hl.fl", this.t1);
        this.query("q", "matchesnothing", "fl", "*,score");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "count");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "count", "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "index");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", -1, "facet.sort", "index", "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.limit", 1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.query", "quick", "facet.query", "all", "facet.query", "*:*");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.offset", 1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.t1, "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.query", "quick", "facet.query", "all", "facet.query", "*:*", "facet.field", this.t1);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.query", "{!key=myquick}quick", "facet.query", "{!key=myall ex=a}all", "facet.query", "*:*", "facet.field", "{!key=mykey ex=a}" + this.t1, "facet.field", "{!key=other ex=b}" + this.t1, "facet.field", "{!key=again ex=a,b}" + this.t1, "facet.field", this.t1, "fq", "{!tag=a}id:[1 TO 7]", "fq", "{!tag=b}id:[3 TO 9]");
        this.query("q", "*:*", "facet", "true", "facet.field", "{!ex=t1}SubjectTerms_mfacet", "fq", "{!tag=t1}SubjectTerms_mfacet:(test 1)", "facet.limit", "10", "facet.mincount", "1");
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.missingField, "facet.mincount", 2);
        this.query("q", "*:*", "rows", 100, "facet", "true", "facet.field", this.oddField, "facet.mincount", 2);
        this.query("q", "*:*", "sort", this.i1 + " desc", "stats", "true", "stats.field", this.i1);
        this.handle.put("facet_fields", SKIPVAL);
        this.query("q", "*:*", "rows", 0, "facet", "true", "facet.field", this.t1, "facet.limit", 5, "facet.shard.limit", 5);
        this.query("q", "*:*", "rows", 0, "facet", "true", "facet.field", "{!key='a b/c \\' \\} foo'}" + this.t1, "facet.limit", 5, "facet.shard.limit", 5);
        this.handle.remove("facet_fields");
        this.query("q", "*:*", "sort", "n_tl1 desc");
        if (this.clients.size() >= 2) {
            this.index(this.id, 100, this.i1, 107, this.t1, "oh no, a duplicate!");
            for (int i = 0; i < this.getShardCount(); ++i) {
                this.index_specific(i, this.id, 100, this.i1, 107, this.t1, "oh no, a duplicate!");
            }
            this.commit();
            this.query("q", "duplicate", "hl", "true", "hl.fl", this.t1);
            this.query("q", "fox duplicate horses", "hl", "true", "hl.fl", this.t1);
            this.query("q", "*:*", "rows", 100);
        }
    }

    protected void indexAbunchOfDocs() throws Exception {
        int i;
        this.indexr(this.id, 2, this.i1, 50, this.t1, "to come to the aid of their country.");
        this.indexr(this.id, 3, this.i1, 2, this.t1, "how now brown cow");
        this.indexr(this.id, 4, this.i1, -100, this.t1, "the quick fox jumped over the lazy dog");
        this.indexr(this.id, 5, this.i1, 500, this.t1, "the quick fox jumped way over the lazy dog");
        this.indexr(this.id, 6, this.i1, -600, this.t1, "humpty dumpy sat on a wall");
        this.indexr(this.id, 7, this.i1, 123, this.t1, "humpty dumpy had a great fall");
        this.indexr(this.id, 8, this.i1, 876, this.t1, "all the kings horses and all the kings men");
        this.indexr(this.id, 9, this.i1, 7, this.t1, "couldn't put humpty together again");
        this.indexr(this.id, 10, this.i1, 4321, this.t1, "this too shall pass");
        this.indexr(this.id, 11, this.i1, -987, this.t1, "An eye for eye only ends up making the whole world blind.");
        this.indexr(this.id, 12, this.i1, 379, this.t1, "Great works are performed, not by strength, but by perseverance.");
        this.indexr(this.id, 13, this.i1, 232, this.t1, "no eggs on wall, lesson learned", this.oddField, "odd man out");
        this.indexr(this.id, 14, "SubjectTerms_mfacet", new String[]{"mathematical models", "mathematical analysis"});
        this.indexr(this.id, 15, "SubjectTerms_mfacet", new String[]{"test 1", "test 2", "test3"});
        this.indexr(this.id, 16, "SubjectTerms_mfacet", new String[]{"test 1", "test 2", "test3"});
        String[] vals = new String[100];
        for (i = 0; i < 100; ++i) {
            vals[i] = "test " + i;
        }
        this.indexr(this.id, 17, "SubjectTerms_mfacet", vals);
        for (i = 100; i < 150; ++i) {
            this.indexr(this.id, i);
        }
    }

    public QueryResponse queryAndCompareReplicas(SolrParams params, String shard) throws Exception {
        ArrayList<SolrClient> shardClients = new ArrayList<SolrClient>(7);
        this.updateMappingsFromZk(this.jettys, this.clients);
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        List<CloudJettyRunner> solrJetties = this.shardToJetty.get(shard);
        AbstractFullDistribZkTestBase.assertNotNull((String)("no jetties found for shard: " + shard), solrJetties);
        for (CloudJettyRunner cjetty : solrJetties) {
            ZkNodeProps props = cjetty.info;
            String nodeName = props.getStr("node_name");
            boolean active = Replica.State.getState((String)props.getStr("state")) == Replica.State.ACTIVE;
            boolean live = zkStateReader.getClusterState().liveNodesContain(nodeName);
            if (!active || !live) continue;
            shardClients.add(cjetty.client.solrClient);
        }
        return this.queryAndCompare(params, shardClients);
    }

    public void queryAndCompareShards(SolrParams params) throws Exception {
        this.updateMappingsFromZk(this.jettys, this.clients);
        ArrayList<String> shards = new ArrayList<String>(this.shardToJetty.keySet());
        for (String shard : shards) {
            this.queryAndCompareReplicas(params, shard);
        }
    }

    protected void checkShardConsistency(String shard) throws Exception {
        this.checkShardConsistency(shard, false, false);
    }

    protected String checkShardConsistency(String shard, boolean expectFailure, boolean verbose) throws Exception {
        List<CloudJettyRunner> solrJetties = this.shardToJetty.get(shard);
        if (solrJetties == null) {
            throw new RuntimeException("shard not found:" + shard + " keys:" + this.shardToJetty.keySet());
        }
        long num = -1L;
        long lastNum = -1L;
        String failMessage = null;
        if (verbose) {
            System.err.println("check const of " + shard);
        }
        int cnt = 0;
        ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
        AbstractFullDistribZkTestBase.assertEquals((String)("The client count does not match up with the shard count for slice:" + shard), (long)zkStateReader.getClusterState().getCollection("collection1").getSlice(shard).getReplicasMap().size(), (long)solrJetties.size());
        CloudJettyRunner lastJetty = null;
        for (CloudJettyRunner cjetty : solrJetties) {
            boolean active;
            ZkNodeProps props = cjetty.info;
            if (verbose) {
                System.err.println("client" + cnt++);
            }
            if (verbose) {
                System.err.println("PROPS:" + props);
            }
            try {
                ModifiableSolrParams query = AbstractFullDistribZkTestBase.params("q", "*:*", "rows", "0", "distrib", "false", "tests", "checkShardConsistency");
                num = cjetty.client.solrClient.query((SolrParams)query).getResults().getNumFound();
            }
            catch (SolrServerException e) {
                if (!verbose) continue;
                System.err.println("error contacting client: " + e.getMessage() + "\n");
                continue;
            }
            catch (SolrException e) {
                if (!verbose) continue;
                System.err.println("error contacting client: " + e.getMessage() + "\n");
                continue;
            }
            boolean live = false;
            String nodeName = props.getStr("node_name");
            if (zkStateReader.getClusterState().liveNodesContain(nodeName)) {
                live = true;
            }
            if (verbose) {
                System.err.println(" live:" + live);
            }
            if (verbose) {
                System.err.println(" num:" + num + "\n");
            }
            if (!(active = Replica.State.getState((String)props.getStr("state")) == Replica.State.ACTIVE) || !live) continue;
            if (lastNum > -1L && lastNum != num && failMessage == null) {
                failMessage = shard + " is not consistent.  Got " + lastNum + " from " + lastJetty.url + " (previous client)" + " and got " + num + " from " + cjetty.url;
                if (!expectFailure || verbose) {
                    System.err.println("######" + failMessage);
                    SolrQuery query = new SolrQuery("*:*");
                    query.set("distrib", false);
                    query.set("fl", new String[]{"id,_version_"});
                    query.set("rows", new String[]{"100000"});
                    query.set("sort", new String[]{"id asc"});
                    query.set("tests", new String[]{"checkShardConsistency/showDiff"});
                    SolrDocumentList lst1 = lastJetty.client.solrClient.query((SolrParams)query).getResults();
                    SolrDocumentList lst2 = cjetty.client.solrClient.query((SolrParams)query).getResults();
                    CloudInspectUtil.showDiff(lst1, lst2, lastJetty.url, cjetty.url);
                }
            }
            lastNum = num;
            lastJetty = cjetty;
        }
        return failMessage;
    }

    public void showCounts() {
        Set<String> theShards = this.shardToJetty.keySet();
        for (String shard : theShards) {
            List<CloudJettyRunner> solrJetties = this.shardToJetty.get(shard);
            for (CloudJettyRunner cjetty : solrJetties) {
                ZkNodeProps props = cjetty.info;
                System.err.println("PROPS:" + props);
                try {
                    ModifiableSolrParams query = AbstractFullDistribZkTestBase.params("q", "*:*", "rows", "0", "distrib", "false", "tests", "checkShardConsistency");
                    long num = cjetty.client.solrClient.query((SolrParams)query).getResults().getNumFound();
                    System.err.println("DOCS:" + num);
                }
                catch (IOException | SolrServerException | SolrException e) {
                    System.err.println("error contacting client: " + e.getMessage() + "\n");
                    continue;
                }
                boolean live = false;
                String nodeName = props.getStr("node_name");
                ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
                if (zkStateReader.getClusterState().liveNodesContain(nodeName)) {
                    live = true;
                }
                System.err.println(" live:" + live);
            }
        }
    }

    protected void randomlyEnableAutoSoftCommit() {
        if (r.nextBoolean()) {
            this.enableAutoSoftCommit(1000);
        } else {
            log.info("Not turning on auto soft commit");
        }
    }

    protected void enableAutoSoftCommit(int time) {
        log.info("Turning on auto soft commit: " + time);
        for (List<CloudJettyRunner> jettyList : this.shardToJetty.values()) {
            for (CloudJettyRunner jetty : jettyList) {
                CoreContainer cores = jetty.jetty.getCoreContainer();
                for (SolrCore core : cores.getCores()) {
                    ((DirectUpdateHandler2)core.getUpdateHandler()).getSoftCommitTracker().setTimeUpperBound((long)time);
                }
            }
        }
    }

    protected void checkShardConsistency() throws Exception {
        this.checkShardConsistency(true, false);
    }

    protected void checkShardConsistency(boolean checkVsControl, boolean verbose) throws Exception {
        this.checkShardConsistency(checkVsControl, verbose, null, null);
    }

    protected void checkShardConsistency(boolean checkVsControl, boolean verbose, Set<String> addFails, Set<String> deleteFails) throws Exception {
        this.updateMappingsFromZk(this.jettys, this.coreClients, true);
        Set<String> theShards = this.shardToJetty.keySet();
        String failMessage = null;
        for (String shard : theShards) {
            String shardFailMessage = this.checkShardConsistency(shard, false, verbose);
            if (shardFailMessage == null || failMessage != null) continue;
            failMessage = shardFailMessage;
        }
        if (failMessage != null) {
            AbstractFullDistribZkTestBase.fail(failMessage);
        }
        if (!checkVsControl) {
            return;
        }
        ModifiableSolrParams q = AbstractFullDistribZkTestBase.params("q", "*:*", "rows", "0", "tests", "checkShardConsistency(vsControl)");
        SolrDocumentList controlDocList = this.controlClient.query((SolrParams)q).getResults();
        long controlDocs = controlDocList.getNumFound();
        SolrDocumentList cloudDocList = this.cloudClient.query((SolrParams)q).getResults();
        long cloudClientDocs = cloudDocList.getNumFound();
        theShards = this.shardToJetty.keySet();
        int cnt = 0;
        block3: for (String s : theShards) {
            int times = this.shardToJetty.get(s).size();
            for (int i = 0; i < times; ++i) {
                try {
                    boolean active;
                    CloudJettyRunner cjetty = this.shardToJetty.get(s).get(i);
                    ZkNodeProps props = cjetty.info;
                    SolrClient client = cjetty.client.solrClient;
                    boolean bl = active = Replica.State.getState((String)props.getStr("state")) == Replica.State.ACTIVE;
                    if (!active) continue;
                    SolrQuery query = new SolrQuery("*:*");
                    query.set("distrib", false);
                    long results = client.query((SolrParams)query).getResults().getNumFound();
                    if (verbose) {
                        System.err.println(new ZkCoreNodeProps(props).getCoreUrl() + " : " + results);
                    }
                    if (verbose) {
                        System.err.println("shard:" + props.getStr("shard"));
                    }
                    cnt = (int)((long)cnt + results);
                    continue block3;
                }
                catch (Exception e) {
                    if (i != times - 1) continue;
                    throw e;
                }
            }
        }
        if (controlDocs != (long)cnt || cloudClientDocs != controlDocs) {
            String msg = "document count mismatch.  control=" + controlDocs + " sum(shards)=" + cnt + " cloudClient=" + cloudClientDocs;
            log.error(msg);
            boolean shouldFail = CloudInspectUtil.compareResults(this.controlClient, (SolrClient)this.cloudClient, addFails, deleteFails);
            if (shouldFail) {
                AbstractFullDistribZkTestBase.fail((String)msg);
            }
        }
    }

    protected SolrClient getClient(String nodeName) {
        for (CloudJettyRunner cjetty : this.cloudJettys) {
            CloudSolrServerClient client = cjetty.client;
            if (!client.shardName.equals(nodeName)) continue;
            return client.solrClient;
        }
        return null;
    }

    protected void assertDocCounts(boolean verbose) throws Exception {
        ClusterState clusterState;
        if (verbose) {
            System.err.println("control docs:" + this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound() + "\n\n");
        }
        long controlCount = this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound();
        Map slices = null;
        try (ZkStateReader zk = new ZkStateReader(this.zkServer.getZkAddress(), 45000, 45000);){
            zk.createClusterStateWatchersAndUpdate();
            clusterState = zk.getClusterState();
            DocCollection docCollection = clusterState.getCollectionOrNull("collection1");
            slices = docCollection != null ? docCollection.getSlicesMap() : null;
        }
        if (slices == null) {
            throw new RuntimeException("Could not find collection collection1 in " + clusterState.getCollectionsMap().keySet());
        }
        for (CloudJettyRunner cjetty : this.cloudJettys) {
            CloudSolrServerClient client = cjetty.client;
            for (Map.Entry slice : slices.entrySet()) {
                Map theShards = ((Slice)slice.getValue()).getReplicasMap();
                for (Map.Entry shard : theShards.entrySet()) {
                    String shardName = new URI(((HttpSolrClient)client.solrClient).getBaseURL()).getPort() + "_solr_";
                    if (!verbose || !((String)shard.getKey()).endsWith(shardName)) continue;
                    System.err.println("shard:" + (String)slice.getKey());
                    System.err.println(shard.getValue());
                }
            }
            ZkStateReader zkStateReader = this.cloudClient.getZkStateReader();
            long count = 0L;
            Replica.State currentState = Replica.State.getState((String)cjetty.info.getStr("state"));
            if (currentState == Replica.State.ACTIVE && zkStateReader.getClusterState().liveNodesContain(cjetty.info.getStr("node_name"))) {
                SolrQuery query = new SolrQuery("*:*");
                query.set("distrib", false);
                count = client.solrClient.query((SolrParams)query).getResults().getNumFound();
            }
            if (!verbose) continue;
            System.err.println("client docs:" + count + "\n\n");
        }
        if (verbose) {
            System.err.println("control docs:" + this.controlClient.query((SolrParams)new SolrQuery("*:*")).getResults().getNumFound() + "\n\n");
        }
        SolrQuery query = new SolrQuery("*:*");
        AbstractFullDistribZkTestBase.assertEquals((String)"Doc Counts do not add up", (long)controlCount, (long)this.cloudClient.query((SolrParams)query).getResults().getNumFound());
    }

    @Override
    protected QueryResponse queryServer(ModifiableSolrParams params) throws SolrServerException, IOException {
        if (r.nextBoolean()) {
            params.set("collection", new String[]{"collection1"});
        }
        return this.cloudClient.query((SolrParams)params);
    }

    public void waitForThingsToLevelOut(int waitForRecTimeSeconds) throws Exception {
        log.info("Wait for recoveries to finish - wait " + waitForRecTimeSeconds + " for each attempt");
        int cnt = 0;
        boolean retry = false;
        do {
            this.waitForRecoveriesToFinish(VERBOSE, waitForRecTimeSeconds);
            try {
                this.commit();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.updateMappingsFromZk(this.jettys, this.clients);
            Set<String> theShards = this.shardToJetty.keySet();
            String failMessage = null;
            for (String shard : theShards) {
                failMessage = this.checkShardConsistency(shard, true, false);
            }
            if (failMessage != null) {
                log.info("shard inconsistency - waiting ...");
                retry = true;
            } else {
                retry = false;
            }
            if (++cnt > 30) break;
            Thread.sleep(2000L);
        } while (retry);
    }

    public void waitForNoShardInconsistency() throws Exception {
        log.info("Wait for no shard inconsistency");
        int cnt = 0;
        boolean retry = false;
        do {
            try {
                this.commit();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.updateMappingsFromZk(this.jettys, this.clients);
            Set<String> theShards = this.shardToJetty.keySet();
            String failMessage = null;
            for (String shard : theShards) {
                try {
                    failMessage = this.checkShardConsistency(shard, true, true);
                }
                catch (Exception e) {
                    failMessage = "hit exception:" + e.getMessage();
                }
            }
            if (failMessage != null) {
                log.info("shard inconsistency - waiting ...");
                retry = true;
            } else {
                retry = false;
            }
            if (++cnt > 40) break;
            Thread.sleep(2000L);
        } while (retry);
    }

    void doQuery(String expectedDocs, String ... queryParams) throws Exception {
        HashSet expectedIds = new HashSet(StrUtils.splitSmart((String)expectedDocs, (String)",", (boolean)true));
        QueryResponse rsp = this.cloudClient.query((SolrParams)AbstractFullDistribZkTestBase.params(queryParams));
        HashSet<String> obtainedIds = new HashSet<String>();
        for (SolrDocument doc : rsp.getResults()) {
            obtainedIds.add((String)doc.get((Object)"id"));
        }
        AbstractFullDistribZkTestBase.assertEquals(expectedIds, obtainedIds);
    }

    @Override
    public void distribTearDown() throws Exception {
        if (VERBOSE || this.printLayoutOnTearDown) {
            super.printLayout();
        }
        this.closeRestTestHarnesses();
        if (this.commonCloudSolrClient != null) {
            this.commonCloudSolrClient.close();
        }
        if (this.controlClient != null) {
            this.controlClient.close();
        }
        if (this.cloudClient != null) {
            this.cloudClient.close();
        }
        if (this.controlClientCloud != null) {
            this.controlClientCloud.close();
        }
        super.distribTearDown();
        System.clearProperty("zkHost");
        System.clearProperty("numShards");
        if (!this.proxies.isEmpty()) {
            for (SocketProxy proxy : this.proxies.values()) {
                proxy.close();
            }
        }
    }

    @Override
    protected void commit() throws Exception {
        this.controlClient.commit();
        this.cloudClient.commit();
    }

    @Override
    protected void destroyServers() throws Exception {
        if (this.controlJetty != null) {
            ChaosMonkey.stop(this.controlJetty);
        }
        for (JettySolrRunner jetty : this.jettys) {
            try {
                ChaosMonkey.stop(jetty);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        for (SolrClient client : this.coreClients) {
            client.close();
        }
        this.coreClients.clear();
        super.destroyServers();
    }

    protected CollectionAdminResponse createCollection(String collectionName, String configSetName, int numShards, int replicationFactor, int maxShardsPerNode) throws SolrServerException, IOException {
        return this.createCollection(null, collectionName, configSetName, numShards, replicationFactor, maxShardsPerNode, null, null);
    }

    protected CollectionAdminResponse createCollection(Map<String, List<Integer>> collectionInfos, String collectionName, Map<String, Object> collectionProps, SolrClient client) throws SolrServerException, IOException {
        return this.createCollection(collectionInfos, collectionName, collectionProps, client, "conf1");
    }

    protected CollectionAdminResponse createCollection(Map<String, List<Integer>> collectionInfos, String collectionName, Map<String, Object> collectionProps, SolrClient client, String confSetName) throws SolrServerException, IOException {
        Integer numPullReplicas;
        Integer numTlogReplicas;
        Integer numNrtReplicas;
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("action", new String[]{CollectionParams.CollectionAction.CREATE.toString()});
        for (Map.Entry<String, Object> entry : collectionProps.entrySet()) {
            if (entry.getValue() == null) continue;
            params.set(entry.getKey(), new String[]{String.valueOf(entry.getValue())});
        }
        Integer numShards = (Integer)collectionProps.get("numShards");
        if (numShards == null) {
            String shardNames = (String)collectionProps.get("shards");
            numShards = StrUtils.splitSmart((String)shardNames, (char)',').size();
        }
        if ((numNrtReplicas = (Integer)collectionProps.get("nrtReplicas")) == null) {
            numNrtReplicas = (Integer)collectionProps.get("replicationFactor");
        }
        if (numNrtReplicas == null) {
            numNrtReplicas = (Integer)OverseerCollectionMessageHandler.COLL_PROPS.get("replicationFactor");
        }
        if (numNrtReplicas == null) {
            numNrtReplicas = 0;
        }
        if ((numTlogReplicas = (Integer)collectionProps.get("tlogReplicas")) == null) {
            numTlogReplicas = 0;
        }
        if ((numPullReplicas = (Integer)collectionProps.get("pullReplicas")) == null) {
            numPullReplicas = 0;
        }
        if (confSetName != null) {
            params.set("collection.configName", new String[]{confSetName});
        } else {
            params.set("collection.configName", new String[]{"conf1"});
        }
        int clientIndex = AbstractFullDistribZkTestBase.random().nextInt(2);
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(numShards);
        list.add(numNrtReplicas + numTlogReplicas + numPullReplicas);
        if (collectionInfos != null) {
            collectionInfos.put(collectionName, list);
        }
        params.set("name", new String[]{collectionName});
        if ("1".equals(this.getStateFormat())) {
            log.info("Creating collection with stateFormat=1: " + collectionName);
            params.set("stateFormat", new String[]{"1"});
        }
        QueryRequest request = new QueryRequest((SolrParams)params);
        request.setPath("/admin/collections");
        CollectionAdminResponse res = new CollectionAdminResponse();
        if (client == null) {
            String baseUrl = this.getBaseUrl((HttpSolrClient)this.clients.get(clientIndex));
            try (SolrClient adminClient = this.createNewSolrClient("", baseUrl);){
                res.setResponse(adminClient.request((SolrRequest)request));
            }
        } else {
            res.setResponse(client.request((SolrRequest)request));
        }
        return res;
    }

    protected CollectionAdminResponse createCollection(Map<String, List<Integer>> collectionInfos, String collectionName, String configSetName, int numShards, int replicationFactor, int maxShardsPerNode, SolrClient client, String createNodeSetStr) throws SolrServerException, IOException {
        int numNrtReplicas = this.useTlogReplicas() ? 0 : replicationFactor;
        int numTlogReplicas = this.useTlogReplicas() ? replicationFactor : 0;
        return this.createCollection(collectionInfos, collectionName, Utils.makeMap((Object[])new Object[]{"numShards", numShards, "nrtReplicas", numNrtReplicas, "tlogReplicas", numTlogReplicas, "pullReplicas", this.getPullReplicaCount(), "createNodeSet", createNodeSetStr, "maxShardsPerNode", maxShardsPerNode}), client, configSetName);
    }

    protected CollectionAdminResponse createCollection(Map<String, List<Integer>> collectionInfos, String collectionName, int numShards, int replicationFactor, int maxShardsPerNode, SolrClient client, String createNodeSetStr, String configName) throws SolrServerException, IOException {
        int numNrtReplicas = this.useTlogReplicas() ? 0 : replicationFactor;
        int numTlogReplicas = this.useTlogReplicas() ? replicationFactor : 0;
        return this.createCollection(collectionInfos, collectionName, Utils.makeMap((Object[])new Object[]{"numShards", numShards, "nrtReplicas", numNrtReplicas, "tlogReplicas", numTlogReplicas, "pullReplicas", this.getPullReplicaCount(), "createNodeSet", createNodeSetStr, "maxShardsPerNode", maxShardsPerNode}), client, configName);
    }

    @Override
    protected SolrClient createNewSolrClient(int port) {
        return this.createNewSolrClient("collection1", port);
    }

    protected SolrClient createNewSolrClient(int port, int connectionTimeoutMillis, int socketTimeoutMillis) {
        return this.createNewSolrClient("collection1", port, connectionTimeoutMillis, socketTimeoutMillis);
    }

    protected SolrClient createNewSolrClient(String coreName, int port) {
        try {
            String baseUrl = this.buildUrl(port);
            String url = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + coreName;
            HttpSolrClient client = AbstractFullDistribZkTestBase.getHttpSolrClient(url, DEFAULT_CONNECTION_TIMEOUT, 60000);
            return client;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected SolrClient createNewSolrClient(String coreName, int port, int connectionTimeoutMillis, int socketTimeoutMillis) {
        try {
            String baseUrl = this.buildUrl(port);
            String url = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + coreName;
            HttpSolrClient client = AbstractFullDistribZkTestBase.getHttpSolrClient(url, connectionTimeoutMillis, socketTimeoutMillis);
            return client;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected SolrClient createNewSolrClient(String collection, String baseUrl) {
        try {
            HttpSolrClient client = AbstractFullDistribZkTestBase.getHttpSolrClient(baseUrl + "/" + collection, DEFAULT_CONNECTION_TIMEOUT, 60000);
            return client;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String getBaseUrl(HttpSolrClient client) {
        return client.getBaseURL().substring(0, client.getBaseURL().length() - "collection1".length() - 1);
    }

    public static SolrInputDocument getDoc(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument(new String[0]);
        AbstractFullDistribZkTestBase.addFields(doc, fields);
        return doc;
    }

    private String checkCollectionExpectations(String collectionName, List<Integer> numShardsNumReplicaList, List<String> nodesAllowedToRunShards) {
        ClusterState clusterState = this.getCommonCloudSolrClient().getZkStateReader().getClusterState();
        int expectedSlices = numShardsNumReplicaList.get(0);
        int expectedShardsPerSlice = numShardsNumReplicaList.get(1);
        int expectedTotalShards = expectedSlices * expectedShardsPerSlice;
        if (clusterState.hasCollection(collectionName)) {
            Map slices = clusterState.getCollection(collectionName).getSlicesMap();
            if (slices.size() != expectedSlices) {
                return "Found new collection " + collectionName + ", but mismatch on number of slices. Expected: " + expectedSlices + ", actual: " + slices.size();
            }
            int totalShards = 0;
            for (String sliceName : slices.keySet()) {
                for (Replica replica : ((Slice)slices.get(sliceName)).getReplicas()) {
                    if (nodesAllowedToRunShards == null || nodesAllowedToRunShards.contains(replica.getStr("node_name"))) continue;
                    return "Shard " + replica.getName() + " created on node " + replica.getNodeName() + " not allowed to run shards for the created collection " + collectionName;
                }
                totalShards += ((Slice)slices.get(sliceName)).getReplicas().size();
            }
            if (totalShards != expectedTotalShards) {
                return "Found new collection " + collectionName + " with correct number of slices, but mismatch on number of shards. Expected: " + expectedTotalShards + ", actual: " + totalShards;
            }
            return null;
        }
        return "Could not find new collection " + collectionName;
    }

    protected void checkForCollection(String collectionName, List<Integer> numShardsNumReplicaList, List<String> nodesAllowedToRunShards) throws Exception {
        TimeOut timeout = new TimeOut(120L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        boolean success = false;
        String checkResult = "Didnt get to perform a single check";
        while (!timeout.hasTimedOut()) {
            checkResult = this.checkCollectionExpectations(collectionName, numShardsNumReplicaList, nodesAllowedToRunShards);
            if (checkResult == null) {
                success = true;
                break;
            }
            Thread.sleep(500L);
        }
        if (!success) {
            super.printLayout();
            AbstractFullDistribZkTestBase.fail((String)checkResult);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CloudSolrClient getCommonCloudSolrClient() {
        AbstractFullDistribZkTestBase abstractFullDistribZkTestBase = this;
        synchronized (abstractFullDistribZkTestBase) {
            if (this.commonCloudSolrClient == null) {
                this.commonCloudSolrClient = AbstractFullDistribZkTestBase.getCloudSolrClient(this.zkServer.getZkAddress(), AbstractFullDistribZkTestBase.random().nextBoolean(), 5000, 120000);
                this.commonCloudSolrClient.setDefaultCollection("collection1");
                this.commonCloudSolrClient.connect();
                log.info("Created commonCloudSolrClient with updatesToLeaders={} and parallelUpdates={}", (Object)this.commonCloudSolrClient.isUpdatesToLeaders(), (Object)this.commonCloudSolrClient.isParallelUpdates());
            }
        }
        return this.commonCloudSolrClient;
    }

    public static String getUrlFromZk(ClusterState clusterState, String collection) {
        Map slices = clusterState.getCollection(collection).getSlicesMap();
        if (slices == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection:" + collection);
        }
        for (Map.Entry entry : slices.entrySet()) {
            Slice slice = (Slice)entry.getValue();
            Map shards = slice.getReplicasMap();
            Set shardEntries = shards.entrySet();
            for (Map.Entry shardEntry : shardEntries) {
                ZkNodeProps node = (ZkNodeProps)shardEntry.getValue();
                if (!clusterState.liveNodesContain(node.getStr("node_name"))) continue;
                return ZkCoreNodeProps.getCoreUrl((String)node.getStr("base_url"), (String)collection);
            }
        }
        throw new RuntimeException("Could not find a live node for collection:" + collection);
    }

    public static void waitForNon403or404or503(HttpSolrClient collectionClient) throws Exception {
        SolrException exp = null;
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        while (!timeout.hasTimedOut()) {
            boolean missing = false;
            try {
                collectionClient.query((SolrParams)new SolrQuery("*:*"));
            }
            catch (SolrException e) {
                if (e.code() != 403 && e.code() != 503 && e.code() != 404) {
                    throw e;
                }
                exp = e;
                missing = true;
            }
            if (!missing) {
                return;
            }
            Thread.sleep(50L);
        }
        AbstractFullDistribZkTestBase.fail((String)("Could not find the new collection - " + exp.code() + " : " + collectionClient.getBaseURL()));
    }

    protected void assertCollectionNotExists(String collectionName, int timeoutSeconds) throws Exception {
        AbstractFullDistribZkTestBase.waitForCollectionToDisappear(collectionName, this.getCommonCloudSolrClient().getZkStateReader(), false, true, timeoutSeconds);
        AbstractFullDistribZkTestBase.assertFalse((boolean)this.cloudClient.getZkStateReader().getZkClient().exists("/collections/" + collectionName, true));
    }

    protected void createCollection(String collName, CloudSolrClient client, int replicationFactor, int numShards) throws Exception {
        int maxShardsPerNode = (numShards + 1) * replicationFactor / this.getCommonCloudSolrClient().getZkStateReader().getClusterState().getLiveNodes().size() + 1;
        int numNrtReplicas = this.useTlogReplicas() ? 0 : replicationFactor;
        int numTlogReplicas = this.useTlogReplicas() ? replicationFactor : 0;
        Map props = Utils.makeMap((Object[])new Object[]{"maxShardsPerNode", maxShardsPerNode, "nrtReplicas", numNrtReplicas, "tlogReplicas", numTlogReplicas, "pullReplicas", this.getPullReplicaCount(), "numShards", numShards});
        HashMap<String, List<Integer>> collectionInfos = new HashMap<String, List<Integer>>();
        this.createCollection(collectionInfos, collName, props, (SolrClient)client);
    }

    protected void createCollectionRetry(String testCollectionName, String configSetName, int numShards, int replicationFactor, int maxShardsPerNode) throws SolrServerException, IOException {
        CollectionAdminResponse resp = this.createCollection(testCollectionName, configSetName, numShards, replicationFactor, maxShardsPerNode);
        if (resp.getResponse().get("failure") != null) {
            CollectionAdminRequest.Delete req = CollectionAdminRequest.deleteCollection((String)testCollectionName);
            req.process((SolrClient)this.cloudClient);
            resp = this.createCollection(testCollectionName, configSetName, numShards, replicationFactor, maxShardsPerNode);
            if (resp.getResponse().get("failure") != null) {
                AbstractFullDistribZkTestBase.fail((String)("Could not create " + testCollectionName));
            }
        }
    }

    protected Replica getShardLeader(String testCollectionName, String shardId, int timeoutSecs) throws Exception {
        Replica leader = null;
        long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeoutSecs, TimeUnit.SECONDS);
        while (System.nanoTime() < timeout) {
            Replica tmp = null;
            try {
                tmp = this.cloudClient.getZkStateReader().getLeaderRetry(testCollectionName, shardId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tmp != null && "active".equals(tmp.getStr("state"))) {
                leader = tmp;
                break;
            }
            Thread.sleep(1000L);
        }
        AbstractFullDistribZkTestBase.assertNotNull((String)("Could not find active leader for " + shardId + " of " + testCollectionName + " after " + timeoutSecs + " secs; clusterState: " + this.printClusterStateInfo(testCollectionName)), (Object)leader);
        return leader;
    }

    protected List<Replica> ensureAllReplicasAreActive(String testCollectionName, String shardId, int shards, int rf, int maxWaitSecs) throws Exception {
        RTimer timer = new RTimer();
        HashMap<String, Replica> notLeaders = new HashMap<String, Replica>();
        ZkStateReader zkr = this.cloudClient.getZkStateReader();
        zkr.forceUpdateCollection(testCollectionName);
        ClusterState cs = zkr.getClusterState();
        Collection slices = cs.getCollection(testCollectionName).getActiveSlices();
        AbstractFullDistribZkTestBase.assertTrue((slices.size() == shards ? 1 : 0) != 0);
        boolean allReplicasUp = false;
        long waitMs = 0L;
        long maxWaitMs = (long)maxWaitSecs * 1000L;
        Replica leader = null;
        ZkShardTerms zkShardTerms = new ZkShardTerms(testCollectionName, shardId, this.cloudClient.getZkStateReader().getZkClient());
        while (waitMs < maxWaitMs && !allReplicasUp) {
            cs = this.cloudClient.getZkStateReader().getClusterState();
            AbstractFullDistribZkTestBase.assertNotNull((Object)cs);
            DocCollection docCollection = cs.getCollectionOrNull(testCollectionName);
            AbstractFullDistribZkTestBase.assertNotNull((String)("No collection found for " + testCollectionName), (Object)docCollection);
            Slice shard = docCollection.getSlice(shardId);
            AbstractFullDistribZkTestBase.assertNotNull((String)("No Slice for " + shardId), (Object)shard);
            allReplicasUp = true;
            Collection replicas = shard.getReplicas();
            AbstractFullDistribZkTestBase.assertTrue((String)("Did not find correct number of replicas. Expected:" + rf + " Found:" + replicas.size()), (replicas.size() == rf ? 1 : 0) != 0);
            leader = shard.getLeader();
            AbstractFullDistribZkTestBase.assertNotNull((Object)leader);
            log.info("Found " + replicas.size() + " replicas and leader on " + leader.getNodeName() + " for " + shardId + " in " + testCollectionName);
            for (Replica replica : replicas) {
                if (!zkShardTerms.canBecomeLeader(replica.getName()) || replica.getState() != Replica.State.ACTIVE) {
                    log.info("Replica {} is currently {}", (Object)replica.getName(), (Object)replica.getState());
                    allReplicasUp = false;
                }
                if (leader.equals((Object)replica)) continue;
                notLeaders.put(replica.getName(), replica);
            }
            if (allReplicasUp) continue;
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            waitMs += 500L;
        }
        zkShardTerms.close();
        if (!allReplicasUp) {
            AbstractFullDistribZkTestBase.fail((String)("Didn't see all replicas for shard " + shardId + " in " + testCollectionName + " come up within " + maxWaitMs + " ms! ClusterState: " + this.printClusterStateInfo()));
        }
        if (notLeaders.isEmpty()) {
            AbstractFullDistribZkTestBase.fail((String)("Didn't isolate any replicas that are not the leader! ClusterState: " + this.printClusterStateInfo()));
        }
        log.info("Took {} ms to see all replicas become active.", (Object)timer.getTime());
        ArrayList<Replica> replicas = new ArrayList<Replica>();
        replicas.addAll(notLeaders.values());
        return replicas;
    }

    protected String printClusterStateInfo() throws Exception {
        return this.printClusterStateInfo(null);
    }

    protected String printClusterStateInfo(String collection) throws Exception {
        this.cloudClient.getZkStateReader().forceUpdateCollection(collection);
        String cs = null;
        ClusterState clusterState = this.cloudClient.getZkStateReader().getClusterState();
        if (collection != null) {
            cs = clusterState.getCollection(collection).toString();
        } else {
            Map map = clusterState.getCollectionsMap();
            CharArr out = new CharArr();
            new JSONWriter(out, 2).write(map);
            cs = out.toString();
        }
        return cs;
    }

    protected boolean reloadCollection(Replica replica, String testCollectionName) throws Exception {
        ZkCoreNodeProps coreProps = new ZkCoreNodeProps((ZkNodeProps)replica);
        String coreName = coreProps.getCoreName();
        boolean reloadedOk = false;
        try (HttpSolrClient client = AbstractFullDistribZkTestBase.getHttpSolrClient(coreProps.getBaseUrl());){
            CoreAdminResponse statusResp = CoreAdminRequest.getStatus((String)coreName, (SolrClient)client);
            long leaderCoreStartTime = statusResp.getStartTime(coreName).getTime();
            Thread.sleep(1000L);
            log.info("Sending RELOAD command for " + testCollectionName);
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("action", new String[]{CollectionParams.CollectionAction.RELOAD.toString()});
            params.set("name", new String[]{testCollectionName});
            QueryRequest request = new QueryRequest((SolrParams)params);
            request.setPath("/admin/collections");
            client.request((SolrRequest)request);
            Thread.sleep(2000L);
            long timeout = System.nanoTime() + TimeUnit.NANOSECONDS.convert(30L, TimeUnit.SECONDS);
            while (System.nanoTime() < timeout) {
                statusResp = CoreAdminRequest.getStatus((String)coreName, (SolrClient)client);
                long startTimeAfterReload = statusResp.getStartTime(coreName).getTime();
                if (startTimeAfterReload > leaderCoreStartTime) {
                    reloadedOk = true;
                    break;
                }
                Thread.sleep(1000L);
            }
        }
        return reloadedOk;
    }

    protected void logReplicaTypesReplicationInfo(String collectionName, ZkStateReader zkStateReader) throws KeeperException, InterruptedException, IOException {
        log.info("## Collecting extra Replica.Type information of the cluster");
        zkStateReader.updateLiveNodes();
        StringBuilder builder = new StringBuilder();
        zkStateReader.forceUpdateCollection(collectionName);
        DocCollection collection = zkStateReader.getClusterState().getCollection(collectionName);
        for (Slice s : collection.getSlices()) {
            Replica leader = s.getLeader();
            for (Replica r : s.getReplicas()) {
                if (!r.isActive(zkStateReader.getClusterState().getLiveNodes())) {
                    builder.append(String.format(Locale.ROOT, "Replica %s not in liveNodes or is not active%s", r.getName(), System.lineSeparator()));
                    continue;
                }
                if (r.equals((Object)leader)) {
                    builder.append(String.format(Locale.ROOT, "Replica %s is leader%s", r.getName(), System.lineSeparator()));
                }
                this.logReplicationDetails(r, builder);
            }
        }
        log.info("Summary of the cluster: " + builder.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitForReplicationFromReplicas(String collectionName, ZkStateReader zkStateReader, TimeOut timeout) throws KeeperException, InterruptedException, IOException {
        zkStateReader.forceUpdateCollection(collectionName);
        DocCollection collection = zkStateReader.getClusterState().getCollection(collectionName);
        HashMap<String, CoreContainer> containers = new HashMap<String, CoreContainer>();
        for (JettySolrRunner runner : this.jettys) {
            if (!runner.isRunning()) continue;
            containers.put(runner.getNodeName(), runner.getCoreContainer());
        }
        for (Slice s : collection.getSlices()) {
            Replica leader = zkStateReader.getLeaderRetry(collectionName, s.getName(), (int)timeout.timeLeft(TimeUnit.MILLISECONDS));
            long leaderIndexVersion = -1L;
            while (!timeout.hasTimedOut() && (leaderIndexVersion = this.getIndexVersion(leader)) < 0L) {
                Thread.sleep(1000L);
            }
            if (timeout.hasTimedOut()) {
                AbstractFullDistribZkTestBase.fail((String)"Unable to get leader indexVersion");
            }
            block19: for (Replica pullReplica : s.getReplicas(EnumSet.of(Replica.Type.PULL, Replica.Type.TLOG))) {
                if (!zkStateReader.getClusterState().liveNodesContain(pullReplica.getNodeName())) continue;
                while (true) {
                    block27: {
                        long replicaIndexVersion;
                        if (leaderIndexVersion == (replicaIndexVersion = this.getIndexVersion(pullReplica))) {
                            log.info("Leader replica's version ({}) in sync with replica({}): {} == {}", new Object[]{leader.getName(), pullReplica.getName(), leaderIndexVersion, replicaIndexVersion});
                            SolrCore core = ((CoreContainer)containers.get(pullReplica.getNodeName())).getCore(pullReplica.getCoreName());
                            Throwable throwable = null;
                            try {
                                RefCounted ref = core.getRegisteredSearcher();
                                try {
                                    SolrIndexSearcher searcher = (SolrIndexSearcher)ref.get();
                                    String servingVersion = (String)searcher.getIndexReader().getIndexCommit().getUserData().get("commitTimeMSec");
                                    if (Long.parseLong(servingVersion) == replicaIndexVersion) continue block19;
                                    log.info("Replica {} has the correct version replicated, but the searcher is not ready yet. Replicated version: {}, Serving version: {}", new Object[]{pullReplica.getName(), replicaIndexVersion, servingVersion});
                                    break block27;
                                }
                                finally {
                                    if (ref == null) continue block19;
                                    ref.decref();
                                    continue block19;
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (core == null) continue block19;
                                if (throwable != null) {
                                    try {
                                        core.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue block19;
                                }
                                core.close();
                                continue block19;
                            }
                        }
                        if (timeout.hasTimedOut()) {
                            this.logReplicaTypesReplicationInfo(collectionName, zkStateReader);
                            AbstractFullDistribZkTestBase.fail((String)String.format(Locale.ROOT, "Timed out waiting for replica %s (%d) to replicate from leader %s (%d)", pullReplica.getName(), replicaIndexVersion, leader.getName(), leaderIndexVersion));
                        }
                        if (leaderIndexVersion > replicaIndexVersion) {
                            log.info("{} version is {} and leader's is {}, will wait for replication", new Object[]{pullReplica.getName(), replicaIndexVersion, leaderIndexVersion});
                        } else {
                            log.info("Leader replica's version ({}) is lower than pull replica({}): {} < {}", new Object[]{leader.getName(), pullReplica.getName(), leaderIndexVersion, replicaIndexVersion});
                        }
                    }
                    Thread.sleep(1000L);
                }
            }
        }
    }

    protected void waitForAllWarmingSearchers() throws InterruptedException {
        for (JettySolrRunner jetty : this.jettys) {
            if (!jetty.isRunning()) continue;
            for (SolrCore core : jetty.getCoreContainer().getCores()) {
                AbstractFullDistribZkTestBase.waitForWarming(core);
            }
        }
    }

    /*
     * Loose catch block
     */
    protected long getIndexVersion(Replica replica) throws IOException {
        Throwable throwable = null;
        try (HttpSolrClient client = new HttpSolrClient.Builder(replica.getCoreUrl()).build();){
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("qt", new String[]{"/replication"});
            params.set("command", new String[]{"commits"});
            try {
                QueryResponse response = client.query((SolrParams)params);
                List commits = (List)response.getResponse().get("commits");
                Collections.max(commits, (a, b) -> ((Long)a.get("indexVersion")).compareTo((Long)b.get("indexVersion")));
                long l = (Long)((NamedList)Collections.max(commits, (a, b) -> ((Long)a.get("indexVersion")).compareTo((Long)b.get("indexVersion")))).get("indexVersion");
                return l;
            }
            catch (SolrServerException e) {
                long l;
                block17: {
                    block18: {
                        log.warn("Exception getting version from {}, will return an invalid version to retry.", (Object)replica.getName(), (Object)e);
                        l = -1L;
                        if (client == null) break block17;
                        if (throwable == null) break block18;
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block17;
                    }
                    client.close();
                }
                return l;
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
    }

    protected static boolean attemptCollectionDelete(CloudSolrClient client, String collectionName) {
        try {
            CollectionAdminRequest.deleteCollection((String)collectionName).process((SolrClient)client);
            return true;
        }
        catch (Exception e) {
            log.warn("Could not delete collection {} - ignoring", (Object)collectionName);
            return false;
        }
    }

    protected void logReplicationDetails(Replica replica, StringBuilder builder) throws IOException {
        try (HttpSolrClient client = new HttpSolrClient.Builder(replica.getCoreUrl()).build();){
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("qt", new String[]{"/replication"});
            params.set("command", new String[]{"details"});
            try {
                QueryResponse response = client.query((SolrParams)params);
                builder.append(String.format(Locale.ROOT, "%s: %s%s", replica.getName(), response.getResponse(), System.lineSeparator()));
            }
            catch (SolrServerException e) {
                log.warn("Unable to ger replication details for replica {}", (Object)replica.getName(), (Object)e);
            }
        }
    }

    static RequestStatusState getRequestStateAfterCompletion(String requestId, int waitForSeconds, SolrClient client) throws IOException, SolrServerException {
        RequestStatusState state = null;
        TimeOut timeout = new TimeOut((long)waitForSeconds, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        while (!timeout.hasTimedOut()) {
            state = AbstractFullDistribZkTestBase.getRequestState(requestId, client);
            if (state == RequestStatusState.COMPLETED || state == RequestStatusState.FAILED) {
                return state;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return state;
    }

    static RequestStatusState getRequestState(int requestId, SolrClient client) throws IOException, SolrServerException {
        return AbstractFullDistribZkTestBase.getRequestState(String.valueOf(requestId), client);
    }

    static RequestStatusState getRequestState(String requestId, SolrClient client) throws IOException, SolrServerException {
        CollectionAdminResponse response = AbstractFullDistribZkTestBase.getStatusResponse(requestId, client);
        NamedList innerResponse = (NamedList)response.getResponse().get("status");
        return RequestStatusState.fromKey((String)((String)innerResponse.get("state")));
    }

    static CollectionAdminResponse getStatusResponse(String requestId, SolrClient client) throws SolrServerException, IOException {
        return (CollectionAdminResponse)CollectionAdminRequest.requestStatus((String)requestId).process(client);
    }

    protected void setupRestTestHarnesses() {
        for (SolrClient client : this.clients) {
            RestTestHarness harness = new RestTestHarness(() -> ((HttpSolrClient)client).getBaseURL());
            this.restTestHarnesses.add(harness);
        }
    }

    protected void closeRestTestHarnesses() throws IOException {
        for (RestTestHarness h : this.restTestHarnesses) {
            h.close();
        }
    }

    protected RestTestHarness randomRestTestHarness() {
        return this.restTestHarnesses.get(AbstractFullDistribZkTestBase.random().nextInt(this.restTestHarnesses.size()));
    }

    protected RestTestHarness randomRestTestHarness(Random random) {
        return this.restTestHarnesses.get(random.nextInt(this.restTestHarnesses.size()));
    }

    protected void forAllRestTestHarnesses(UnaryOperator<RestTestHarness> op) {
        for (RestTestHarness h : this.restTestHarnesses) {
            op.apply(h);
        }
    }

    static abstract class StoppableThread
    extends Thread {
        public StoppableThread(String name) {
            super(name);
        }

        public abstract void safeStop();
    }

    public static class CloudSolrServerClient {
        SolrClient solrClient;
        String shardName;
        int port;
        public ZkNodeProps info;

        public CloudSolrServerClient() {
        }

        public CloudSolrServerClient(SolrClient client) {
            this.solrClient = client;
        }

        public SolrClient getSolrClient() {
            return this.solrClient;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.solrClient == null ? 0 : this.solrClient.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CloudSolrServerClient other = (CloudSolrServerClient)obj;
            return !(this.solrClient == null ? other.solrClient != null : !this.solrClient.equals(other.solrClient));
        }
    }

    public static class CloudJettyRunner {
        public JettySolrRunner jetty;
        public String nodeName;
        public String coreNodeName;
        public String url;
        public CloudSolrServerClient client;
        public ZkNodeProps info;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CloudJettyRunner other = (CloudJettyRunner)obj;
            return !(this.url == null ? other.url != null : !this.url.equals(other.url));
        }

        public String toString() {
            return "CloudJettyRunner [url=" + this.url + "]";
        }
    }
}

