/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.cloud.AbstractDistribZkTestBase;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.apache.solr.cloud.SolrCloudTestCase;
import org.junit.AfterClass;

public abstract class MultiSolrCloudTestCase
extends SolrTestCaseJ4 {
    protected static Map<String, MiniSolrCloudCluster> clusterId2cluster = new HashMap<String, MiniSolrCloudCluster>();

    protected static void doSetupClusters(String[] clusterIds, Function<String, MiniSolrCloudCluster> createFunc, BiConsumer<String, MiniSolrCloudCluster> initFunc) throws Exception {
        for (String clusterId : clusterIds) {
            MultiSolrCloudTestCase.assertFalse((String)("duplicate clusterId " + clusterId), (boolean)clusterId2cluster.containsKey(clusterId));
            MiniSolrCloudCluster cluster = createFunc.apply(clusterId);
            initFunc.accept(clusterId, cluster);
            clusterId2cluster.put(clusterId, cluster);
        }
    }

    @AfterClass
    public static void shutdownCluster() throws Exception {
        for (MiniSolrCloudCluster cluster : clusterId2cluster.values()) {
            cluster.shutdown();
        }
        clusterId2cluster.clear();
    }

    protected static abstract class DefaultClusterInitFunction
    implements BiConsumer<String, MiniSolrCloudCluster> {
        private final int numShards;
        private final int numReplicas;
        private final int maxShardsPerNode;

        public DefaultClusterInitFunction(int numShards, int numReplicas, int maxShardsPerNode) {
            this.numShards = numShards;
            this.numReplicas = numReplicas;
            this.maxShardsPerNode = maxShardsPerNode;
        }

        protected void doAccept(String collection, MiniSolrCloudCluster cluster) {
            try {
                CollectionAdminRequest.createCollection((String)collection, (String)"conf", (int)this.numShards, (int)this.numReplicas).setMaxShardsPerNode(Integer.valueOf(this.maxShardsPerNode)).processAndWait((SolrClient)cluster.getSolrClient(), 90L);
                AbstractDistribZkTestBase.waitForRecoveriesToFinish(collection, cluster.getSolrClient().getZkStateReader(), false, true, 90);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected static abstract class DefaultClusterCreateFunction
    implements Function<String, MiniSolrCloudCluster> {
        protected abstract int nodesPerCluster(String var1);

        @Override
        public MiniSolrCloudCluster apply(String clusterId) {
            try {
                MiniSolrCloudCluster cluster = new SolrCloudTestCase.Builder(this.nodesPerCluster(clusterId), LuceneTestCase.createTempDir()).addConfig("conf", SolrTestCaseJ4.configset("cloud-dynamic")).build();
                return cluster;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

