/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import java.security.UnrecoverableKeyException;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.HttpClientUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.CertificateUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class SSLTestConfig
extends SSLConfig {
    private static final String TEST_KEYSTORE_BOGUSHOST_RESOURCE = "SSLTestConfig.hostname-and-ip-missmatch.keystore";
    private static final String TEST_KEYSTORE_LOCALHOST_RESOURCE = "SSLTestConfig.testing.keystore";
    private static final String TEST_KEYSTORE_PASSWORD = "secret";
    private final boolean checkPeerName;
    private final Resource keyStore;
    private final Resource trustStore;
    private static final HttpClientUtil.SchemaRegistryProvider HTTP_ONLY_SCHEMA_PROVIDER = new HttpClientUtil.SchemaRegistryProvider(){

        public Registry<ConnectionSocketFactory> getSchemaRegistry() {
            return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).build();
        }
    };

    public SSLTestConfig() {
        this(false, false);
    }

    public SSLTestConfig(boolean useSSL, boolean clientAuth) {
        this(useSSL, clientAuth, false);
    }

    public SSLTestConfig(boolean useSSL, boolean clientAuth, boolean checkPeerName) {
        super(useSSL, clientAuth, null, TEST_KEYSTORE_PASSWORD, null, TEST_KEYSTORE_PASSWORD);
        this.checkPeerName = checkPeerName;
        String resourceName = checkPeerName ? TEST_KEYSTORE_LOCALHOST_RESOURCE : TEST_KEYSTORE_BOGUSHOST_RESOURCE;
        this.trustStore = this.keyStore = Resource.newClassPathResource((String)resourceName);
        if (null == this.keyStore || !this.keyStore.exists()) {
            throw new IllegalStateException("Unable to locate keystore resource file in classpath: " + resourceName);
        }
    }

    public boolean getCheckPeerName() {
        return this.checkPeerName;
    }

    public String getKeyStore() {
        return null;
    }

    public String getTrustStore() {
        return null;
    }

    public HttpClientUtil.SchemaRegistryProvider buildClientSchemaRegistryProvider() {
        if (this.isSSLMode()) {
            SSLConnectionSocketFactory sslConnectionFactory = this.buildClientSSLConnectionSocketFactory();
            assert (null != sslConnectionFactory);
            return new SSLSchemaRegistryProvider(sslConnectionFactory);
        }
        return HTTP_ONLY_SCHEMA_PROVIDER;
    }

    public SSLContext buildClientSSLContext() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        assert (this.isSSLMode());
        SSLContextBuilder builder = SSLContexts.custom();
        builder.setSecureRandom(NotSecurePsuedoRandom.INSTANCE);
        builder.loadTrustMaterial(SSLTestConfig.buildKeyStore(this.keyStore, this.getKeyStorePassword()), (TrustStrategy)new TrustSelfSignedStrategy()).build();
        if (this.isClientAuthMode()) {
            builder.loadKeyMaterial(SSLTestConfig.buildKeyStore(this.trustStore, this.getTrustStorePassword()), this.getTrustStorePassword().toCharArray());
        }
        return builder.build();
    }

    public SSLContext buildServerSSLContext() throws KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException {
        assert (this.isSSLMode());
        SSLContextBuilder builder = SSLContexts.custom();
        builder.setSecureRandom(NotSecurePsuedoRandom.INSTANCE);
        builder.loadKeyMaterial(SSLTestConfig.buildKeyStore(this.keyStore, this.getKeyStorePassword()), this.getKeyStorePassword().toCharArray());
        if (this.isClientAuthMode()) {
            builder.loadTrustMaterial(SSLTestConfig.buildKeyStore(this.trustStore, this.getTrustStorePassword()), (TrustStrategy)new TrustSelfSignedStrategy()).build();
        }
        return builder.build();
    }

    public SslContextFactory createContextFactory() {
        if (!this.isSSLMode()) {
            return null;
        }
        SslContextFactory factory = new SslContextFactory(false);
        try {
            factory.setSslContext(this.buildServerSSLContext());
        }
        catch (Exception e) {
            throw new RuntimeException("ssl context init failure: " + e.getMessage(), e);
        }
        factory.setNeedClientAuth(this.isClientAuthMode());
        return factory;
    }

    protected static KeyStore buildKeyStore(Resource resource, String password) {
        try {
            return CertificateUtils.getKeyStore((Resource)resource, (String)"JKS", null, (String)password);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Unable to build KeyStore from resource: " + resource.getName(), ex);
        }
    }

    public SSLConnectionSocketFactory buildClientSSLConnectionSocketFactory() {
        SSLConnectionSocketFactory sslConnectionFactory;
        if (!this.isSSLMode()) {
            return null;
        }
        try {
            SSLContext sslContext = this.buildClientSSLContext();
            sslConnectionFactory = !this.checkPeerName ? new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE) : new SSLConnectionSocketFactory(sslContext);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new IllegalStateException("Unable to setup https scheme for HTTPClient to test SSL.", e);
        }
        return sslConnectionFactory;
    }

    public static boolean toBooleanDefaultIfNull(Boolean bool, boolean valueIfNull) {
        if (bool == null) {
            return valueIfNull;
        }
        return bool != false;
    }

    public static Boolean toBooleanObject(String str) {
        if ("true".equalsIgnoreCase(str)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(str)) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static class NotSecurePsuedoRandom
    extends SecureRandom {
        public static final SecureRandom INSTANCE = new NotSecurePsuedoRandom();
        private static final Random RAND = new Random(42L);
        private static final SecureRandomSpi NOT_SECURE_SPI = new SecureRandomSpi(){

            @Override
            public byte[] engineGenerateSeed(int numBytes) {
                return NotSecurePsuedoRandom.fillData(new byte[numBytes]);
            }

            @Override
            public void engineNextBytes(byte[] bytes) {
                NotSecurePsuedoRandom.fillData(bytes);
            }

            @Override
            public void engineSetSeed(byte[] seed) {
            }
        };

        private static final byte[] fillData(byte[] data) {
            RAND.nextBytes(data);
            return data;
        }

        private NotSecurePsuedoRandom() {
            super(NOT_SECURE_SPI, null);
        }

        @Override
        public byte[] generateSeed(int numBytes) {
            return NotSecurePsuedoRandom.fillData(new byte[numBytes]);
        }

        @Override
        public synchronized void nextBytes(byte[] bytes) {
            NotSecurePsuedoRandom.fillData(bytes);
        }

        @Override
        public synchronized void setSeed(byte[] seed) {
        }

        @Override
        public synchronized void setSeed(long seed) {
        }
    }

    private static class SSLSchemaRegistryProvider
    extends HttpClientUtil.SchemaRegistryProvider {
        private final SSLConnectionSocketFactory sslConnectionFactory;

        public SSLSchemaRegistryProvider(SSLConnectionSocketFactory sslConnectionFactory) {
            this.sslConnectionFactory = sslConnectionFactory;
        }

        public Registry<ConnectionSocketFactory> getSchemaRegistry() {
            return RegistryBuilder.create().register("https", (Object)this.sslConnectionFactory).build();
        }
    }
}

