/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jetty9.InstrumentedHandler;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.Filter;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.embedded.SSLConfig;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.request.ConfigSetAdminRequest;
import org.apache.solr.client.solrj.response.ConfigSetAdminResponse;
import org.apache.solr.cloud.ChaosMonkey;
import org.apache.solr.cloud.Overseer;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.CloudCollectionsListener;
import org.apache.solr.common.cloud.CollectionStatePredicate;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.util.TimeOut;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiniSolrCloudCluster {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String SOLR_TESTS_SHARDS_WHITELIST = "solr.tests.shardsWhitelist";
    public static final String DEFAULT_CLOUD_SOLR_XML = "<solr>\n\n  <str name=\"shareSchema\">${shareSchema:false}</str>\n  <str name=\"configSetBaseDir\">${configSetBaseDir:configsets}</str>\n  <str name=\"coreRootDirectory\">${coreRootDirectory:.}</str>\n  <str name=\"collectionsHandler\">${collectionsHandler:solr.CollectionsHandler}</str>\n\n  <shardHandlerFactory name=\"shardHandlerFactory\" class=\"HttpShardHandlerFactory\">\n    <str name=\"urlScheme\">${urlScheme:}</str>\n    <int name=\"socketTimeout\">${socketTimeout:90000}</int>\n    <int name=\"connTimeout\">${connTimeout:15000}</int>\n    <str name=\"shardsWhitelist\">${solr.tests.shardsWhitelist:}</str>\n  </shardHandlerFactory>\n\n  <solrcloud>\n    <str name=\"host\">127.0.0.1</str>\n    <int name=\"hostPort\">${hostPort:8983}</int>\n    <str name=\"hostContext\">${hostContext:solr}</str>\n    <int name=\"zkClientTimeout\">${solr.zkclienttimeout:30000}</int>\n    <bool name=\"genericCoreNodeNames\">${genericCoreNodeNames:true}</bool>\n    <int name=\"leaderVoteWait\">${leaderVoteWait:10000}</int>\n    <int name=\"distribUpdateConnTimeout\">${distribUpdateConnTimeout:45000}</int>\n    <int name=\"distribUpdateSoTimeout\">${distribUpdateSoTimeout:340000}</int>\n    <str name=\"zkCredentialsProvider\">${zkCredentialsProvider:org.apache.solr.common.cloud.DefaultZkCredentialsProvider}</str> \n    <str name=\"zkACLProvider\">${zkACLProvider:org.apache.solr.common.cloud.DefaultZkACLProvider}</str> \n  </solrcloud>\n  <metrics>\n    <reporter name=\"default\" class=\"org.apache.solr.metrics.reporters.SolrJmxReporter\">\n      <str name=\"rootName\">solr_${hostPort:8983}</str>\n    </reporter>\n  </metrics>\n  \n</solr>\n";
    private volatile ZkTestServer zkServer;
    private final boolean externalZkServer;
    private final List<JettySolrRunner> jettys = new CopyOnWriteArrayList<JettySolrRunner>();
    private final Path baseDir;
    private final CloudSolrClient solrClient;
    private final JettyConfig jettyConfig;
    private final boolean trackJettyMetrics;
    private final AtomicInteger nodeIds = new AtomicInteger();

    public MiniSolrCloudCluster(int numServers, Path baseDir, JettyConfig jettyConfig) throws Exception {
        this(numServers, baseDir, DEFAULT_CLOUD_SOLR_XML, jettyConfig, null);
    }

    public MiniSolrCloudCluster(int numServers, String hostContext, Path baseDir, String solrXml, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters) throws Exception {
        this(numServers, hostContext, baseDir, solrXml, extraServlets, extraRequestFilters, null);
    }

    public MiniSolrCloudCluster(int numServers, String hostContext, Path baseDir, String solrXml, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters, SSLConfig sslConfig) throws Exception {
        this(numServers, baseDir, solrXml, JettyConfig.builder().setContext(hostContext).withSSLConfig(sslConfig).withFilters(extraRequestFilters).withServlets(extraServlets).build());
    }

    public MiniSolrCloudCluster(int numServers, Path baseDir, String solrXml, JettyConfig jettyConfig) throws Exception {
        this(numServers, baseDir, solrXml, jettyConfig, null);
    }

    public MiniSolrCloudCluster(int numServers, Path baseDir, String solrXml, JettyConfig jettyConfig, ZkTestServer zkTestServer) throws Exception {
        this(numServers, baseDir, solrXml, jettyConfig, zkTestServer, Optional.empty());
    }

    MiniSolrCloudCluster(int numServers, Path baseDir, String solrXml, JettyConfig jettyConfig, ZkTestServer zkTestServer, Optional<String> securityJson) throws Exception {
        this(numServers, baseDir, solrXml, jettyConfig, zkTestServer, securityJson, false);
    }

    MiniSolrCloudCluster(int numServers, Path baseDir, String solrXml, JettyConfig jettyConfig, ZkTestServer zkTestServer, Optional<String> securityJson, boolean trackJettyMetrics) throws Exception {
        Objects.requireNonNull(securityJson);
        this.baseDir = Objects.requireNonNull(baseDir);
        this.jettyConfig = Objects.requireNonNull(jettyConfig);
        this.trackJettyMetrics = trackJettyMetrics;
        log.info("Starting cluster of {} servers in {}", (Object)numServers, (Object)baseDir);
        Files.createDirectories(baseDir, new FileAttribute[0]);
        boolean bl = this.externalZkServer = zkTestServer != null;
        if (!this.externalZkServer) {
            String zkDir = baseDir.resolve("zookeeper/server1/data").toString();
            zkTestServer = new ZkTestServer(zkDir);
            try {
                zkTestServer.run();
            }
            catch (Exception e) {
                log.error("Error starting Zk Test Server, trying again ...");
                zkTestServer.shutdown();
                zkTestServer = new ZkTestServer(zkDir);
                zkTestServer.run();
            }
        }
        this.zkServer = zkTestServer;
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkHost(), 45000);){
            zkClient.makePath("/solr/solr.xml", solrXml.getBytes(Charset.defaultCharset()), true);
            if (jettyConfig.sslConfig != null && jettyConfig.sslConfig.isSSLMode()) {
                zkClient.makePath("/solr/clusterprops.json", "{'urlScheme':'https'}".getBytes(StandardCharsets.UTF_8), true);
            }
            if (securityJson.isPresent()) {
                zkClient.makePath("/solr/security.json", securityJson.get().getBytes(Charset.defaultCharset()), true);
            }
        }
        System.setProperty("zkHost", this.zkServer.getZkAddress());
        ArrayList<Callable<JettySolrRunner>> startups = new ArrayList<Callable<JettySolrRunner>>(numServers);
        for (int i = 0; i < numServers; ++i) {
            startups.add(() -> this.startJettySolrRunner(this.newNodeName(), jettyConfig.context, jettyConfig));
        }
        ExecutorService executorLauncher = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("jetty-launcher"));
        List<Future<JettySolrRunner>> futures = executorLauncher.invokeAll(startups);
        ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)executorLauncher);
        Exception startupError = this.checkForExceptions("Error starting up MiniSolrCloudCluster", futures);
        if (startupError != null) {
            try {
                this.shutdown();
            }
            catch (Throwable t) {
                startupError.addSuppressed(t);
            }
            throw startupError;
        }
        this.solrClient = this.buildSolrClient();
        if (numServers > 0) {
            this.waitForAllNodes(numServers, 60);
        }
    }

    private void waitForAllNodes(int numServers, int timeoutSeconds) throws IOException, InterruptedException, TimeoutException {
        int numRunning = 0;
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        while (true) {
            if (timeout.hasTimedOut()) {
                throw new IllegalStateException("giving up waiting for all jetty instances to be running. numServers=" + numServers + " numRunning=" + numRunning);
            }
            numRunning = 0;
            for (JettySolrRunner jetty : this.getJettySolrRunners()) {
                if (!jetty.isRunning()) continue;
                ++numRunning;
            }
            if (numServers == numRunning) break;
            Thread.sleep(100L);
        }
        ZkStateReader reader = this.getSolrClient().getZkStateReader();
        for (JettySolrRunner jetty : this.getJettySolrRunners()) {
            reader.waitForLiveNodes(30L, TimeUnit.SECONDS, (o, n) -> n.contains(jetty.getNodeName()));
        }
    }

    public void waitForNode(JettySolrRunner jetty, int timeoutSeconds) throws IOException, InterruptedException, TimeoutException {
        ZkStateReader reader = this.getSolrClient().getZkStateReader();
        reader.waitForLiveNodes(30L, TimeUnit.SECONDS, (o, n) -> n.contains(jetty.getNodeName()));
    }

    public void waitForAllNodes(int timeout) throws IOException, InterruptedException, TimeoutException {
        this.waitForAllNodes(this.jettys.size(), timeout);
    }

    private String newNodeName() {
        return "node" + this.nodeIds.incrementAndGet();
    }

    private Path createInstancePath(String name) throws IOException {
        Path instancePath = this.baseDir.resolve(name);
        Files.createDirectory(instancePath, new FileAttribute[0]);
        return instancePath;
    }

    public ZkTestServer getZkServer() {
        return this.zkServer;
    }

    public List<JettySolrRunner> getJettySolrRunners() {
        return Collections.unmodifiableList(this.jettys);
    }

    public JettySolrRunner getRandomJetty(Random random) {
        int index = random.nextInt(this.jettys.size());
        return this.jettys.get(index);
    }

    public JettySolrRunner startJettySolrRunner(String name, String hostContext, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters) throws Exception {
        return this.startJettySolrRunner(name, hostContext, extraServlets, extraRequestFilters, null);
    }

    public JettySolrRunner startJettySolrRunner(String name, String hostContext, SortedMap<ServletHolder, String> extraServlets, SortedMap<Class<? extends Filter>, String> extraRequestFilters, SSLConfig sslConfig) throws Exception {
        return this.startJettySolrRunner(name, hostContext, JettyConfig.builder().withServlets(extraServlets).withFilters(extraRequestFilters).withSSLConfig(sslConfig).build());
    }

    public JettySolrRunner getJettySolrRunner(int index) {
        return this.jettys.get(index);
    }

    public JettySolrRunner startJettySolrRunner(String name, String hostContext, JettyConfig config) throws Exception {
        Path runnerPath = this.createInstancePath(name);
        String context = MiniSolrCloudCluster.getHostContextSuitableForServletContext(hostContext);
        JettyConfig newConfig = JettyConfig.builder((JettyConfig)config).setContext(context).build();
        JettySolrRunner jetty = !this.trackJettyMetrics ? new JettySolrRunner(runnerPath.toString(), newConfig) : new JettySolrRunnerWithMetrics(runnerPath.toString(), newConfig);
        jetty.start();
        this.jettys.add(jetty);
        return jetty;
    }

    public JettySolrRunner startJettySolrRunner() throws Exception {
        return this.startJettySolrRunner(this.newNodeName(), this.jettyConfig.context, this.jettyConfig);
    }

    public JettySolrRunner stopJettySolrRunner(int index) throws Exception {
        JettySolrRunner jetty = this.jettys.get(index);
        jetty.stop();
        this.jettys.remove(index);
        return jetty;
    }

    public JettySolrRunner startJettySolrRunner(JettySolrRunner jetty) throws Exception {
        jetty.start(false);
        if (!this.jettys.contains(jetty)) {
            this.jettys.add(jetty);
        }
        return jetty;
    }

    public JettySolrRunner stopJettySolrRunner(JettySolrRunner jetty) throws Exception {
        jetty.stop();
        this.jettys.remove(jetty);
        return jetty;
    }

    public void uploadConfigSet(Path configDir, String configName) throws IOException, KeeperException, InterruptedException {
        try (SolrZkClient zkClient = new SolrZkClient(this.zkServer.getZkAddress(), 45000, 45000, null);){
            ZkConfigManager manager = new ZkConfigManager(zkClient);
            manager.uploadConfigDir(configDir, configName);
        }
    }

    public void deleteAllCollections() throws Exception {
        boolean allContainersEmpty;
        try (ZkStateReader reader = new ZkStateReader(this.solrClient.getZkStateReader().getZkClient());){
            final CountDownLatch latch = new CountDownLatch(1);
            reader.registerCloudCollectionsListener(new CloudCollectionsListener(){

                public void onChange(Set<String> oldCollections, Set<String> newCollections) {
                    if (newCollections != null && newCollections.size() == 0) {
                        latch.countDown();
                    }
                }
            });
            reader.createClusterStateWatchersAndUpdate();
            reader.aliasesManager.applyModificationAndExportToZk(aliases -> Aliases.EMPTY);
            for (Object collection : reader.getClusterState().getCollectionStates().keySet()) {
                CollectionAdminRequest.deleteCollection((String)collection).process((SolrClient)this.solrClient);
            }
            boolean success = latch.await(60L, TimeUnit.SECONDS);
            if (!success) {
                throw new IllegalStateException("Still waiting to see all collections removed from clusterstate.");
            }
            for (String collection : reader.getClusterState().getCollectionStates().keySet()) {
                reader.waitForState(collection, 15L, TimeUnit.SECONDS, (liveNodes, collectionState) -> collectionState == null);
            }
        }
        TimeOut timeout = new TimeOut(30L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        do {
            if (timeout.hasTimedOut()) {
                throw new TimeoutException("Timed out waiting for all collections to be fully removed.");
            }
            allContainersEmpty = true;
            for (JettySolrRunner jetty : this.jettys) {
                CoreContainer cc = jetty.getCoreContainer();
                if (cc == null || cc.getCores().size() == 0) continue;
                allContainersEmpty = false;
            }
        } while (!allContainersEmpty);
    }

    public void deleteAllConfigSets() throws SolrServerException, IOException {
        List configSetNames = ((ConfigSetAdminResponse.List)new ConfigSetAdminRequest.List().process((SolrClient)this.solrClient)).getConfigSets();
        for (String configSet : configSetNames) {
            if (configSet.equals("_default")) continue;
            ((ConfigSetAdminRequest.Delete)new ConfigSetAdminRequest.Delete().setConfigSetName(configSet)).process((SolrClient)this.solrClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws Exception {
        try {
            IOUtils.closeQuietly((Closeable)this.solrClient);
            ArrayList<Callable<JettySolrRunner>> shutdowns = new ArrayList<Callable<JettySolrRunner>>(this.jettys.size());
            for (JettySolrRunner jetty : this.jettys) {
                shutdowns.add(() -> this.stopJettySolrRunner(jetty));
            }
            this.jettys.clear();
            ExecutorService executorCloser = ExecutorUtil.newMDCAwareCachedThreadPool((ThreadFactory)new SolrjNamedThreadFactory("jetty-closer"));
            List<Future<JettySolrRunner>> futures = executorCloser.invokeAll(shutdowns);
            ExecutorUtil.shutdownAndAwaitTermination((ExecutorService)executorCloser);
            Exception shutdownError = this.checkForExceptions("Error shutting down MiniSolrCloudCluster", futures);
            if (shutdownError != null) {
                throw shutdownError;
            }
        }
        finally {
            try {
                if (!this.externalZkServer) {
                    this.zkServer.shutdown();
                }
            }
            finally {
                System.clearProperty("zkHost");
            }
        }
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public CloudSolrClient getSolrClient() {
        return this.solrClient;
    }

    public SolrZkClient getZkClient() {
        return this.solrClient.getZkStateReader().getZkClient();
    }

    protected CloudSolrClient buildSolrClient() {
        return ((CloudSolrClient.Builder)((CloudSolrClient.Builder)new CloudSolrClient.Builder(Collections.singletonList(this.getZkServer().getZkAddress()), Optional.empty()).withSocketTimeout(90000)).withConnectionTimeout(15000)).build();
    }

    private static String getHostContextSuitableForServletContext(String ctx) {
        if (ctx == null || "".equals(ctx)) {
            ctx = "/solr";
        }
        if (ctx.endsWith("/")) {
            ctx = ctx.substring(0, ctx.length() - 1);
        }
        if (!ctx.startsWith("/")) {
            ctx = "/" + ctx;
        }
        return ctx;
    }

    private Exception checkForExceptions(String message, Collection<Future<JettySolrRunner>> futures) throws InterruptedException {
        Exception parsed = new Exception(message);
        boolean ok = true;
        for (Future<JettySolrRunner> future : futures) {
            try {
                future.get();
            }
            catch (ExecutionException e) {
                parsed.addSuppressed(e.getCause());
                ok = false;
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                throw e;
            }
        }
        return ok ? null : parsed;
    }

    public JettySolrRunner getReplicaJetty(Replica replica) {
        for (JettySolrRunner jetty : this.jettys) {
            if (jetty.isStopped() || !replica.getCoreUrl().startsWith(jetty.getBaseUrl().toString())) continue;
            return jetty;
        }
        throw new IllegalArgumentException("Cannot find Jetty for a replica with core url " + replica.getCoreUrl());
    }

    public void expireZkSession(JettySolrRunner jetty) {
        CoreContainer cores = jetty.getCoreContainer();
        if (cores != null) {
            SolrZkClient zkClient = cores.getZkController().getZkClient();
            zkClient.getSolrZooKeeper().closeCnxn();
            long sessionId = zkClient.getSolrZooKeeper().getSessionId();
            this.zkServer.expire(sessionId);
            log.info("Expired zookeeper session {} from node {}", (Object)sessionId, (Object)jetty.getBaseUrl());
        }
    }

    public synchronized void injectChaos(Random random) throws Exception {
        JettySolrRunner jetty;
        if (random.nextBoolean()) {
            jetty = this.jettys.get(random.nextInt(this.jettys.size()));
            jetty.stop();
            log.info("============ Restarting jetty");
            jetty.start();
        }
        if (random.nextBoolean()) {
            this.zkServer.shutdown();
            log.info("============ Restarting zookeeper");
            this.zkServer = new ZkTestServer(this.zkServer.getZkDir(), this.zkServer.getPort());
            this.zkServer.run(false);
        }
        if (random.nextBoolean()) {
            jetty = this.jettys.get(random.nextInt(this.jettys.size()));
            ChaosMonkey.causeConnectionLoss(jetty);
        }
    }

    public Overseer getOpenOverseer() {
        ArrayList<Overseer> overseers = new ArrayList<Overseer>();
        for (int i = 0; i < this.jettys.size(); ++i) {
            JettySolrRunner runner = this.getJettySolrRunner(i);
            if (runner.getCoreContainer() == null) continue;
            overseers.add(runner.getCoreContainer().getZkController().getOverseer());
        }
        return MiniSolrCloudCluster.getOpenOverseer(overseers);
    }

    public static Overseer getOpenOverseer(List<Overseer> overseers) {
        ArrayList<Overseer> shuffledOverseers = new ArrayList<Overseer>(overseers);
        Collections.shuffle(shuffledOverseers, LuceneTestCase.random());
        for (Overseer overseer : shuffledOverseers) {
            if (overseer.isClosed()) continue;
            return overseer;
        }
        throw new SolrException(SolrException.ErrorCode.NOT_FOUND, "No open Overseer found");
    }

    public void waitForActiveCollection(String collection, long wait, TimeUnit unit, int shards, int totalReplicas) {
        CollectionStatePredicate predicate = MiniSolrCloudCluster.expectedShardsAndActiveReplicas(shards, totalReplicas);
        AtomicReference state = new AtomicReference();
        AtomicReference liveNodesLastSeen = new AtomicReference();
        try {
            this.getSolrClient().waitForState(collection, wait, unit, (n, c) -> {
                state.set(c);
                liveNodesLastSeen.set(n);
                return predicate.matches(n, c);
            });
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Failed while waiting for active collection\n" + e.getMessage() + "\nLive Nodes: " + Arrays.toString(((Set)liveNodesLastSeen.get()).toArray()) + "\nLast available state: " + state.get());
        }
    }

    public void waitForActiveCollection(String collection, int shards, int totalReplicas) {
        this.waitForActiveCollection(collection, 30L, TimeUnit.SECONDS, shards, totalReplicas);
    }

    public static CollectionStatePredicate expectedShardsAndActiveReplicas(int expectedShards, int expectedReplicas) {
        return (liveNodes, collectionState) -> {
            if (collectionState == null) {
                return false;
            }
            if (collectionState.getSlices().size() != expectedShards) {
                return false;
            }
            int activeReplicas = 0;
            for (Slice slice : collectionState) {
                for (Replica replica : slice) {
                    if (!replica.isActive(liveNodes)) continue;
                    ++activeReplicas;
                }
            }
            return activeReplicas == expectedReplicas;
        };
    }

    public void waitForJettyToStop(JettySolrRunner runner) throws TimeoutException {
        TimeOut timeout = new TimeOut(15L, TimeUnit.SECONDS, TimeSource.NANO_TIME);
        while (!timeout.hasTimedOut() && !runner.isStopped()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (timeout.hasTimedOut()) {
            throw new TimeoutException("Waiting for Jetty to stop timed out");
        }
    }

    public static final class JettySolrRunnerWithMetrics
    extends JettySolrRunner {
        private volatile MetricRegistry metricRegistry;

        public JettySolrRunnerWithMetrics(String solrHome, JettyConfig config) {
            super(solrHome, config);
        }

        protected HandlerWrapper injectJettyHandlers(HandlerWrapper chain) {
            this.metricRegistry = new MetricRegistry();
            InstrumentedHandler metrics = new InstrumentedHandler(this.metricRegistry);
            metrics.setHandler((Handler)chain);
            return metrics;
        }

        public MetricRegistry getMetricRegistry() {
            return this.metricRegistry;
        }
    }
}

