/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr;

import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakFilters;
import com.carrotsearch.randomizedtesting.annotations.ThreadLeakLingering;
import com.carrotsearch.randomizedtesting.rules.SystemPropertiesRestoreRule;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.lucene.util.QuickPatchThreadsFilter;
import org.apache.lucene.util.VerifyTestClassNamingConvention;
import org.apache.solr.SolrIgnoredThreadsFilter;
import org.apache.solr.common.util.ObjectReleaseTracker;
import org.apache.solr.util.ExternalPaths;
import org.apache.solr.util.RevertDefaultThreadHandlerRule;
import org.apache.solr.util.StartupLoggingUtils;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadLeakFilters(defaultFilters=true, filters={SolrIgnoredThreadsFilter.class, QuickPatchThreadsFilter.class})
@ThreadLeakLingering(linger=0)
public class SolrTestCase
extends LuceneTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Pattern NAMING_CONVENTION_TEST_SUFFIX = Pattern.compile("(.+\\.)([^.]+)(Test)");
    private static final Pattern NAMING_CONVENTION_TEST_PREFIX = Pattern.compile("(.+\\.)(Test)([^.]+)");
    @ClassRule
    public static TestRule solrClassRules = RuleChain.outerRule((TestRule)new SystemPropertiesRestoreRule()).around((TestRule)new VerifyTestClassNamingConvention("org.apache.solr.analytics", NAMING_CONVENTION_TEST_SUFFIX)).around((TestRule)new VerifyTestClassNamingConvention("org.apache.solr.ltr", NAMING_CONVENTION_TEST_PREFIX)).around((TestRule)new RevertDefaultThreadHandlerRule());

    @BeforeClass
    public static void beforeSolrTestCase() {
        String existingValue = System.getProperty("solr.default.confdir");
        if (null != existingValue) {
            log.info("Test env includes configset dir system property '{}'='{}'", (Object)"solr.default.confdir", (Object)existingValue);
            return;
        }
        File extPath = new File(ExternalPaths.DEFAULT_CONFIGSET);
        if (extPath.canRead() && extPath.isDirectory()) {
            log.info("Setting '{}' system property to test-framework derived value of '{}'", (Object)"solr.default.confdir", (Object)ExternalPaths.DEFAULT_CONFIGSET);
            assert (null == existingValue);
            System.setProperty("solr.default.confdir", ExternalPaths.DEFAULT_CONFIGSET);
        } else {
            log.warn("System property '{}' is not already set, but test-framework derived value ('{}') either does not exist or is not a readable directory, you may need to set the property yourself for tests to run properly", (Object)"solr.default.confdir", (Object)ExternalPaths.DEFAULT_CONFIGSET);
        }
        if (!TEST_NIGHTLY) {
            System.setProperty("zookeeper.nio.numSelectorThreads", "2");
            System.setProperty("zookeeper.nio.numWorkerThreads", "3");
            System.setProperty("zookeeper.commitProcessor.numWorkerThreads", "2");
            System.setProperty("zookeeper.forceSync", "no");
            System.setProperty("zookeeper.nio.shutdownTimeout", "100");
        }
    }

    @BeforeClass
    public static void checkSyspropForceBeforeClassAssumptionFailure() {
        String PROP = "tests.force.assumption.failure.beforeclass";
        SolrTestCase.assumeFalse((String)"tests.force.assumption.failure.beforeclass == true", (boolean)RandomizedTest.systemPropertyAsBoolean((String)"tests.force.assumption.failure.beforeclass", (boolean)false));
    }

    @Before
    public void checkSyspropForceBeforeAssumptionFailure() {
        String PROP = "tests.force.assumption.failure.before";
        SolrTestCase.assumeFalse((String)"tests.force.assumption.failure.before == true", (boolean)RandomizedTest.systemPropertyAsBoolean((String)"tests.force.assumption.failure.before", (boolean)false));
    }

    @AfterClass
    public static void afterSolrTestCase() throws Exception {
        if (suiteFailureMarker.wasSuccessful()) {
            String orr = ObjectReleaseTracker.clearObjectTrackerAndCheckEmpty();
            SolrTestCase.assertNull((String)orr, (Object)orr);
        } else {
            ObjectReleaseTracker.tryClose();
        }
        StartupLoggingUtils.shutdown();
    }
}

